#!/usr/bin/env python
#
#
#-------------------------------------------------------------------------------

import pprint

#-------------------------------------------------------------------------------

class Logger():
   directory = None

   #----------------------------------------------------------------------------

   def __init__(self, dir=None):
      print "[http::scraper]  dir %s" % dir

      if dir:
         self.directory = dir
      else:
         self.directory = '.'

   #----------------------------------------------------------------------------

   def log_request_params(self, idx, params):
      of = open('%s/%04d.req_params' % (self.directory, idx), 'w')

      of.write("%s\n" % pprint.pformat(params))

      of.close()

   #----------------------------------------------------------------------------

   def log_request_header(self, idx, hdr):
      of = open('%s/%04d.req_header' % (self.directory, idx), 'w')

      of.write("%s\n" % pprint.pformat(hdr))

      of.close()

   #----------------------------------------------------------------------------

   def log_request_data(self, idx, data):
      of = open('%s/%04d.req_data' % (self.directory, idx), 'w')

      of.write("%s\n" % pprint.pformat(data))

      of.close()

   #----------------------------------------------------------------------------

   def log_response_header(self, idx, resp):
      of = open('%s/%04d.resp_header' % (self.directory, idx), 'w')

      of.write("resp.__dict__ ->\n%s\n\n" % pprint.pformat(resp.__dict__))
      of.write("Status %s  Reason [%s]\n" % (resp.status, resp.reason))
      of.write("Msg ->\n%s\n\n" % resp.msg)
      of.write("Msg.__dict__ ->\n%s\n\n" % pprint.pformat(resp.msg.__dict__))

      of.close()

   #----------------------------------------------------------------------------

   def log_response_body(self, idx, resp_body):
      of = open('%s/%04d.html' % (self.directory, idx), 'w')

      of.write(resp_body);

      of.close()

#-------------------------------------------------------------------------------

