#! /usr/bin/env python

import sys
import re
import string

err = sys.stderr.write
dbg = err
rep = sys.stdout.write

filename = "adventure1.bas"

r_goto  = re.compile('^.*GOTO ')
r_gosub = re.compile('^.*GOSUB ')

try:
    f = open(filename, 'r')
except IOError, msg:
    err(filename + ': cannot open: ' + `msg` + '\n')
    sys.exit(0)

cnt    = 0
lines  = []
lineno = []
goto   = []
tgt    = {}
ref    = {}

while 1:
   line = f.readline()

   if not line: break

   (lno, rest) = line.split("  ",1)
   code = rest.rstrip()

   lines.append(code)
   goto.append(0)

   ilno = int(lno)

   lineno.append(ilno)

   tgt[ilno] = cnt

   if r_goto.search(code) != None:
      a = r_goto.sub("", code)
      b = a.split(",")
      #print b
      if len(b) > 0:
         for i in b:
            i = i.strip()
            #print i
            ref[i] = 1

   if r_gosub.search(code) != None:
      a = r_gosub.sub("", code)
      b = a.split(",")
      #print b
      if len(b) > 0:
         for i in b:
            i = i.strip()
            #print i
            ref[i] = 1

   cnt += 1

f.close()

print cnt, "lines"
print len(ref), "references"

print "::::::::::::::::::::"

references = ref.keys()

def num(a,b):
   if int(a) < int(b):
      return -1
   elif int(a) == int(b):
      return 0
   elif int(a) > int(b):
      return 1

references.sort(num)

for i in range(len(lines)):
   referenced = 0
   for reference in references:
      if int(lineno[i]) == int(reference):
         referenced = 1
         break
   if referenced:
      print "%5d  %s" % (lineno[i], lines[i])
   else:
      print "       %s" % lines[i]

sys.exit(0)
