#! /usr/bin/env python

import sys
import regex
import os
from stat import *
import string

err = sys.stderr.write
dbg = err
rep = sys.stdout.write

filename = "adventure2.bas"

try:
    f = open(filename, 'r')
except IOError, msg:
    err(filename + ': cannot open: ' + `msg` + '\n')
    return 1

lineno = 0

while 1:
    line = f.readline()

    if not line: break

    lineno = lineno + 1

    if g is None and '\0' in line:
        # Check for binary files
        err(filename + ': contains null bytes; not fixed\n')
        f.close()
        return 1

    while line[-2:] == '\\\n':
        nextline = f.readline()
        if not nextline: break
        line = line + nextline
        lineno = lineno + 1

    newline = fixline(line)

    if newline != line:
        if g is None:
            try:
                g = open(tempname, 'w')
            except IOError, msg:
                f.close()
                err(tempname+': cannot create: '+\
                    `msg`+'\n')
                return 1

            f.seek(0)

            lineno = 0

            rep(filename + ':\n')
            continue # restart from the beginning

        rep(`lineno` + '\n')
        rep('< ' + line)
        rep('> ' + newline)

   if g is not None:
      g.write(newline)

f.close()

if not g:
   return 0  # No changes

