/*
 *      Author:  Peter Harding  <plh@eram.esi.com.au>
 *               P. O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  578 8001
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 *
 */

static char
	id[] = "@(#) [1.2.1] scenes.c 01/04/92";
 

//------------------------------------------------------------------------------

#include "config.h"

#include <stdio.h>
#include <errno.h>

#ifdef MAC
#include <console.h>
#include <stdlib.h>
#include <unix.h>
#endif MAC

#ifdef UNIX
#endif UNIX

#include "misc.h"
#include "advent.h"
#include "global.h"
#include "objects.h"
#include "objectGlobals.h"
#include "error.h"


//------------------------------------------------------------------------------

extern int   errno;              /*  Standard error return.  */


//------------------------------------------------------------------------------

void showLocation(int here)
{
	int
		id, irand;

	char
		*s;

	id = descriptor[here];

	switch(id) {
		case  0:
			fprintf(stdout, "You seem to be floating in %s\n\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout,	"It is like being...\n");
			break;
		case  1:
			fprintf(stdout, "You are inside %s\n\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout,	"It is a safe place to store treasure.\n");
			break;
		case  2:
			fprintf(stdout, "You are on %s.\n", scene[id]);
			break;
		case  3:
			fprintf(stdout, "You are in %s.\n", scene[id]);

			if (here == 14)
				if (knightAbout) {
					fprintf(stdout, "\nA black knight in full iron armour stands in a glade before you.\n\n");
					fprintf(stdout, "He is carrying a goldern sword\n");
				} else {
					fprintf(stdout, "\nThere is an ancient iron statue of a knight in the glade\n\n");
				}
			break;
		case  4:
			fprintf(stdout, "You are walking along %s.\n", scene[id]);
			break;
		case  5:
			fprintf(stdout, "You are at %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "A small stream flows across the ground and into a crevice.\n");
			break;
		case  6:
			fprintf(stdout, "You are walking through %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "The sound of many birds and animals fills the air.\n");
			break;
		case  7:
			fprintf(stdout, "You are at %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "A 3X3 iron grate bars your way to where the cave appears to open up.\n");
			break;
		case  8:
			fprintf(stdout, "You are inside %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "A large passage opens up ahead.\n");
			break;
		case  9:
			fprintf(stdout, "You are at %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "You can climb down, but you might not be able to climb back up again.\n");
			break;
		case 10:
			fprintf(stdout, "You are in %s that extends vertically in both directions.\n", scene[id]);
			break;
		case 11:
			fprintf(stdout, "You are in %s.\n\n", scene[id]);
      		fprintf(stdout, "You are standing beside a large sign flashing '%s'!\n",
				magicWord);
      		mysticFlg = _TRUE;
			break;
		case 12:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			break;
		case 13:
			fprintf(stdout, "You are walking along %s.\n", scene[id]);
			break;
		case 14:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			break;
		case 15:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			break;
		case 16:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			break;
		case 17:
			fprintf(stdout, "You are at %s.\n", scene[id]);
			break;
		case 18:
			fprintf(stdout, "You are at %s.\n", scene[id]);
			break;
		case 19:
			fprintf(stdout, "You are at %s you could climb up but not back down.\n",
				scene[id]);
			break;
		case 20:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "Exits lead in many directions.\n");
			break;
		case 21:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			break;
		case 22:
			fprintf(stdout, "You are walking through %s.\n", scene[id]);
			if (firstGlimpse) {
				fprintf(stdout, "At its center is a large hole.\n\n");
				fprintf(stdout, "SHHH!..I think I hear the sound of water!\n");
			}
			break;
		case 23:
			if (ran(99) > 50)
				s = "a narow tunnel";
			else
				s = "a small crack";
			fprintf(stdout, "You climb through %s only to find that........\n\n", s);
			here -= 7;
			showLocation(here);
			break;
		case 24:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			break;
		case 25:
			here -= 5;
			checkLantern();
			break;
		case 26:
            if (ran(99) > 50)
                s = "twisty, little";
            else
                s = "little, twisty";
            fprintf(stdout, "You are in a %s maze!\n", s);
            break;
		case 27:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "Obvious paths lead east and west.\n");
			break;
		case 28:
			fprintf(stdout, "You have stumbled into %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "His job is to protect the enchanted castle which lies to the south.\n");
            if (dragonAbout)
                s = "refuses to let you enter.";
            else
                s = "lies dead off to one side.";
            fprintf(stdout, "The dragon %s\n", s);
			break;
		case 29:
			fprintf(stdout, "You are in %s.\n", scene[id]);
            if (frogAbout)   {
                fprintf(stdout,
					"\nA small green frog happily hops to and fro across the floor of the\n");
                fprintf(stdout, "chamber!\n");
            }
			break;
		case 30:
			fprintf(stdout, "You are standing on %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "You can neither jump nor swim across.\n");
            if (drawbridgeDown)
                fprintf(stdout, "\nThe drawbridge is lowered to cross.\n");
			break;
		case 31:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "Your footsteps echo endlessly.\n");
			break;
		case 32:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			break;
		case 33:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			if (list[_Partner].held)
                moveCode[98] = 0x0A;
			break;
		case 34:
			fprintf(stdout, "You are in %s.\n", scene[id]);
			if (firstGlimpse)
				fprintf(stdout, "SHHHH!... I think he's asleep!\n");
			break;
		case 35:
			fprintf(stdout, "The floor you were standing on has given way.\n");
            fprintf(stdout, "You fall..and fall...and fall................\n");
            fprintf(stdout, "finally landing on solid ground..............\n");
            here += 50;
            checkLantern();
			break;
		case 36:
			if (firstGlimpse) {
				fprintf(stdout, "Welcome to the Magic Castle.\n");
				fprintf(stdout, "I hope you enjoy your visit even though our ruler is stupid.\n");
			}
			break;
		case 37:
            fprintf(stdout, "You are in the castle dungeons.\n");
			break;
		case 38:
			fprintf(stdout, "You are adrift in %s.\n", scene[id]);
			if (firstGlimpse) {
				if ((irand = ran(100)) < 40)
					fprintf(stdout, "It seems to go on forever.\n");
				else if (irand < 65)
					fprintf(stdout, "A fog seems to be moving in.\n");
				else if (irand < 80)
					fprintf(stdout, "The fog swirls about you.  It seems to have a life of its own.\n");
				else if (irand < 90)
					fprintf(stdout, "Mysterious lights seem to hover on the edge of your vision.\n");
				else if (irand < 99)
					fprintf(stdout, "A deep swell apears out of nowhere.\n");
			}
			break;
	}

	firstGlimpse = _FALSE;

	if (debugFlg)
		fprintf(stdout, "***Maze descriptor = %d\n", id);
}	/* showLocation */


//------------------------------------------------------------------------------

void cmd_look(void)
{
	int
		direction,
		location;

	for (direction = NORTH; direction <= DOWN; direction++) {
		if((location = lookTowards(direction)) != ERROR) {
			switch (direction) {
				case NORTH:
					fprintf(stdout, "To the north is %s.\n",     scene[descriptor[location]]);
					break;
				case EAST:
					fprintf(stdout, "Over to the east is %s.\n", scene[descriptor[location]]);
					break;
				case SOUTH:
					fprintf(stdout, "To the south is %s.\n",     scene[descriptor[location]]);
					break;
				case WEST:
					fprintf(stdout, "To the west is %s.\n",      scene[descriptor[location]]);
					break;
				case UP:
					fprintf(stdout, "Up above is %s.\n",         scene[descriptor[location]]);
					break;
				case DOWN:
					fprintf(stdout, "Down below is %s.\n",       scene[descriptor[location]]);
					break;
			}
		}
	}

	fprintf(stdout, "\n");

	showLocation(here);

	lookForObjects(here);
}	/* cmd_look */


//------------------------------------------------------------------------------

void listScenes(void)
{
	int
		i;

	for (i = 0; i < 37; i++) {
		fprintf(stdout, "<%s>\n", scene[i]);
		sleep(1);
	}
}	/* listScenes */


//------------------------------------------------------------------------------

