
/*
 *	@(#) = "scenes.c"
 *
 *	Date: 19th October 1985
 */


#include  <stdio.h>
#include  <ctype.h>

#include  "const.h"
#include  "param.h"
#include  "maze.h"
#include  "things.h"
#include  "advent.h"

extern THING  Thing[] ;
extern MAZE   Maze[] ;


/*       *********  Display scenes.  */

disp_scenes()
{
  char  *str ;

  switch ( Maze[ maze_posn ].descriptor ) {
    case 1:
      printf( "You are inside a building, a safe place to store treasures.\n" ) ;
      break ;
    case 2:
      printf( "You are on a very nicely groomed path.\n" ) ;
      break ;
    case 3:
      printf( "You are in the forest.\n" ) ;
      if ( maze_posn == 15 )  {
        if ( black_knight )
          printf( "\nA black knight in full iron armour is standing before you.\n" ) ;
          printf( "He is carrying a golden sword.\n" ) ;
      } else {
	printf( "An iron statue of a black knight stands in front of you.\n" ) ;
      }
      break ;
    case 4:
      printf( "You are in a dried up stream bed of a once great river.\n" ) ;
      break ;
    case 5:
      printf( "You are at the bottom of a climbable pit.  A small stream flows across\n" ) ;
      printf( "the floor of the pit.\n" ) ;
      break ;
    case 6:
      printf( "You are in a beautiful forest carrying the sounds of many animals\n" ) ;
      break ;
    case 7:
      printf( "You are at the entrance of a small cave.  A 3x3 iron grate keeps you\n" ) ;
      printf( "from going down to where it looks like the cave opens up.\n" ) ;
      break ;
    case 8:
      printf( "You are inside the cave entrance.  It is a good sized passage and  easy\n" ) ;
      printf( "to walk in.\n" ) ;
      break ;
    case 9:
      printf( "You are at the edge of a pit.  You can climb down but you might not be\n" ) ;
      printf( "able to climb back up again.\n" ) ;
      break ;
    case 10:
      printf( "You are in an old mine shaft that extends vertically in both directions\n" ) ;
      break ;
    case 11:
      printf( "You are standing beside a large sign flashing '%s'!\n",
          magic_word ) ;
      say = TRUE ;
      break ;
    case 12:
      printf( "You are traveling in a east-west tunnel.\n" ) ;
      break ;
    case 13:
      printf( "You are walking in a east-west corridor.\n" ) ;
      break ;
    case 14:
      irintf( "You're in a large north-south passage.\n" ) ;
      break ;
    case 15:
      printf( "You are in a small north-south cave.\n" ) ;
      break ;
    case 16:
      printf( "You are in a room that connects to an alternate passage.\n" ) ;
      break ;
    case 17:
      printf( "You are at an intersection of three corridors.\n" ) ;
      break ;
    case 18:
      printf( "You are at the brink of an easily climbable pit.\n" ) ;
      break ;
    case 19:
      printf( "You are at the bottom of a narrow shaft.  You could climb up but not\n" ) ;
      printf( "back down.\n" ) ;
      break ;
    case 20:
      printf( "You're in an enormous chamber of solid granite.  Exits lead in many\n" ) ;
      printf( "directions.\n" ) ;
      break ;
    case 21:
      printf( "You're in a cave of many exits.\n" ) ;
      break ;
    case 22:
      printf( "You're in a beautiful cavern.  In the center of the cavern is a huge\n" ) ;
      printf( "hole.  I think I hear the sound of water?\n" ) ;
      break ;
    case 23:
      if ( ran( 99 ) > 50 )
        str = "a narow tunnel" ;
      else
        str = "a small crack" ;
      printf( "You climb thru %s only to find that........\n\n", str ) ;
      maze_posn -= 7 ;
      disp_scenes() ;
      break ;
    case 24:
      printf( "You are in a spendid chamber decorated with strands of multi-coloured\n" ) ;
      printf( "thread.\n" ) ;
      break ;
    case 25:
      maze_posn -= 5 ;
      check_lantern() ;
      break ;
    case 26:
      if ( ran( 99 ) > 50 )
        str = "twisty, little" ;
      else
        str = "little, twisty" ;
      printf( "You are in a %s maze!\n", str ) ;
      break ;
    case 27:
      printf( "You are at a complex junction of three forks.  Obvious paths lead  east\n" ) ;
      printf ( "and west.\n" ) ;
      break ;
    case 28:
      printf( "You are at the dragon's lair.  His job is to protect the magic castle\n" ) ;
      printf( "which lies to the south.  \n" ) ;
      if ( dragon )
        str = "refuses to let you enter." ;
      else
        str = "lies dead off to one side." ;
      printf( "The dragon %s\n", str ) ;
      break ;
    case 29:
      printf( "You're in a small stone chamber of the magic castle.\n" ) ;
      if ( frog )  {
        printf( "\nA small green frog happily hops to and fro across the floor of the\n" ) ;
        printf( "chamber!\n" ) ;
      }
      break ;
    case 30:
      printf( "You are standing on one side of a large moat that surrounds the castle\n" ) ;
      printf( "You cannot jump or swim across.\n" ) ;
      if ( drawbridge )
        printf( "\nThe drawbridge is lowered to cross.\n" ) ;
      break ;
    case 31:
      printf( "You are in the west hall of the magic castle.  Your footsteps echo\n" ) ;
      printf( "endlessly.\n" ) ;
      break ;
    case 32:
      printf( "You're in the eastern hall of the magic castle.\n" ) ;
      break ;
    case 33:
      printf( "You are in a room where a bed is made from twelve matresses.\n" ) ;
      if ( Thing[ HERO ].held )
        Maze[ 99 ].allowed_directions = 10 ;
      break ;
    case 34:
      printf( "Shhhh....you are in the king's chamber.  I think he's asleep.\n" ) ;
      break ;
    case 35:
      printf( "The floor you were standing on has given way...you fall..and fall...and\n" ) ;
      printf( "fall.....finally landing on solid ground.................\n" ) ;
      maze_posn += 50 ;
      check_lantern() ;
      break ;
    case 36:
      printf( "Welcome to the magic castle.  Although our ruler( King Dumb ) is stupid\n" ) ;
      printf( "I hope you enjoy your visit.\n" ) ;
      break ;
    case 37:
      printf( "You are in the castle dungeons.\n" ) ;
      break ;
  }
  return( 0 ) ;
}
