/*
 *      Author:  Peter Harding  <plh@eram.esi.com.au>
 *               P. O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  578 8001
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [1.2.1] objects.c 01/04/92";


//------------------------------------------------------------------------------

#include "config.h"

#include <stdio.h>

#ifdef MAC
#include <console.h>
#include <stdlib.h>
#include <unix.h>
#endif MAC

#ifdef UNIX
#endif UNIX

#include "misc.h"
#include "global.h"
#include "objects.h"


//------------------------------------------------------------------------------

OBJECT_LIST
	list[NO_OBJECTS] = {
		{"Keys",        2,  FALSE,   10},       /* _Keys */
		{"Lantern",     2,  FALSE,   10},       /* _Lantern */
		{"Food",        2,  FALSE,   10},       /* _Food */
		{"Bottle",      2,  FALSE,   10},       /* _Bottle */
		{"Water",      58,  FALSE,   10},       /* _Water */
		{"Oil",        68,  FALSE,   20},       /* _Oil */
		{"Rope",       44,  FALSE,   20},       /* _Rope */
		{"Book",       -1,  FALSE,   20},       /* _Book */
		{"Carpet",     -1,  FALSE,   20},       /* _Carpet */
		{"Axe",        -1,  FALSE,   20},       /* _Axe */
		{"Statue",     -1,  FALSE,   20},       /* _Statue */
		{"Sword",      -1,  FALSE,   20},       /* _Sword */
		{"Wand",       27,  FALSE,   20},       /* _Wand */
		{"Silver",     43,  FALSE,   30},       /* _Silver */
		{"Diamonds",   48,  FALSE,   30},       /* _Diamonds */
		{"Emerald",    -1,  FALSE,   30},       /* _Emerald */
		{"Crown",      94,  FALSE,   30},       /* _Crown */
		{"Treasure",   32,  FALSE,   30},       /* _Treasure */
		{BLANK,        -1,  FALSE,    0},       /* _Unused */
		{BLANK,        -1,  FALSE,   50},       /* _Partner */
	};


//------------------------------------------------------------------------------

OBJECT matchObject(char *s)
{
	OBJECT
		theObject;

	for (theObject = _Keys; theObject <= _Partner; theObject++)	{
		if (equivString(list[theObject].name, s))	{
			return(theObject);
		}
	}
	return(ERROR);
}	/* matchObject */


//------------------------------------------------------------------------------

void lookForObjects(int here)
{
	int
		theObject;

	for (theObject = _Keys; theObject <= _Partner; theObject++) {
		if (list[theObject].locn == here) {
			switch (theObject) {
				case _Axe:
					if (axeVisible)
						fprintf(stdout, "A little axe is here!\n");
					break;
				case _Book:
					fprintf(stdout,
						"There is an ancient book on the ground!\n");
					break;
				case _Bottle:
					fprintf(stdout, "A small bottle is lying here!\n");
					break;
				case _Carpet:
					fprintf(stdout,
						"There is a persian carpet lying on the ground\n");
					break;
				case _Crown:
					fprintf(stdout, "There's a king's crown here!\n");
					break;
				case _Diamonds:
					fprintf(stdout, "Many diamonds are scattered here!\n");
					break;
				case _Emerald:
					fprintf(stdout,
						"A pea-sized emerald falls to the floor!\n");
					break;
				case _Food:
					fprintf(stdout, "There is tasty food here!\n");
					break;
				case _Keys:
					fprintf(stdout, "There's a set of keys here!\n");
					break;
				case _Lantern:
					fprintf(stdout, "A lantern rests here!\n");
					break;
				case _Oil:
					fprintf(stdout, "A small pool of oil is here!\n");
					break;
				case _Rope:
					fprintf(stdout, "A useful hemp rope is coiled here!\n");
					break;
				case _Silver:
					fprintf(stdout, "Seven bars of silver lie here!\n");
					break;
				case _Statue:
					fprintf(stdout,
						"There is a tiny marble statue in the corner.\n");
					break;
				case _Sword:
					fprintf(stdout, "A golden sword lies here!\n");
					break;
				case _Treasure:
					fprintf(stdout,
						"There's a pirate's treasure chest here!\n");
					break;
				case _Wand:
					fprintf(stdout, "A magic wand floats in mid air!\n");
					break;
				case _Water:
					fprintf(stdout, "There is much water here!\n");
					break;
				case _Partner:
					if ( !list[_Partner].held )
						fprintf(stdout, "A %s patiently waits here!\n", partner);
					else
						fprintf(stdout, "The %s is still by your side.\n", partner);
			 }
		}
	}
}	/* lookForObjects */


//------------------------------------------------------------------------------

