/*
 *   @(#) = "move.c"
 *
 *   Date: 11th November 1985
 */


#include <stdio.h>

#include  "param.h"
#include  "const.h"
#include  "cmds.h"
#include  "maze.h"
#include  "move.h"
#include  "advent.h"


//------------------------------------------------------------------------------

extern MAZE
	Maze[];


//------------------------------------------------------------------------------

void glimpse(int locn);


//------------------------------------------------------------------------------

char *allowableDirections(int here)
{
	return( "ESWNUD";
}	/* allowableDirections */


//------------------------------------------------------------------------------
// **********  Process directional moves.

void move(COMMANDS  cmd)
{
	DIRECTIONS
		dirn;

	int
		new_maze_posn;

	switch ( cmd ) {
		case NORTH:
			if ( Maze[ maze_posn ].descriptor != 6 )
				dirn = North;
			else
				dirn = East;
			break;

		case EAST:
			if ( Maze[ maze_posn ].descriptor != 6 )
				dirn = East;
			else
				dirn = South;
			break;

		case SOUTH:
			if ( Maze[ maze_posn ].descriptor != 6 )
				dirn = South;
			else
				dirn = West;
			break;

		case WEST:
			if ( Maze[ maze_posn ].descriptor != 6 )
				dirn = West;
			else
				dirn = North;
			break;

		case UP:
			dirn = Up;
			break;

		case DOWN:
			dirn = Down;
			break;
	}

	if ( Maze[ maze_posn ].allowed_directions & Move[ dirn ].mask )
		new_maze_posn = maze_posn + Move[ dirn ].increment;
	else {
		if ( ran( 5 ) <= 2 )
			printf( "You do not seem to know where you're going!\n" );
		else
			printf( "You can't go that way!\n" );
		return( 0 );
	}

	if (( new_maze_posn < 0 ) || ( new_maze_posn > 200 ))  {
		printf( "You don't seem to know where you are going!" );
		return( 0 );
	}

	/*  if ( maze_posn = 87 )
	Sstr      = "refuses to let you pass!"  */

	maze_posn = new_maze_posn;
	look      = TRUE;

#ifdef TRMOVE
	printf( "  Maze location [%d].\n", maze_posn );
#endif
}	/* move */


//------------------------------------------------------------------------------
//  **********  Look around at nearby scenes.

void look_around(void)
{
	DIRECTIONS
		dirn;

#ifdef TRLOOK
  printf( "Maze[%d] { %d, %d, %d }\n", maze_posn,
	 (int) Maze[ maze_posn ].descriptor,
	 (int) Maze[ maze_posn ].modifier,
	 (int) Maze[ maze_posn ].allowed_directions );
#endif

	for ( dirn = North; dirn <= Down ; dirn++ )  {
		if ( Maze[ maze_posn ].modifier & Move[ dirn ].mask )  {
			switch ( dirn )  {
				case North:
					printf( "To the north is " );
					break;
				case East:
					printf( "Along the east is " );
					break;
				case South:
					printf( "Looking south is " );
					break;
				case West:
					printf( "Appearing westerly is " );
					break;
			}

			glimpse( maze_posn + Move[ dirn ].increment );
		}
	}

	look = FALSE;

	return( 0 );
}	/* look_around */


//------------------------------------------------------------------------------

void glimpse(int locn)
{
	switch ( Maze[ locn ].descriptor )  {
		case 1:
			printf( "a small building.\n" );
			break;

		case 2:
			printf( "a shallow valley.\n" );
			break;

		case 3:
			printf( "a rusty statue of a knight.\n" );
			break;

		case 4:
			printf( "a river bed\n" );
			break;

		case 6:
			printf( "a beautiful forest.\n" );
			break;

		case 7:
			printf( "A cobble path leads up to the surface.\n" );
			break;

		case 8:
			printf( "A cobble path leads down into the cave.\n" );
			if ( grate_open )
				printf( "\nThe grate is open.\n" );
			break;
	}
}   /* glimpse */


//------------------------------------------------------------------------------

