/*
 *      Author:  Peter Harding  <plh@eram.esi.com.au>
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  578 8001
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [1.0.1] global.c 01/04/92";


//------------------------------------------------------------------------------

#include "config.h"

#ifdef MAC
#include <console.h>
#include <stdlib.h>
#include <unix.h>
#endif MAC

#ifdef UNIX
#endif UNIX

#include "misc.h"
#include "advent.h"
#include "command.h"


//------------------------------------------------------------------------------

int
	here                = 7,
	dwarfCnt            = 0,
	helpCnt             = 0,
	itemCnt             = 0,
	itemLimit           = ITEM_LIMIT,
	movesMade           = 0,
	oilLevel            = OIL_LEVEL,
	pitCnt              = 0,
	shadowCnt           = 0;

char
	*magicWord,
	*partner,
	word[STR16],
	cmdStr[STR64],
	line[STR128],
	errMsg[STR128],
	parsedLine[NO_WORDS_PER_LINE][STR16];

KEY_WORDS
	direction,
	objects;
 
BOOLEAN
	axeVisible        = TRUE,
	broken            = FALSE,
	chestLocked       = TRUE,
	debugFlg          = FALSE,
	dragonAbout       = TRUE,
	drawbridgeDown    = FALSE,
	dwarfAbout        = FALSE,
	fine              = FALSE,
	finished          = FALSE,
	firstGlimpse      = TRUE,
	frogAbout         = FALSE,
	grateOpen         = FALSE,
	killed            = FALSE,
	knightAbout       = TRUE,
	lanternDim        = FALSE,
	lanternLit        = FALSE,
	loop              = TRUE,
	mysticFlg         = FALSE,
	noLight           = TRUE,
	pirateGone        = FALSE,
	shadowyFigure     = FALSE,
	showMap           = FALSE;


//------------------------------------------------------------------------------

int increment[] = {
	(-MAZE_EW),              /* North */
	1,                       /* East */
	(MAZE_EW),               /* South */
	(-1),                    /* West */
	(-(MAZE_NS * MAZE_EW)),  /* Up */
	(MAZE_NS * MAZE_EW)      /* Down */
};


//------------------------------------------------------------------------------

int allowed[] = {
	NORTH_OK,
	EAST_OK,
	SOUTH_OK,
	WEST_OK,
	UP_OK,
	DOWN_OK
};


//------------------------------------------------------------------------------

int lookCode[MAZE_SIZE] = {
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x0F,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x20,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,

	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x10,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,

	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,

	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,

	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
	0x00,  0x00,  0x00,  0x00,  0x00,
};


//------------------------------------------------------------------------------

int moveCode[MAZE_SIZE] = {
	0x22,  0x04,  0x00,  0x06,  0x0E,
	0x0F,  0x0F,  0x0E,  0x0F,  0x0F,
	0x0B,  0x0F,  0x0F,  0x07,  0x0D,
	0x22,  0x0F,  0x0F,  0x0F,  0x0B,
	0x0A,  0x0A,  0x0B,  0x0B,  0x0B,

	0x22,  0x0E,  0x0A,  0x0A,  0x0E,
	0x12,  0x09,  0x0D,  0x22,  0x0F,
	0x0A,  0x0E,  0x22,  0x0D,  0x0C,
	0x12,  0x0F,  0x0A,  0x05,  0x0F,
	0x0A,  0x09,  0x0B,  0x0A,  0x00,

	0x22,  0x0A,  0x0A,  0x0A,  0x0A,
	0x0E,  0x00,  0x12,  0x10,  0x22,
	0x0F,  0x0D,  0x0E,  0x0A,  0x0A,
	0x0F,  0x0E,  0x0E,  0x0F,  0x0F,
	0x03,  0x09,  0x0B,  0x0B,  0x0B,

	0x0B,  0x0E,  0x0A,  0x0A,  0x12,
	0x0A,  0x0F,  0x12,  0x05,  0x0C,
	0x0B,  0x0B,  0x0A,  0x0A,  0x09,
	0x04,  0x01,  0x06,  0x0A,  0x0A,
	0x0B,  0x0B,  0x0B,  0x08,  0x20,

	0x12,  0x12,  0x12,  0x12,  0x12,
	0x3F,  0x3F,  0x3F,  0x3F,  0x3F,
	0x3F,  0x3F,  0x3F,  0x3F,  0x3F, 
	0x3F,  0x3F,  0x3F,  0x3F,  0x3F,
	0x3F,  0x3F,  0x3F,  0x3F,  0x3F
};


//------------------------------------------------------------------------------

int wizLookCode[MAZE_SIZE] = {
	0x23,  0x2B,  0x2B,  0x2B,  0x29,
	0x27,  0x2F,  0x2F,  0x2F,  0x2D,
	0x27,  0x2F,  0x2F,  0x2F,  0x2D,
	0x27,  0x2F,  0x2F,  0x2F,  0x2D,
	0x26,  0x2E,  0x2E,  0x2E,  0x2C,

	0x33,  0x3B,  0x3B,  0x3B,  0x39,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x36,  0x3E,  0x3E,  0x3E,  0x3C,

	0x33,  0x3B,  0x3B,  0x3B,  0x39,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x36,  0x3E,  0x3E,  0x3E,  0x3C,

	0x33,  0x3B,  0x3B,  0x3B,  0x39,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x36,  0x3E,  0x3E,  0x3E,  0x3C,

	0x13,  0x1B,  0x1B,  0x1B,  0x19,
	0x17,  0x1F,  0x1F,  0x1F,  0x1D,
	0x17,  0x1F,  0x1F,  0x1F,  0x1D,
	0x17,  0x1F,  0x1F,  0x1F,  0x1D,
	0x16,  0x1E,  0x1E,  0x1E,  0x1C
};


//------------------------------------------------------------------------------

int wizMoveCode[MAZE_SIZE] = {
	0x23,  0x2B,  0x2B,  0x2B,  0x29,
	0x27,  0x2F,  0x2F,  0x2F,  0x2D,
	0x27,  0x2F,  0x2F,  0x2F,  0x2D,
	0x27,  0x2F,  0x2F,  0x2F,  0x2D,
	0x26,  0x2E,  0x2E,  0x2E,  0x2C,

	0x33,  0x3B,  0x3B,  0x3B,  0x39,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x36,  0x3E,  0x3E,  0x3E,  0x3C,

	0x33,  0x3B,  0x3B,  0x3B,  0x39,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x36,  0x3E,  0x3E,  0x3E,  0x3C,

	0x33,  0x3B,  0x3B,  0x3B,  0x39,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x37,  0x3F,  0x3F,  0x3F,  0x3D,
	0x36,  0x3E,  0x3E,  0x3E,  0x3C,

	0x13,  0x1B,  0x1B,  0x1B,  0x19,
	0x17,  0x1F,  0x1F,  0x1F,  0x1D,
	0x17,  0x1F,  0x1F,  0x1F,  0x1D,
	0x17,  0x1F,  0x1F,  0x1F,  0x1D,
	0x16,  0x1E,  0x1E,  0x1E,  0x1C
};


//------------------------------------------------------------------------------

int descriptor[MAZE_SIZE] = {
	 9,  3,  1,  3,  3,
	 6,  6,  2,  6,  6,
	 3,  6,  2,  2,  3,
	 7,  2,  2,  6,  3,
	 3,  4,  4,  4, 11,

	 9, 17, 12, 12, 17,
	19, 16, 20, 18, 21,
	12, 17, 22, 23, 16,
	 8, 21, 12, 14, 24,
	12, 16, 17, 12, 23,

	 9, 13, 13, 13, 13,
	13, 25, 26,  5,  9,
	26, 26, 27, 12, 12,
	26, 26, 26, 26, 26,
	26, 26, 26, 26, 26,

	16, 17, 12, 12, 19,
	12, 21, 19, 14, 16,
	17, 28, 12, 12, 16,
	29, 30, 29, 13, 34,
	31, 36, 32, 33, 35,

	37, 37, 37, 37, 37,
	37, 37, 37, 37, 37,
	37, 37, 37, 37, 37,
	37, 37, 37, 37, 37,
	37, 37, 37, 37, 37,
};


//------------------------------------------------------------------------------

