#include <stdio.h>

/*
 * get option letter from argument vector
 */
int     opterr = 1,             /* useless, never set or used */
        optind = 1,             /* index into parent argv vector */
        optopt;                 /* character checked for validity */
char    *optarg;                /* argument associated with option */

#define BADCH   (int)'?'
#define EMSG    ""

#ifdef  VERBOSE
#define tell(s) fputs(*nargv,stderr); fputs(s,stderr); fputs(" [-",stderr); \
                fputc(optopt,stderr); fputs("]\n",stderr); return(BADCH);

#else
#define tell(s)  return( optopt ) ;
#endif  VERBOSE


getopt(nargc,nargv,ostr)
int     nargc;
char    **nargv,
        *ostr;
{
        static char     *place = EMSG;  /* option letter processing */
        register char   *oli;           /* option letter list index */
        char    *index();

        if(!*place) {                   /* update scanning pointer */
                if (optind >= nargc
                        || (*(place = nargv[optind]) != '-')
                        || !*++place)
                                return(EOF);
                if (*place == '-') {                    /* found "--" */
                        ++optind;
                        return(EOF);
                }
        }                               /* option letter okay? */
        if ((optopt = (int)*place++) == (int)':' || !(oli = index(ostr,optopt))) {
                if(!*place) ++optind;
                tell(": illegal option ");
        }
        if (*++oli != ':') {            /* don't need argument */
                optarg = NULL;
                if (!*place) ++optind;
        }
        else {                          /* need an argument */
                if (*place)
                        optarg = place;                         /* no white space */
                else if (nargc <= ++optind) {   /* no arg */
                        place = EMSG;
                        tell(": option requires an argument ");
                }
                else
                        optarg = nargv[optind];         /* white space */
                place = EMSG;
                ++optind;
        }
        return(optopt);                 /* dump back option letter */
}
