/*
 *      Author:  Peter Harding  <plh@eram.esi.com.au>
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  578 8001
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [1.0.1] function.c 01/04/92";


//------------------------------------------------------------------------------

#include "config.h"

#include <stdio.h>
#include <errno.h>

#ifdef MAC
#include <console.h>
#include <stdlib.h>
#include <unix.h>
#endif MAC

#ifdef UNIX
#endif UNIX

#include "misc.h"
#include "advent.h"
#include "command.h"
#include "global.h"
#include "error.h"


//------------------------------------------------------------------------------
//  Movement functions.

int lookTowards(int dirn)
{
	if (lookCode[here] & allowed[dirn]) {
		showLocation(here);
		return(here + increment[dirn]);
	} else
		return(ERROR);
}  /* lookTowards */


//------------------------------------------------------------------------------

static char
	allowedStr[ 8 ];

char *allowedDirections(int here)
{
	int
		i;

	char
		*dirnStr = "NESWUD";

	for ( i = 0; i < 6; i++ ) {
		if (moveCode[here] & allowed[i])
			allowedStr[ i ] = dirnStr[ i ];
		else
			allowedStr[ i ] = ' ';
	}

	allowedStr[ 6 ] = '\0';

	return( allowedStr );
}	/* allowedDirections */


//------------------------------------------------------------------------------

char *levelStr(int level)
{
	static char
		tmpStr[ 32 ];

		if (level == 0)
			sprintf(tmpStr, "Surface");
		else
			sprintf(tmpStr, "Cavern level %d", level);

	return tmpStr;
}	/* levelStr */


//------------------------------------------------------------------------------

void debugLocn(void)
{
	int
		level = here / 25,
		y     = ((here % 25 ) / 5) + 1,
		x     = ((here % 25 ) % 5) + 1;

	fprintf(stdout, "Maze position: %s  locn (%d,%d)  [%s]\n", levelStr(level), x, y, allowedDirections(here));
//			fprintf(stdout, "Maze position: %d [0x%x]\n", here, moveCode[here]);
}	/* debugLocn */


//------------------------------------------------------------------------------

void map(void)
{
	int
		i, j,
		locn,
		level = here / 25,
   	y     = ((here % 25 ) / 5) + 1,
   	x     = ((here % 25 ) % 5) + 1;

	char
		c_north,
		c_east,
		c_south,
		c_west,
		c_up,
		c_down,
		c_here,
		c_thing;

	fprintf(stdout, "Locn: %d  Level: %s  [%d,%d]\n", here, levelStr(level), x, y );

	for ( i = 0; i < 5; i++ ) {
		fprintf(stdout, "+-----+-----+-----+-----+-----+\n" );

		for ( j = 0; j < 5; j++ ) {
			locn = (level * 25) + ((i * 5) + j);

			if (moveCode[locn] & allowed[NORTH])
				c_north = '^';
			else
				c_north = ' ';

			if (moveCode[locn] & allowed[UP])
				c_up = 'u';
			else
				c_up = ' ';

			fprintf(stdout, "|%c %c  ", c_up, c_north );
		}
		fprintf(stdout, "|\n" );

		// fprintf(stdout, "|     |     |     |     |     |\n" );

		for ( j = 0; j < 5; j++ ) {
			locn = (level * 25) + ((i * 5) + j);

			if (moveCode[locn] & allowed[WEST])
				c_west = '<';
			else
				c_west = ' ';

			if (moveCode[locn] & allowed[EAST])
				c_east = '>';
			else
				c_east = ' ';

			if (locn == here)
				c_here = '*';
			else
				c_here = ' ';

			fprintf(stdout, "|%c %c %c", c_west, c_here, c_east );
		}
		fprintf(stdout, "|\n" );

		// fprintf(stdout, "|     |     |     |     |     |\n" );

		for ( j = 0; j < 5; j++ ) {
			locn = (level * 25) + ((i * 5) + j);

			if (moveCode[locn] & allowed[SOUTH])
				c_south = 'v';
			else
				c_south = ' ';

			if (moveCode[locn] & allowed[DOWN])
				c_down = 'd';
			else
				c_down = ' ';

			c_thing = ' ';

			fprintf(stdout, "|%c %c  ", c_down, c_south, c_thing );
		}
		fprintf(stdout, "|\n" );
	}

	fprintf(stdout, "+-----+-----+-----+-----+-----+\n" );
}	/* map */


//------------------------------------------------------------------------------

void move(int dirn)
{
	int
		oldLocn;

	if (moveCode[here] & allowed[dirn]) {
		oldLocn = here;
		here += increment[dirn];
		if (descriptor[here] != descriptor[oldLocn])
			firstGlimpse    = TRUE;
		showLocation(here);
		lookForObjects(here);
	} else
		fprintf(stdout, "I'm sorry you can't go that way!\n");
}	/* move */


//------------------------------------------------------------------------------

void cmd_go(CMD_LINE *c)
{
	if (strncmp(c->word[1], "N", 1) == 0) {
		move(NORTH);
	} else if (strncmp(c->word[1], "E", 1) == 0) {
		move(EAST);
	} else if (strncmp(c->word[1], "S", 1) == 0) {
		move(SOUTH);
	} else if (strncmp(c->word[1], "W", 1) == 0) {
		move(WEST);
	} else if (strncmp(c->word[1], "U", 1) == 0) {
		move(UP);
	} else if (strncmp(c->word[1], "D", 1) == 0) {
		move(DOWN);
	} else
		fprintf(stdout, "Which way? ...\n");		
}	/* cmd_go */


//------------------------------------------------------------------------------

void cmd_goNorth(void)
{
	move(NORTH);
}	/* cmd_goNorth */


void cmd_goEast(void)
{
	move(EAST);
}	/* cmd_goEast */


void cmd_goSouth(void)
{
	move(SOUTH);
}	/* cmd_goSouth */


void cmd_goWest(void)
{
	move(WEST);
}	/* cmd_goWest */


void cmd_goUp(void)
{
	move(UP);
}	/* cmd_goUp */


void cmd_goDown(void)
{
	move(DOWN);
}	/* cmd_goDown */


//------------------------------------------------------------------------------

void cmd_enter(CMD_LINE *c)
{
	if (here == 7) {
		here = 2;
		fprintf(stdout, "\nYou walk through a wooden door...\n\n");
		showLocation(here);
		lookForObjects(here);

	} else
		fprintf(stdout, "Enter where?\n");
}	/* cmd_enter */


//------------------------------------------------------------------------------

void cmd_leave(CMD_LINE *c)
{
	if (here == 2) {
		here = 7;
	} else
		fprintf(stdout, "I'm not sure which way you are facing.  Try a compass!\n");
}	/* cmd_leave */


//------------------------------------------------------------------------------
//  Misc. functions

void checkLantern(void)
{
	if ((ran(99) > 92) && (here > 25))
		pirate();
	if ((movesMade > 200) && (!lanternDim)) {
		fprintf(stdout, "Your lantern is getting very dim!\n");
		fprintf(stdout, "I would look for a source of oil\n");
		lanternDim = TRUE;
	} else if ((movesMade > 250) && (!noLight)) {
		fprintf(stdout, "Your lantern has run out of fuel!\n");
		noLight = TRUE;
	} else if (noLight)
		lanternLit = FALSE;
	if (((descriptor[here] != 3) && (here < 25)) || !lanternLit) {
		fprintf(stdout, "It is pitch dark!\n\n");
		sleep(1);
		fprintf(stdout,
			"If you proceed you will most likely fall into a pit\n");
		sleep(2);
		if (ran(99) > 85)
			pit();
	}
}	/* checkLantern */


//------------------------------------------------------------------------------

void cmd_queryThing(CMD_LINE* c)
{
	fprintf(stdout, "What shall I do with the %s?\n", c->word[0]);
}	/* cmd_queryThing */


//------------------------------------------------------------------------------

void cmd_debug(CMD_LINE *c)
{
	if (debugFlg)
		debugFlg = FALSE;
	else
		debugFlg = TRUE;
}	/* cmd_debug */


//------------------------------------------------------------------------------

void cmd_drink(CMD_LINE *c)
{
	fprintf(stdout, "Drink \"%s\"? ...\n", c->word[1]);
}	/* cmd_drink */


//------------------------------------------------------------------------------

void cmd_drop(CMD_LINE *c)
{
	int
		len;

	char
		line[16],
		*str;

	OBJECT
		theObject;

	if (itemCnt == 0) {
		fprintf(stdout, "You don't have anything to drop!\n");
		return;
	}
	if (strlen(c->word[1]) == 0) {
		fprintf(stdout, "What do you want to drop? ");
		fgets(line, 16, stdin);
		len = strlen(line);
		line[--len] = '\0';
		if (len == 0)		{
			fprintf(stdout, "\nSorry, if you won't tell me what to drop, I can't do it!\n\n");
			return;
		}
		c->word[1] = line;
	}
	if ((theObject = matchObject(c->word[1])) == -1)		{
		fprintf(stdout, "I don't know how to drop '%s'.\n\n", c->word[1]);
		return;
	}
	if (list[theObject].held == FALSE)		{
		fprintf(stdout, "You dont have that to drop!\n\n");
	} else {
		list[theObject].held = FALSE;
		list[theObject].locn = here;
		itemCnt--;
		switch (theObject) {
			case _Lantern:
				lanternLit = FALSE;
				fprintf(stdout, "Ok!\n\n");
				break;
			case _Bottle:
				fprintf(stdout, "The bottle tipped over and the water spilled out of the bottle!\n");
				break;
			case _Statue:
				if (list[_Carpet].locn != here)		{
					fprintf(stdout, "The statue falls and breaks worthlessly\n");
					list[_Statue].locn = -1;
					broken = TRUE;
				} else {
					fprintf(stdout, "The statue lands safely on the persian rug.\n");
				}
			default:
				fprintf(stdout, "Ok!\n\n");
				break;
		}
	}
}	/* cmd_drop */


//------------------------------------------------------------------------------

void cmd_eat(CMD_LINE *c)
{
	fprintf(stdout, "Eat \"%s\"? ...\n", c->word[1]);
}	/* cmd_eat */


//------------------------------------------------------------------------------

void cmd_find(CMD_LINE *c)
{
	fprintf(stdout, "Find \"%s\"? ...\n", c->word[1]);
}	/* cmd_find */


//------------------------------------------------------------------------------

void cmd_get(CMD_LINE *c)
{
	int
		len;
	
	char
		line[16],
		*str;

	OBJECT
		theObject;

	if (itemCnt == itemLimit) {
		fprintf(stdout, "You can't carry anything more.  You'll have to drop something first!\n");
		return;
	}
	if (strlen(c->word[1]) == 0) {
		fprintf(stdout, "What do you want to pick up ? ");
		fgets(line, 16, stdin);
		len = strlen(line);
		line[--len] = '\0';
		if (len == 0)		{
			fprintf(stdout, "\nSorry, if you won't tell me what to pick up I can't get it!\n\n");
			return;
		}
		c->word[1] = line;
	}
	if ((theObject = matchObject(c->word[1])) == -1)		{
		fprintf(stdout, "I don't know how to get '%s'.\n\n", c->word[1]);
		return;
	}
	if (list[theObject].held)		{
		if (theObject == _Water)
			fprintf(stdout, "You can't carry any more water!\n\n");
		else
			fprintf(stdout, "You already holding that!\n\n");
	} else if (list[theObject].locn != here) {
		fprintf(stdout, "There is no %s here!\n\n", c->word[1]);
		if (debugFlg)
			fprintf(stdout, "locn = %d\n", list[theObject].locn);
	} else {
		switch (theObject) {
			case _Water:
				if (!list[_Bottle].held) {
					fprintf(stdout, "You have nothing to carry the water in!\n");
					return;
				}
				break;
			case _Oil:
				fprintf(stdout, "Your lantern is full again.\n");
				lanternDim = FALSE;
				oilLevel = movesMade;
				movesMade = 1;
				break;
			case _Book:
				if (!fine && (here = 159))
						/* goto L12150; */
				return;
			case _Axe:
				if ((here == 86) && !axeVisible) {
					fprintf(stdout, "The dragon is sitting on it!\n\n");
					return;
				}
				break;
			case _Treasure:
				if (chestLocked) {
					fprintf(stdout, "It's locked!\n");
					return;
				} else
				break;
			case _Partner:
				break;
		}
		fprintf(stdout, "Ok!\n\n");
		list[theObject].held = TRUE;
		list[theObject].locn = -1;
		itemCnt++;
	}
}	/* cmd_get */


//------------------------------------------------------------------------------

void cmd_give(CMD_LINE *c)
{
}	/* cmd_give */


//------------------------------------------------------------------------------

void cmd_help(CMD_LINE *c)
{
}	/* cmd_help */


//------------------------------------------------------------------------------

void cmd_how(CMD_LINE *c)
{
	fprintf(stdout, "I refuse to answer on the grounds that it might incriminate me!\n");
}	/* cmd_how */


//------------------------------------------------------------------------------

void cmd_inventory(CMD_LINE *c)
{
	OBJECT
		theObject;

	if (itemCnt > 0)		{
		fprintf(stdout, "\nYou are holding the following:\n");
		for (theObject = _Keys; theObject <= _Partner; theObject++)
			if (list[theObject].held == TRUE)
				fprintf(stdout, "   %s\n", list[theObject].name);
	} else
		fprintf(stdout, "\nYou are not holding anything!\n");
}	/* cmd_inventory */


//------------------------------------------------------------------------------

void cmd_kill(CMD_LINE *c)
{
}	/* cmd_kill */


//------------------------------------------------------------------------------

void cmd_kiss(CMD_LINE *c)
{
}	/* cmd_kiss */


//------------------------------------------------------------------------------

void cmd_lift(CMD_LINE *c)
{
}	/* cmd_lift */



//------------------------------------------------------------------------------

void cmd_light(CMD_LINE *c)
{
}	/* cmd_light */


//------------------------------------------------------------------------------

void cmd_listen(CMD_LINE *c)
{
	int
		i;

	if ((i - ran(3)) == 0)
        fprintf(stdout, "Slosh, boil, drip, spurt, squirt ...\n" );
    else if (i == 1)
        fprintf(stdout, "I don't hear anything\n" );
}	/* cmd_listen */


//------------------------------------------------------------------------------

void cmd_map(CMD_LINE *c)
{
	if ( showMap )
		showMap = FALSE;
	else
		showMap = TRUE;
}	/* cmd_map */

//------------------------------------------------------------------------------

void cmd_move(CMD_LINE *c)
{
	cmd_go(c);
}	/* cmd_move */


//------------------------------------------------------------------------------

void cmd_no(CMD_LINE *c)
{
}	/* cmd_no */


//------------------------------------------------------------------------------

void cmd_open(CMD_LINE *c)
{
}	/* cmd_open */


//------------------------------------------------------------------------------

void cmd_pay(CMD_LINE *c)
{
}	/* cmd_pay */


//------------------------------------------------------------------------------

void cmd_please(CMD_LINE *c)
{
}	/* cmd_please */


//------------------------------------------------------------------------------

void cmd_quit(CMD_LINE *c)
{
	fprintf(stdout, "\n\n\n");

	if (prompt("Do you really want to quit ? [%c] ", YES) == YES) {
		loop = FALSE;
	}
}	/* cmd_quit */


//------------------------------------------------------------------------------

void cmd_say(CMD_LINE *c)
{
	if (equivString(magicWord, c->word[1]))		{
		if (here == 199)		{
			fprintf(stdout, "A secret passage opens to the west!\n");
			moveCode[199] = 9;
		} else if (here == HUT)		{
			here = CAVE_ENTRANCE;
			firstGlimpse = FALSE;
		} else if (here == CAVE_ENTRANCE)		{
			here = HUT;
			firstGlimpse = FALSE;
		} else { 
			fprintf(stdout, "Nothing happens!\n");
		}
	} else {
		fprintf(stdout, "Okay, '%s'!\n", c->word[1]);
	}
}	/* cmd_say */


//------------------------------------------------------------------------------

void cmd_shake(CMD_LINE *c)
{
}	/* cmd_shake */


//------------------------------------------------------------------------------

void cmd_slay(CMD_LINE *c)
{
}	/* cmd_slay */


//------------------------------------------------------------------------------

void cmd_undefined(CMD_LINE *c)
{
	fprintf(stdout, "I don't know what you mean!\n");
}	/* cmd_undefined */


//------------------------------------------------------------------------------

void cmd_unlock(CMD_LINE *c)
{
}	/* cmd_unlock */


//------------------------------------------------------------------------------

void cmd_wave(CMD_LINE *c)
{
}	/* cmd_wave */


//------------------------------------------------------------------------------

void cmd_wet(CMD_LINE *c)
{
}	/* cmd_wet */


//------------------------------------------------------------------------------

void cmd_what(CMD_LINE *c)
{
	fprintf(stdout, "I refuse to answer on the grounds that it might incriminate me!\n");
}	/* cmd_what */


//------------------------------------------------------------------------------

void cmd_when(CMD_LINE *c)
{
	fprintf(stdout, "I refuse to answer on the grounds that it might incriminate me!\n");
}	/* cmd_when */


//------------------------------------------------------------------------------

void cmd_where(CMD_LINE *c)
{
	if (debugFlg)
		fprintf(stdout, "here = %d, moveCode = %d\n", here, moveCode[here]);

	fprintf(stdout, "I'm not really sure which way you're facing.  Try a compass heading.\n" );
}	/* cmd_where */


//------------------------------------------------------------------------------

void cmd_who(CMD_LINE *c)
{
}	/* cmd_who */


//------------------------------------------------------------------------------

void cmd_yes(CMD_LINE *c)
{
}	/* cmd_yes */


//------------------------------------------------------------------------------

/*
 *  Debugging routines.
 */

void cmd_toggleDebug(void)
{
	if (debugFlg)
		debugFlg = FALSE;
	else
		debugFlg = TRUE;
}	/* cmd_toggleDebug */


//------------------------------------------------------------------------------

void cmd_teleport(void)
{
	int
		new;

	char
		s[STR16];

	fprintf(stdout, "Where do you want to go ? ");

	gets(s);

	new = atoi(s);

	if ((new >= 0) && (new <= 125))
		here = new;

	firstGlimpse    = TRUE;

	showLocation(here);

	lookForObjects(here);
}	/* cmd_teleport */


//------------------------------------------------------------------------------

void cmd_scanScenes(void)
{
	listScenes();
}	/* cmd_scanScores */


//------------------------------------------------------------------------------

