/*
 *      Author:  Peter Harding  <plh@eram.esi.com.au>
 *               P. O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  578 8001
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [1.2.1] endgame.c 01/04/92";


//------------------------------------------------------------------------------

#include "config.h"

#include <stdio.h>
#include <errno.h>

#ifdef MAC
#include <console.h>
#include <stdlib.h>
#include <unix.h>
#endif MAC

#ifdef UNIX
#endif UNIX


#include "misc.h"
#include "advent.h"
#include "command.h"
#include "global.h"
#include "objects.h"
#include "objectGlobals.h"
#include "error.h"


//------------------------------------------------------------------------------

extern int   errno;              /*  Standard error return.  */


//------------------------------------------------------------------------------

typedef struct rank
	RANK;

struct rank {
	char *title;
	int	minScore;
};

RANK
	ranks [] = {
		{ "Failed", -9999999 },
		{ "RANK BEGINNER", 0 },
		{ "NOVICE",	50 },
		{ "EXPERIENCED", 100 },
		{ "SEASONED", 150 },
		{ "Junior MASTER", 200 },
		{ "Senior MASTER", 250 },
		{ "MASTER", 300 },
		{ "WIZARD", 350 }
	};

#define	NORANKS	(sizeof(ranks) / sizeof(RANK))


//------------------------------------------------------------------------------

void die(void);


//------------------------------------------------------------------------------

void pit(void)
{
	fprintf(stdout,
		"\nYou fell into a pit and are a mass of twisted flesh and bones.\n\n");
	die();
}	/* pit */


//------------------------------------------------------------------------------

void die(void)
{
	char
		reply;

	OBJECT
		theObject;

	if (++pitCnt < NO_LIVES)	{
		fprintf(stdout, "\n");
		fprintf(stdout, "I might be able to reincarnate you!\n");
		fprintf(stdout, "Would you like me to try?\n");
	} else {
		fprintf(stdout, "You've really done it this time.\n");
		fprintf(stdout, "I'm all out of fairy dust!\n\n");
		fprintf(stdout, "You don't really expect me to do a decent\n");
		fprintf(stdout, "reincarnation without it do you?\n");
		killed = _FALSE;
		dwarfCnt = 0;
	}

	fprintf(stdout, "\n... Well ? ");

	if ((reply = prompt("What [%c] ? ", YES)) == YES) {
		if (pitCnt < NO_LIVES)	{
			fprintf(stdout, "Ready......one.two..three!	*POOF*\n\n");
			fprintf(stdout, "You emerge from a cloud of fairy dust only to find yourself.......\n");

			for (theObject = _Axe; theObject <= _Partner; theObject++) {
				if (list[theObject].held)	{
					list[theObject].held = _FALSE;
					if (theObject = _Lantern)
						list[theObject].locn = HUT;
					else
						list[theObject].locn = here;
				}
			}

			here         = HUT;
			firstGlimpse = FALSE;
		} else {
			fprintf(stdout, "\nOk!	If you're so smart do it yourself!!\n\n");
			finished     = TRUE;
		}
	} else
		finished = TRUE;
}	/* die */


//------------------------------------------------------------------------------

void calcScores(void)
{
	int
		finalScore = 0,
		grade;

	OBJECT
		theObject;

	for (theObject = _Keys; theObject <= _Partner ; theObject++) {
		if (list[theObject].locn == HUT)	{
			finalScore += list[theObject].value;
#ifdef TRSCORES
			fprintf(stdout,
				"	In calcScores() :-	%10s >> Value <%2d>	Score = <%2d>\n",
					list[theObject].name, list[theObject].value, finalScore);
#endif TRSCORES
		}
	}

	if (mysticFlg)
		finalScore += 50;

	finalScore -= (movesMade + oilLevel) / 10;

	for (grade = 0; grade < NORANKS ; grade++)	 {
		if (finalScore >= ranks[grade].minScore)
			continue;
		break;
	}

	if (grade > 0)
		grade--;

	fprintf(stdout,
		"\nYou scored %d points out of a possible 350, using %d turns!\n\n",
		 finalScore, movesMade);
	fprintf(stdout, "Your score qualifies you as a\n\n");
	fprintf(stdout, "	*** '%s' ADVENTURER ***\n\n", ranks[grade].title);

	if (grade != (NORANKS - 1)) 
		fprintf(stdout,
			"To achieve the next higher rating you need %d more points!\n\n\n",
		 	ranks[grade + 1].minScore - finalScore );
}	/* calcScores */


//------------------------------------------------------------------------------

