/*
 *      Author:  Peter Harding  <plh@eram.esi.com.au>
 *               P. O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  578 8001
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [1.2.1] creatures.c 01/04/92";


//------------------------------------------------------------------------------

#include "config.h"

#include <stdio.h>

#ifdef MAC
#include <console.h>
#include <stdlib.h>
#include <unix.h>
#endif MAC

#ifdef UNIX
#endif UNIX

#include "misc.h"
#include "global.h"
#include "objects.h"
#include "objectGlobals.h"


//------------------------------------------------------------------------------

void pirate(void)
{
	char
		*s;

	OBJECT
		theObject;

	if (!pirateGone) {
		if (shadowyFigure) {
			shadowCnt++;

			fprintf(stdout, "\nA shadowy figure is following you!\n\n");

			for (theObject = _Partner; theObject >= _Book; theObject--) {
				if (list[theObject].held && shadowCnt > (ran(13) + 7))	{
					if (theObject == _Partner)
						s = partner;
					else {
						s = list[theObject].name; /* lower(name)!! */
					}

					fprintf(stdout, "The shadow leaps out of the darkness.\n\n");
					fprintf(stdout, "'Har har', cries a bearded pirate, 'me thinks me will take a little of\n");
					fprintf(stdout, "yur booty!'\n\n");
					fprintf(stdout, "The %s will do just fine!\n\n", s);
					fprintf(stdout, "With that he scurries off to his treasure cave!!!!\n\n");

					list[theObject].held = FALSE;
					list[theObject].locn = 32;

					break;
				}
			}
		} else {
			if (ran(99) >= 96)
				shadowyFigure = TRUE;
			shadowCnt = 0;
		}
	}
}	/* pirate */


//------------------------------------------------------------------------------

void dwarf(void)
{
	if (!dwarfAbout)	{
		fprintf(stdout,
			 "An angry dwarf came in and threw a little axe which just missed you.\n\n");
		fprintf(stdout, "He cursed and ran away!\n");
		list[_Axe].locn = here;
		firstGlimpse = TRUE;
		dwarfAbout   = TRUE;
		axeVisible   = TRUE;
	} else {
		fprintf(stdout, "There's an angry dwarf in the room with you!\n\n");
		fprintf(stdout, "He throws a single knife\n");

		if (ran(++dwarfCnt) <= 3)	{
			fprintf(stdout, "It misses!\n");
		} else {
			fprintf(stdout, "It hits you!\n");
			if (killed++ > 5)	{
				die();
			}
		}
	}
}	/* dwarf */


//------------------------------------------------------------------------------

