/*
 *      Author:  Peter Harding  <plh@yarra>
 *
 *               Phone:  (03) 521 3799
 *               Fax:    (03) 525 1730
 *               Mobile: (03) 375 085
 *
 *      Date:    `date`
 *
 *      @(#)command.h: Command structures and definitions.
 */

#ifndef   _COMMAND_H_
#define   _COMMAND_H_


//------------------------------------------------------------------------------

#define NO_WORDS_PER_LINE  5


//------------------------------------------------------------------------------

typedef struct cmd_line
	CMD_LINE;

struct cmd_line {
	int noWords;
	char *word[NO_WORDS_PER_LINE];
};


//------------------------------------------------------------------------------

typedef struct command
	COMMAND;

struct command {
	char *name;
	void (*fn)();
};


//------------------------------------------------------------------------------

enum key_words {
	_North,
	_South,
	_East,
	_West,
	_Up,
	_Down,
	_Drink,
	_Drop,
	_Eat,
	_Enter,
	_Leave,
	_Find,
	_Get,
	_Give,
	_Go,
	_Help,
	_How,
	_Inventory,
	_Kill,
	_Kiss,
	_Lift,
	_Light,
	_Listen,
	_Look,
	_Open,
	_Pay,
	_Please,
	_Quit,
	_Say,
	_Shake,
	_Slay,
	_Unlock,
	_Wave,
	_Wet,
	_What,
	_When,
	_Where,
	_Who,
	_Yes,
	_You,
	_Your,
	_Undefined,
	_Nul
};

typedef enum key_words
	KEY_WORDS;


//------------------------------------------------------------------------------

#endif /* _COMMAND_H_ */


