/*
 *      Author:  Peter Harding  <plh@eram.esi.com.au>
 *               P. O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  578 8001
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [1.2.1] command.c 01/04/92";

//------------------------------------------------------------------------------

#include "config.h"

#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#ifdef MAC
#include <console.h>
#include <unix.h>
#include <string.h>
#endif MAC

#include <stdlib.h>
#include <unistd.h>

#ifdef UNIX
#include <strings.h>
#endif UNIX

#include "misc.h"
#include "global.h"
#include "command.h"
#include "functions.h"


//------------------------------------------------------------------------------

COMMAND commandList[] = {
	{"North",     &cmd_goNorth},
	{"South",     &cmd_goSouth},
	{"East",      &cmd_goEast},
	{"West",      &cmd_goWest},
	{"Up",        &cmd_goUp},
	{"Down",      &cmd_goDown},
	{"Quit",      &cmd_quit},
	{"DEbug",     &cmd_toggleDebug},
	{"DRink",     &cmd_drink},
	{"DRop",      &cmd_drop},
	{"EAt",       &cmd_eat},
	{"ENter",     &cmd_enter},
	{"EXit",      &cmd_leave},
	{"Leave",     &cmd_leave},
	{"Find",      &cmd_find},
	{"GEt",       &cmd_get},
	{"GIve",      &cmd_give},
	{"GO",        &cmd_go},
	{"HElp",      &cmd_help},
	{"HOw",       &cmd_how},
	{"Inventory", &cmd_inventory},
	{"KILl",      &cmd_kill},
	{"KISs",      &cmd_kiss},
	{"LIFt",      &cmd_lift},
	{"LIGht",     &cmd_light},
	{"LISten",    &cmd_listen},
	{"LOok",      &cmd_look},
	{"No",        &cmd_no},
	{"Map",       &cmd_map},
	{"Open",      &cmd_open},
	{"PAy",       &cmd_pay},
	{"PLease",    &cmd_please},
	{"SCenes",    &cmd_scanScenes},
	{"SAy",       &cmd_say},
	{"SHake",     &cmd_shake},
	{"SLay",      &cmd_slay},
	{"Teleport",  &cmd_teleport},
	{"Unlock",    &cmd_unlock},
	{"WAve",      &cmd_wave},
	{"WEt",       &cmd_wet},
	{"WHAt",      &cmd_what},
	{"WHEN",      &cmd_when},
	{"WHERe",     &cmd_where},
	{"WHO",       &cmd_who},
	{"Yes",       &cmd_yes},
	{"YOU",       &cmd_undefined},
	{"YOUR",      &cmd_undefined},
	{"AXE",       &cmd_queryThing},
	{"BOOK",      &cmd_queryThing},
	{"BOTTLE",    &cmd_queryThing},
	{"CARPET",    &cmd_queryThing},
	{"CROWN",     &cmd_queryThing},
	{"DIAMONDs",  &cmd_queryThing},
	{"EMERALD",   &cmd_queryThing},
	{"FOOD",      &cmd_queryThing},
	{"KEYS",      &cmd_queryThing},
	{"LANTern",   &cmd_queryThing},
	{"OIL",       &cmd_queryThing},
	{"ROPE",      &cmd_queryThing},
	{"SILVER",    &cmd_queryThing},
	{"STATUE",    &cmd_queryThing},
	{"SWORD",     &cmd_queryThing},
	{"TREASure",  &cmd_queryThing},
	{"WAND",      &cmd_queryThing},
	{"WATER",     &cmd_queryThing},
	{"UNDEFINED", &cmd_undefined}
};

#define NO_COMMANDS     sizeof(commandList)/sizeof(COMMAND)
#define UNDEFINED_CMD   (NO_COMMANDS - 1)


//------------------------------------------------------------------------------

void noCommands(void)
{
	if (debugFlg)
		fprintf(stdout, "NO_COMMANDS = %d\n", NO_COMMANDS);
}	/* noCommans */


//------------------------------------------------------------------------------

void doAction(CMD_LINE *c)
{
	int
		i, cmdIdx;

	movesMade++;

	cmdIdx = UNDEFINED_CMD;

	for (i = 0; i < NO_COMMANDS; i++) {
		if (equivString(commandList[i].name, c->word[0])) {
			cmdIdx = i;
			break;
		}
	}

#ifdef DEBUG
	fprintf(stdout, "Cmd -> %d\n", cmdIdx);
	fprintf(stdout, "Cmd -> %s\n", commandList[cmdIdx].name);
#endif DEBUG

	(*commandList[cmdIdx].fn)(c);
}	/* doAction */


//------------------------------------------------------------------------------

CMD_LINE *getReply(void)
{
	static char
		cmdStr[STR128];

	static CMD_LINE
		reply;

	BOOLEAN
		newWord;

	int
		i, noWords;

	char
		*s;

	fprintf(stdout, ">> ");

	gets(cmdStr);

	reply.noWords = 0;
	s             = cmdStr;
	newWord       = TRUE;

	while (*s != (char)NULL) {
		if ((*s != ' ') && (*s != '\t')) {
			if (newWord == TRUE) {
				if (reply.noWords >= NO_WORDS_PER_LINE) {
					fprintf(stdout, "[getReply] I only know how to parse %d words\n", NO_WORDS_PER_LINE);
					return(&reply);
				}

				newWord                     = FALSE;
				reply.word[reply.noWords++] = s;
			}
		} else {
			newWord = TRUE;
			*s      = (char)0;
		}
		s++;
	}

	for (i = reply.noWords; i < NO_WORDS_PER_LINE; i++)
		reply.word[i] = s;

	return(&reply);
}	/* getReply */


//------------------------------------------------------------------------------

