#!/usr/bin/env python

"""
Skeleton Python Framework

Usage: skel.py -g <no_groups> -s <no_students>

The '-g <no_groups>' option is used to specift the number of groups
that the class level is to be broke up into

The '-s <no_students>' specifies the size of the overall student group
"""

import sys
import getopt
import string
import whrandom



#----------------------------------------------------------------------------

def main():
   try:
      opts, args = getopt.getopt(sys.argv[1:], "dg:s:v")
   except getopt.error, msg:
      print __doc__,
      return 1

   global no_groups

   no_groups   = 3

   for o, a in opts:
      if o == '-g':
         no_groups = string.atoi(a)

   if args:
      for arg in args:
         process(arg)
   else:
      process(".")

   for i in range(no_groups):
      print "\n"


#----------------------------------------------------------------------------

def process(str):
   print str


#----------------------------------------------------------------------------

if __name__ == '__main__' or __name__ == sys.argv[0]:
    sys.exit(main())


#----------------------------------------------------------------------------

