#!/usr/bin/env python

"""Test class grouping algorithm

Usage: grouping.py -g <no_groups> -s <no_students>

The '-g <no_groups>' option is used to specift the number of groups
that the class level is to be broke up into

The '-s <no_students>' specifies the size of the overall student group
"""

import os
import sys
import stat
import getopt
import string
import whrandom



#----------------------------------------------------------------------------

def main():
   try:
      opts, args = getopt.getopt(sys.argv[1:], "n:s:")
   except getopt.error, msg:
      print msg
      print __doc__,
      return 1

   global no_groups
   global no_students
   global lower
   global upper

   no_groups   = 3
   no_students = 100
   lower       = 20
   upper       = 90


   for o, a in opts:
      if o == '-g':
         no_groups = a

   if args:
      for arg in args:
         process(arg)
   else:
      process(".")

   setup_student_list(no_students)

   student_list.sort()
   student_list.reverse()

   group(no_groups)



#----------------------------------------------------------------------------

def setup_student_list(n):
   global student_list

   student_list = []

   for i in range(no_students):
      rand_score = whrandom.randint(lower, upper)

      student_list.append(rand_score)

      print i, student_list[len(student_list)-1]


#----------------------------------------------------------------------------

def group(n):
   """Grouping"""

   i = 0

   while i < len(student_list):
      alloc(i, no_groups)


#----------------------------------------------------------------------------

def alloc(start, no):
   """First sort groups by cumulative score"""
   
   for i in range(no):
      if (start + i < len(student_list)):
         cum[i] = cum[i] + score[start+i]


#----------------------------------------------------------------------------

def process(str):
   print str


#----------------------------------------------------------------------------

sys.exit(main())

