#!/usr/bin/env python

import sys
import getopt
import time
import random
import pickle

#---------------------------------------------------------------------

debugFlg = 0
no_items = 0

#---------------------------------------------------------------------

class testset:
   no_items_per_test   = 2
   no_tests            = 0
   curr_set            = 3
   no_sets             = 0
   set_no              = 0
   max                 = 12
   name                = None
   filename            = None

   def __init__(self,no_items_per_test=10,multiplier=3):
      self.no_items_per_test   = no_items_per_test
      self.curr_multiplier     = multiplier
      self.tests               = []

   def __str__(self):
      str  = """
   Number of tests:  %d
Current multiplier:  %d
              Name:  %s
""" % (self.no_tests, self.curr_set, self.filename)
      return str

   def show_multiplier(self):
      return self.curr_set

   def add_test(self, set):
      self.tests.append(set)
      self.no_tests = len(self.tests)

   def set_no_items(self,no):
      self.no_items_per_test = no

   def dump(self):
      print self.tests

   def report(self):
      print self
      print "Test  Items  Correct  Time (sec)"
      for i in range(len(self.tests)):
         set = self.tests[i]
         no_items = set[1]
         last     = set[-1]
         elapsed_time = last[0]
         no_correct   = last[1]
         print "%3d     %2d     %2d     %3d" % (i+1, no_items, no_correct, elapsed_time)
      print

#---------------------------------------------------------------------

def restore(name):
   filename = name.lower() + ".maths"

   try:
      f          = open(filename, 'r')
      u          = pickle.Unpickler(f)
      t          = u.load()
      f.close()
      print "Reloaded old data for %s ..." % name
   except IOError, e:
      #t          = testset(no_items_per_test=no_items)
      t          = testset()
      t.name     = name.capitalize()
      t.filename = filename
   return t

#---------------------------------------------------------------------

def save(t):
   try:
      f          = open(t.filename, 'w')
      p          = pickle.Pickler(f)
      p.dump(t)
      f.close()
   except IOError, e:
      print "Failed to save data"

#---------------------------------------------------------------------

def getline(prompt):
   try:
      line = raw_input(prompt)
   except KeyboardInterrupt, e:
      print " ** Caught Keyboard Interrupt..."
      return None
   except EOFError, e:
      print " ** Terminating - EoF Detected..."
      return None
   return line

#---------------------------------------------------------------------

def prompt(str, default):
   prompt_str = str % default

   try:
      line = raw_input(prompt_str)
   except KeyboardInterrupt, e:
      print " ** Caught Keyboard Interrupt..."
      return None
   except EOFError, e:
      print " ** Terminating - EoF Detected..."
      return None

   if len(line) == 0:
      line = default

   return line

#---------------------------------------------------------------------

def do_test():
   correct_cnt = 0
   wrong_cnt   = 0
   turns       = 0

   start_time  = time.time()

   set         = [start_time, t.no_items_per_test]

   for i in range(t.no_items_per_test):
      n     = int(random.random() * t.max)
      str   = "%d X %d = ___  ? " % (n, t.curr_set)
      n_ans = n * t.curr_set

      ans = getline(str)

      if (ans == None):
         sys.exit(0)
      else:
         try:
            my_ans = int(ans)
            if (my_ans == n_ans):
               print "Correct!"
               correct_cnt += 1
            else:
               print "Wrong! Try it again."
               wrong_cnt += 1
         except ValueError, e:
            my_ans = None
            print "Bad value!"
         set.append([n, t.curr_set, n_ans, my_ans])
         turns += 1

   end_time = time.time()

   time_taken = end_time - start_time

   print "\n"
   print "You got %d out of %d correct in %d seconds" % (correct_cnt, turns, time_taken)
   print "Wrong:   %d" % wrong_cnt

   set.append([time_taken, correct_cnt, wrong_cnt])

   if (debugFlg):
      print set

   t.add_test(set)

#---------------------------------------------------------------------

def process(s):
   pass

#---------------------------------------------------------------------

def main():
   global t

   no_items  = 0
   report_no = 0
   name = None

   try:
      opts, args = getopt.getopt(sys.argv[1:], "di:n:r:v")
   except getopt.error, msg:
      print __doc__,
      return 1

   for o, a in opts:
     if o == '-r':
       report_no = int(a)
     elif o == '-i':
       no_items = int(a)
     elif o == '-d':
       debugFlg = 1
     elif o == '-n':
       name = a
     elif o == '-v':
       verboseFlg = 1

   if args:
     for arg in args:
       process(arg)
   else:
     pass

   if name == None:
      name = getline("Type your name: ")

      if ((name == None) or (len(name) == 0)):
         sys.exit(0)

   t = restore(name.lower())

   if report_no == 1:
      t.report()
      sys.exit(0)

   if (no_items > 0):
      t.set_no_items(no_items)

   while 1:
      do_test()
      more = prompt("Continue [%s]? ", "Yes")
      if more != "Yes":
         break

   print t

   save(t)

   return 0

#---------------------------------------------------------------------

if __name__ == '__main__' or __name__ == sys.argv[0]:
   sys.exit(main())

#---------------------------------------------------------------------

