#!/usr/bin/env python

import sys
import random
import screen

#------------------------------------------------------------------------------

VERSION = "1.4.4.1"

#------------------------------------------------------------------------------

TRUE                    =    1
FALSE                   =    0
UNDEFINED               =   -1

#------------------------------------------------------------------------------

MAZE_SIZE               =  250
NO_KEY_WORDS            =   57
NO_ENTITIES             =    3
MAX_LOCATION_DESCRIPTOR =   19
NO_DESCRIPTORS          =   19

NORTH                   =    0
EAST                    =    1
SOUTH                   =    2
WEST                    =    3
UP                      =    4
DOWN                    =    5

NORTH_OK                = 0x01
EAST_OK                 = 0x02
SOUTH_OK                = 0x04
WEST_OK                 = 0x08
UP_OK                   = 0x10
DOWN_OK                 = 0x20

MAZE_NS                 =    5
MAZE_EW                 =    5

HUT                     =    2
KNIGHTS_GLADE           =   17
CAVE_ENTRANCE           =   40

NO_LIVES                =    3
ITEM_LIMIT              =   10  # Should be 6!
OIL_LEVEL               =   99

#------------------------------------------------------------------------------

magicWord               = None
partner                 = None

here                    =    7
dwarfCnt                =    0
helpCnt                 =    0
itemCnt                 =    0
itemLimit               = ITEM_LIMIT
maxLives                = NO_LIVES
movesMade               =    0
oilLevel                = OIL_LEVEL
pitCnt                  =    0
shadowCnt               =    0

magicWord               = None
partner                 = None

direction               = None
objects                 = None
 
axeVisible              = TRUE
broken                  = FALSE
chestLocked             = TRUE
debugFlg                = TRUE
dragonAbout             = TRUE
drawbridgeDown          = FALSE
dwarfAbout              = FALSE
dwarfHere               = FALSE
fine                    = FALSE
finished                = FALSE
firstGlimpse            = TRUE
frogAbout               = FALSE
grateLocked             = TRUE
killed                  = FALSE
knightAbout             = TRUE
lanternDim              = FALSE
lanternLit              = FALSE
look                    = TRUE
loop                    = TRUE
mysticFlg               = FALSE
noLight                 = TRUE
pirateGone              = FALSE
shadowyFigure           = FALSE
showMap                 = FALSE

#------------------------------------------------------------------------------

functions     = {}

#------------------------------------------------------------------------------

increment = (
   (-MAZE_EW),              # North
   1,                       # East
   (MAZE_EW),               # South
   (-1),                    # West
   (-(MAZE_NS * MAZE_EW)),  # Up
   (MAZE_NS * MAZE_EW)      # Down
)

#------------------------------------------------------------------------------

directionMask = (
   NORTH_OK,
   EAST_OK,
   SOUTH_OK,
   WEST_OK,
   UP_OK,
   DOWN_OK
)


#------------------------------------------------------------------------------

lookMask = (
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x0F,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x20,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x10,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00
)


#------------------------------------------------------------------------------

moveMask = (
   0x22,  0x04,  0x00,  0x06,  0x0E,
   0x0F,  0x0F,  0x0E,  0x0F,  0x0F,
   0x0B,  0x0F,  0x0F,  0x07,  0x0D,
   0x22,  0x0F,  0x0F,  0x0F,  0x0B,
   0x0A,  0x0A,  0x0B,  0x0B,  0x0B,

   0x22,  0x0E,  0x0A,  0x0A,  0x0E,
   0x12,  0x09,  0x0D,  0x22,  0x0F,
   0x0A,  0x0E,  0x22,  0x0D,  0x0C,
   0x12,  0x0F,  0x0A,  0x05,  0x0F,
   0x0A,  0x09,  0x0B,  0x0A,  0x00,

   0x22,  0x0A,  0x0A,  0x0A,  0x0A,
   0x0E,  0x00,  0x12,  0x10,  0x22,
   0x0F,  0x0D,  0x0E,  0x0A,  0x0A,
   0x0F,  0x0E,  0x0E,  0x0F,  0x0F,
   0x03,  0x09,  0x0B,  0x0B,  0x0B,

   0x0B,  0x0E,  0x0A,  0x0A,  0x12,
   0x0A,  0x0F,  0x12,  0x05,  0x0C,
   0x0B,  0x0B,  0x0A,  0x0A,  0x09,
   0x04,  0x01,  0x06,  0x0A,  0x0A,
   0x0B,  0x0B,  0x0B,  0x08,  0x20,

   0x12,  0x12,  0x12,  0x12,  0x12,
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F,
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F, 
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F,
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F
)


#------------------------------------------------------------------------------

wizLookMask = (
   0x23,  0x2B,  0x2B,  0x2B,  0x29,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x26,  0x2E,  0x2E,  0x2E,  0x2C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x13,  0x1B,  0x1B,  0x1B,  0x19,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x16,  0x1E,  0x1E,  0x1E,  0x1C
)


#------------------------------------------------------------------------------

wizMoveMask = (
   0x23,  0x2B,  0x2B,  0x2B,  0x29,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x26,  0x2E,  0x2E,  0x2E,  0x2C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x13,  0x1B,  0x1B,  0x1B,  0x19,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x16,  0x1E,  0x1E,  0x1E,  0x1C
)


#------------------------------------------------------------------------------

descriptor = (
    9,  3,  1,  3,  3,
    6,  6,  2,  6,  6,
    3,  6,  2,  2,  3,
    7,  2,  2,  6,  3,
    3,  4,  4,  4, 11,

    9, 17, 12, 12, 17,
   19, 16, 20, 18, 21,
   12, 17, 22, 23, 16,
    8, 21, 12, 14, 24,
   12, 16, 17, 12, 23,

    9, 13, 13, 13, 13,
   13, 25, 26,  5,  9,
   26, 26, 27, 12, 12,
   26, 26, 26, 26, 26,
   26, 26, 26, 26, 26,

   16, 17, 12, 12, 19,
   12, 21, 19, 14, 16,
   17, 28, 12, 12, 16,
   29, 30, 29, 13, 34,
   31, 36, 32, 33, 35,

   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37
)


#------------------------------------------------------------------------------

print len(descriptor)
print moveMask

#------------------------------------------------------------------------------

def randomize():
   random.seed(None)

#------------------------------------------------------------------------------

def rand(n):
   return int(n * random.random())

#===== Command shells =========================================================

def cmd_go(cmd):
   if (len(cmd) > 1):
      if (cmd[1][0:1].upper() == "N"):
         move(NORTH)
      elif (cmd[1][0:1].upper() == "E"):
         move(EAST)
      elif (cmd[1][0:1].upper() == "S"):
         move(SOUTH)
      elif (cmd[1][0:1].upper() == "W"):
         move(WEST)
      elif (cmd[1][0:1].upper() == "U"):
         move(UP)
      elif (cmd[1][0:1].upper() == "D"):
         move(DOWN)
      else:
         print "Which way? ..."      
   else:
      print "Go where? ..."      

   return 1

#------------------------------------------------------------------------------

def cmd_goNorth(cmd):
   move(NORTH)

   return 1

def cmd_goEast(cmd):
   move(EAST)

   return 1

def cmd_goSouth(cmd):
   move(SOUTH)

   return 1

def cmd_goWest(cmd):
   move(WEST)

   return 1

def cmd_goUp(cmd):
   move(UP)

   return 1

def cmd_goDown(cmd):
   move(DOWN)

   return 1

#------------------------------------------------------------------------------

def cmd_debug(cmd):
   global debugFlg

   if (debugFlg):
      debugFlg = FALSE
   else:
      debugFlg = TRUE

   return 1

#------------------------------------------------------------------------------

def cmd_drink(cmd):
   print "Drink \"%s\"? ...\n" % cmd[1]

   return 1

#------------------------------------------------------------------------------

def cmd_drop(cmd):
   global broken
   global itemCnt
   global lanternLit

   if (itemCnt == 0):
      print "You don't have anything to drop!"
      return

   if (len(cmd) == 1):
      reply = raw_input("What do you want to drop? ")
      l = len(reply)
      if (l == 0):
         print "\nSorry, if you won't tell me what to drop, I can't do it!\n"
         return
      cmd[1] = reply

   idx = matchObject(cmd[1])

   if (idx == -1):
      print "I don't know how to drop '%s'.\n\n" % cmd[1]
      return 1

   if (Objects[idx][2] == FALSE):
      print "You dont have that to drop!\n"
   else:
      Objects[idx][2] = FALSE
      Objects[idx][1] = here
      itemCnt -= 1

      if (Objects[idx][0] == "Lantern"):
         lanternLit = FALSE
         print "Ok!\n"
      elif (Objects[idx][0] == "Bottle"):
         print "The bottle tipped over and the water spilled out of the bottle!\n"
      elif (Objects[idx][0] == "Statue"):
         if (Objects[8][1] != here):  # Carpet
            print "The statue falls and breaks worthlessly"
            Objects[10][1] = -1  # Statue
            broken = TRUE
         else:
            print "The statue lands safely on the persian rug.\n"
      else:
         print "Ok!\n"

   return 1

#------------------------------------------------------------------------------

def cmd_eat(cmd):
   if (len(cmd) > 1):
      print "Eat \"%s\"? ..." % cmd[1]
   else:
      print "Eat what? ..."

   return 1

#------------------------------------------------------------------------------

def cmd_enter(cmd):
   global here

   print '[cmd_enter]'

   if (here == 7):
      here = 2
      print "\nYou walk through a wooden door..."
      lookAtLocation(here)
      lookForObjects(here)
   else:
      print "Enter where?"

   return 1

#------------------------------------------------------------------------------

def cmd_exit(cmd):
   global here

   print "[exit]"

   if (here == 2):
      here = 7
      lookAtLocation(here)
      lookAround(here)
   else:
      print "Exit what?"

   return 1

#------------------------------------------------------------------------------

def cmd_find(cmd):
   if (len(cmd) > 1):
      print "Find \"%s\"? ..." % cmd[1]
   else:
      print "Find what? ..."

   return 1

#------------------------------------------------------------------------------

def cmd_get(cmd):
   global itemCnt
   global lanternDim
   global movesMade
   global oilLevel

   if (itemCnt == itemLimit):
      print "You can't carry anything more."
      print "You'll have to drop something first!\n"
      return 1

   if (len(cmd) == 1):
      reply = raw_input("What do you want to pick up ? ")
      l = len(reply)
      if (l == 0):
         print "Sorry, if you won't tell me what to pick up I can't get it!\n"
         return 1

      cmd.append(reply)

   pickup = []

   if (cmd[1].capitalize() == "All"):
      for idx in range(len(Objects)):
         if (Objects[idx][1] == here):
            pickup.append(idx)
   else:
      idx = matchObject(cmd[1])

      if (idx == -1):
         print "I don't know how to get '%s'." %  cmd[1]
         return 1
      else:
         pickup.append(idx)

   for idx in pickup:
      if (itemCnt == itemLimit):
         print "You can't carry anything more."
         print "You'll have to drop something before you can pick up anything else!"
         return 1

      if (Objects[idx][2]):
         if (Objects[idx] == "Water"):
            print "You can't carry any more water!"
         else:
            print "You already holding that!"

      elif (Objects[idx][1] != here):
         print "There is no %s here!" % cmd[1]
         if (debugFlg):
            print "locn = %d\n" % Objects[idx][1]
      else:
         if (Objects[idx][0] == "Water"):
            if (not Objects[3][2]):  # Bottle
               print "You have nothing to carry the water in!\n"
               return 1

         elif (Objects[idx][0] == "Oil"):
            print "Your lantern is full again.\n"
            lanternDim = FALSE
            oilLevel = movesMade
            movesMade = 1

         elif (Objects[idx][0] == "Book"):
            if (not fine and (here == 159)):
               # goto L12150
               return 1

         elif (Objects[idx][0] == "Axe"):
            if ((here == 86) and not axeVisible):
               print "The dragon is sitting on it!"
               return 1

         elif (Objects[idx][0] == "Treasure"):
            if (chestLocked):
               print "It's locked!  I can't get the treasure."
               return 1

         Objects[idx][2]   = TRUE
         Objects[idx][1]   = -1
         itemCnt          += 1

      print "Got %s Ok!" % Objects[idx][0]

   return 1

#------------------------------------------------------------------------------

def cmd_give(cmd):
   print "Would you like to tell me how?"

   return 1

#------------------------------------------------------------------------------

def cmd_help(cmd):
   print "[cmd_help]"

   return 1

#------------------------------------------------------------------------------

def cmd_how(cmd):
   print "I refuse to answer on the grounds that it might incriminate me!"

   return 1

#------------------------------------------------------------------------------

def cmd_invent(cmd):
   if (itemCnt > 0):
      print "\nYou are holding the following:\n"
      for idx in range(len(Objects)):
         if (Objects[idx][2] == TRUE):
            print "   %s" % Objects[idx][0]
   else:
      print "\nYou are not holding anything!\n"

   return 1

#------------------------------------------------------------------------------

def cmd_kill(cmd):
   print "[cmd_kill]"

   return 1

#------------------------------------------------------------------------------

def cmd_kiss(cmd):
   print "[cmd_kiss]"

   return 1

#------------------------------------------------------------------------------

def cmd_leave(cmd):
   global here

   if (here == 2):
      here = 7
   else:
      print "I'm not sure which way you are facing.  Try a compass!"

   return 1

#------------------------------------------------------------------------------

def cmd_lift(cmd):
   print "[cmd_lift]"

   return 1

#------------------------------------------------------------------------------

def cmd_light(cmd):
   if not equivString(cmd[1].capitalize(), "Lantern"):
      print "C'mon.  Be serious!"
   elif not Objects[1][2]:
      print "You don't have a lantern"
   else:
      if oilLevel == 0:
         print "Your lantern is out of oil."
      else:
         print "Your lantern is lit."

   return 1

#-----------------------------------------