#!/usr/bin/env python

import sys
import random
import screen

#------------------------------------------------------------------------------

VERSION = "1.x.x.x"

#------------------------------------------------------------------------------

TRUE                    =    1
FALSE                   =    0
UNDEFINED               =   -1

#------------------------------------------------------------------------------

MAZE_SIZE               =  250
NO_KEY_WORDS            =   57
NO_ENTITIES             =    3
MAX_LOCATION_DESCRIPTOR =   19
NO_DESCRIPTORS          =   19

NORTH                   =    0
EAST                    =    1
SOUTH                   =    2
WEST                    =    3
UP                      =    4
DOWN                    =    5

NORTH_OK                = 0x01
EAST_OK                 = 0x02
SOUTH_OK                = 0x04
WEST_OK                 = 0x08
UP_OK                   = 0x10
DOWN_OK                 = 0x20

MAZE_NS                 =    5
MAZE_EW                 =    5

HUT                     =    2
KNIGHTS_GLADE           =   17
CAVE_ENTRANCE           =   40

NO_LIVES                =    3
ITEM_LIMIT              =   10  # Should be 6!
OIL_LEVEL               =   99

#------------------------------------------------------------------------------

magicWord               = None
partner                 = None

here                    =    7
dwarfCnt                =    0
helpCnt                 =    0
itemCnt                 =    0
itemLimit               = ITEM_LIMIT
maxLives                = NO_LIVES
movesMade               =    0
oilLevel                = OIL_LEVEL
pitCnt                  =    0
shadowCnt               =    0

magicWord               = None
partner                 = None

direction               = None
objects                 = None
 
axeVisible              = TRUE
broken                  = FALSE
chestLocked             = TRUE
grateLocked             = TRUE
debugFlg                = TRUE
dragonAbout             = TRUE
drawbridgeDown          = FALSE
dwarfAbout              = FALSE
fine                    = FALSE
finished                = FALSE
firstGlimpse            = TRUE
frogAbout               = FALSE
killed                  = FALSE
knightAbout             = TRUE
lanternDim              = FALSE
lanternLit              = FALSE
look                    = TRUE
loop                    = TRUE
mysticFlg               = FALSE
noLight                 = TRUE
pirateGone              = FALSE
shadowyFigure           = FALSE
showMap                 = FALSE

#------------------------------------------------------------------------------

functions     = {}

#------------------------------------------------------------------------------

increment = (
   (-MAZE_EW),              # North
   1,                       # East
   (MAZE_EW),               # South
   (-1),                    # West
   (-(MAZE_NS * MAZE_EW)),  # Up
   (MAZE_NS * MAZE_EW)      # Down
)

#------------------------------------------------------------------------------

allowedMask = (
   NORTH_OK,
   EAST_OK,
   SOUTH_OK,
   WEST_OK,
   UP_OK,
   DOWN_OK
)


#------------------------------------------------------------------------------

lookCode = (
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x0F,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x20,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x10,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,

   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00,
   0x00,  0x00,  0x00,  0x00,  0x00
)


#------------------------------------------------------------------------------

moveCode = (
   0x22,  0x04,  0x00,  0x06,  0x0E,
   0x0F,  0x0F,  0x0E,  0x0F,  0x0F,
   0x0B,  0x0F,  0x0F,  0x07,  0x0D,
   0x22,  0x0F,  0x0F,  0x0F,  0x0B,
   0x0A,  0x0A,  0x0B,  0x0B,  0x0B,

   0x22,  0x0E,  0x0A,  0x0A,  0x0E,
   0x12,  0x09,  0x0D,  0x22,  0x0F,
   0x0A,  0x0E,  0x22,  0x0D,  0x0C,
   0x12,  0x0F,  0x0A,  0x05,  0x0F,
   0x0A,  0x09,  0x0B,  0x0A,  0x00,

   0x22,  0x0A,  0x0A,  0x0A,  0x0A,
   0x0E,  0x00,  0x12,  0x10,  0x22,
   0x0F,  0x0D,  0x0E,  0x0A,  0x0A,
   0x0F,  0x0E,  0x0E,  0x0F,  0x0F,
   0x03,  0x09,  0x0B,  0x0B,  0x0B,

   0x0B,  0x0E,  0x0A,  0x0A,  0x12,
   0x0A,  0x0F,  0x12,  0x05,  0x0C,
   0x0B,  0x0B,  0x0A,  0x0A,  0x09,
   0x04,  0x01,  0x06,  0x0A,  0x0A,
   0x0B,  0x0B,  0x0B,  0x08,  0x20,

   0x12,  0x12,  0x12,  0x12,  0x12,
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F,
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F, 
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F,
   0x3F,  0x3F,  0x3F,  0x3F,  0x3F
)


#------------------------------------------------------------------------------

wizLookCode = (
   0x23,  0x2B,  0x2B,  0x2B,  0x29,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x26,  0x2E,  0x2E,  0x2E,  0x2C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x13,  0x1B,  0x1B,  0x1B,  0x19,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x16,  0x1E,  0x1E,  0x1E,  0x1C
)


#------------------------------------------------------------------------------

wizMoveCode = (
   0x23,  0x2B,  0x2B,  0x2B,  0x29,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x27,  0x2F,  0x2F,  0x2F,  0x2D,
   0x26,  0x2E,  0x2E,  0x2E,  0x2C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x33,  0x3B,  0x3B,  0x3B,  0x39,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x37,  0x3F,  0x3F,  0x3F,  0x3D,
   0x36,  0x3E,  0x3E,  0x3E,  0x3C,

   0x13,  0x1B,  0x1B,  0x1B,  0x19,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x17,  0x1F,  0x1F,  0x1F,  0x1D,
   0x16,  0x1E,  0x1E,  0x1E,  0x1C
)


#------------------------------------------------------------------------------

descriptor = (
    9,  3,  1,  3,  3,
    6,  6,  2,  6,  6,
    3,  6,  2,  2,  3,
    7,  2,  2,  6,  3,
    3,  4,  4,  4, 11,

    9, 17, 12, 12, 17,
   19, 16, 20, 18, 21,
   12, 17, 22, 23, 16,
    8, 21, 12, 14, 24,
   12, 16, 17, 12, 23,

    9, 13, 13, 13, 13,
   13, 25, 26,  5,  9,
   26, 26, 27, 12, 12,
   26, 26, 26, 26, 26,
   26, 26, 26, 26, 26,

   16, 17, 12, 12, 19,
   12, 21, 19, 14, 16,
   17, 28, 12, 12, 16,
   29, 30, 29, 13, 34,
   31, 36, 32, 33, 35,

   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37,
   37, 37, 37, 37, 37
)


#------------------------------------------------------------------------------

print len(descriptor)
print moveCode

#------------------------------------------------------------------------------

def randomize():
   random.seed(None)

#------------------------------------------------------------------------------

def rand(n):
   return int(n * random.random())

#===== Command shells =========================================================

def cmd_go(cmd):
   if (len(cmd) > 1):
      if (cmd[1][0:1].upper() == "N"):
         move(NORTH)
      elif (cmd[1][0:1].upper() == "E"):
         move(EAST)
      elif (cmd[1][0:1].upper() == "S"):
         move(SOUTH)
      elif (cmd[1][0:1].upper() == "W"):
         move(WEST)
      elif (cmd[1][0:1].upper() == "U"):
         move(UP)
      elif (cmd[1][0:1].upper() == "D"):
         move(DOWN)
      else:
         print "Which way? ..."      
   else:
      print "Go where? ..."      

   return 1

#------------------------------------------------------------------------------

def cmd_goNorth(cmd):
   move(NORTH)

   return 1

def cmd_goEast(cmd):
   move(EAST)

   return 1

def cmd_goSouth(cmd):
   move(SOUTH)

   return 1

def cmd_goWest(cmd):
   move(WEST)

   return 1

def cmd_goUp(cmd):
   move(UP)

   return 1

def cmd_goDown(cmd):
   move(DOWN)

   return 1

#------------------------------------------------------------------------------

def cmd_debug(cmd):
   global debugFlg

   if (debugFlg):
      debugFlg = FALSE
   else:
      debugFlg = TRUE

   return 1

#------------------------------------------------------------------------------

def cmd_drink(cmd):
   print "Drink \"%s\"? ...\n" % cmd[1]

#------------------------------------------------------------------------------

def cmd_drop(cmd):
   global broken
   global itemCnt
   global lanternLit

   if (itemCnt == 0):
      print "You don't have anything to drop!"
      return

   if (len(cmd) == 1):
      reply = raw_input("What do you want to drop? ")
      l = len(reply)
      if (l == 0):
         print "\nSorry, if you won't tell me what to drop, I can't do it!\n"
         return
      cmd[1] = reply

   idx = matchObject(cmd[1])

   if (idx == -1):
      print "I don't know how to drop '%s'.\n\n" % cmd[1]
      return 1

   if (Objects[idx][2] == FALSE):
      print "You dont have that to drop!\n"
   else:
      Objects[idx][2] = FALSE
      Objects[idx][1] = here
      itemCnt -= 1

      if (Objects[idx][0] == "Lantern"):
         lanternLit = FALSE
         print "Ok!\n"
      elif (Objects[idx][0] == "Bottle"):
         print "The bottle tipped over and the water spilled out of the bottle!\n"
      elif (Objects[idx][0] == "Statue"):
         if (Objects[8][1] != here):  # Carpet
            print "The statue falls and breaks worthlessly"
            Objects[10][1] = -1  # Statue
            broken = TRUE
         else:
            print "The statue lands safely on the persian rug.\n"
      else:
         print "Ok!\n"

   return 1

#------------------------------------------------------------------------------

def cmd_eat(cmd):
   if (len(cmd) > 1):
      print "Eat \"%s\"? ..." % cmd[1]
   else:
      print "Eat what? ..."

   return 1

#------------------------------------------------------------------------------

def cmd_enter(cmd):
   global here

   print '[cmd_enter]'

   if (here == 7):
      here = 2
      print "\nYou walk through a wooden door..."
      lookAtLocation(here)
      lookForObjects(here)
   else:
      print "Enter where?"

   return 1

#------------------------------------------------------------------------------

def cmd_exit(cmd):
   global here

   print "[exit]"

   if (here == 2):
      here = 7
      lookAtLocation(here)
   else:
      print "Exit what?"

   return 1

#------------------------------------------------------------------------------

def cmd_find(cmd):
   if (len(cmd) > 1):
      print "Find \"%s\"? ..." % cmd[1]
   else:
      print "Find what? ..."

   return 1

#------------------------------------------------------------------------------

def cmd_get(cmd):
   global itemCnt
   global lanternDim
   global movesMade
   global oilLevel

   if (itemCnt == itemLimit):
      print "You can't carry anything more."
      print "You'll have to drop something first!\n"
      return 1

   if (len(cmd) == 1):
      reply = raw_input("What do you want to pick up ? ")
      l = len(reply)
      if (l == 0):
         print "Sorry, if you won't tell me what to pick up I can't get it!\n"
         return 1

      cmd.append(reply)

   pickup = []

   if (cmd[1].capitalize() == "All"):
      for idx in range(len(Objects)):
         if (Objects[idx][1] == here):
            pickup.append(idx)
   else:
      idx = matchObject(cmd[1])

      if (idx == -1):
         print "I don't know how to get '%s'." %  cmd[1]
         return 1
      else:
         pickup.append(idx)

   for idx in pickup:
      if (itemCnt == itemLimit):
         print "You can't carry anything more."
         print "You'll have to drop something before you can pick up anything else!"
         return 1

      if (Objects[idx][2]):
         if (Objects[idx] == "Water"):
            print "You can't carry any more water!"
         else:
            print "You already holding that!"

      elif (Objects[idx][1] != here):
         print "There is no %s here!" % cmd[1]
         if (debugFlg):
            print "locn = %d\n" % Objects[idx][1]
      else:
         if (Objects[idx][0] == "Water"):
            if (not Objects[3][2]):  # Bottle
               print "You have nothing to carry the water in!\n"
               return 1

         elif (Objects[idx][0] == "Oil"):
            print "Your lantern is full again.\n"
            lanternDim = FALSE
            oilLevel = movesMade
            movesMade = 1

         elif (Objects[idx][0] == "Book"):
            if (not fine and (here == 159)):
               # goto L12150
               return 1

         elif (Objects[idx][0] == "Axe"):
            if ((here == 86) and not axeVisible):
               print "The dragon is sitting on it!"
               return 1

         elif (Objects[idx][0] == "Treasure"):
            if (chestLocked):
               print "It's locked!"
               return 1

         Objects[idx][2]   = TRUE
         Objects[idx][1]   = -1
         itemCnt          += 1

      print "Ok!"

   return 1

#------------------------------------------------------------------------------

def cmd_give(cmd):
   print "[cmd_give]"

   return 1

#------------------------------------------------------------------------------

def cmd_help(cmd):
   print "[cmd_help]"

   return 1

#------------------------------------------------------------------------------

def cmd_how(cmd):
   print "I refuse to answer on the grounds that it might incriminate me!"

   return 1

#------------------------------------------------------------------------------

def cmd_invent(cmd):
   if (itemCnt > 0):
      print "\nYou are holding the following:\n"
      for idx in range(len(Objects)):
         if (Objects[idx][2] == TRUE):
            print "   %s" % Objects[idx][0]
   else:
      print "\nYou are not holding anything!\n"

   return 1

#------------------------------------------------------------------------------

def cmd_kill(cmd):
   print "[cmd_kill]"

   return 1

#------------------------------------------------------------------------------

def cmd_kiss(cmd):
   print "[cmd_kiss]"

   return 1

#------------------------------------------------------------------------------

def cmd_leave(cmd):
   global here

   if (here == 2):
      here = 7
   else:
      print "I'm not sure which way you are facing.  Try a compass!"

   return 1

#------------------------------------------------------------------------------

def cmd_lift(cmd):
   print "[cmd_lift]"

   return 1

#------------------------------------------------------------------------------

def cmd_light(cmd):
   if not equivString(cmd[1].capitalize(), "Lantern"):
      print "C'mon.  Be serious!"
   elif not Objects[1][2]:
      print "You don't have a lantern"
   else:
      if oilLevel == 0:
         print "Your lantern is out of oil."
      else:
         print "Your lantern is lit."

   return 1

#------------------------------------------------------------------------------

def cmd_listen(cmd):
   if (rand(5) <= 2):
      print "Slosh, boil, drip, spurt, squirt ..."
   else:
      print "I don't hear anything"

   return 1

#------------------------------------------------------------------------------

def cmd_la(cmd):
   lookAround()

   return 1

#------------------------------------------------------------------------------

def cmd_look(cmd):
   for direction in range(6):
      location = lookTowards(direction)

      if (location != -1):
         idx = descriptor[location]

         if (direction == NORTH):
            print "To the north is %s."     % Scene[idx]
         elif (direction == EAST):
            print "Over to the east is %s." % Scene[idx]
         elif (direction == SOUTH):
            print "To the south is %s."     % Scene[idx]
         elif (direction == WEST):
            print "To the west is %s."      % Scene[idx]
         elif (direction == UP):
            print "Up above is %s."         % Scene[idx]
         elif (direction == DOWN):
            print "Down below is %s."       % Scene[idx]

   print ""

   lookAtLocation(here)

   lookForObjects(here)

   return 1

#------------------------------------------------------------------------------

def cmd_map(cmd):
   global showMap

   if (len(cmd) == 2):
      if cmd[1].upper() == "ON":
         showMap = TRUE
      elif cmd[1].upper() == "OFF":
         showMap = FALSE
   else:
      map()

   return 1

#------------------------------------------------------------------------------

def cmd_move(cmd):
   cmd_go(cmd)

   return 1

#------------------------------------------------------------------------------

def cmd_no(cmd):
   print "[cmd_no]"

   return 1

#------------------------------------------------------------------------------

def cmd_object(cmd):
   print "[cmd_object]", cmd

   return 1

#------------------------------------------------------------------------------

def cmd_open(cmd):
   global grateLocked

   if ((descriptor[here] == 7) and Objects[0][2]):
      grateLocked = FALSE

   return 1

#------------------------------------------------------------------------------

def cmd_pay(cmd):
   print "[cmd_pay]"

   return 1

#------------------------------------------------------------------------------

def cmd_please(cmd):
   print "[cmd_please]"

   return 1

#------------------------------------------------------------------------------

def cmd_queryThing(cmd):
   print "What shall I do with the %s?\n" % cmd[1]

   return 1

#------------------------------------------------------------------------------

def cmd_quit(cmd):
   global loop

   print "\n"

   try:
      reply = raw_input("Do you really want to quit ? [YES] ")
   except KeyboardInterrupt, e:
      print " ** Caught Keyboard Interrupt..."
      return 0
   except EOFError, e:
      print " ** Terminating - EoF Detected..."
      return 0

   if (reply[0:1].upper() == "Y"):
      loop = FALSE
      return 0
   else:
      return 1

#------------------------------------------------------------------------------

def cmd_say(cmd):
   global here
   global firstGlimpse

   if (equivString(magicWord, cmd[1])):
      if (here == 199):
         print "A secret passage opens to the west!\n"
         moveCode[199] = 9
      elif (here == HUT):
         here         = CAVE_ENTRANCE
         #firstGlimpse = FALSE
      elif (here == CAVE_ENTRANCE):
         here         = HUT
         #firstGlimpse = FALSE
      else:
         print "Nothing happens!"
   else:
      print "Okay, '%s'!\n" % cmd[1]

   return 1

#------------------------------------------------------------------------------

def cmd_shake(cmd):
   print "[cmd_shake]"

   return 1

#------------------------------------------------------------------------------

def cmd_slay(cmd):
   print "[cmd_slay]"

   return 1

#------------------------------------------------------------------------------

def cmd_undefined(cmd):
   print "I don't know what you mean!"

   return 1

#------------------------------------------------------------------------------

def cmd_unlock(cmd):
   print "[cmd_unlock]"

   return 1

#------------------------------------------------------------------------------

def cmd_wave(cmd):
   print "[cmd_wave]"

   return 1

#------------------------------------------------------------------------------

def cmd_wet(cmd):
   print "[cmd_wet]"

   return 1

#------------------------------------------------------------------------------

def cmd_what(cmd):
   print "I refuse to answer on the grounds that it might incriminate me!"

   return 1

#------------------------------------------------------------------------------

def cmd_when(cmd):
   print "I refuse to answer on the grounds that it might incriminate me!"

   return 1

#------------------------------------------------------------------------------

def cmd_where(cmd):
   if (debugFlg):
      print "here = %d, moveCode = %d" % (here, moveCode[here])

   print "I'm not really sure which way you're facing.  Try a compass heading."

   return 1

#------------------------------------------------------------------------------

def cmd_who(cmd):
   print "[cmd_who]"

   return 1

#------------------------------------------------------------------------------

def cmd_you(cmd):
   print "[cmd_you]"

   return 1

#------------------------------------------------------------------------------

def cmd_your(cmd):
   print "[cmd_your]"

   return 1

#------------------------------------------------------------------------------

def cmd_yes(cmd):
   print "[cmd_yes]"

   return 1

#------------------------------------------------------------------------------

def cmd_teleport(cmd):
   global firstGlimpse

   reply = raw_input("Where do you want to go ? ")

   new_posn = int(reply)

   if ((new_posn >= 0) and (new_posn <= 125)):
      here = new_posn

   firstGlimpse    = TRUE

   lookAtLocation(here)

   lookForObjects(here)

   return 1

#------------------------------------------------------------------------------

def cmd_throw(cmd):
   print "[cmd_throw]"

   return 1

#------------------------------------------------------------------------------

def cmd_scenes(cmd):
   listScenes()

   return 1

#------------------------------------------------------------------------------

Commands = (
   ("Map",        cmd_map),
   ("North",      cmd_goNorth),
   ("East",       cmd_goEast),
   ("South",      cmd_goSouth),
   ("West",       cmd_goWest),
   ("Up",         cmd_goUp),
   ("Down",       cmd_goDown),
   ("DEbug",      cmd_debug),
   ("DRink",      cmd_drink),
   ("DRop",       cmd_drop),
   ("EAt",        cmd_eat),
   ("ENter",      cmd_enter),
   ("EXit",       cmd_exit),
   ("Leave",      cmd_leave),
   ("Find",       cmd_find),
   ("GEt",        cmd_get),
   ("GIve",       cmd_give),
   ("GO",         cmd_go),
   ("HElp",       cmd_help),
   ("HOw",        cmd_how),
   ("Inventory",  cmd_invent),
   ("KILl",       cmd_kill),
   ("KISs",       cmd_kiss),
   ("LIFt",       cmd_lift),
   ("LIGht",      cmd_light),
   ("LISten",     cmd_listen),
   ("LOok",       cmd_look),
   ("LA",         cmd_la),
   ("NO",         cmd_no),
   ("Open",       cmd_open),
   ("PAy",        cmd_pay),
   ("PLease",     cmd_please),
   ("SCenes",     cmd_scenes),
   ("SAy",        cmd_say),
   ("SHake",      cmd_shake),
   ("SLay",       cmd_slay),
   ("Teleport",   cmd_teleport),
   ("Throw",      cmd_throw),
   ("Unlock",     cmd_unlock),
   ("WAve",       cmd_wave),
   ("WEt",        cmd_wet),
   ("WHAt",       cmd_what),
   ("WHEN",       cmd_when),
   ("WHERe",      cmd_where),
   ("WHO",        cmd_who),
   ("Yes",        cmd_yes),
   ("YOU",        cmd_you),
   ("YOUR",       cmd_your),
   ("AXE",        cmd_object),
   ("BOOk",       cmd_object),
   ("BOTTle",     cmd_object),
   ("CArpEt",     cmd_object),
   ("CRown",      cmd_object),
   ("DIamonds",   cmd_object),
   ("EMerald",    cmd_object),
   ("FOod",       cmd_object),
   ("KEys",       cmd_object),
   ("LAntern",    cmd_object),
   ("OIl",        cmd_object),
   ("ROpe",       cmd_object),
   ("SIlver",     cmd_object),
   ("STatue",     cmd_object),
   ("SWord",      cmd_object),
   ("TReasure",   cmd_object),
   ("WANd",       cmd_object),
   ("WATer",      cmd_object),
   ("UNDefined",  cmd_object),
   ("Quit",       cmd_quit)
)


#------------------------------------------------------------------------------

Ranks = (
   ( "Failed",        -999 ),
   ( "Rank Beginner",    0 ),
   ( "Novice",          50 ),
   ( "Experienced",    100 ),
   ( "Seasoned",       150 ),
   ( "Junior Master",  200 ),
   ( "Senior Master",  250 ),
   ( "Master",         300 ),
   ( "Wizard",         350 )
)


#==== Objects =================================================================

KEYS     =  0
LANTERN  =  1
FOOD     =  2
BOTTLE   =  3
WATER    =  4
OIL      =  5
ROPE     =  6
BOOK     =  7
CARPET   =  8
AXE      =  9
STATUE   = 10
SWORD    = 11
WAND     = 12
SILVER   = 13
DIAMONDS = 14
EMERALD  = 15
CROWN    = 16
TREASURE = 17
XXXX     = 18
PARTNER  = 19

Objects = [
   ["Keys",        2,  FALSE,  TRUE,   10],
   ["Lantern",     2,  FALSE,  TRUE,   10],
   ["Food",        2,  FALSE,  TRUE,   10],
   ["Bottle",      2,  FALSE,  TRUE,   10],
   ["Water",      58,  FALSE,  TRUE,   10],
   ["Oil",        68,  FALSE,  TRUE,   20],
   ["Rope",       44,  FALSE,  TRUE,   20],
   ["Book",       -1,  FALSE,  TRUE,   20],
   ["Carpet",     -1,  FALSE,  TRUE,   20],
   ["Axe",        -1,  FALSE,  TRUE,   20],
   ["Statue",     -1,  FALSE,  TRUE,   20],
   ["Sword",      -1,  FALSE,  TRUE,   20],
   ["Wand",       27,  FALSE,  TRUE,   20],
   ["Silver",     43,  FALSE,  TRUE,   30],
   ["Diamonds",   48,  FALSE,  TRUE,   30],
   ["Emerald",    -1,  FALSE,  TRUE,   30],
   ["Crown",      94,  FALSE,  TRUE,   30],
   ["Treasure",   32,  FALSE,  TRUE,   30],
   ["None",       -1,  FALSE,  TRUE,    0],
   ["Partner",    -1,  FALSE,  TRUE,   50],
]

#------------------------------------------------------------------------------

def matchObject(name):
   for idx in range(len(Objects)):
      if (equivString(Objects[idx][0], name)):
         return idx

   return -1

#------------------------------------------------------------------------------

def lookForObjects(here):
   for idx in range(len(Objects)):
      if (Objects[idx][1] == here):
         name = Objects[idx][0]

         if (name == "Axe"):
            if (axeVisible):
               print "A little axe is here!"
         elif (name == "Book"):
            print "There is an ancient book on the ground!"
         elif (name == "Bottle"):
            print "A small bottle is lying here!"
         elif (name == "Carpet"):
            print "There is a persian carpet lying on the ground"
         elif (name == "Crown"):
            print "There's a king's crown here!"
         elif (name == "Diamonds"):
            print "Many diamonds are scattered here!"
         elif (name == "Emerald"):
            print "A pea-sized emerald falls to the floor!"
         elif (name == "Food"):
            print "There is tasty food here!"
         elif (name == "Keys"):
            print "There's a set of keys here!"
         elif (name == "Lantern"):
            print "A lantern rests here!"
         elif (name == "Oil"):
            print "A small pool of oil is here!"
         elif (name == "Rope"):
            print "A useful hemp rope is coiled here!"
         elif (name == "Silver"):
            print "Seven bars of silver lie here!"
         elif (name == "Statue"):
            print "There is a tiny marble statue in the corner."
         elif (name == "Sword"):
            print "A golden sword lies here!"
         elif (name == "Treasure"):
            print "There's a pirate's treasure chest here!"
         elif (name == "Wand"):
            print "A magic wand floats in mid air!"
         elif (name == "Water"):
            print "There is much water here!"
         elif (name == "Partner"):
            if (not Objects[19][2]):  # Partner
               print "A %s patiently waits here!" % partner
            else:
               print "The %s is still by your side." % partner

#==============================================================================

def noCommands():
   return len(Commands)

#==============================================================================

Scene = (
   "a gloomy grotto",
   "a small building",
   "a nicely groomed path",
   "a great and eerie forest",
   "the dried up bed of a once great river",
   "the bottom of a climable pit",
   "a beautiful forest",
   "the entrance of a small cave",
   "the cave enterance",
   "the edge of a pit",
   "an old mine shaft",
   "a misty passage",
   "an east-west tunnel",
   "an east-west corridor",
   "a large north-south passage",
   "a small north-south cave",
   "a room that connects to an alternating passage",
   "the intersection of three corridors",
   "the brink of an easily climable pit",
   "the bottom of a narrow shaft",
   "an enormous chamber hewn into solid granite",
   "a cave of many exits",
   "a beautiful cavern",
   "",
   "a splendid chamber decorated with multi-coloured strands",
   "",
   "",
   "a complex junction of three forks",
   "the dragons lair",
   "a small stone chamber",
   "the edge of a large moat which surrounds the castle",
   "the western hall of the magic castle",
   "the eastern hall of the magic castle",
   "a room containing a bed made from twelve matresses",
   "the King's chamber",
   "",
   "",
   "an enormous underground sea"
)


#------------------------------------------------------------------------------

def lookAtLocation(here):
   global firstGlimpse

   desc = descriptor[here]

   if (desc == 0):
      print "You seem to be floating in %s" % Scene[desc]
      if (firstGlimpse):
         print   "It is like being..."
   elif (desc == 1):
      print "You are inside %s" % Scene[desc]
      if (firstGlimpse):
         print   "It is a safe place to store treasure."
   elif (desc == 2):
      print "You are on %s." % Scene[desc]
   elif (desc == 3):
      print "You are in %s." % Scene[desc]

      if (here == 14):
         if (knightAbout):
            print "A black knight in full iron armour stands in a glade before you."
            print "He is carrying a goldern sword"
         else:
            print "There is an ancient iron statue of a knight in the glade"
   elif (desc == 4):
      print "You are walking along %s." % Scene[desc]
   elif (desc == 5):
      print "You are at %s." % Scene[desc]
      if (firstGlimpse):
         print "A small stream flows across the ground and into a crevice."
   elif (desc == 6):
      print "You are walking through %s." % Scene[desc]
      if (firstGlimpse):
         print "The sound of many birds and animals fills the air."
   elif (desc == 7):
      print "You are at %s." % Scene[desc]
      if (firstGlimpse):
         print "A 3X3 iron grate bars your way to where a cave appears to open up."
   elif (desc == 8):
      print "You are inside %s." % Scene[desc]
      if (firstGlimpse):
         print "A large passage opens up ahead."
   elif (desc == 9):
      print "You are at %s." % Scene[desc]
      if (firstGlimpse):
         print "You can climb down, but you might not be able to climb back up again."
   elif (desc == 10):
      print "You are in %s that extends vertically in both directions." % Scene[desc]
   elif (desc == 11):
      print "You are in %s." % Scene[desc]
      print "You are standing beside a large sign flashing '%s'!" % magicWord
      mysticFlg = TRUE
   elif (desc == 12):
      print "You are in %s." % Scene[desc]
   elif (desc == 13):
      print "You are walking along %s." % Scene[desc]
   elif (desc == 14):
      print "You are in %s." % Scene[desc]
   elif (desc == 15):
      print "You are in %s." % Scene[desc]
   elif (desc == 16):
      print "You are in %s." % Scene[desc]
   elif (desc == 17):
      print "You are at %s." % Scene[desc]
   elif (desc == 18):
      print "You are at %s." % Scene[desc]
   elif (desc == 19):
      print "You are at %s you could climb up but not back down." % Scene[desc]
   elif (desc == 20):
      print "You are in %s." % Scene[desc]
      if (firstGlimpse):
         print "Exits lead in many directions."
   elif (desc == 21):
      print "You are in %s." % Scene[desc]
   elif (desc == 22):
      print "You are walking through %s." % Scene[desc]
      if (firstGlimpse):
         print "At its center is a large hole."
         print "SHHH!..I think I hear the sound of water!"
   elif (desc == 23):
      if (rand(99) > 50):
         s = "a narow tunnel"
      else:
         s = "a small crack"
      print "You climb through %s only to find that........" % s
      here -= 7
      lookAtLocation(here)
   elif (desc == 24):
      print "You are in %s." % Scene[desc]
   elif (desc == 25):
      here -= 5
      checkLantern()
   elif (desc == 26):
      if (rand(99) > 50):
         s = "twisty, little"
      else:
         s = "little, twisty"
      print "You are in a %s maze!" % s
   elif (desc == 27):
      print "You are in %s." % Scene[desc]
      if (firstGlimpse):
         print "Obvious paths lead east and west."
   elif (desc == 28):
      print "You have stumbled into %s." % Scene[desc]
      if (firstGlimpse):
         print "His job is to protect the enchanted castle which lies to the south."
         if (dragonAbout):
            print "The dragon refuses to let you enter."
         else:
            print "The dragon lies dead off to one side."
   elif (desc == 29):
      print "You are in %s." % Scene[desc]
      if (frogAbout):
         print "A small green frog happily hops to and fro across the floor of the"
         print "chamber!"
   elif (desc == 30):
      print "You are standing on %s." % Scene[desc]
      if (firstGlimpse):
         print "You can neither jump nor swim across."
         if (drawbridgeDown):
            print "The drawbridge is lowered to cross."
   elif (desc == 31):
      print "You are in %s." % Scene[desc]
      if (firstGlimpse):
         print "Your footsteps echo endlessly."
   elif (desc == 32):
      print "You are in %s." % Scene[desc]
   elif (desc == 33):
      print "You are in %s." % Scene[desc]
      if (list[_Partner].held):
         moveCode[98] = 0x0A
   elif (desc == 34):
      print "You are in %s." % Scene[desc]
      if (firstGlimpse):
         print "SHHHH!... I think he's asleep!"
   elif (desc == 35):
      print "The floor you were standing on has given way."
      print "You fall..and fall...and fall................"
      print "finally landing on solid ground.............."
      here += 50
      checkLantern()
   elif (desc == 36):
      if (firstGlimpse):
         print "Welcome to the Magic Castle."
         print "I hope you enjoy your visit even though our ruler is stupid."
   elif (desc == 37):
      print "You are in the castle dungeons."
   elif (desc == 38):
      print "You are adrift in %s." % Scene[desc]
      if (firstGlimpse):
         irand = rand(100)
         if (irand < 40):
            print "It seems to go on forever."
         elif (irand < 65):
            print "A fog seems to be moving in."
         elif (irand < 80):
            print "The fog swirls about you.  It seems to have a life of its own."
         elif (irand < 90):
            print "Mysterious lights seem to hover on the edge of your vision."
         elif (irand < 99):
            print "A deep swell apears out of nowhere."

   #firstGlimpse = FALSE

   if (debugFlg):
      print "*** Maze descriptor = %d" % desc

#------------------------------------------------------------------------------

def listScenes():
   for i in range(len(Scene)):
      print "<%s>" % Scene[i]

#==============================================================================

def doAction(cmd):
   global movesMade

   movesMade += 1

   command    = None
   cmdIdx     = UNDEFINED

   if (len(cmd) == 0):
      return 1

   for i in range(len(Commands)):
      if (equivString(Commands[i][0], cmd[0])):
         cmdIdx = i
         command = Commands[i][0].capitalize()
         cmd[0] = command
         break

   if (debugFlg):
      print len(cmd[0])
      print "Cmd -> %s (%d)" % (cmd, cmdIdx)

   if (cmdIdx >= 0):
      cmd0 = cmd[0]

#      if functions.has_key(cmd0):
#         fn = functions[cmd0]
#         fn(cmd)

      return Commands[cmdIdx][1](cmd)
   else:
      return 1

#------------------------------------------------------------------------------

def getReply():
   try:
      line = raw_input(">> ")
   except KeyboardInterrupt, e:
      print " ** Caught Keyboard Interrupt..."
      return None
   except EOFError, e:
      print " ** Terminating - EoF Detected..."
      return None

   words   = line.split()

   return words

#------------------------------------------------------------------------------

def setupFunctions():
   functions["Look"]  = cmd_look
   functions["Go"]    = cmd_go
   functions["East"]  = cmd_goEast
   functions["West"]  = cmd_goWest
   functions["North"] = cmd_goNorth
   functions["South"] = cmd_goSouth
   functions["Up"]    = cmd_goUp
   functions["Down"]  = cmd_goDown
   functions["Map"]   = cmd_map
   functions["Eat"]   = cmd_eat
   functions["Find"]  = cmd_find
   functions["Inventory"]  = cmd_invent
   functions["Enter"]  = cmd_enter
   functions["Exit"]  = cmd_exit
   functions["Get"]  = cmd_get

#------------------------------------------------------------------------------

def initializeGame():
   global here
   global location
   global magicWord
   global partner

   screen.clearScreen()

   print "A*D*V*E*N*T*U*R*E" 

   random.seed(None)

   here      = 7
   itemLimit = ITEM_LIMIT
   asking    = TRUE

   while (asking) :
      #/ gotoXY(10, 0)


      #/ clearEoL()

      reply = raw_input("Are you a boy or a girl ? ")

      if (equivString("Boy", reply)):
         asking  = FALSE
         partner = "PRINCESS"
      elif (equivString("Girl", reply)):
         asking  = FALSE
         partner = "PRINCE"
      else:
         print "\Please answer 'boy' or 'girl'"

   randVal = rand(3)

   if (randVal == 0):
      magicWord = "Xyzzy"
   elif (randVal == 1):
      magicWord = "Renob"
   elif (randVal == 2):
      magicWord = "Cigam"
   
   reply = raw_input("Are you ready to start? ")

   if (equivString("Yes", reply)):
      print "Good, then off we go"
   else:
      print "Why not then? -- we'll start without you!"

   setupFunctions()

#------------------------------------------------------------------------------

def equivString(s1, s2):
   l1 = len(s1)
   l2 = len(s2)
   l = min(l1, l2)

   S1 = s1.upper()
   S2 = s2.upper()

   ok = TRUE

   for i in range(l):
      if (S1[i][:l] != S2[i][:l]):
         ok = FALSE
         break

   return ok

#------------------------------------------------------------------------------

def play():
   loop = TRUE

   lookAtLocation(here)

   while (loop):
      cmd = getReply()

      if (cmd != None):
         ok = doAction(cmd)

         if (not ok):
            return

         if (debugFlg):
            debugLocn()

         if (here >= 25):
            picker = rand(10)

            if (picker == 10):
               pirate()
            elif (picker > 7):
               dwarf()

         if (showMap):
            map()

         if (killed):
            return
      else:
         return

#===== Things =================================================================

def pirate():
   global shadowyFigure
   global shadowCnt

   if (not pirateGone):
      if (shadowyFigure):
         shadowCnt += 1

         print "\nA shadowy figure is following you!\n"

         for idx in range(len(Objects)):
            if (Objects[idx][2] and (shadowCnt > (rand(13) + 7))):
               if (idx == 19):  # Partner
                  s = partner
               else:
                  s = Objects[idx][0]

               print "The shadow leaps out of the darkness.\n"
               print "'Har har', cries a bearded pirate, 'me thinks me will take a little of"
               print "yur booty!'\n"
               print "The %s will do just fine!\n" % s
               print "With that he scurries off to his treasure cave!!!!\n"

               Objects[idx][2] = FALSE
               Objects[idx][1] = 32

               break
      else:
         if (rand(99) >= 96):
            shadowyFigure = TRUE
         shadowCnt = 0

#------------------------------------------------------------------------------

def dwarf():
   global axeVisible
   global dwarfAbout
   global dwarfCnt
   global firstGlimpse
   global killed
   global location

   if (not dwarfAbout):
      print "An angry dwarf came in and threw a little axe which just missed you.\n"
      print "He cursed and ran away!"

      Objects[9][1] = here  # Axe

      firstGlimpse = TRUE
      dwarfAbout   = TRUE
      axeVisible   = TRUE
   else:
      print "There's an angry dwarf in the room with you!\n"
      print "He throws a single knife"

      dwarfCnt += 1

      if (rand(dwarfCnt) <= 5):
         print "It misses!\n"
      else:
         print "It hits you!\n"
         killed += 1
         if (killed > 5):
            die()

#===== Functions ==============================================================

def inventory():
   if (item_count > 0):
      print "\nYou are holding the following:\n"
      for idx in range(len(Objects)):
         if (Objects[idx][2]):
            print "      %s", Objects[idx][0]
   else:
      print "\nYou are not holding anything!\n"


#===== Movement ===============================================================

def lookTowards(dirn):
   if (lookCode[here] & allowedMask[dirn]):
      there = here + increment[dirn]
      return there
   else:
      return -1

#------------------------------------------------------------------------------

def allowedDirections(here):
   dirnStr = "NESWUD"

   for i in range(6):
      if (moveCode[here] & allowedMask[i]):
         allowedStr[i] = dirnStr[i]
      else:
         allowedStr[i] = ' '

   return allowedStr


#------------------------------------------------------------------------------

def levelStr(level):
   if (level == 0):
      lStr = "Surface"
   else:
      lStr = "Cavern level %d" % level

   return lStr

#------------------------------------------------------------------------------

def debugLocn():
   level = here / 25,
   y     = ((here % 25 ) / 5) + 1,
   x     = ((here % 25 ) % 5) + 1

   print "Maze position: %s  locn (%d,%d)  [%s]" % (levelStr(level), x, y, allowedDirections(here))
#         print "Maze position: %d [0x%x]", here, moveCode[here])


#------------------------------------------------------------------------------

def map():
   level = here / 25
   y     = ((here % 25 ) / 5) + 1
   x     = ((here % 25 ) % 5) + 1

   print "Locn: %d  Level: %s  [%d,%d]" % (here, levelStr(level), x, y)

   for row in range(5):
      print "+------+------+------+------+------+" 

      for col in range(5):
         locn = (level * 25) + ((row * 5) + col)

         if (moveCode[locn] & allowedMask[NORTH]):
            c_north = '^'
         else:
            c_north = ' '

         if (moveCode[locn] & allowedMask[UP]):
            c_up = 'u'
         else:
            c_up = ' '

         if (descriptor[locn] == 6):
            c_rot = '@'
         else:
            c_rot = ' '

         print "|%c %c %c" % (c_up, c_north, c_rot),

      print "|"

      # print "|     |     |     |     |     |" )

      for col in range(5):
         locn = (level * 25) + ((row * 5) + col)

         if (moveCode[locn] & allowedMask[WEST]):
            c_west = '<'
         else:
            c_west = ' '

         if (moveCode[locn] & allowedMask[EAST]):
            c_east = '>'
         else:
            c_east = ' '

         if (locn == here):
            c_here = '*'
         else:
            c_here = ' '

         print "|%c %c %c" % (c_west, c_here, c_east),

      print "|"

      # print "|     |     |     |     |     |" )

      for col in range(5):
         locn = (level * 25) + ((row * 5) + col)

         if (moveCode[locn] & allowedMask[SOUTH]):
            c_south = 'v'
         else:
            c_south = ' '

         if (moveCode[locn] & allowedMask[DOWN]):
            c_down = 'd'
         else:
            c_down = ' '

         c_thing = ' '

         print "|%c %c %c" % (c_down, c_south, c_thing),

      print "|"

   print "+------+------+------+------+------+" 

#------------------------------------------------------------------------------

def checkLantern(cmd):
   global lanternDim
   global noLight

   if ((rand(99) > 92) and (here > 25)):
      pirate()

   if ((movesMade > 200) and (not lanternDim)):
      print "Your lantern is getting very dim!\n"
      print "I would look for a source of oil\n"
      lanternDim = TRUE
   elif ((movesMade > 250) and (not noLight)):
      print "Your lantern has run out of fuel!\n"
      noLight = TRUE
   elif (noLight):
      lanternLit = FALSE

   if (((descriptor[here] != 3) and (here < 25)) or not lanternLit):
      print "It is pitch dark!\n"
      sleep(1)
      print "If you proceed you will most likely fall into a pit"
      sleep(2)
      if (rand(99) > 85):
         pit()

#------------------------------------------------------------------------------

def debugLocn():
   print "[debugLocn]"

#------------------------------------------------------------------------------

def pit():
   global pitCnt

   pitCnt += 1

   print "\nYou fell into a pit and are a mass of twisted flesh and bones.\n\n"
   die()

#------------------------------------------------------------------------------

def die():
   global here
   global finished
   global firstGlimpse
   global killed
   global dwarfCnt

   if (pitCnt < NO_LIVES):
      print "\n"
      print "I might be able to reincarnate you!\n"
      print "Would you like me to try?\n"
   else:
      print "You've really done it this time.\n"
      print "I'm all out of fairy dust!\n\n"
      print "You don't really expect me to do a decent\n"
      print "reincarnation without it do you?\n"

      killed   = FALSE
      dwarfCnt = 0

   print "\n... Well ? "

   reply = raw_input("What [YES] ? ")

   if (reply == "YES"):
      if (pitCnt < NO_LIVES):
         print "Ready......one.two..three!   *POOF*\n\n"
         print "You emerge from a cloud of fairy dust only to find yourself.......\n"

         for idx in range(len(Objects)):
            if (Objects[idx][2]):
               Objects[idx][2] = FALSE
               if (Objects[idx][0] == "Lantern"):
                  Objects[idx][1] = HUT
               else:
                  Objects[idx][1] = here

         here         = HUT
         #firstGlimpse = FALSE
      else:
         print "\nOk!   If you're so smart do it yourself!!\n\n"
         finished     = TRUE
   else:
      finished = TRUE

#------------------------------------------------------------------------------

def calcScores():
   if debugFlg:
      print "[calcScores]"

   finalScore = 0
   grade      = 0

   for idx in range(len(Objects)):
      if ((Objects[idx][1] == HUT) or Objects[idx][2]):
         finalScore += Objects[idx][4]
         # print
         #    "   In calcScores() :-   %10s >> Value <%2d>   Score = <%2d>\n",
         #       list[theObject].name, list[theObject].value, finalScore)

   if (mysticFlg):
      finalScore += 50

   #finalScore -= (movesMade + oilLevel) / 10
   finalScore -= movesMade / 10

   for i in range(len(Ranks)):
      if (finalScore >= Ranks[i][1]):
         grade = i
         continue
      break

   print "\nYou scored %d points out of a possible 350, using %d turns!\n" % (finalScore, movesMade)
   print "Your score qualifies you as a\n"
   print "   *** '%s' ADVENTURER ***\n" % Ranks[grade][0]

   if (grade != (len(Ranks) - 1)):
      print "To achieve the next higher rating you need %d more points!\n" % (Ranks[grade + 1][1] - finalScore)

#------------------------------------------------------------------------------

def help():
   global helpCnt
   global look
   global lanternLit
   global noLight
   global pitCnt

   helpCnt += 1

   if (helpCnt <= 4):
      if (list[_Lantern].held):
         if (noLight and (helpCnt < 2)):
            print "\nThe wizard of 'ADVENTURE' will light your way for 25 moves!\n"

            noLight      = FALSE
            lanternLit   = TRUE
            oilLevel    += 25
            look         = FALSE
         else:
            print "The wizard says, 'Quit bothering me!'.\n"
      else:
         print "You need a lantern to see where you are going!\n"
   else:
      print "\n'I, the wizard of 'ADVENTURE', have given you enough warnings!!'\n\n"
      print "Now you will suffer this fate.....\n\n"
      print "The wizard turns you into stone!!!!\n\n"

      pitCnt += 1

      if (pitCnt > maxLives):
         die()


#===== Movement ===============================================================

def allowableDirections(here):
   s = ""

   code = ( "N", "E", "S", "W", "U", "D" )

   for i in range(6):
      if (moveCode[here] & allowedMask[dirn]):
         s += code[dirn]

   return s

#------------------------------------------------------------------------------

def movex(dirn):
   global here

   if (moveCode[here] & allowedMask[dirn]):
      oldLocn  = here
      here    += increment[dirn]

      if (descriptor[here] != descriptor[oldLocn]):
         firstGlimpse    = TRUE

      lookAtLocation(here)
      lookForObjects(here)
   else:
      print "I'm sorry you can't go that way!"

#------------------------------------------------------------------------------
# **********  Process directional moves.

def move(dirn):
   global here
   global look

   if (dirn < NORTH) or (dirn > DOWN):
      print "What!"
      return 0

   if (descriptor[here] == 6):
      if (dirn == NORTH):
         dirn = EAST
      elif (dirn == EAST):
         dirn = SOUTH
      elif (dirn == SOUTH):
         dirn = WEST
      elif (dirn == WEST):
         dirn = NORTH

   if (moveCode[here] & allowedMask[dirn]):
      new_maze_posn = here + increment[dirn]
   else:
      if (rand(5) <= 2):
         print "You do not seem to know where you're going!"
      else:
         print "You can't go that way!"
      return 0

   if ((new_maze_posn < 0) or (new_maze_posn > 125)):
      print "You don't seem to know where you are going!"
      return 0

   if ((descriptor[here] == 7) and (grateLocked) and (dirn == DOWN)):
      print "The grate is locked"
      return 0

   here = new_maze_posn
   look = TRUE

   lookAtLocation(here)
   lookForObjects(here)

   if (debugFlg):
      print "New maze location [%d]." % here

#------------------------------------------------------------------------------
#  **********  Look around at nearby scenes.

def look_around():
   print "[look_around]"

   if (debugFlg):
      print "Maze[%d] {%d, %d}" % (here, descriptor[here], moveCode[here])

   for dirn in range(6):
      if (moveCode[here] & allowedMask[dirn]):
         there = here + increment[dirn]

         if (dirn == NORTH):
            print "To the north is ",
            glimpse(there)
         elif (dirn == EAST):
            print "Along the east is ",
            glimpse(there)
         elif (dirn == SOUTH):
            print "Looking south is ",
            glimpse(there)
         elif (dirn == WEST):
            print "Appearing westerly is ",
            glimpse(there)
         elif (dirn == UP):
            print "Up above is ",
            glimpse(there)
         elif (dirn == DOWN):
            print "Down below is ",
            glimpse(there)

   # look = FALSE

#------------------------------------------------------------------------------

def glimpse(locn):
   idx =  descriptor[locn]

   if (idx == 1):
      print "a small building."

   elif (idx == 2):
      print "a shallow valley."

   elif (idx == 3):
      print "a rusty statue of a knight."

   elif (idx == 4):
      print "a river bed"

   elif (idx == 6):
      print "a beautiful forest."

   elif (idx == 7):
      print "A cobble path leads up to the surface."

   elif (idx == 8):
      print "A cobble path leads down into the cave."
      if (grate_open):
         print "The grate is open."

   else:
      print "..."

#===== Debugging ==============================================================

def list_maze(cmd):
   pmw(cmd)

   for i in range(125):
      print "   Locn [%3d]:   Maze Descriptor [%2d]   Maze Director [%2d]" % (i, descriptor[i], moveCode[i])

   disp_things(cmd)

#------------------------------------------------------------------------------

def pmw(cmd):
   print "Magic Word is [%s]" % magic_word

#------------------------------------------------------------------------------

def disp_things(cmd):
   print "things>>>"

#==============================================================================

def go():
   initializeGame()
   play()
   calcScores()
   return 1

#==============================================================================

if __name__ == '__main__' or __name__ == sys.argv[0]:
    sys.exit(go())

#------------------------------------------------------------------------------

