00010  REM
00020  REM      ########## APPLE II ADVENTURE ##########
00030  REM
00040  REM      ***** Arrays *****
00050  REM
00060  REM      D1      Direction
00070  REM      M1      Maze descriptor
00080  REM      T       Thing location
00090  REM      M3      Maze modifier
00100  REM      P1      Holding thing
00110  REM      T$      Thing name
00120  REM
00130  REM      ***** OTHERS *****
00140  REM
00150  REM      B1      Drawbridge #
00160  REM      B2      Black knight #
00162  REM      B3      Break #
00170  REM      C1      Thing count
00180  REM      D2      Dwarf about #
00190  REM      D3      Dwarf count
00192  REM      D4      Dwarf here #
00200  REM      D5      Dragon #
00210  REM      D5      Dir
00220  REM      F1      Frog #
00230  REM      F2      Fine #
00240  REM      H1      Help
00250  REM      K1      Killed
00260  REM      L1      Look #
00270  REM      L2      Location
00280  REM      L3      Lantern lit #
00290  REM      L4      Lantern dim #
00300  REM      M$      Magic word
00310  REM      N1      No light #
00320  REM      N2      Pirate gone #
00330  REM      N3      No axe #
00340  REM      O1      Oil level
00350  REM      P2      Pit count
00360  REM      P3      Holding count
00370  REM      P4      Final score
00380  REM      S1      Shadowy figure #
00390  REM      S2      Shadow count
00400  REM      S3      Say #
00402  REM      T0      Thing limit
00405  REM      T1      Test 1
00410  REM      T2      Test 2
00415  REM      T3      Test 3
00420  REM      V1      Moves made
00430  REM      Z0      Zero
00440  REM      Z1      Posn in maze
00450  REM      Z2      New maze posn
00460  REM
00470  REM      ( NOTE: '#' -- Used as a flag. )
00480  REM
00490  REM      **********  Declare arrays.
00500  DIM M1( 200 ), D1( 200 ), D2( 200 ), T( 20 ), D( 6 ), M3( 2 ), P1( 20 ),
00510  REM      **********  Define names of things.
00520  T$( 1 ) = "Keys"
00530  T$( 2 ) = "Lantern"
00540  T$( 3 ) = "Food"
00550  T$( 4 ) = "Bottle"
00560  T$( 5 ) = "Water"
00565  T$( 6 ) = "Oil"
00570  T$( 7 ) = "Rope"
00575  T$( 8 ) = "Book"
00580  T$( 9 ) = "Carpet"
00585  T$( 10 ) = "Statue"
00590  T$( 11 ) = "Axe"
00595  T$( 12 ) = "Sword"
00600  T$( 13 ) = "Wand"
00605  T$( 14 ) = "Silver"
00610  T$( 15 ) = "Diamonds"
00615  T$( 16 ) = "Emerald"
00620  T$( 17 ) = "Crown"
00625  T$( 18 ) = "Treasure"
00670  M3( 1 ) = 16 \ M3( 2 ) = 33
00672  REM      **********  Define flag values.
00674  A0 = 99 \ Z0 = 0
00680  REM      **********  Setup arrays which define maze structure.
00690  FOR I = 1 TO 200
00700  READ M1( I )
00710  NEXT I
00720  FOR I = 1 TO 200
00730  READ D1( I )
00732  D2( I ) = D1( I )
00740  NEXT I
00750  FOR I = 1 TO 20
00760  READ  T( I )
00770  NEXT I
00780  FOR I = 1 TO 20
00790  P1( I ) = Z0
00800  NEXT I
00801  REM      **********  Start of main program.
00810  PRINT "Are you a Boy or Girl ";
00812  GOSUB 8200
00815  IF C1$ = "Boy" OR C1$ = "Girl" THEN GOTO 850
00820  PRINT
00830  PRINT "Please answer Boy or Girl !"
00840  GOTO 810
00850  IF C1$ = "Boy" THEN P$ = "Princess"
00860  IF C1$ = "Girl" THEN P$ = "Prince"
00861  T$( 20 ) = P$
00870  M$ = "Xyzzy"
00880  IF INT( 99 * RND ) > 66 THEN M$ = "Cigam"
00890  IF INT( 99 * RND ) > 66 THEN M$ = "Renob"
00892  PRINT  "                      *** ADVENTURE ***" \ PRINT \ PRINT
00894  REM      **********  Initialize miscelaneous values.
00895  T0 = 6
00896  Z1 = 8
00897  GOTO 2990
00915  REM      **********  Shadowy figure.
00920  IF N2 <> Z0 THEN GOTO 1130
00930  IF S1 > Z0 THEN GOTO 960
00940  IF INT( 99 * RND ) < 96 THEN GOTO 1130
00950  S1 = A0
00960  PRINT \ PRINT "A shadowy figure is following you!" \ PRINT
00970  FOR I = 20 TO 7 STEP  - 1
00980  IF P1( I ) <> Z0 AND S2 > INT( 13 * RND ) + 7 THEN GOTO 1020
00990  NEXT I
01000  S2 = S2 + 1
01010  GOTO 1130
01020  PRINT "The shadow leaps out of the darkness." \ PRINT
01030  PRINT "'Har har', cries a bearded pirate, 'me thinks me will take a littl
01040  PRINT "yur booty!'" \ PRINT
01050  IF I <> 20 THEN GOTO 1080
01060  C$ = P$
01070  GOTO 1085
01080  C$ = T$( I )
01085  GOSUB 7700
01090  PRINT "That "; L$; " will do just fine!"
01100  PRINT \ PRINT "With that he scurries off to his treasure cave!!!!" \ PRIN
01110  N2 = A0
01120  P3 = P3 - 1
01130  RETURN
01262  REM      **********  Dwarf.
01270  PRINT
01275  IF D2 <> Z0 THEN GOTO 1300
01280  PRINT "An angry dwarf came in, threw a little axe which missed, cursed an
01290  T( 11 ) = Z1 \ D2 = A0 \ GOTO 3120
01300  IF D2 <> Z0 THEN D3 = D3 + 2
01310  D4 = A0
01320  PRINT "There's an angry dwarf in the room with you!  He throws a single k
01330  PRINT
01340  IF INT( D3 * RND ) > 4 THEN GOTO 1360
01350  PRINT "It misses!" \ GOTO 3120
01360  PRINT "It hits you!" \ K1 = K1 + 1
01370  IF K1 = 2 THEN  GOTO 6920
01380  GOTO 3120
01382  REM      **********  Display things.
01390  PRINT
01400  IF T( 1 ) = Z1 THEN PRINT "There's a set of keys here!"
01410  IF T( 2 ) = Z1 THEN PRINT "A lantern rests here!"
01420  IF T( 3 ) = Z1 THEN PRINT "There is tasty food here!"
01430  IF T( 4 ) = Z1 THEN PRINT "A small bottle is lying here!"
01440  IF T( 5 ) = Z1 THEN PRINT "There is much water here!"
01445  IF T( 6 ) = Z1 THEN PRINT "A small pool of oil is here!"
01450  IF T( 7 ) = Z1 THEN PRINT "A useful hemp rope is coiled here!"
01455  IF T( 8 ) = Z1 THEN PRINT "There is an ancient book on the ground!"
01460  IF T( 9 ) = Z1 THEN PRINT "There is a tiny marble statue in the corner."
01465  IF T( 10 ) = Z1 THEN PRINT "There is a persian carpet lying on the ground
01470  IF T( 11 ) = Z1 AND N3 = Z0 THEN PRINT "A little axe is here!"
01475  IF T( 12 ) = Z1 THEN PRINT "A golden sword lies here!"
01480  IF T( 13 ) = Z1 THEN PRINT "A magic wand floats in mid air!"
01485  IF T( 14 ) = Z1 THEN PRINT "Seven bars of silver lie here!"
01490  IF T( 15 ) = Z1 THEN PRINT "Many diamonds are scattered here!"
01495  IF T( 16 ) = Z1 THEN PRINT "A pea-sized emerald falls to the floor!"
01500  IF T( 17 ) = Z1 THEN PRINT "There's a king's crown here!"
01505  IF T( 18 ) = Z1 THEN PRINT "There's a pirate's treasure chest here!"
01550  IF P1( 20 ) = Z0 THEN GOTO 1580
01560  PRINT "The "; P$; " is still by your side."
01570  GOTO 1600
01580  IF T( 20 ) = Z1 THEN PRINT "A "; P$; " patiently waits here!"
01600  L1 = A0
01610  GOTO 3230
01612  REM      **********  Display scenes.
01620  PRINT "You are inside a building, a safe place to store treasures." \ GOTO 5530
01640  PRINT "You are on a very nicely groomed path." \ GOTO 5530
01670  PRINT "You are in the forest."
01680  IF Z1 <> 15 THEN GOTO 5530
01690  IF B2 <> Z0 THEN GOTO 1720
01700  PRINT \ PRINT "A black knight in full iron armour is standing before you."
01710  PRINT "He is carrying a golden sword." \ GOTO 5530
01720  PRINT "An iron statue of a black knight stands in front of you." \ GOTO 5530
01730  PRINT "You are in a dried up stream bed of a once great river." \ GOTO 5530
01750  PRINT "You are at the bottom of a climbable pit.  A small stream flows across"
01760  PRINT "the floor of the pit." \ GOTO 5530
01770  PRINT "You are in a beautiful forest carrying the sounds of many animals"
01790  PRINT "You are at the entrance of a small cave.  A 3x3 iron grate keeps you"
01800  PRINT "from going down to where it looks like the cave opens up." \ GOTO 5530
01820  PRINT "You are inside the cave entrance.  It is a good sized passage and
01860  PRINT "You are at the edge of a pit.  You can climb down but you might not"
01870  PRINT "able to climb back up again." \ GOTO 5530
01880  PRINT "You are in an old mine shaft that extends vertically in both direc
01890  PRINT "You are standing beside a large sign flashing '"; M$; "'!" \ S3 =
01900  PRINT "You are traveling in a east-west tunnel." \ GOTO 5530
01910  PRINT "You are walking in a east-west corridor." \ GOTO 5530
01920  PRINT "You're in a large north-south passage." \ GOTO 5530
01930  PRINT "You are in a small north-south cave." \ GOTO 5530
01940  PRINT "You are in a room that connects to an alternate passage." \ GOTO 5530
01950  PRINT "You are at an intersection of three corridors." \ GOTO 5530
01960  PRINT "You are at the brink of an easily climbable pit." \ GOTO 5530
01970  PRINT "You are at the bottom of a narrow shaft.  You could climb up but not
01980  PRINT "You're in an enormous chamber of solid granite.  Exits lead in many"
01990  PRINT "You're in a cave of many exits." \ GOTO 5530
02000  PRINT "You're in a beautiful cavern.  In the center of the cavern is a hu
02010  PRINT "hole.  I think I hear the sound of water?" \ GOTO 5530
02020  S$ = "a small crack" \ IF INT( 99 * RND ) > 50 THEN S$ = "a narow tunnel"
02030  PRINT "You climb thru "; S$; " only to find that........" \ PRINT \ Z1 =
02040  PRINT "You are in a spendid chamber decorated with strands of multi-colou
02050  Z1 = Z1 - 5 \ GOTO 2990
02060  S$ = "little, twisty" \ IF INT( 99 * RND ) > 50 THEN S$ = "twisty, litle"
02070  PRINT "You are in a "; S$; " maze!" \ GOTO 5530
02080  PRINT "You are at a complex junction of three forks.  Obvious paths lead
02090  print "and west." \ GOTO 5530
02100  PRINT "You are at the dragon's lair.  His job is to protect the magic cas
02110  PRINT "which lies to the south.  ";
02120  S$ = "refuses to let you enter." \ IF D5 <> Z0 THEN S$ = "lies dead off t
02130  PRINT "The dragon "; S$ \ GOTO 5530
02140  PRINT "You're in a small stone chamber of the magic castle." \ PRINT \ IF
02150  PRINT "A small green frog happily hops to and fro across the floor of the
02160  PRINT "You are standing on one side of a large moat that surrounds the ca
02170  PRINT "You cannot jump or swim across." \ PRINT \ IF B1 <> Z0 THEN PRINT
02180  GOTO 5530
02190  PRINT "You are in the west hall of the magic castle.  Your footsteps echo
02200  PRINT "You're in the eastern hall of the magic castle." \ GOTO 5530
02210  PRINT "You are in a room where a bed is made from twelve matresses."
02211  IF P1( 17 ) <> Z0 THEN D1( 99 ) = 0010
02212  GOTO 5530
02220  PRINT "Shhhh....you are in the king's chamber.  I think he's asleep." \ G
02230  PRINT "The floor you were standing on has given way...you fall..and fall.
02240  PRINT "fall.....finally landing on solid ground................." \ Z1 =
02250  PRINT "Welcome to the magic castle.  Although our ruler( King Dumb ) is s
02260  PRINT "I hope you enjoy your visit." \ GOTO 5530
02261  PRINT "You are in the castle dungeons." \ GOTO 5530
02769  REM      **********  The P$.
02270  IF C2$ <> P$ THEN GOTO 2300
02280  IF P1( 20 ) <> Z0 OR T( 20 ) = Z1 THEN GOTO 2350
02300  IF T2 <> Z0 THEN GOTO 4500
02320  IF T2 <> Z0 THEN GOTO 4500
02330  IF Z1 <> 93 AND Z1 <> 91 THEN GOTO 5180
02340  IF C2$ <> "Frog" AND C2$ <> P$ THEN GOTO 5160
02350  IF C2$ = "Frog" THEN GOTO 2430
02360  IF T( 20 ) <> Z1 THEN GOTO 5180
02370  PRINT "The "; P$; " disappears in a puff of blue smoke............."
02380  PRINT
02390  PRINT "A small green frog leaps from the smoke and hurriedly hops off int
02400  PRINT "the murky darkness of the chamber!"
02410  PRINT \ F1 = Z0 \ T( 20 ) = Z0 \ P1( 20 ) = Z0
02420  F3 = A0 \ GOTO 3150
02430  IF F3 <> Z0 THEN GOTO 4500
02440  PRINT "The room is filled with blue smoke and when the smoke clears......
02450  PRINT
02460  F1 = A0
02470  T( 20 ) = Z1
02480  GOTO 1390
02490  PRINT "The "; P$; " refuses to go by force!" \ GOTO 3150
02500  PRINT "The "; P$; " accepts your offer and will walk by your side!" \ P1(
02510  P1( 20 ) = Z0 \ T( 20 ) = Z1 \ L1 = Z0 \ GOTO 1390
02520  PRINT "They are too heavy to carry!" \ GOTO 3150
02522  REM      **********  Help.
02530  H1 = H1 + 1
02540  IF H1 < INT( H1 * RND ) + H1 OR H1 < 2 AND P1( 2 ) <> Z0 THEN GOTO 2580
02550  PRINT "The wizard says, 'Quit bothering me!'."
02560  IF H1 > 2 THEN GOTO 2680
02570  GOTO 3150
02580  IF N1 = A0 AND H1 < 4 THEN GOTO 2610
02590  GOTO 5120
02610  PRINT \ PRINT "The wizard of 'ADVENTURE' will light your way for 25 moves
02620  N1 = Z0
02630  L3 = A0
02640  O1 = O1 + 25
02650  V1 = 225
02660  L1 = Z0
02670  GOTO 2990
02680  PRINT \ PRINT "'I, the wizard of 'ADVENTURE', have given you enough warni
02690  PRINT \ PRINT "Now you will suffer this fate....."
02700  PRINT \ PRINT "The wizard turns you into stone!!!!" \ P2 = P2 + 1
02710  PRINT
02712  IF P2 > 1 THEN GOTO 7160
02718  GOTO 6920
02719  REM      **********  Some events.
02720  IF D4 <> Z0 OR  Z1 = 91 OR  Z1 = 93 OR P1( 20 ) <> Z0 OR  Z1 = 87 OR C2$
02740  IF T2 <> Z0 THEN GOTO 5160
02750  GOTO 5180
02770  IF C2$ = "Me" OR C2$ = "Myself" THEN GOTO 2800
02780  PRINT "With what?  Your bare hands?"
02790  GOTO 3150
02800  PRINT "Are you sure that you want me to put an end to your miserable life
02801  GOSUB 8200
02810  IF LEFT$( C1$, 1 ) = "Y" OR LEFT$( C1$, 1 ) = "N" THEN GOTO 2840
02820  PRINT \ PRINT "Please answer ( Yes or No ) !!!!!" \ PRINT
02830  GOTO 2800
02840  IF LEFT$( C1$, 1 ) = "Y" THEN GOTO 6920
02850  PRINT "Ok!" \ GOTO 3120
02860  IF Z1 <> 91 AND Z1 <> 93 THEN GOTO 5180
02870  PRINT "The frog hops just out of your reach. It seems impossible to catch
02880  IF D5 <> Z0 THEN GOTO 4320
02890  IF P1( 11 ) = Z0 THEN GOTO 6560
02900  PRINT "The dragon dodges out of the way and promptly sits upon the axe wh
02910  N3 = A0 \ P1( 11 ) = Z0 \ T( 11 ) = 87 \ P3 = P3 - 1 \ GOTO 3150
02920  PRINT "The dragon is sitting on it!" \ GOTO 3150
02930  IF P1( 12 ) <> Z0 THEN GOTO 2960
02940  PRINT "You have nothing that can kill it!"
02950  GOTO 3150
02960  PRINT "The golden sword strikes home!" \ N3 = Z0 \ L1 = Z0 \ D1( 87 ) = 0
02970  PRINT "The water quickly rusts the armor and turns the knight into an "
02980  PRINT "iron statue.  He drops the golden sword."
02982  P1( 5 ) = Z0 \ T( 12 ) = 15 \ P3 = P3 - 1 \ B2 = A0 \ L1 = Z0 \ GOTO 1390
02985  REM      **********  Check light.
02990  IF INT( 99 * RND ) > 92 AND Z1 > 25 THEN GOTO 1270
03000  IF V1 > 200 AND L4 = Z0 THEN GOTO 3110
03010  IF V1 > 250 AND N1 = Z0 THEN GOTO 3030
03020  GOTO 3040
03030  PRINT \ PRINT "Your lantern has run out of fuel!" \ N1 = A0
03040  IF N1 = Z0 THEN GOTO 3060
03050  L3 = Z0
03060  IF M1( Z1 ) <> 3 AND Z1 < 25 THEN GOTO 3120
03070  IF L3 <> Z0 THEN GOTO 3120
03080  PRINT \ PRINT "It is pitch dark!  If you proceed you will most likely fal
03090  IF INT( 99 * RND ) > 85 THEN GOTO 6910
03100  GOTO 3150
03110  PRINT \ PRINT "Your lantern is getting very dim!  I would look for a sour
03120  PRINT
03125  IF M1( Z1 ) > 20 THEN GOTO 3140
03130  ON M1( Z1 ) GOTO 1620,1640,1670,1730,1750,1770,1790,1820,1860,1880,1890,1
03140  ON M1( Z1 ) - 20 GOTO 1990,2000,2020,2040,2050,2060,2080,2100,2140,2160,2
03145  REM      **********  Input next command.
03150  IF L1 <> Z0 THEN GOTO 3230
03200  IF Z1 = 3 OR L3 <> Z0 THEN GOTO 1390
03230  PRINT \ PRINT "What is your command";
03232  GOSUB 8200
03240  IF C1$ = "" THEN GOTO 5110
03250  REM      **********  Make the next move.
03260  V1 = V1 + 1
03270  IF P1( 20 ) <> Z0 THEN T( 20 ) = Z1
03280  N = Z0 \ E = Z0 \ S = Z0 \ W = Z0 \ U = Z0 \ D = Z0
03380  IF LEN( C1$ ) > 1 THEN GOTO 3580
03382  REM      **********  Check for directional move.
03390  IF LEFT$( C1$, 1 ) <> "N" THEN GOTO 3410
03400  Z2 = Z1 - 5 \ N = 1 \ GOTO 3510
03410  IF LEFT$( C1$, 1 ) <> "E" THEN GOTO 3430
03420  Z2 = Z1 + 1 \ E = 1 \ GOTO 3510
03430  IF LEFT$( C1$, 1 ) <> "S" THEN GOTO 3450
03440  Z2 = Z1 + 5 \ S = 1 \ GOTO 3510
03450  IF LEFT$( C1$, 1 ) <> "W" THEN GOTO 3470
03460  Z2 = Z1 - 1 \ W = 1 \ GOTO 3510
03470  IF LEFT$( C1$, 1 ) <> "U" THEN GOTO 3490
03480  Z2 = Z1 - 25 \ U = 1 \ GOTO 3510
03490  IF LEFT$( C1$, 1 ) <> "D" THEN GOTO 3580
03500  Z2 = Z1 + 25 \ D = 1 \ GOTO 3510
03510  IF Z2 < 1 OR Z2 > 200 GOTO 5130
03514  N0 = ( D1( Z1 ) - INT( D1( Z1 ) / 100 ) * 100 )
03516  GOSUB 8400
03520  IF LEFT$( C1$, 1 ) <> "D" THEN GOTO 5210
03530  FOR I = 1 TO 2
03540  IF M3( I ) = Z1 THEN GOTO 3570
03550  NEXT I
03560  GOTO 5210
03570  PRINT "It is locked!" \ GOTO 3150
03580  IF C1$ <> "Walk" AND C1$ <> "Crawl" AND C1$ <> "Jump" AND C1$ <> "Run" TH
03590  IF LEN( C2$ ) <> Z0 THEN GOTO 3610
03600  PRINT C1$; " where";
03602  GOSUB 8300
03610  IF C2$ <> "North" AND C2$ <> "East" AND C2$ <> "South" AND C2$ <> "West"
03620  C1$ = C2$ \ GOTO 3390
03640  IF C1$ = "North" OR C1$ = "South" OR C1$ = "East" OR C1$ = "West" OR C1$
03645  REM      **********  Interpret non-directional commands.
03650  GOSUB 8350
03655  IF C1$ <> "Look" THEN GOTO 3680
03660  L1 = Z0 \ PRINT "I'm not allowed to give more detail!"
03670  GOTO 2990
03680  IF C1$ <> "Exit" AND C1$ <> "Enter" THEN GOTO 3770
03690  IF Z1 = 3 OR  Z1 = 8 THEN GOTO 3710
03700  GOTO 5140
03710  IF Z1 = 8 THEN GOTO 3740
03720  IF C1$ <> "Exit" THEN GOTO 5130
03730  Z1 = 8 \ GOTO 2990
03740  IF C1$ <> "Enter" THEN GOTO 5130
03750  Z1 = 3 \ PRINT "You walk thru a wooden door....." \ GOTO 2990
03760  GOTO 5130
03770  IF C1$ = "Inven" OR C1$ = "Inventory" THEN GOTO 6110
03780  IF C1$ = "Get" THEN GOTO 6200
03800  IF C1$ <> "Light" AND C1$ <> "Lite" THEN GOTO 3900
03810  IF N1 <> Z0 THEN GOTO 3840
03820  IF LEN( C2$ ) <> Z0 THEN GOTO 3860
03830  GOTO 5110
03840  IF N1 = Z0 THEN GOTO 3860
03850  PRINT "Your lantern is out of oil!" \ GOTO 2990
03860  IF C2$ <> "Lantern" THEN GOTO 5160
03870  IF P1( 2 ) = Z0 THEN GOTO 3890
03880  L3 = A0 \ PRINT "Your lantern is lit!" \ GOTO 2990
03890  PRINT "You don't have a lantern!" \ GOTO 3150
03900  IF C1$ <> "Quit" AND C2$ <> "Quit" THEN GOTO 3970
03910  PRINT \ PRINT "Do you really want to quit";
03911  GOSUB 8200
03912  IF LEFT$( C1$, 1 ) = "Y" OR LEFT$( C1$, 1 ) = "N" THEN GOTO 3950
03930  PRINT "Answer the question!!!( Yes or No )" \ PRINT \ PRINT
03940  PRINT "Do you want to quit?";
03944  GOTO 3911
03950  IF LEFT$( C1$, 1 ) = "Y" THEN GOTO 7160
03960  GOTO 2990
03970  IF C1$ = "Drop" THEN GOTO 6560
03990  IF C1$ <> "Say" THEN GOTO 4040
04000  IF S3 <> Z0 THEN GOTO 6810
04010  IF LEN( C2$ ) = Z0 THEN GOTO 6180
04030  PRINT \ PRINT "Okay, '"; C2$; "'!" \ GOTO 3150
04040  IF C1$ <> "Open" AND C1$ <> "Unlock" THEN GOTO 4120
04041  IF C2$ <> "Sesame" THEN GOTO 4058
04042  IF O2 <> Z0 THEN GOTO 4050
04043  O2 = A0
04044  FOR I = 1 TO 200
04045  D2( I ) = D1( I )
06044  D1( I ) = 0063
04047  NEXT I
04048  GOTO 3150
04050  O2 = Z0
04051  FOR I = 1 TO 200
04052  D1( I ) = D2( I )
04053  NEXT I
04054  GOTO 3150
04058  IF P1( 1 ) <> Z0 THEN GOTO 4070
04060  PRINT "You have no keys!" \ GOTO 3150
04070  FOR I = 1 TO 2
04080  IF Z1 = M3( I ) THEN GOTO 4110
04090  NEXT I
04100  GOTO 5140
04110  M3( I ) = Z0 \ PRINT "The keys have "; L1$; "ed it!" \ GOTO 3150
04120  IF C1$ <> "Abracadbra" THEN GOTO 4135
04121  IF A1 <> Z0 THEN GOTO 4130
04122  A1 = A0
04123  T0 = 20
04124  GOTO 3150
04125  A1 = Z0
04126  T0 = 6
04127  FOR I = 20 TO 3 STEP -1
04128  IF P3 <= T0 THEN GOTO 3150
04129  IF P1( I ) = Z0 THEN GOTO 4132
04130  P1( I ) = 0
04131  T( I ) = INT( 100 * RND ) + 1
04132  NEXT I
04133  GOTO 3150
04135  IF C1$ <> "*scan" AND C1$ <> "*s" THEN GOTO 4150
04136  IF C2$ <> "Thing" AND C2$ <> "T" THEN GOTO 4142
04137  PRINT \ PRINT \ PRINT "Locations of Things you are not holding." \ PRINT
04138  FOR I = 1 TO 20
04139  IF P1( I ) = Z0 THEN PRINT I, T$( I ), T( I )
04140  NEXT I
04141  GOTO 3150
04142  IF C2$ <> "Location" AND C2$ <> "Loc" THEN GOTO 5110
04143  PRINT \ PRINT
04144  PRINT "Maze position is "; Z1, "Location descriptor is "; M1( Z1 )
04145  PRINT
04146  GOTO 3150
04150  IF C1$ <> "*goto" AND C1$ <> "*g" THEN GOTO 4160
04151  IF LEN( C2$ ) = Z0 THEN GOTO 6180
04152  L1 = Z0 \ X = VAL( C2$ )
04154  IF X > 0 AND X <= 200 THEN Z1 = X
04156  GOTO 2990
04160  IF C1$ <> "Drink" THEN GOTO 4200
04161  IF LEN( C2$ ) = Z0 THEN GOTO 6180
04163  IF T1 = Z0 THEN GOTO 5110
04164  IF C2$ <> "Water" THEN GOTO 5190
04165  IF P1( 5 ) = 0 THEN GOTO 5195
04166  PRINT "Your water is gone!"
04167  P1( 5 ) = Z0 \ P3 = P3 - 1 \ GOTO 3150
04200  IF C1$ <> "Eat" THEN GOTO 4260
04201  IF LEN( C2$ ) = Z0 THEN GOTO 6180
04203  IF T1 = Z0 THEN GOTO 5110
04204  IF T3 = Z0 THEN GOTO 5150
04205  IF I < 3 THEN GOTO 5190
04206  PRINT "Thanks, don't mind if I do!" \ PRINT \ PRINT "Your "; L2$; " was v
04207  P1( I ) = Z0 \ P3 = P3 - 1 \ GOTO 3150
04260  IF C1$ <> "Throw" THEN GOTO 4380
04270  IF C2$ <> "Axe" THEN GOTO 6560
04280  IF Z1 = 87 THEN GOTO 2880
04290  IF P1( 11 ) <> Z0 THEN GOTO 4320
04300  GOTO 6560
04310  PRINT "There's nothing here to attack!" \ GOTO 3150
04320  IF Z1 = 15 THEN GOTO 6560
04330  IF D4 = Z0 THEN GOTO 4310
04340  P1( 11 ) = Z0 \ T( 11 ) = Z1 \ P3 = P3 - 1 \ S$ = "You missed!"
04350  IF INT( 99 * RND ) > 70 THEN GOTO 4370
04360  S$ = "You killed a little dwarf.  His body vanishes in a *POOF* of pink s
04370  PRINT S$ \ D3 = INT( 3 * RND ) + 1 \ L1 = Z0 \ PRINT \ D4 = Z0 \ GOTO 299
04380  IF C1$ <> "Wave" AND C1$ <> "Shake" THEN GOTO 4520
04390  IF P1( 13 ) = Z0 OR  Z1 <> 92 OR C2$ <> "Wand" THEN GOTO 4440
04400  B1 = A0
04410  D1( 92 ) = 0005
04420  GOTO 3120
04440  IF T2 <> Z0 THEN GOTO 4500
04450  GOTO 5150
04460  D4 = Z0
04470  D3 = INT( 2 * RND ) + 1
04480  PRINT "The angry little dwarf sees the anger in the way that you "; L1$
04490  PRINT "your axe and promptly heads for the nearest exit." \ GOTO 3150
04500  IF D4 <> Z0  AND C2$ = "Axe" THEN GOTO 4460
04510  PRINT "Nothing happens!" \ GOTO 3150
04520  IF C1$ <> "Pay" THEN GOTO 4580
04530  IF P1( 15 ) <> Z0 THEN GOTO 4550
04540  PRINT "No money.. no book!" \ GOTO 3150
04550  IF Z1 <> 170 THEN GOTO 5110
04560  PRINT "Thank you sir.  I hope you enjoy it!"
04570  P1( 8 ) = A0 \ T( 8 ) = Z0 \ P3 = P3 + 1 \ F2 = A0 \ GOTO 3150
04580  IF C1$ <> "Give" THEN GOTO 4650
04590  IF P1( 5 ) <> Z0 AND Z1 = 145 AND C2$ = "Water" THEN GOTO 4630
04600  IF P1( 5 ) = Z0 THEN GOTO 6560
04610  GOTO 3150
04620  PRINT "Who are you going to give it to?"
04630  PRINT "The old man drinks the water and walks off into the darkness!"
04640  P1( 5 ) = Z0 \ P3 = P3 - 1 \ M1( 145 ) = 28 \ GOTO 2990
04650  IF C1$ <> "Wet" THEN GOTO 4710
04660  IF P1( 5 ) <> Z0 THEN GOTO 4680
04670  PRINT "With what?  Spit? Sweat?" \ GOTO 5160
04680  IF Z1 <> 157 THEN GOTO 5110
04690  PRINT "You slip and slide into........" \ PRINT
04700  P1( 5 ) = Z0 \ D1( 157 ) = 0010 \ P3 = P3 - 1 \ Z1 = 159 \ GOTO 2990
04710  D4 = Z0
04720  IF C1$ <> "Read" OR P1( 8 ) = Z0 THEN GOTO 4750
04730  IF C2$ <> "Book" THEN GOTO 5160
04740  PRINT "The book reads, 'say magic word in the 'not same' maze!" \ GOTO 31
04750  IF C1$ = "Kill" THEN GOTO 2720
04760  IF C1$ <> "With" THEN GOTO 4790
04770  IF C2$ <> "Axe" THEN GOTO 5160
04780  C1$ = "Throw" \ C2$ = "Axe" \ GOTO 4260
04790  IF C1$ <> M$ THEN GOTO 4810
04800  C2$ = M$ \ C1$ = "Say" \ GOTO 3990
04810  IF C1$ <> "Why" THEN GOTO 4830
04820  PRINT "Because I said so!  That's why!!!!" \ GOTO 3150
04830  IF C1$ <> "You" AND C1$ <> "Your" AND C2$ <> "You" THEN GOTO 4850
04840  PRINT "If you don't like playing the game you can always 'Quit'!" \ GOTO
04850  IF C1$ <> "Find" THEN GOTO 4870
04860  PRINT "I cannot tell you where remote things are located!" \ GOTO 3150
04870  IF C1$ = "Slay" AND C2$ = "Dragon" THEN GOTO 2930
04880  IF C1$ <> "Yes" THEN GOTO 4920
04890  IF Z1 = 15 OR  Z1 = 87 OR D4 <> Z0  THEN GOTO 5160
04900  PRINT "You seem unsure of that answer!"
04910  GOTO 3150
04920  IF C1$ <> "Lift" THEN GOTO 4970
04922  IF LEN( C2$ ) = Z0 THEN GOTO 6180
04940  IF T2 = Z0 AND Z1 <> 99 THEN GOTO 5180
04950  IF C2$ <> "Matress" AND C2$ <> "Matresses" THEN GOTO 4500
04960  T( 16 ) = A0 \ L1 = Z0 \ GOTO 1390
04970  IF C1$ = "Kiss" THEN GOTO 2270
04980  IF C1$ = "Please" AND T( 20 ) = Z1 THEN GOTO 2500
04990  IF C1$ = "Wait" AND P1( 20 ) <> Z0 THEN GOTO 2510
05000  IF C1$ = "Help" THEN GOTO 2530
05010  IF C1$ <> "Listen" THEN GOTO 5030
05020  PRINT "Slosh..boil..drip..spurt..squirt......" \ GOTO 3150
05030  IF C1$ <> "Where" THEN GOTO 5035
05032  PRINT "I'm not really sure which way you're facing.  Try a compass headin
05035  IF C1$ <> "What" AND C1$ <> "Who" AND C1$ <> "When" AND C1$ <> "How" THEN
05040  PRINT "I refuse to answer on the grounds that it might incriminate me!" \
05050  IF LEFT$( C1$, 1 ) <> "N" THEN GOTO 5070
05060  PRINT "Why must you always be so negative?" \ GOTO 3150
05070  IF C1$ <> "Cause" AND C1$ <> "Because" THEN GOTO 5090
05080  PRINT "That answer stinks!" \ GOTO 3150
05090  IF C2$ = "" THEN Q = A0
05092  C2$ = C1$
05096  IF T2 = Z0 THEN GOTO 5120
05098  REM      **********  Some miscelaneous messages.
05100  PRINT "What do you want to do with the "; L2$; "?" \ GOTO 3150
05105  PRINT "You can't "; L1$; " "; L2$; "!" \ GOTO 3150
05110  S$ = "I don't understand what you mean!" \ IF INT( 99 * RND ) > 50 THEN S
05111  IF Q = Z0 THEN GOTO 5113
05112  PRINT "I'm not yet familiar with that word!" \ Q = Z0 \ GOTO 3150
05113  PRINT S$ \ GOTO 3150
05120  PRINT "Nothing happens!" \ GOTO 3150
05130  S$ = "You do not seem to know where you're going!"
05131  IF RND > 0.5 THEN S$ = "You can't go that way!"
05132  PRINT S$ \ GOTO 3150
05140  PRINT "There's nothing here to "; L1$; "!" \ GOTO 3150
05150  PRINT "You don't have that to "; L1$; "!" \ GOTO 3150
05155  PRINT "You are already holding the "; L2$; "!" \ GOTO 3150
05160  PRINT "C'mon, can't you be serious?" \ GOTO 3150
05170  PRINT "You have nothing to "; L1$; "!" \ GOTO 3150
05180  PRINT "I see no "; L2$; " here!" \ GOTO 3150
05190  PRINT "I'm game.  Would you care to explain how?" \ GOTO 3150
05195  PRINT "You have to get it first!" \ GOTO 3150
05205  REM      **********  Process directional moves.
05210  IF M1( Z1 ) <> 6 THEN GOTO 5300
05220  IF N = Z0 THEN GOTO 5240
05230  N = Z0 \ E = 1 \ Z2 = Z1 + 1 \ GOTO 5310
05240  IF E = Z0 THEN GOTO 5260
05250  E = Z0 \ S = 1 \ Z2 = Z1 + 5 \ GOTO 5320
05260  IF S = Z0 THEN GOTO 5280
05270  S = Z0 \ W = 1 \ Z2 = Z1 - 1 \ GOTO 5330
05280  IF W = Z0 THEN GOTO 5300
05290  W = Z0 \ N = 1 \ Z2 = Z1 - 5 \ GOTO 5300
05298  REM      **********  Check allowed directions.
05300  IF N = 1 AND D( 1 ) = 1 THEN GOTO 5520
05310  IF E = 1 AND D( 2 ) = 1 THEN GOTO 5520
05320  IF S = 1 AND D( 3 ) = 1 THEN GOTO 5520
05330  IF W = 1 AND D( 4 ) = 1 THEN GOTO 5520
05340  IF U = 1 AND D( 5 ) = 1 THEN GOTO 5520
05350  IF D = 1 AND D( 6 ) = 1 THEN GOTO 5520
05480  PRINT
05490  IF Z1 = 87 THEN GOTO 5510
05500  GOTO 5130
05510  S$ = "refuses to let you pass!" \ GOTO 2130
05520  Z1 = Z2 \ L1 = Z0 \ GOTO 2990
05522  REM      **********  Look around at nearby scenes.
05530  N = Z0 \ E = Z0 \ S = Z0 \ W = Z0 \ U = Z0 \ D = Z0
05540  IF V1 > 50 +  INT( 50 * RND ) THEN  GOSUB 920
05550  N0 = INT( D1( Z1 ) / 100 )
05560  GOSUB 8400
05570  N = D( 1 )
05580  E = D( 2 )
05590  S = D( 3 )
05600  W = D( 4 )
05610  U = D( 5 )
05620  D = D( 6 )
05970  IF N = Z0 THEN GOTO 5990
05980  L2 = Z1 - 5 \ N = Z0 \ PRINT "To the north is "; \ GOTO 6095
05990  IF E = Z0 THEN GOTO 6010
06000  L2 = Z1 + 1 \ E = Z0 \ PRINT "Along the east is "; \ GOTO 6095
06010  IF S = Z0 THEN GOTO 6030
06020  L2 = Z1 + 5 \ S = Z0 \ PRINT "Looking south is "; \ GOTO 6095
06030  IF W = Z0 THEN GOTO 6050
06040  L2 = Z1 - 1 \ W = Z0 \ PRINT "Appearing westerly is "; \ GOTO 6095
06050  IF U = Z0 THEN GOTO 6070
06060  L2 = Z1 - 25 \ U = Z0 \ GOTO 6095
06070  IF D = Z0 THEN GOTO 6090
06080  L2 = Z1 + 25 \ D = Z0 \ GOTO 6095
06090  GOTO 3150
06095  ON M1( L2 ) GOTO 6096, 6098, 1720, 6102, 5970, 6104, 6105, 6106
06096  PRINT "a small building." \ GOTO 5970
06098  PRINT "a shallow valley." \ GOTO 5970
06102  PRINT "a river bed" \ GOTO 5970
06104  PRINT "a beautiful forest." \ GOTO 5970
06105  PRINT \ PRINT "A cobble path leads up to the surface." \ GOTO 5970
06106  PRINT \ PRINT "A cobble path leads down into the cave." \ PRINT
06107  IF M3( 1 ) = Z0 THEN PRINT "The grate is open."
06108  GOTO 5970
06109  REM      **********  Perform inventory.
06110  PRINT \ PRINT "You are holding the following items:" \ PRINT
06120  X = Z0
06130  FOR I = 1 TO 19
06140  IF P1( I ) = Z0 THEN  6170
06150  PRINT T$( I )
06160  X = A0
06170  NEXT I
06172  IF X = Z0 THEN PRINT "Nothing!"
06174  GOTO 3150
06179  REM      **********  Ask for C2$.
06180  PRINT C1$; " what";
06182  GOSUB 8300
06184  GOTO 3650
06192  REM      **********  Perform 'Get' and 'Drop'.
06200  IF P3 <> T0 THEN GOTO 6260
06250  PRINT "You can't carry anything more.  You'll have to drop something firs
06260  IF LEN( C2$ ) = Z0 THEN GOTO 6180
06270  IF T3 = A0 THEN GOTO 5155
06290  IF T2 <> Z0 THEN GOTO 6350
06300  IF C2$ = "Water" AND Z1 = 59 THEN GOTO 6350
06310  IF C2$ = "Frog" THEN GOTO 2860
06320  IF T( 20 ) = Z1 THEN GOTO 2490
06330  IF C2$ = "Matress" OR C2$ = "Matresses" THEN GOTO 2520
06340  GOTO 5180
06350  IF C2$ <> "Water" OR T( 5 ) <> Z1 THEN GOTO 6410
06360  IF P1( 5 ) <> Z0 THEN GOTO 6400
06370  IF P1( 4 ) = Z0 THEN GOTO 6390
06380  P1( 5 ) = A0 \ GOTO 6550
06390  PRINT "You have nothing to carry the water in!" \ GOTO 3150
06400  PRINT "You can't carry any more water!" \ GOTO 3150
06410  IF C2$ <> "Oil" OR T( 6 ) <> Z1 THEN GOTO 6420
06411  PRINT "Your lantern is full again."
06413  T( 6 ) = Z0 \ L4 = Z0 \ O1 = V1 \ V1 = 1
06414  GOTO 3150
06420  IF C2$ = "Book" AND F2 = Z0 AND Z1 = 159 THEN GOTO 8670
06440  IF C2$ <> "Book" OR T( 8 ) <> Z1 THEN GOTO 6460
06450  P1( 8 ) = A0 \ T( 8 ) = Z0 \ GOTO 6550
06460  IF C2$ <> "Treasure" OR T( 18 ) <> Z1 THEN GOTO 6500
06470  IF M3( 2 ) <> Z0 THEN GOTO 6490
06480  P1( 18 ) = A0 \ T( 18 ) = Z0 \ GOTO 6550
06490  PRINT "It's locked!" \ GOTO 3150
06500  IF C2$ <> "Axe" THEN GOTO 6530
06510  IF N3 <> Z0 THEN GOTO 2920
06530  P1( I ) = A0 \ T( I ) = Z0 \ GOTO 6550
06540  GOTO 5180
06550  PRINT "Ok!" \ P3 = P3 + 1 \ GOTO 3150
06555  REM      **********  Drop things.
06560  IF P3 <> Z0 THEN GOTO 6580
06570  GOTO 5170
06580  IF LEN( C2$ ) = Z0 THEN GOTO 6180
06610  IF T3 <> Z0 THEN GOTO 6640
06620  IF C2$ = P$ THEN GOTO 2350
06630  IF T1 = Z0 THEN GOTO 5105
06632  PRINT "You are not carrying it!" \ GOTO 3150
06640  IF C2$ <> "Lantern" THEN GOTO 6660
06650  L3 = Z0
06660  IF C2$ <> "Bottle" THEN GOTO 6720
06690  IF P1( 5 ) = Z0 THEN GOTO 6800
06700  P1( 5 ) = Z0 \ P3 = P3 - 1
06710  PRINT "The bottle tipped over and the water spilled out of the bottle!" \
06720  IF C2$ <> "Statue" THEN GOTO 6780
06730  IF T( 9 ) = Z1 THEN GOTO 6750
06740  PRINT "The statue falls and breaks worthlessly" \ P1( 12 ) = Z0 \ T( 12 )
06750  IF B3 <> Z0 THEN GOTO 6740
06760  PRINT "The statue lands safely on the persian rug." \ B3 = A0 \ GOTO 6802
06780  IF C1$ = "Throw" AND C2$ = "Water" AND Z1 = 15 AND B2 = Z0 THEN GOTO 2970
06800  PRINT "Ok!"
06802  P1( I ) = Z0 \ T( I ) = Z1
06804  P3 = P3 - 1 \ GOTO 3150
06808  REM      **********  Magic words.
06810  IF C2$ <> M$ THEN GOTO 4030
06820  IF Z1 <> 199 THEN GOTO 6840
06830  PRINT "A secret passage opens to the west!" \ D1( 199 ) = 0009 \ GOTO 315
06840  IF Z1 <> 3 THEN GOTO 6860
06850  Z1 = 41 \ GOTO 6880
06860  IF Z1 <> 41 THEN GOTO 6890
06870  Z1 = 3
06880  L1 = Z0
06890  IF Z1 = 3 OR  Z1 = 41 THEN GOTO 2990
06900  PRINT "Nothing happens!" \ GOTO 3150
06902  REM      **********  The pit.
06910  PRINT \ P2 = P2 + 1 \ PRINT "You fell into a pit and are a mass of twiste
06920  IF P2 > 1 THEN GOTO 6950
06930  PRINT \ PRINT "I might be able to reincarnate you!  Would you like me to
06940  GOTO 6990
06950  PRINT "You've really done it this time.  I'm all out of fairy dust!"
06960  PRINT \ PRINT "You don't really expect me to do a decent reincarnation wi
06970  PRINT "you?"
06980  K1 = Z0 \ D3 = Z0
06990  PRINT \ PRINT "Well";
07000  IF P2 > 1 THEN GOTO 7130
07005  GOSUB 8200
07010  IF LEFT$( C1$, 1 ) = "N" THEN GOTO 7160
07020  PRINT "Ready......one.two..three!  *POOF*" \ P2 = P2 + 1
07030  PRINT \ PRINT "You emerge from a cloud of fairy dust only to find yoursel
07040  L1 = Z0
07050  FOR I = 1 TO 20
07060  IF P1( I ) = Z0 THEN GOTO 7090
07070  T( I ) = Z1
07080  IF I = 2 THEN T( 2 ) = 3
07090  NEXT I
07120  Z1 = 3 \ P3 = Z0 \ GOTO 3120
07130  GOSUB 8200
07140  IF LEFT$( C1$, 1 ) = "N" THEN GOTO 7160
07150  PRINT \ PRINT "Ok!  If you're so smart do it yourself!!" \ PRINT
07155  REM      **********  Calculate score.
07160  P4 = Z0
07170  FOR I = 1 TO 5
07180  IF T( I ) = 3 THEN P4 = P4 + 10
07190  NEXT I
07210  FOR I = 6 TO 13
07220  IF T( I ) = 3 THEN P4 = P4 + 20
07230  NEXT I
07240  FOR I = 14 TO 19
07250  IF T( I ) = 3 THEN P4 = P4 + 30
07260  NEXT I
07270  IF T( 20 ) = 3 THEN P4 = P4 + 50
07280  IF S3 <> Z0 THEN P4 = P4 + 50
07290  IF O1 <> Z0 THEN V1 = V1 + O1
07300  P4 = P4 - INT( V1 / 10 )
07310  PRINT \ PRINT "You scored "; P4 ; " points out of a possible 350, using";
07320  G$ = "RANK BEGINNER"
07330  IF P4 > 50 THEN G$ = "NOVICE"
07340  IF P4 > 100 THEN G$ = "EXPERIENCED"
07350  IF P4 > 150 THEN G$ = "SEASONED"
07360  IF P4 > 200 THEN G$ = "JR. MASTER"
07370  IF P4 > 250 THEN G$ = "SR. MASTER"
07380  IF P4 > 300 THEN G$ = "MASTER"
07390  IF P4 = 350 THEN G$ = "WIZARD"
07400  PRINT "Your score qualifies you as a  *** '"; G$; "' ADVENTURER ***" \ PR
07410  FOR I = 50 TO 350 STEP 50
07420  IF I - P4 > Z0 THEN GOTO 7440
07430  NEXT I
07440  PRINT "To achieve the next higher rating you need "; I - P4 ; " more poin
07450  GOTO 8670
07500  REM      **********  Convert upper case to lower case.
07510  D0 = ASCII( D$ )
07520  IF D0 < 65 OR D0 > 90 THEN RETURN
07530  D$ = CHR$( D0 + 32 )
07540  RETURN
07600  REM      **********  Convert lower case to upper case.
07610  D0 = ASCII( D$ )
07620  IF D0 < 97 OR D0 > 122 THEN RETURN
07630  D$ = CHR$( D0 - 32 )
07640  RETURN
07699  REM      **********  Convert string to lower case.
07700  D$ = ""
07705  IF LEN( C$ ) = Z0 THEN GOTO 7730
07710  D$ = LEFT$( C$, 1 )
07720  GOSUB 7500
07722  IF LEN( C$ ) = 1 THEN GOTO 7730
07725  D$ = D$ + RIGHT$( C$, LEN( C$ ) - 1 )
07730  L$ = D$
07780  RETURN
07799  REM      **********  Convert to capitalized first letter.
07800  C$ = ""
07805  L = LEN( W$ )
07810  IF L = Z0 THEN RETURN
07820  D$ = LEFT$( W$, 1 )
07822  GOSUB 7600
07823  C$ = D$
07824  IF L = 1 THEN RETURN
07830  FOR I = 2 TO L
07840  D$ = MID$( W$ , I, 1 )
07850  GOSUB 7500
07860  C$ = C$ + D$
07870  NEXT I
07899  RETURN
07999  REM      **********  Parse input string.
08000  IF R$ = "" THEN GOTO 8185
08041  L = LEN( R$ )
08050  IF L <> Z0 AND LEFT$( R$, 1 ) = " " THEN GOTO 8185
08100  FOR I = 1 TO L
08110  IF MID$( R$, I, 1 ) = " " THEN GOTO 8150
08120  NEXT I
08130  R2$ = ""
08140  GOTO 8170
08150  I = I - 1
08160  R2$ = MID$( R$, I + 2, L - I )
08170  R1$ = LEFT$( R$, I )
08180  RETURN
08185  R1$ = "" \ R2$ = "" \ L = Z0
08190  RETURN
08199  REM      **********  Input 1.
08200  INPUT R$
08205  PRINT
08210  GOSUB 8000
08220  W$ = R1$
08222  GOSUB 7800
08223  C1$ = C$
08224  GOSUB 7700
08225  L1$ = L$
08230  W$ = R2$
08235  GOSUB 7800
08236  C2$ = C$
08237  GOSUB 7700
08238  L2$ = L$
08249  RETURN
08299  REM      **********  Input 2.
08300  INPUT R$
08302  PRINT
08304  GOSUB 8000
08306  W$ = R1$
08308  GOSUB 7800
08310  C2$ = C$
08312  GOSUB 7700
08314  L2$ = L$
08320  RETURN
08349  REM      **********  Test
08350  T1 = Z0 \ T2 = Z0 \ T3 = Z0
08351  FOR I = 1 TO 19
08352  IF C2$ = T$( I ) THEN GOTO 8355
08353  NEXT I
08354  RETURN
08355  T1 = A0
08356  IF T( I ) = Z1 THEN T2 = A0
08357  IF P1( I ) <> Z0 THEN T3 = A0
08359  RETURN
08398  REM      **********  Decode directional data.
08400  FOR I = 1 TO 6
08402  Q = INT( N0 / 2 )
08403  D( I ) = N0 - 2 * Q
08404  N0 = Q
08408  NEXT I
08409  RETURN
08440  REM      **********  Data definition for maze.
08450  DATA  9,  3,  1,  3,  3,  6,  6,  2,  6,  6
08460  DATA  3,  6,  2,  2,  3,  7,  2,  2,  6,  3
08470  DATA  3,  4,  4,  4, 11,  9, 17, 12, 12, 17
08480  DATA 19, 16, 20, 18, 21, 12, 17, 22, 23, 16
08490  DATA  8, 21, 12, 14, 24, 12, 16, 17, 12, 23
08500  DATA  9, 13, 13, 13, 13, 13, 25, 26,  5,  9
08510  DATA 26, 26, 27, 12, 12, 26, 26, 26, 26, 26
08520  DATA 26, 26, 26, 26, 26, 16, 17, 12, 12, 19
08530  DATA 12, 21, 19, 14, 16, 17, 28, 12, 12, 16
08538  DATA 29, 30, 29, 13, 34, 31, 36, 32, 33, 35
08540  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08541  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08542  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08543  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08544  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08545  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08546  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08547  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08548  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08549  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
08550  DATA 0034,  0004,  0000,  0006,  0014,  0015,  0015,  1514,  0015,  0015
08560  DATA 0011,  0015,  0015,  0007,  0013,  3234,  0015,  0015,  0015,  0011
08570  DATA 0010,  0010,  0011,  0011,  0011,  0034,  0014,  0010,  0010,  0014
08580  DATA 0018,  0009,  0013,  0034,  0015,  0010,  0014,  0034,  0013,  0012
08590  DATA 1618,  0015,  0010,  0005,  0015,  0010,  0009,  0011,  0010,  0000
08600  DATA 0034,  0010,  0010,  0010,  0010,  0014,  0000,  0018,  0016,  0034
08610  DATA 0015,  0013,  0014,  0010,  0010,  0015,  0014,  0014,  0015,  0015
08620  DATA 0003,  0009,  0011,  0011,  0011,  0011,  0014,  0010,  0010,  0018
08630  DATA 0010,  0015,  0018,  0005,  0012,  0011,  0011,  0010,  0010,  0009
08640  DATA 0004,  0001,  0006,  0010,  0010,  0011,  0011,  0011,  0008,  0032
08641  DATA 0018,  0018,  0018,  0018,  0018,  0063,  0063,  0063,  0063,  0063
08642  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08643  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08644  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08645  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08646  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08647  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08648  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08649  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
08650  DATA 0063,  0063,  0063,  0063,  0063,  0018,  0018,  0018,  0018,  0009
08655  DATA 3,  3,  3,  3, 59, 69, 45,  0,  0,  0
08660  DATA 0,  0, 28, 44, 49,  0, 95, 33,  0,  0
08670  END
