00010  REM
00020  REM      ########## APPLE II ADVENTURE ##########
00030  REM
00040  REM      ***** Arrays *****
00050  REM
00060  REM      D1      Direction
00070  REM      M1      Maze descriptor
00080  REM      T       Thing location
00090  REM      M3      Maze modifier
00100  REM      P1      Holding thing
00110  REM      T$      Thing name
00120  REM
00130  REM      ***** OTHERS *****
00140  REM
00150  REM      B1      Drawbridge #
00160  REM      B2      Black knight #
00162  REM      B3      Break #
00170  REM      C1      Thing count
00180  REM      D2      Dwarf about #
00190  REM      D3      Dwarf count
00192  REM      D4      Dwarf here #
00200  REM      D5      Dragon #
00210  REM      D5      Dir
00220  REM      F1      Frog #
00230  REM      F2      Fine #
00240  REM      H1      Help
00250  REM      K1      Killed
00260  REM      L1      Look #
00270  REM      L2      Location
00280  REM      L3      Lantern lit #
00290  REM      L4      Lantern dim #
00300  REM      M$      Magic word
00310  REM      N1      No light #
00320  REM      N2      Pirate gone #
00330  REM      N3      No axe #
00340  REM      O1      Oil level
00350  REM      P2      Pit count
00360  REM      P3      Holding count
00370  REM      P4      Final score
00380  REM      S1      Shadowy figure #
00390  REM      S2      Shadow count
00400  REM      S3      Say #
00402  REM      T0      Thing limit
00405  REM      T1      Test 1
00410  REM      T2      Test 2
00415  REM      T3      Test 3
00420  REM      V1      Moves made
00430  REM      Z0      Zero
00440  REM      Z1      Posn in maze
00450  REM      Z2      New maze posn
00460  REM
00470  REM      ( NOTE: '#' -- Used as a flag. )
00480  REM
00490  REM      **********  Declare arrays.
00540  REM      **********  Declare arrays.
00550  DIM M1( 200 ), D1( 200 ), D2( 200 ), T( 20 ), D( 6 ), M3( 2 ), P1( 20 ), T$( 20 )
00560  REM      **********  Define names of things.
00570  T$( 1 ) = "Keys"
00580  T$( 2 ) = "Lantern"
00590  T$( 3 ) = "Food"
00600  T$( 4 ) = "Bottle"
00610  T$( 5 ) = "Water"
00620  T$( 6 ) = "Oil"
00630  T$( 7 ) = "Rope"
00640  T$( 8 ) = "Book"
00650  T$( 9 ) = "Carpet"
00660  T$( 10 ) = "Statue"
00670  T$( 11 ) = "Axe"
00680  T$( 12 ) = "Sword"
00690  T$( 13 ) = "Wand"
00700  T$( 14 ) = "Silver"
00710  T$( 15 ) = "Diamonds"
00720  T$( 16 ) = "Emerald"
00730  T$( 17 ) = "Crown"
00740  T$( 18 ) = "Treasure"
00750  M3( 1 ) = 16
00760  REM      **********  Define flag values.
00770  A0 = 99
00780  Z0 = 0
00790  REM      **********  Setup arrays which define maze structure.
00800  FOR I = 1 TO 200
00810  READ M1( I )
00820  NEXT I
00830  FOR I = 1 TO 200
00840  READ D1( I )
00850  D2( I ) = D1( I )
00860  NEXT I
00870  FOR I = 1 TO 20
00880  READ  T( I )
00890  NEXT I
00900  FOR I = 1 TO 20
00910  P1( I ) = Z0
00920  NEXT I
00930  REM      **********  Start of main program.
00940  PRINT "Are you a Boy or Girl ";
00950  GOSUB 11290
00960  IF C1$ = "Boy" OR C1$ = "Girl" THEN GOTO 1000
00970  PRINT ""
00980  PRINT "Please answer Boy or Girl !"
00990  GOTO 940
01000  IF C1$ = "Boy" THEN P$ = "Princess"
01010  IF C1$ = "Girl" THEN P$ = "Prince"
01020  T$( 20 ) = P$
01030  M$ = "Xyzzy"
01040  IF INT( 99 * RND ) > 66 THEN M$ = "Cigam"
01050  IF INT( 99 * RND ) > 66 THEN M$ = "Renob"
01060  PRINT "                      *** ADVENTURE ***"
01070  PRINT ""
01080  PRINT ""
01090  REM      **********  Initialize miscelaneous values.
01100  T0 = 6
01110  Z1 = 8
01120  GOTO 4180
01130  REM      **********  Shadowy figure.
01140  IF N2 <> Z0 THEN GOTO 1440
01150  IF S1 > Z0 THEN GOTO 1180
01160  IF INT( 99 * RND ) < 96 THEN GOTO 1440
01170  S1 = A0
01180  PRINT ""
01190  PRINT "A shadowy figure is following you!"
01200  PRINT ""
01210  FOR I = 20 TO 7 STEP  - 1
01220  IF P1( I ) <> Z0 AND S2 > INT( 13 * RND ) + 7 THEN GOTO 1260
01230  NEXT I
01240  S2 = S2 + 1
01250  GOTO 1440
01260  PRINT "The shadow leaps out of the darkness."
01270  PRINT ""
01280  PRINT "'Har har', cries a bearded pirate, 'me thinks me will take a littlle of"
01290  PRINT "yur booty!'"
01300  PRINT ""
01310  IF I <> 20 THEN GOTO 1340
01320  C$ = P$
01330  GOTO 1350
01340  C$ = T$( I )
01350  GOSUB 10890
01360  PRINT "That "; L$; " will do just fine!"
01370  PRINT ""
01380  PRINT "With that he scurries off to his treasure cave!!!!"
01390  PRINT ""
01400  P1( I ) = Z0
01410  T( I ) = 33
01420  N2 = A0
01430  P3 = P3 - 1
01440  RETURN
01450  REM      **********  Dwarf.
01460  PRINT ""
01470  IF D2 <> Z0 THEN GOTO 1530
01480  PRINT "An angry dwarf came in, threw a little axe which missed, cursed and ran"
01490  PRINT "away!"
01500  T( 11 ) = Z1
01510  D2 = A0
01520  GOTO 4360
01530  IF D2 <> Z0 THEN D3 = D3 + 2
01540  D4 = A0
01550  PRINT "There's an angry dwarf in the room with you!  He throws a single knife"
01560  PRINT ""
01570  IF INT( D3 * RND ) > 4 THEN GOTO 1600
01580  PRINT "It misses!"
01590  GOTO 4360
01600  PRINT "It hits you!"
01610  K1 = K1 + 1
01620  IF K1 = 2 THEN  GOTO 10120
01630  GOTO 4360
01640  REM      **********  Display things.
01650  PRINT ""
01660  IF T( 1 ) = Z1 THEN PRINT "There's a set of keys here!"
01670  IF T( 2 ) = Z1 THEN PRINT "A lantern rests here!"
01680  IF T( 3 ) = Z1 THEN PRINT "There is tasty food here!"
01690  IF T( 4 ) = Z1 THEN PRINT "A small bottle is lying here!"
01700  IF T( 5 ) = Z1 THEN PRINT "There is much water here!"
01710  IF T( 6 ) = Z1 THEN PRINT "A small pool of oil is here!"
01720  IF T( 7 ) = Z1 THEN PRINT "A useful hemp rope is coiled here!"
01730  IF T( 8 ) = Z1 THEN PRINT "There is an ancient book on the ground!"
01740  IF T( 9 ) = Z1 THEN PRINT "There is a tiny marble statue in the corner."
01750  IF T( 10 ) = Z1 THEN PRINT "There is a persian carpet lying on the ground
01760  IF T( 11 ) = Z1 AND N3 = Z0 THEN PRINT "A little axe is here!"
01770  IF T( 12 ) = Z1 THEN PRINT "A golden sword lies here!"
01780  IF T( 13 ) = Z1 THEN PRINT "A magic wand floats in mid air!"
01790  IF T( 14 ) = Z1 THEN PRINT "Seven bars of silver lie here!"
01800  IF T( 15 ) = Z1 THEN PRINT "Many diamonds are scattered here!"
01810  IF T( 16 ) = Z1 THEN PRINT "A pea-sized emerald falls to the floor!"
01820  IF T( 17 ) = Z1 THEN PRINT "There's a king's crown here!"
01830  IF T( 18 ) = Z1 THEN PRINT "There's a pirate's treasure chest here!"
01840  IF P1( 20 ) = Z0 THEN GOTO 1870
01850  PRINT "The "; P$; " is still by your side."
01860  GOTO 1880
01870  IF T( 20 ) = Z1 THEN PRINT "A "; P$; " patiently waits here!"
01880  L1 = A0
01890  GOTO 4430
01900  REM      **********  Display scenes.
01910  PRINT "You are inside a building, a safe place to store treasures."
01920  GOTO 8320
01930  PRINT "You are on a very nicely groomed path."
01940  GOTO 8320
01950  PRINT "You are in the forest."
01960  IF Z1 <> 15 THEN GOTO 8320
01970  IF B2 <> Z0 THEN GOTO 2020
01980  PRINT ""
01990  PRINT "A black knight in full iron armour is standing before you."
02000  PRINT "He is carrying a golden sword."
02010  GOTO 8320
02020  PRINT "An iron statue of a black knight stands in front of you."
02030  GOTO 8320
02040  PRINT "You are in a dried up stream bed of a once great river."
02050  GOTO 8320
02060  PRINT "You are at the bottom of a climbable pit.  A small stream flows across"
02070  PRINT "the floor of the pit."
02080  GOTO 8320
02090  PRINT "You are in a beautiful forest carrying the sounds of many animals"
02100  GOTO 8320
02110  PRINT "You are at the entrance of a small cave.  A 3x3 iron grate keeps you"
02120  PRINT "from going down to where it looks like the cave opens up."
02130  GOTO 8320
02140  PRINT "You are inside the cave entrance.  It is a good sized passage and  easy"
02150  PRINT "to walk in."
02160  GOTO 8320
02170  PRINT "You are at the edge of a pit.  You can climb down but you might not be"
02180  PRINT "able to climb back up again."
02190  GOTO 8320
02200  PRINT "You are in an old mine shaft that extends vertically in both directions"
02210  GOTO 8320
02220  PRINT "You are standing beside a large sign flashing '"; M$; "'!"
02230  S3 = A0
02240  GOTO 8320
02250  PRINT "You are traveling in a east-west tunnel."
02260  GOTO 8320
02270  PRINT "You are walking in a east-west corridor."
02280  GOTO 8320
02290  PRINT "You're in a large north-south passage."
02300  GOTO 8320
02310  PRINT "You are in a small north-south cave."
02320  GOTO 8320
02330  PRINT "You are in a room that connects to an alternate passage."
02340  GOTO 8320
02350  PRINT "You are at an intersection of three corridors."
02360  GOTO 8320
02370  PRINT "You are at the brink of an easily climbable pit."
02380  GOTO 8320
02390  PRINT "You are at the bottom of a narrow shaft.  You could climb up but not"
02400  PRINT "back down."
02410  GOTO 8320
02420  PRINT "You're in an enormous chamber of solid granite.  Exits lead in many"
02430  PRINT "directions."
02440  GOTO 8320
02450  PRINT "You're in a cave of many exits."
02460  GOTO 8320
02470  PRINT "You're in a beautiful cavern.  In the center of the cavern is a huge"
02480  PRINT "hole.  I think I hear the sound of water?"
02490  GOTO 8320
02500  S$ = "a small crack"
02510  IF INT( 99 * RND ) > 50 THEN S$ = "a narrow tunnel"
02520  PRINT "You climb thru "; S$; " only to find that........"
02530  PRINT ""
02540  Z1 = Z1 - 7
02550  GOTO 4360
02560  PRINT "You are in a spendid chamber decorated with strands of multi-coloured"
02570  PRINT "thread."
02580  GOTO 8320
02590  Z1 = Z1 - 5
02600  GOTO 4180
02610  S$ = "little, twisty"
02620  IF INT( 99 * RND ) > 50 THEN S$ = "twisty, litle"
02630  PRINT "You are in a "; S$; " maze!"
02640  GOTO 8320
02650  PRINT "You are at a complex junction of three forks.  Obvious paths lead  east"
02660  print "and west."
02670  GOTO 8320
02680  PRINT "You are at the dragon's lair.  His job is to protect the magic castle"
02690  PRINT "which lies to the south.  ";
02700  S$ = "refuses to let you enter."
02710  IF D5 <> Z0 THEN S$ = "lies dead off to one side."
02720  PRINT "The dragon "; S$
02730  GOTO 8320
02740  PRINT "You're in a small stone chamber of the magic castle."
02750  PRINT ""
02760  IF F1 <> Z0 THEN GOTO 8320
02770  PRINT "A small green frog happily hops to and fro across the floor of the"
02780  PRINT "chamber!"
02790  GOTO 8320
02800  PRINT "You are standing on one side of a large moat that surrounds the castle"
02810  PRINT "You cannot jump or swim across."
02820  PRINT ""
02830  IF B1 <> Z0 THEN PRINT "The drawbridge is lowered to cross."
02840  GOTO 8320
02850  PRINT "You are in the west hall of the magic castle.  Your footsteps echo"
02860  PRINT "endlessly."
02870  GOTO 8320
02880  PRINT "You're in the eastern hall of the magic castle."
02890  GOTO 8320
02900  PRINT "You are in a room where a bed is made from twelve matresses."
02910  IF P1( 17 ) <> Z0 THEN D1( 99 ) = 0010
02920  GOTO 8320
02930  PRINT "Shhhh....you are in the king's chamber.  I think he's asleep."
02940  GOTO 8320
02950  PRINT "The floor you were standing on has given way...you fall..and fall...and"
02960  PRINT "fall.....finally landing on solid ground................."
02970  Z1 = Z1 + 50
02980  GOTO 4180
02990  PRINT "Welcome to the magic castle.  Although our ruler( King Dumb ) is stupid"
03000  PRINT "I hope you enjoy your visit."
03010  GOTO 8320
03020  PRINT "You are in the castle dungeons."
03030  GOTO 8320
03040  IF C2$ <> P$ THEN GOTO 3060
03050  IF P1( 20 ) <> Z0 OR T( 20 ) = Z1 THEN GOTO 3100
03060  IF T2 <> Z0 THEN GOTO 6650
03070  IF T2 <> Z0 THEN GOTO 6650
03080  IF Z1 <> 93 AND Z1 <> 91 THEN GOTO 7880
03090  IF C2$ <> "Frog" AND C2$ <> P$ THEN GOTO 7840
03100  IF C2$ = "Frog" THEN GOTO 3220
03110  IF T( 20 ) <> Z1 THEN GOTO 7880
03120  PRINT "The "; P$; " disappears in a puff of blue smoke............."
03130  PRINT ""
03140  PRINT "A small green frog leaps from the smoke and hurriedly hops off into"
03150  PRINT "the murky darkness of the chamber!"
03160  PRINT ""
03170  F1 = Z0
03180  T( 20 ) = Z0
03190  P1( 20 ) = Z0
03200  F3 = A0
03210  GOTO 4410
03220  IF F3 <> Z0 THEN GOTO 6650
03230  PRINT "The room is filled with blue smoke and when the smoke clears......"
03240  PRINT ""
03250  F1 = A0
03260  T( 20 ) = Z1
03270  GOTO 1650
03280  PRINT "The "; P$; " refuses to go by force!"
03290  GOTO 4410
03300  PRINT "The "; P$; " accepts your offer and will walk by your side!"
03310  P1( 20 ) = A0
03320  T( 20 ) = Z0
03330  GOTO 4410
03340  P1( 20 ) = Z0
03350  T( 20 ) = Z1
03360  L1 = Z0
03370  GOTO 1650
03380  PRINT "They are too heavy to carry!"
03390  GOTO 4410
03400  REM      **********  Help.
03410  H1 = H1 + 1
03420  IF H1 < INT( H1 * RND ) + H1 OR H1 < 2 AND P1( 2 ) <> Z0 THEN GOTO 3460
03430  PRINT "The wizard says, 'Quit bothering me!'."
03440  IF H1 > 2 THEN GOTO 3560
03450  GOTO 4410
03460  IF N1 = A0 AND H1 < 4 THEN GOTO 3480
03470  GOTO 7720
03480  PRINT ""
03490  PRINT "The wizard of 'ADVENTURE' will light your way for 25 moves!"
03500  N1 = Z0
03510  L3 = A0
03520  O1 = O1 + 25
03530  V1 = 225
03540  L1 = Z0
03550  GOTO 4180
03560  PRINT ""
03570  PRINT "'I, the wizard of 'ADVENTURE', have given you enough warnings!!'"
03580  PRINT ""
03590  PRINT "Now you will suffer this fate....."
03600  PRINT ""
03610  PRINT "The wizard turns you into stone!!!!"
03620  P2 = P2 + 1
03630  PRINT ""
03640  IF P2 > 1 THEN GOTO 10460
03650  GOTO 10120
03660  REM      **********  Some events.
03670  IF D4 <> Z0 OR  Z1 = 91 OR  Z1 = 93 OR P1( 20 ) <> Z0 OR  Z1 = 87 OR C2$ = "Myself" OR C2$ = "Me" OR C2$ = "Knight" THEN GOTO 3710
03680  IF T2 <> Z0 THEN GOTO 7840
03690  GOTO 7880
03700  REM      **********  The P$.
03710  IF C2$ = "Me" OR C2$ = "Myself" THEN GOTO 3740
03720  PRINT "With what?  Your bare hands?"
03730  GOTO 4410
03740  PRINT "Are you sure that you want me to put an end to your miserable life!"
03750  PRINT ""
03760  PRINT "Well";
03770  GOSUB 11290
03780  IF LEFT$( C1$, 1 ) = "Y" OR LEFT$( C1$, 1 ) = "N" THEN GOTO 3830
03790  PRINT ""
03800  PRINT "Please answer ( Yes or No ) !!!!!"
03810  PRINT ""
03820  GOTO 3740
03830  IF LEFT$( C1$, 1 ) = "Y" THEN GOTO 10120
03840  PRINT "Ok!"
03850  GOTO 4360
03860  IF Z1 <> 91 AND Z1 <> 93 THEN GOTO 7880
03870  PRINT "The frog hops just out of your reach. It seems impossible to catch him"
03880  GOTO 4410
03890  IF D5 <> Z0 THEN GOTO 6390
03900  IF P1( 11 ) = Z0 THEN GOTO 9600
03910  PRINT "The dragon dodges out of the way and promptly sits upon the axe where"
03920  PRINT "you cannot get it!"
03930  N3 = A0
03940  P1( 11 ) = Z0
03950  T( 11 ) = 87
03960  P3 = P3 - 1
03970  GOTO 4410
03980  PRINT "The dragon is sitting on it!"
03990  GOTO 4410
04000  IF P1( 12 ) <> Z0 THEN GOTO 4030
04010  PRINT "You have nothing that can kill it!"
04020  GOTO 4410
04030  PRINT "The golden sword strikes home!"
04040  N3 = Z0
04050  L1 = Z0
04060  D1( 87 ) = 0015
04070  D5 = A0
04080  GOTO 4180
04090  PRINT "The water quickly rusts the armor and turns the knight into an "
04100  PRINT "iron statue.  He drops the golden sword."
04110  P1( 5 ) = Z0
04120  T( 12 ) = 15
04130  P3 = P3 - 1
04140  B2 = A0
04150  L1 = Z0
04160  GOTO 1650
04170  REM      **********  Check light.
04180  IF INT( 99 * RND ) > 92 AND Z1 > 25 THEN GOTO 1460
04190  IF V1 > 200 AND L4 = Z0 THEN GOTO 4330
04200  IF V1 > 250 AND N1 = Z0 THEN GOTO 4220
04210  GOTO 4250
04220  PRINT ""
04230  PRINT "Your lantern has run out of fuel!"
04240  N1 = A0
04250  IF N1 = Z0 THEN GOTO 4270
04260  L3 = Z0
04270  IF M1( Z1 ) <> 3 AND Z1 < 25 THEN GOTO 4360
04280  IF L3 <> Z0 THEN GOTO 4360
04290  PRINT ""
04300  PRINT "It is pitch dark!  If you proceed you will most likely fall into a pit"
04310  IF INT( 99 * RND ) > 85 THEN GOTO 10080
04320  GOTO 4410
04330  PRINT ""
04340  PRINT "Your lantern is getting very dim!  I would look for a source of oil"
04350  L4 = A0
04360  PRINT ""
04370  IF M1( Z1 ) > 20 THEN GOTO 4390
04380  ON M1( Z1 ) GOTO 1910,1930,1950,2040,2060,2090,2110,2140,2170,2200,2220,2250,2270,2290,2310,2330,2350,2370,2390,2420
04390  ON M1( Z1 ) - 20 GOTO 2450,2470,2500,2560,2590,2610,2650,2680,2740,2800,2850,2880,2900,2930,2950,2990,3020
04400  REM      **********  Input next command.
04410  IF L1 <> Z0 THEN GOTO 4430
04420  IF Z1 = 3 OR L3 <> Z0 THEN GOTO 1650
04430  PRINT ""
04440  PRINT "What is your command";
04450  GOSUB 11290
04460  IF C1$ = "" THEN GOTO 7640
04470  REM      **********  Make the next move.
04480  V1 = V1 + 1
04490  IF P1( 20 ) <> Z0 THEN T( 20 ) = Z1
04500  N = Z0
04510  E = Z0
04520  S = Z0
04530  W = Z0
04540  U = Z0
04550  D = Z0
04560  IF LEN( C1$ ) > 1 THEN GOTO 4920
04570  REM      **********  Check for directional move.
04580  IF LEFT$( C1$, 1 ) <> "N" THEN GOTO 4620
04590  Z2 = Z1 - 5
04600  N = 1
04610  GOTO 4820
04620  IF LEFT$( C1$, 1 ) <> "E" THEN GOTO 4660
04630  Z2 = Z1 + 1
04640  E = 1
04650  GOTO 4820
04660  IF LEFT$( C1$, 1 ) <> "S" THEN GOTO 4700
04670  Z2 = Z1 + 5
04680  S = 1
04690  GOTO 4820
04700  IF LEFT$( C1$, 1 ) <> "W" THEN GOTO 4740
04710  Z2 = Z1 - 1
04720  W = 1
04730  GOTO 4820
04740  IF LEFT$( C1$, 1 ) <> "U" THEN GOTO 4780
04750  Z2 = Z1 - 25
04760  U = 1
04770  GOTO 4820
04780  IF LEFT$( C1$, 1 ) <> "D" THEN GOTO 4920
04790  Z2 = Z1 + 25
04800  D = 1
04810  GOTO 4820
04820  IF Z2 < 1 OR Z2 > 200 GOTO 7740
04830  N0 = ( D1( Z1 ) - INT( D1( Z1 ) / 100 ) * 100 )
04840  GOSUB 11660
04850  IF LEFT$( C1$, 1 ) <> "D" THEN GOTO 7950
04860  FOR I = 1 TO 2
04870  IF M3( I ) = Z1 THEN GOTO 4900
04880  NEXT I
04890  GOTO 7950
04900  PRINT "It is locked!"
04910  GOTO 4410
04920  IF C1$ <> "Walk" AND C1$ <> "Crawl" AND C1$ <> "Jump" AND C1$ <> "Run" THEN GOTO 4990
04930  IF LEN( C2$ ) <> Z0 THEN GOTO 4960
04940  PRINT C1$; " where";
04950  GOSUB 11440
04960  IF C2$ <> "North" AND C2$ <> "East" AND C2$ <> "South" AND C2$ <> "West" AND C2$ <> "Up" AND C2$ <> "Down" THEN GOTO 7840
04970  C1$ = C2$
04980  GOTO 4580
04990  IF C1$ = "North" OR C1$ = "South" OR C1$ = "East" OR C1$ = "West" OR C1$ = "Down" OR C1$ = "Up" THEN GOTO 4580
05000  REM      **********  Interpret non-directional commands.
05010  GOSUB 11540
05020  IF C1$ <> "Look" THEN GOTO 5060
05030  L1 = Z0
05040  PRINT "I'm not allowed to give more detail!"
05050  GOTO 4180
05060  IF C1$ <> "Exit" AND C1$ <> "Enter" THEN GOTO 5180
05070  IF Z1 = 3 OR  Z1 = 8 THEN GOTO 5090
05080  GOTO 7780
05090  IF Z1 = 8 THEN GOTO 5130
05100  IF C1$ <> "Exit" THEN GOTO 7740
05110  Z1 = 8
05120  GOTO 4180
05130  IF C1$ <> "Enter" THEN GOTO 7740
05140  Z1 = 3
05150  PRINT "You walk thru a wooden door....."
05160  GOTO 4180
05170  GOTO 7740
05180  IF C1$ = "Inven" OR C1$ = "Inventory" THEN GOTO 8950
05190  IF C1$ = "Get" THEN GOTO 9110
05200  IF C1$ <> "Light" AND C1$ <> "Lite" THEN GOTO 5340
05210  IF N1 <> Z0 THEN GOTO 5240
05220  IF LEN( C2$ ) <> Z0 THEN GOTO 5270
05230  GOTO 7640
05240  IF N1 = Z0 THEN GOTO 5270
05250  PRINT "Your lantern is out of oil!"
05260  GOTO 4180
05270  IF C2$ <> "Lantern" THEN GOTO 7840
05280  IF P1( 2 ) = Z0 THEN GOTO 5320
05290  L3 = A0
05300  PRINT "Your lantern is lit!"
05310  GOTO 4180
05320  PRINT "You don't have a lantern!"
05330  GOTO 4410
05340  IF C1$ <> "Quit" AND C2$ <> "Quit" THEN GOTO 5460
05350  PRINT ""
05360  PRINT "Do you really want to quit";
05370  GOSUB 11290
05380  IF LEFT$( C1$, 1 ) = "Y" OR LEFT$( C1$, 1 ) = "N" THEN GOTO 5440
05390  PRINT "Answer the question!!!( Yes or No )"
05400  PRINT ""
05410  PRINT ""
05420  PRINT "Do you want to quit?";
05430  GOTO 5370
05440  IF LEFT$( C1$, 1 ) = "Y" THEN GOTO 10460
05450  GOTO 4180
05460  IF C1$ = "Drop" THEN GOTO 9600
05470  IF C1$ <> "Say" THEN GOTO 5530
05480  IF S3 <> Z0 THEN GOTO 9930
05490  IF LEN( C2$ ) = Z0 THEN GOTO 9070
05500  PRINT ""
05510  PRINT "Okay, '"; C2$; "'!"
05520  GOTO 4410
05530  IF C1$ <> "Open" AND C1$ <> "Unlock" THEN GOTO 5760
05540  IF C2$ <> "Sesame" THEN GOTO 5660
05550  IF O2 <> Z0 THEN GOTO 5610
05560  O2 = A0
05570  FOR I = 1 TO 200
05580  D2( I ) = D1( I )
05590  NEXT I
05600  GOTO 4410
05610  O2 = Z0
05620  FOR I = 1 TO 200
05630  D1( I ) = D2( I )
05640  NEXT I
05650  GOTO 4410
05660  IF P1( 1 ) <> Z0 THEN GOTO 5690
05670  PRINT "You have no keys!"
05680  GOTO 4410
05690  FOR I = 1 TO 2
05700  IF Z1 = M3( I ) THEN GOTO 5730
05710  NEXT I
05720  GOTO 7780
05730  M3( I ) = Z0
05740  PRINT "The keys have "; L1$; "ed it!"
05750  GOTO 4410
05760  IF C1$ <> "Abracadbra" THEN GOTO 5900
05770  IF A1 <> Z0 THEN GOTO 5860
05780  A1 = A0
05790  T0 = 20
05800  GOTO 4410
05810  A1 = Z0
05820  T0 = 6
05830  FOR I = 20 TO 3 STEP -1
05840  IF P3 <= T0 THEN GOTO 4410
05850  IF P1( I ) = Z0 THEN GOTO 5880
05860  P1( I ) = 0
05870  T( I ) = INT( 100 * RND ) + 1
05880  NEXT I
05890  GOTO 4410
05900  IF C1$ <> "*scan" AND C1$ <> "*s" THEN GOTO 6060
05910  IF C2$ <> "Thing" AND C2$ <> "T" THEN GOTO 6000
05920  PRINT ""
05930  PRINT ""
05940  PRINT "Locations of Things you are not holding."
05950  PRINT ""
05960  FOR I = 1 TO 20
05970  IF P1( I ) = Z0 THEN PRINT I, T$( I ), T( I )
05980  NEXT I
05990  GOTO 4410
06000  IF C2$ <> "Location" AND C2$ <> "Loc" THEN GOTO 7640
06010  PRINT ""
06020  PRINT ""
06030  PRINT "Maze position is "; Z1, "Location descriptor is "; M1( Z1 )
06040  PRINT ""
06050  GOTO 4410
06060  IF C1$ <> "*goto" AND C1$ <> "*g" THEN GOTO 6120
06070  IF LEN( C2$ ) = Z0 THEN GOTO 9070
06080  L1 = Z0
06090  X = VAL( C2$ )
06100  IF X > 0 AND X <= 200 THEN Z1 = X
06110  GOTO 4180
06120  IF C1$ <> "Drink" THEN GOTO 6210
06130  IF LEN( C2$ ) = Z0 THEN GOTO 9070
06140  IF T1 = Z0 THEN GOTO 7640
06150  IF C2$ <> "Water" THEN GOTO 7900
06160  IF P1( 5 ) = 0 THEN GOTO 7920
06170  PRINT "Your water is gone!"
06180  P1( 5 ) = Z0
06190  P3 = P3 - 1
06200  GOTO 4410
06210  IF C1$ <> "Eat" THEN GOTO 6320
06220  IF LEN( C2$ ) = Z0 THEN GOTO 9070
06230  IF T1 = Z0 THEN GOTO 7640
06240  IF T3 = Z0 THEN GOTO 7800
06250  IF I < 3 THEN GOTO 7900
06260  PRINT "Thanks, don't mind if I do!"
06270  PRINT ""
06280  PRINT "Your "; L2$; " was very tasty!"
06290  P1( I ) = Z0
06300  P3 = P3 - 1
06310  GOTO 4410
06320  IF C1$ <> "Throw" THEN GOTO 6530
06330  IF C2$ <> "Axe" THEN GOTO 9600
06340  IF Z1 = 87 THEN GOTO 3890
06350  IF P1( 11 ) <> Z0 THEN GOTO 6390
06360  GOTO 9600
06370  PRINT "There's nothing here to attack!"
06380  GOTO 4410
06390  IF Z1 = 15 THEN GOTO 9600
06400  IF D4 = Z0 THEN GOTO 6370
06410  P1( 11 ) = Z0
06420  T( 11 ) = Z1
06430  P3 = P3 - 1
06440  S$ = "You missed!"
06450  IF INT( 99 * RND ) > 70 THEN GOTO 6470
06460  S$ = "You killed a little dwarf.  His body vanishes in a *POOF* of pink smoke!"
06470  PRINT S$
06480  D3 = INT( 3 * RND ) + 1
06490  L1 = Z0
06500  PRINT ""
06510  D4 = Z0
06520  GOTO 4180
06530  IF C1$ <> "Wave" AND C1$ <> "Shake" THEN GOTO 6680
06540  IF P1( 13 ) = Z0 OR  Z1 <> 92 OR C2$ <> "Wand" THEN GOTO 6580
06550  B1 = A0
06560  D1( 92 ) = 0005
06570  GOTO 4360
06580  IF T2 <> Z0 THEN GOTO 6650
06590  GOTO 7800
06600  D4 = Z0
06610  D3 = INT( 2 * RND ) + 1
06620  PRINT "The angry little dwarf sees the anger in the way that you "; L1$
06630  PRINT "your axe and promptly heads for the nearest exit."
06640  GOTO 4410
06650  IF D4 <> Z0  AND C2$ = "Axe" THEN GOTO 6600
06660  PRINT "Nothing happens!"
06670  GOTO 4410
06680  IF C1$ <> "Pay" THEN GOTO 6790
06690  IF P1( 15 ) <> Z0 THEN GOTO 6720
06700  PRINT "No money.. no book!"
06710  GOTO 4410
06720  IF Z1 <> 170 THEN GOTO 7640
06730  PRINT "Thank you sir.  I hope you enjoy it!"
06740  P1( 8 ) = A0
06750  T( 8 ) = Z0
06760  P3 = P3 + 1
06770  F2 = A0
06780  GOTO 4410
06790  IF C1$ <> "Give" THEN GOTO 6890
06800  IF P1( 5 ) <> Z0 AND Z1 = 145 AND C2$ = "Water" THEN GOTO 6840
06810  IF P1( 5 ) = Z0 THEN GOTO 9600
06820  GOTO 4410
06830  PRINT "Who are you going to give it to?"
06840  PRINT "The old man drinks the water and walks off into the darkness!"
06850  P1( 5 ) = Z0
06860  P3 = P3 - 1
06870  M1( 145 ) = 28
06880  GOTO 4180
06890  IF C1$ <> "Wet" THEN GOTO 7010
06900  IF P1( 5 ) <> Z0 THEN GOTO 6930
06910  PRINT "With what?  Spit? Sweat?"
06920  GOTO 7840
06930  IF Z1 <> 157 THEN GOTO 7640
06940  PRINT "You slip and slide into........"
06950  PRINT ""
06960  P1( 5 ) = Z0
06970  D1( 157 ) = 0010
06980  P3 = P3 - 1
06990  Z1 = 159
07000  GOTO 4180
07010  D4 = Z0
07020  IF C1$ <> "Read" OR P1( 8 ) = Z0 THEN GOTO 7060
07030  IF C2$ <> "Book" THEN GOTO 7840
07040  PRINT "The book reads, 'say magic word in the 'not same' maze!"
07050  GOTO 4410
07060  IF C1$ = "Kill" THEN GOTO 3670
07070  IF C1$ <> "With" THEN GOTO 7120
07080  IF C2$ <> "Axe" THEN GOTO 7840
07090  C1$ = "Throw"
07100  C2$ = "Axe"
07110  GOTO 6320
07120  IF C1$ <> M$ THEN GOTO 7160
07130  C2$ = M$
07140  C1$ = "Say"
07150  GOTO 5470
07160  IF C1$ <> "Why" THEN GOTO 7190
07170  PRINT "Because I said so!  That's why!!!!"
07180  GOTO 4410
07190  IF C1$ <> "You" AND C1$ <> "Your" AND C2$ <> "You" THEN GOTO 7220
07200  PRINT "If you don't like playing the game you can always 'Quit'!"
07210  GOTO 4410
07220  IF C1$ <> "Find" THEN GOTO 7250
07230  PRINT "I cannot tell you where remote things are located!"
07240  GOTO 4410
07250  IF C1$ = "Slay" AND C2$ = "Dragon" THEN GOTO 4000
07260  IF C1$ <> "Yes" THEN GOTO 7300
07270  IF Z1 = 15 OR  Z1 = 87 OR D4 <> Z0  THEN GOTO 7840
07280  PRINT "You seem unsure of that answer!"
07290  GOTO 4410
07300  IF C1$ <> "Lift" THEN GOTO 7370
07310  IF LEN( C2$ ) = Z0 THEN GOTO 9070
07320  IF T2 = Z0 AND Z1 <> 99 THEN GOTO 7880
07330  IF C2$ <> "Matress" AND C2$ <> "Matresses" THEN GOTO 6650
07340  T( 16 ) = A0
07350  L1 = Z0
07360  GOTO 1650
07370  IF C1$ = "Kiss" THEN GOTO 3040
07380  IF C1$ = "Please" AND T( 20 ) = Z1 THEN GOTO 3300
07390  IF C1$ = "Wait" AND P1( 20 ) <> Z0 THEN GOTO 3340
07400  IF C1$ = "Help" THEN GOTO 3410
07410  IF C1$ <> "Listen" THEN GOTO 7440
07420  PRINT "Slosh..boil..drip..spurt..squirt......"
07430  GOTO 4410
07440  IF C1$ <> "Where" THEN GOTO 7470
07450  PRINT "I'm not really sure which way you're facing.  Try a compass heading."
07460  GOTO 4410
07470  IF C1$ <> "What" AND C1$ <> "Who" AND C1$ <> "When" AND C1$ <> "How" THEN GOTO 7500
07480  PRINT "I refuse to answer on the grounds that it might incriminate me!"
07490  GOTO 4410
07500  IF LEFT$( C1$, 1 ) <> "N" THEN GOTO 7530
07510  PRINT "Why must you always be so negative?"
07520  GOTO 4410
07530  IF C1$ <> "Cause" AND C1$ <> "Because" THEN GOTO 7560
07540  PRINT "That answer stinks!"
07550  GOTO 4410
07560  IF C2$ = "" THEN Q = A0
07570  C2$ = C1$
07580  IF T2 = Z0 THEN GOTO 7720
07590  REM      **********  Some miscelaneous messages.
07600  PRINT "What do you want to do with the "; L2$; "?"
07610  GOTO 4410
07620  PRINT "You can't "; L1$; " "; L2$; "!"
07630  GOTO 4410
07640  S$ = "I don't understand what you mean!"
07650  IF INT( 99 * RND ) > 50 THEN S$ = "What???"
07660  IF Q = Z0 THEN GOTO 7700
07670  PRINT "I'm not yet familiar with that word!"
07680  Q = Z0
07690  GOTO 4410
07700  PRINT S$
07710  GOTO 4410
07720  PRINT "Nothing happens!"
07730  GOTO 4410
07740  S$ = "You do not seem to know where you're going!"
07750  IF RND > 0.5 THEN S$ = "You can't go that way!"
07760  PRINT S$
07770  GOTO 4410
07780  PRINT "There's nothing here to "; L1$; "!"
07790  GOTO 4410
07800  PRINT "You don't have that to "; L1$; "!"
07810  GOTO 4410
07820  PRINT "You are already holding the "; L2$; "!"
07830  GOTO 4410
07840  PRINT "C'mon, can't you be serious?"
07850  GOTO 4410
07860  PRINT "You have nothing to "; L1$; "!"
07870  GOTO 4410
07880  PRINT "I see no "; L2$; " here!"
07890  GOTO 4410
07900  PRINT "I'm game.  Would you care to explain how?"
07910  GOTO 4410
07920  PRINT "You have to get it first!"
07930  GOTO 4410
07940  REM      **********  Process directional moves.
07950  IF M1( Z1 ) <> 6 THEN GOTO 8170
07960  IF N = Z0 THEN GOTO 8010
07970  N = Z0
07980  E = 1
07990  Z2 = Z1 + 1
08000  GOTO 8180
08010  IF E = Z0 THEN GOTO 8060
08020  E = Z0
08030  S = 1
08040  Z2 = Z1 + 5
08050  GOTO 8190
08060  IF S = Z0 THEN GOTO 8110
08070  S = Z0
08080  W = 1
08090  Z2 = Z1 - 1
08100  GOTO 8200
08110  IF W = Z0 THEN GOTO 8170
08120  W = Z0
08130  N = 1
08140  Z2 = Z1 - 5
08150  GOTO 8170
08160  REM      **********  Check allowed directions.
08170  IF N = 1 AND D( 1 ) = 1 THEN GOTO 8280
08180  IF E = 1 AND D( 2 ) = 1 THEN GOTO 8280
08190  IF S = 1 AND D( 3 ) = 1 THEN GOTO 8280
08200  IF W = 1 AND D( 4 ) = 1 THEN GOTO 8280
08210  IF U = 1 AND D( 5 ) = 1 THEN GOTO 8280
08220  IF D = 1 AND D( 6 ) = 1 THEN GOTO 8280
08230  PRINT ""
08240  IF Z1 = 87 THEN GOTO 8260
08250  GOTO 7740
08260  S$ = "refuses to let you pass!"
08270  GOTO 2720
08280  Z1 = Z2
08290  L1 = Z0
08300  GOTO 4180
08310  REM      **********  Look around at nearby scenes.
08320  N = Z0
08330  E = Z0
08340  S = Z0
08350  W = Z0
08360  U = Z0
08370  D = Z0
08380  IF V1 > 50 +  INT( 50 * RND ) THEN  GOSUB 1140
08390  N0 = INT( D1( Z1 ) / 100 )
08400  GOSUB 11660
08410  N = D( 1 )
08420  E = D( 2 )
08430  S = D( 3 )
08440  W = D( 4 )
08450  U = D( 5 )
08460  D = D( 6 )
08470  IF N = Z0 THEN GOTO 8520
08480  L2 = Z1 - 5
08490  N = Z0
08500  PRINT "To the north is ";
08510  GOTO 8770
08520  IF E = Z0 THEN GOTO 8570
08530  L2 = Z1 + 1
08540  E = Z0
08550  PRINT "Along the east is ";
08560  GOTO 8770
08570  IF S = Z0 THEN GOTO 8620
08580  L2 = Z1 + 5
08590  S = Z0
08600  PRINT "Looking south is ";
08610  GOTO 8770
08620  IF W = Z0 THEN GOTO 8680
08630  L2 = Z1 - 1
08640  W = Z0
08650  PRINT "Appearing westerly is ";
08660  GOTO 8770
08670  D1( I ) = 0063
08680  IF U = Z0 THEN GOTO 8720
08690  L2 = Z1 - 25
08700  U = Z0
08710  GOTO 8770
08720  IF D = Z0 THEN GOTO 8760
08730  L2 = Z1 + 25
08740  D = Z0
08750  GOTO 8770
08760  GOTO 4410
08770  ON M1( L2 ) GOTO 8780, 8800, 2020, 8820, 8470, 8840, 8860, 8890
08780  PRINT "a small building."
08790  GOTO 8470
08800  PRINT "a shallow valley."
08810  GOTO 8470
08820  PRINT "a river bed"
08830  GOTO 8470
08840  PRINT "a beautiful forest."
08850  GOTO 8470
08860  PRINT ""
08870  PRINT "A cobble path leads up to the surface."
08880  GOTO 8470
08890  PRINT ""
08900  PRINT "A cobble path leads down into the cave."
08910  PRINT ""
08920  IF M3( 1 ) = Z0 THEN PRINT "The grate is open."
08930  GOTO 8470
08940  REM      **********  Perform inventory.
08950  PRINT ""
08960  PRINT "You are holding the following items:"
08970  PRINT ""
08980  X = Z0
08990  FOR I = 1 TO 19
09000  IF P1( I ) = Z0 THEN  9030
09010  PRINT T$( I )
09020  X = A0
09030  NEXT I
09040  IF X = Z0 THEN PRINT "Nothing!"
09050  GOTO 4410
09060  REM      **********  Ask for C2$.
09070  PRINT C1$; " what";
09080  GOSUB 11440
09090  GOTO 5010
09100  REM      **********  Perform 'Get' and 'Drop'.
09110  IF P3 <> T0 THEN GOTO 9140
09120  PRINT "You can't carry anything more.  You'll have to drop something first!"
09130  GOTO 4410
09140  IF LEN( C2$ ) = Z0 THEN GOTO 9070
09150  IF T3 = A0 THEN GOTO 7820
09160  IF T2 <> Z0 THEN GOTO 9220
09170  IF C2$ = "Water" AND Z1 = 59 THEN GOTO 9220
09180  IF C2$ = "Frog" THEN GOTO 3860
09190  IF T( 20 ) = Z1 THEN GOTO 3280
09200  IF C2$ = "Matress" OR C2$ = "Matresses" THEN GOTO 3380
09210  GOTO 7880
09220  IF C2$ <> "Water" OR T( 5 ) <> Z1 THEN GOTO 9310
09230  IF P1( 5 ) <> Z0 THEN GOTO 9290
09240  IF P1( 4 ) = Z0 THEN GOTO 9270
09250  P1( 5 ) = A0
09260  GOTO 9560
09270  PRINT "You have nothing to carry the water in!"
09280  GOTO 4410
09290  PRINT "You can't carry any more water!"
09300  GOTO 4410
09310  IF C2$ <> "Oil" OR T( 6 ) <> Z1 THEN GOTO 9380
09320  PRINT "Your lantern is full again."
09330  T( 6 ) = Z0
09340  L4 = Z0
09350  O1 = V1
09360  V1 = 1
09370  GOTO 4410
09380  IF C2$ = "Book" AND F2 = Z0 AND Z1 = 159 THEN GOTO 12150
09390  IF C2$ <> "Book" OR T( 8 ) <> Z1 THEN GOTO 9430
09400  P1( 8 ) = A0
09410  T( 8 ) = Z0
09420  GOTO 9560
09430  IF C2$ <> "Treasure" OR T( 18 ) <> Z1 THEN GOTO 9500
09440  IF M3( 2 ) <> Z0 THEN GOTO 9480
09450  P1( 18 ) = A0
09460  T( 18 ) = Z0
09470  GOTO 9560
09480  PRINT "It's locked!"
09490  GOTO 4410
09500  IF C2$ <> "Axe" THEN GOTO 9520
09510  IF N3 <> Z0 THEN GOTO 3980
09520  P1( I ) = A0
09530  T( I ) = Z0
09540  GOTO 9560
09550  GOTO 7880
09560  PRINT "Ok!"
09570  P3 = P3 + 1
09580  GOTO 4410
09590  REM      **********  Drop things.
09600  IF P3 <> Z0 THEN GOTO 9620
09610  GOTO 7860
09620  IF LEN( C2$ ) = Z0 THEN GOTO 9070
09630  IF T3 <> Z0 THEN GOTO 9680
09640  IF C2$ = P$ THEN GOTO 3100
09650  IF T1 = Z0 THEN GOTO 7620
09660  PRINT "You are not carrying it!"
09670  GOTO 4410
09680  IF C2$ <> "Lantern" THEN GOTO 9700
09690  L3 = Z0
09700  IF C2$ <> "Bottle" THEN GOTO 9760
09710  IF P1( 5 ) = Z0 THEN GOTO 9870
09720  P1( 5 ) = Z0
09730  P3 = P3 - 1
09740  PRINT "The bottle tipped over and the water spilled out of the bottle!"
09750  GOTO 9880
09760  IF C2$ <> "Statue" THEN GOTO 9860
09770  IF T( 9 ) = Z1 THEN GOTO 9820
09780  PRINT "The statue falls and breaks worthlessly"
09790  P1( 12 ) = Z0
09800  T( 12 ) = Z0
09810  GOTO 9900
09820  IF B3 <> Z0 THEN GOTO 9780
09830  PRINT "The statue lands safely on the persian rug."
09840  B3 = A0
09850  GOTO 9880
09860  IF C1$ = "Throw" AND C2$ = "Water" AND Z1 = 15 AND B2 = Z0 THEN GOTO 4090
09870  PRINT "Ok!"
09880  P1( I ) = Z0
09890  T( I ) = Z1
09900  P3 = P3 - 1
09910  GOTO 4410
09920  REM      **********  Magic words.
09930  IF C2$ <> M$ THEN GOTO 5500
09940  IF Z1 <> 199 THEN GOTO 9980
09950  PRINT "A secret passage opens to the west!"
09960  D1( 199 ) = 0009
09970  GOTO 4410
09980  IF Z1 <> 3 THEN GOTO 10010
09990  Z1 = 41
10000  GOTO 10030
10010  IF Z1 <> 41 THEN GOTO 10040
10020  Z1 = 3
10030  L1 = Z0
10040  IF Z1 = 3 OR  Z1 = 41 THEN GOTO 4180
10050  PRINT "Nothing happens!"
10060  GOTO 4410
10070  REM      **********  The pit.
10080  PRINT ""
10090  P2 = P2 + 1
10100  PRINT "You fell into a pit and are a mass of twisted flesh and bones."
10110  PRINT ""
10120  IF P2 > 1 THEN GOTO 10160
10130  PRINT ""
10140  PRINT "I might be able to reincarnate you!  Would you like me to try?"
10150  GOTO 10220
10160  PRINT "You've really done it this time.  I'm all out of fairy dust!"
10170  PRINT ""
10180  PRINT "You don't really expect me to do a decent reincarnation without it do"
10190  PRINT "you?"
10200  K1 = Z0
10210  D3 = Z0
10220  PRINT ""
10230  PRINT "Well";
10240  IF P2 > 1 THEN GOTO 10400
10250  GOSUB 11290
10260  IF LEFT$( C1$, 1 ) = "N" THEN GOTO 10460
10270  PRINT "Ready......one.two..three!  *POOF*"
10280  P2 = P2 + 1
10290  PRINT ""
10300  PRINT "You emerge from a cloud of fairy dust only to find yourself......."
10310  L1 = Z0
10320  FOR I = 1 TO 20
10330  IF P1( I ) = Z0 THEN GOTO 10360
10340  T( I ) = Z1
10350  IF I = 2 THEN T( 2 ) = 3
10360  NEXT I
10370  Z1 = 3
10380  P3 = Z0
10390  GOTO 4360
10400  GOSUB 11290
10410  IF LEFT$( C1$, 1 ) = "N" THEN GOTO 10460
10420  PRINT ""
10430  PRINT "Ok!  If you're so smart do it yourself!!"
10440  PRINT ""
10450  REM      **********  Calculate score.
10460  P4 = Z0
10470  FOR I = 1 TO 5
10480  IF T( I ) = 3 THEN P4 = P4 + 10
10490  NEXT I
10500  FOR I = 6 TO 13
10510  IF T( I ) = 3 THEN P4 = P4 + 20
10520  NEXT I
10530  FOR I = 14 TO 19
10540  IF T( I ) = 3 THEN P4 = P4 + 30
10550  NEXT I
10560  IF T( 20 ) = 3 THEN P4 = P4 + 50
10570  IF S3 <> Z0 THEN P4 = P4 + 50
10580  IF O1 <> Z0 THEN V1 = V1 + O1
10590  P4 = P4 - INT( V1 / 10 )
10600  PRINT ""
10610  PRINT "You scored "; P4 ; " points out of a possible 350, using"; V1 ; " turns!"
10620  PRINT ""
10630  G$ = "RANK BEGINNER"
10640  IF P4 > 50 THEN G$ = "NOVICE"
10650  IF P4 > 100 THEN G$ = "EXPERIENCED"
10660  IF P4 > 150 THEN G$ = "SEASONED"
10670  IF P4 > 200 THEN G$ = "JR. MASTER"
10680  IF P4 > 250 THEN G$ = "SR. MASTER"
10690  IF P4 > 300 THEN G$ = "MASTER"
10700  IF P4 = 350 THEN G$ = "WIZARD"
10710  PRINT "Your score qualifies you as a  *** '"; G$; "' ADVENTURER ***"
10720  PRINT ""
10730  FOR I = 50 TO 350 STEP 50
10740  IF I - P4 > Z0 THEN GOTO 10760
10750  NEXT I
10760  PRINT "To achieve the next higher rating you need "; I - P4 ; " more points!"
10770  GOTO 12150
10780  REM      **********  Convert upper case to lower case.
10790  D0 = ASCII( D$ )
10800  IF D0 < 65 OR D0 > 90 THEN RETURN
10810  D$ = CHR$( D0 + 32 )
10820  RETURN
10830  REM      **********  Convert lower case to upper case.
10840  D0 = ASCII( D$ )
10850  IF D0 < 97 OR D0 > 122 THEN RETURN
10860  D$ = CHR$( D0 - 32 )
10870  RETURN
10880  REM      **********  Convert string to lower case.
10890  D$ = ""
10900  IF LEN( C$ ) = Z0 THEN GOTO 10950
10910  D$ = LEFT$( C$, 1 )
10920  GOSUB 10780
10930  IF LEN( C$ ) = 1 THEN GOTO 10950
10940  D$ = D$ + RIGHT$( C$, LEN( C$ ) - 1 )
10950  L$ = D$
10960  RETURN
10970  REM      **********  Convert to capitalized first letter.
10980  C$ = ""
10990  L = LEN( W$ )
11000  IF L = Z0 THEN RETURN
11010  D$ = LEFT$( W$, 1 )
11020  GOSUB 10830
11030  C$ = D$
11040  IF L = 1 THEN RETURN
11050  FOR I = 2 TO L
11060  D$ = MID$( W$ , I, 1 )
11070  GOSUB 10780
11080  C$ = C$ + D$
11090  NEXT I
11100  RETURN
11110  REM      **********  Parse input string.
11120  IF R$ = "" THEN GOTO 11240
11130  L = LEN( R$ )
11140  IF L <> Z0 AND LEFT$( R$, 1 ) = " " THEN GOTO 11240
11150  FOR I = 1 TO L
11160  IF MID$( R$, I, 1 ) = " " THEN GOTO 11200
11170  NEXT I
11180  R2$ = ""
11190  GOTO 11220
11200  I = I - 1
11210  R2$ = MID$( R$, I + 2, L - I )
11220  R1$ = LEFT$( R$, I )
11230  RETURN
11240  R1$ = ""
11250  R2$ = ""
11260  L = Z0
11270  RETURN
11280  REM      **********  Input 1.
11290  INPUT R$
11300  PRINT ""
11310  GOSUB 11120
11320  W$ = R1$
11330  GOSUB 10980
11340  C1$ = C$
11350  GOSUB 10890
11360  L1$ = L$
11370  W$ = R2$
11380  GOSUB 10980
11390  C2$ = C$
11400  GOSUB 10890
11410  L2$ = L$
11420  RETURN
11430  REM      **********  Input 2.
11440  INPUT R$
11450  PRINT ""
11460  GOSUB 11120
11470  W$ = R1$
11480  GOSUB 10980
11490  C2$ = C$
11500  GOSUB 10890
11510  L2$ = L$
11520  RETURN
11530  REM      **********  Test
11540  T1 = Z0
11550  T2 = Z0
11560  T3 = Z0
11570  FOR I = 1 TO 19
11580  IF C2$ = T$( I ) THEN GOTO 11610
11590  NEXT I
11600  RETURN
11610  T1 = A0
11620  IF T( I ) = Z1 THEN T2 = A0
11630  IF P1( I ) <> Z0 THEN T3 = A0
11640  RETURN
11650  REM      **********  Decode directional data.
11660  FOR I = 1 TO 6
11670  Q = INT( N0 / 2 )
11680  D( I ) = N0 - 2 * Q
11690  N0 = Q
11700  NEXT I
11710  RETURN
11720  REM      **********  Data definition for maze.
11730  DATA  9,  3,  1,  3,  3,  6,  6,  2,  6,  6
11740  DATA  3,  6,  2,  2,  3,  7,  2,  2,  6,  3
11750  DATA  3,  4,  4,  4, 11,  9, 17, 12, 12, 17
11760  DATA 19, 16, 20, 18, 21, 12, 17, 22, 23, 16
11770  DATA  8, 21, 12, 14, 24, 12, 16, 17, 12, 23
11780  DATA  9, 13, 13, 13, 13, 13, 25, 26,  5,  9
11790  DATA 26, 26, 27, 12, 12, 26, 26, 26, 26, 26
11800  DATA 26, 26, 26, 26, 26, 16, 17, 12, 12, 19
11810  DATA 12, 21, 19, 14, 16, 17, 28, 12, 12, 16
11820  DATA 29, 30, 29, 13, 34, 31, 36, 32, 33, 35
11830  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11840  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11850  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11860  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11870  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11880  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11890  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11900  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11910  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11920  DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
11930  DATA 0034,  0004,  0000,  0006,  0014,  0015,  0015,  1514,  0015,  0015
11940  DATA 0011,  0015,  0015,  0007,  0013,  3234,  0015,  0015,  0015,  0011
11950  DATA 0010,  0010,  0011,  0011,  0011,  0034,  0014,  0010,  0010,  0014
11960  DATA 0018,  0009,  0013,  0034,  0015,  0010,  0014,  0034,  0013,  0012
11970  DATA 1618,  0015,  0010,  0005,  0015,  0010,  0009,  0011,  0010,  0000
11980  DATA 0034,  0010,  0010,  0010,  0010,  0014,  0000,  0018,  0016,  0034
11990  DATA 0015,  0013,  0014,  0010,  0010,  0015,  0014,  0014,  0015,  0015
12000  DATA 0003,  0009,  0011,  0011,  0011,  0011,  0014,  0010,  0010,  0018
12010  DATA 0010,  0015,  0018,  0005,  0012,  0011,  0011,  0010,  0010,  0009
12020  DATA 0004,  0001,  0006,  0010,  0010,  0011,  0011,  0011,  0008,  0032
12030  DATA 0018,  0018,  0018,  0018,  0018,  0063,  0063,  0063,  0063,  0063
12040  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12050  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12060  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12070  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12080  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12090  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12100  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12110  DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
12120  DATA 0063,  0063,  0063,  0063,  0063,  0018,  0018,  0018,  0018,  0009
12130  DATA 3,  3,  3,  3, 59, 69, 45,  0,  0,  0
12140  DATA 0,  0, 28, 44, 49,  0, 95, 33,  0,  0
12150  END
