       REM
       REM  ########## APPLE II ADVENTURE ##########

       REM  Cleaned up 07/09/2003

       REM  ***** Arrays *****
       REM
       REM      Dirn1      Direction
       REM      Dirn2      Dirn2
       REM      MazeDesc   Maze descriptor
       REM      Location   Thing location
       REM      MazeMod    Maze modifier
       REM      Holding    Holding thing
       REM      Thing$     Thing name
       REM
       REM  ***** Variables *****
       REM
       REM      True           1
       REM      False          0
       REM      Drawbridge     Drawbridge flag
       REM      BlackKnight    Black knight flag
       REM      Break          Vase broken flag
       REM      DwarfCnt       Dwarf count
       REM      DwarfHere      Dwarf here flag
       REM      Dragon         Dragon flag
       REM      Frog           Frog flag
       REM      Fine           Fine flag
       REM      HelpCnt        Help invoked count
       REM      KillCnt        Killed count
       REM      Look           Look flag
       REM      Location       Location
       REM      LanternLit     Lantern lit flag
       REM      LanternDim     Lantern dim flag
       REM      MagicWord$     Magic word
       REM      NoLight        No light flag
       REM      PirateGone     Pirate gone flag
       REM      NoAxe          No axe flag
       REM      OilLevel       Oil level
       REM      PitCnt         Pit count
       REM      HoldingCnt     Holding count
       REM      Points         Final score
       REM      ShadowyFigure  Shadowy figure flag
       REM      ShadowCnt      Shadow count
       REM      Say            Say flag
       REM      ThingLimit     Thing limit
       REM      Test1          Test 1
       REM      Test2          Test 2
       REM      Test3          Test 3
       REM      MovesMade      Moves made
       REM      MazePosn       Position in maze
       REM      NewMazePosn    New maze position
       REM

       REM  ***** Arrays *****

       DIM MazeDesc(200), Dirn1(200), Dirn2(200), Location(20), \
           D(6), MazeMod(2), Holding(20), Thing$(20)

       REM  *****  Define names of things.
       Thing$(1)  = "Keys"
       Thing$(2)  = "Lantern"
       Thing$(3)  = "Food"
       Thing$(4)  = "Bottle"
       Thing$(5)  = "Water"
       Thing$(6)  = "Oil"
       Thing$(7)  = "Rope"
       Thing$(8)  = "Book"
       Thing$(9)  = "Carpet"
       Thing$(10) = "Statue"
       Thing$(11) = "Axe"
       Thing$(12) = "Sword"
       Thing$(13) = "Wand"
       Thing$(14) = "Silver"
       Thing$(15) = "Diamonds"
       Thing$(16) = "Emerald"
       Thing$(17) = "Crown"
       Thing$(18) = "Treasure"
       MazeMod(1) = 16

       REM  *****  Define flag values.
       True  = 1
       False = 0

       REM  *****  Setup arrays which define maze structure.
       FOR I = 1 TO 200
          READ MazeDesc(I)
       NEXT I

       FOR I = 1 TO 200
       READ Dirn1(I)
          Dirn2(I) = Dirn1(I)
       NEXT I

       FOR I = 1 TO 20
          READ  Location(I)
       NEXT I

       FOR I = 1 TO 20
          Holding(I) = False
       NEXT I

       REM  *****  Start of main program.
  940  PRINT "Are you a Boy or Girl ";
       GOSUB 11290
       IF Cmd1$ = "Boy" OR Cmd1$ = "Girl" THEN GOTO 1000
       PRINT ""
       PRINT "Please answer Boy or Girl !"
       GOTO 940

 1000  IF Cmd1$ = "Boy"  THEN P$ = "Princess"
       IF Cmd1$ = "Girl" THEN P$ = "Prince"
       Thing$(20) = P$
       MagicWord$ = "Xyzzy"
       IF INT(99 * RND) > 66 THEN MagicWord$ = "Cigam"
       IF INT(99 * RND) > 66 THEN MagicWord$ = "Renob"
       PRINT "                      *** ADVENTURE ***"
       PRINT ""
       PRINT ""
       REM  *****  Initialize miscelaneous values.
       ThingLimit = 6
       MazePosn = 8
       GOTO 4180

       REM  *****  Shadowy figure.
 1140  IF PirateGone <> False THEN GOTO 1440
       IF ShadowyFigure > False THEN GOTO 1180
       IF INT(99 * RND) < 96 THEN GOTO 1440
       ShadowyFigure = True
 1180  PRINT ""
       PRINT "A shadowy figure is following you!"
       PRINT ""
       FOR I = 20 TO 7 STEP  - 1
          IF Holding(I) <> False AND ShadowCnt > INT(13 * RND) + 7
             THEN GOTO 1260
       NEXT I
       ShadowCnt = ShadowCnt + 1
       GOTO 1440

 1260  PRINT "The shadow leaps out of the darkness."
       PRINT ""
       PRINT "'Har har', cries a bearded pirate, 'me thinks me will take a littlle of"
       PRINT "yur booty!'"
       PRINT ""
       IF I <> 20 THEN GOTO 1340
       Cmd$ = P$
       GOTO 1350

 1340  Cmd$ = Thing$(I)
 1350  GOSUB 10890  # LowerCase
       PRINT "That "; LowerCase$; " will do just fine!"
       PRINT ""
       PRINT "With that he scurries off to his treasure cave!!!!"
       PRINT ""
       Holding(I)  = False
       Location(I) = 33
       PirateGone  = True
       HoldingCnt  = HoldingCnt - 1
 1440  RETURN

       REM  *****  Dwarf.
 1460  PRINT ""
       IF Dirn2 <> False THEN GOTO 1530
       PRINT "An angry dwarf came in, threw a little axe which missed, cursed and ran"
       PRINT "away!"
       Location(11) = MazePosn
       Dirn2 = True
       GOTO 4360

 1530  IF Dirn2 <> False THEN DwarfCnt = DwarfCnt + 2
       DwarfHere = True
       PRINT "There's an angry dwarf in the room with you!  He throws a single knife"
       PRINT ""
       IF INT(DwarfCnt * RND) > 4 THEN GOTO 1600
       PRINT "It misses!"
       GOTO 4360

 1600  PRINT "It hits you!"
       KillCnt = KillCnt + 1
       IF KillCnt = 2 THEN  GOTO 10120
       GOTO 4360

       REM  *****  Display things.
 1650  PRINT ""
       IF Location(1)  = MazePosn THEN PRINT "There's a set of keys here!"
       IF Location(2)  = MazePosn THEN PRINT "A lantern rests here!"
       IF Location(3)  = MazePosn THEN PRINT "There is tasty food here!"
       IF Location(4)  = MazePosn THEN PRINT "A small bottle is lying here!"
       IF Location(5)  = MazePosn THEN PRINT "There is much water here!"
       IF Location(6)  = MazePosn THEN PRINT "A small pool of oil is here!"
       IF Location(7)  = MazePosn THEN PRINT "A useful hemp rope is coiled here!"
       IF Location(8)  = MazePosn THEN PRINT "There is an ancient book on the ground!"
       IF Location(9)  = MazePosn THEN PRINT "There is a tiny marble statue in the corner."
       IF Location(10) = MazePosn THEN PRINT "There is a persian carpet lying on the ground
       IF Location(11) = MazePosn AND NoAxe = False THEN PRINT "A little axe is here!"
       IF Location(12) = MazePosn THEN PRINT "A golden sword lies here!"
       IF Location(13) = MazePosn THEN PRINT "A magic wand floats in mid air!"
       IF Location(14) = MazePosn THEN PRINT "Seven bars of silver lie here!"
       IF Location(15) = MazePosn THEN PRINT "Many diamonds are scattered here!"
       IF Location(16) = MazePosn THEN PRINT "A pea-sized emerald falls to the floor!"
       IF Location(17) = MazePosn THEN PRINT "There's a king's crown here!"
       IF Location(18) = MazePosn THEN PRINT "There's a pirate's treasure chest here!"
       IF Holding(20) = False THEN GOTO 1870
       PRINT "The "; P$; " is still by your side."
       GOTO 1880

 1870  IF Location(20) = MazePosn THEN PRINT "A "; P$; " patiently waits here!"
 1880  Look = True
       GOTO 4430

       REM  *****  Display scenes.
 1910  PRINT "You are inside a building, a safe place to store treasures."
       GOTO 8320

 1930  PRINT "You are on a very nicely groomed path."
       GOTO 8320

 1950  PRINT "You are in the forest."
       IF MazePosn <> 15 THEN GOTO 8320
       IF BlackKnight <> False THEN GOTO 2020
       PRINT ""
       PRINT "A black knight in full iron armour is standing before you."
       PRINT "He is carrying a golden sword."
       GOTO 8320

 2020  PRINT "An iron statue of a black knight stands in front of you."
       GOTO 8320

 2040  PRINT "You are in a dried up stream bed of a once great river."
       GOTO 8320

 2060  PRINT "You are at the bottom of a climbable pit.  A small stream flows across"
       PRINT "the floor of the pit."
       GOTO 8320

 2090  PRINT "You are in a beautiful forest carrying the sounds of many animals"
       GOTO 8320

 2110  PRINT "You are at the entrance of a small cave.  A 3x3 iron grate keeps you"
       PRINT "from going down to where it looks like the cave opens up."
       GOTO 8320

 2140  PRINT "You are inside the cave entrance.  It is a good sized passage and  easy"
       PRINT "to walk in."
       GOTO 8320

 2170  PRINT "You are at the edge of a pit.  You can climb down but you might not be"
       PRINT "able to climb back up again."
       GOTO 8320

 2200  PRINT "You are in an old mine shaft that extends vertically in both directions"
       GOTO 8320

 2220  PRINT "You are standing beside a large sign flashing '"; MagicWord$; "'!"
       Say = True
       GOTO 8320

 2250  PRINT "You are traveling in a east-west tunnel."
       GOTO 8320

 2270  PRINT "You are walking in a east-west corridor."
       GOTO 8320

 2290  PRINT "You're in a large north-south passage."
       GOTO 8320

 2310  PRINT "You are in a small north-south cave."
       GOTO 8320

 2330  PRINT "You are in a room that connects to an alternate passage."
       GOTO 8320

 2350  PRINT "You are at an intersection of three corridors."
       GOTO 8320

 2370  PRINT "You are at the brink of an easily climbable pit."
       GOTO 8320

 2390  PRINT "You are at the bottom of a narrow shaft.  You could climb up but not"
       PRINT "back down."
       GOTO 8320

 2420  PRINT "You're in an enormous chamber of solid granite.  Exits lead in many"
       PRINT "directions."
       GOTO 8320

 2450  PRINT "You're in a cave of many exits."
       GOTO 8320

 2470  PRINT "You're in a beautiful cavern.  In the center of the cavern is a huge"
       PRINT "hole.  I think I hear the sound of water?"
       GOTO 8320

 2500  S$ = "a small crack"
       IF INT(99 * RND) > 50 THEN S$ = "a narrow tunnel"
       PRINT "You climb thru "; S$; " only to find that........"
       PRINT ""
       MazePosn = MazePosn - 7
       GOTO 4360

 2560  PRINT "You are in a spendid chamber decorated with strands of multi-coloured"
       PRINT "thread."
       GOTO 8320

 2590  MazePosn = MazePosn - 5
       GOTO 4180

 2610  S$ = "little, twisty"
       IF INT(99 * RND) > 50 THEN S$ = "twisty, litle"
       PRINT "You are in a "; S$; " maze!"
       GOTO 8320

 2650  PRINT "You are at a complex junction of three forks.  Obvious paths lead  east"
       print "and west."
       GOTO 8320

 2680  PRINT "You are at the dragon's lair.  His job is to protect the magic castle"
       PRINT "which lies to the south.  ";
       S$ = "refuses to let you enter."
       IF Dragon <> False THEN S$ = "lies dead off to one side."
 2720  PRINT "The dragon "; S$
       GOTO 8320

 2740  PRINT "You're in a small stone chamber of the magic castle."
       PRINT ""
       IF Frog <> False THEN GOTO 8320
       PRINT "A small green frog happily hops to and fro across the floor of the"
       PRINT "chamber!"
       GOTO 8320

 2800  PRINT "You are standing on one side of a large moat that surrounds the castle"
       PRINT "You cannot jump or swim across."
       PRINT ""
       IF Drawbridge <> False THEN PRINT "The drawbridge is lowered to cross."
       GOTO 8320

 2850  PRINT "You are in the west hall of the magic castle.  Your footsteps echo"
       PRINT "endlessly."
       GOTO 8320

 2880  PRINT "You're in the eastern hall of the magic castle."
       GOTO 8320

 2900  PRINT "You are in a room where a bed is made from twelve matresses."
       IF Holding(17) <> False THEN Dirn1(99) = 0010
       GOTO 8320

 2930  PRINT "Shhhh....you are in the king's chamber.  I think he's asleep."
       GOTO 8320

 2950  PRINT "The floor you were standing on has given way...you fall..and fall...and"
       PRINT "fall.....finally landing on solid ground................."
       MazePosn = MazePosn + 50
       GOTO 4180

 2990  PRINT "Welcome to the magic castle.  Although our ruler(King Dumb) is stupid"
       PRINT "I hope you enjoy your visit."
       GOTO 8320

 3020  PRINT "You are in the castle dungeons."
       GOTO 8320

 3040  IF Cmd2$ <> P$ THEN GOTO 3060
       IF Holding(20) <> False OR Location(20) = MazePosn THEN GOTO 3100
 3060  IF Test2 <> False THEN GOTO 6650
       IF Test2 <> False THEN GOTO 6650
       IF MazePosn <> 93 AND MazePosn <> 91 THEN GOTO 7880
       IF Cmd2$ <> "Frog" AND Cmd2$ <> P$ THEN GOTO 7840
 3100  IF Cmd2$ = "Frog" THEN GOTO 3220
       IF Location(20) <> MazePosn THEN GOTO 7880
       PRINT "The "; P$; " disappears in a puff of blue smoke............."
       PRINT ""
       PRINT "A small green frog leaps from the smoke and hurriedly hops off into"
       PRINT "the murky darkness of the chamber!"
       PRINT ""
       Frog         = False
       Location(20) = False
       Holding(20)  = False
       F3 = True
       GOTO 4410

 3220  IF F3 <> False THEN GOTO 6650
       PRINT "The room is filled with blue smoke and when the smoke clears......"
       PRINT ""
       Frog         = True
       Location(20) = MazePosn
       GOTO 1650

 3280  PRINT "The "; P$; " refuses to go by force!"
       GOTO 4410

 3300  PRINT "The "; P$; " accepts your offer and will walk by your side!"
       Holding(20)  = True
       Location(20) = False
       GOTO 4410

 3340  Holding(20)  = False
       Location(20) = MazePosn
       Look = False
       GOTO 1650

 3380  PRINT "They are too heavy to carry!"
       GOTO 4410

       REM  *****  Help.
 3410  HelpCnt = HelpCnt + 1
       IF HelpCnt < INT(HelpCnt * RND) + HelpCnt OR HelpCnt < 2 \
             AND Holding(2) <> False \
          THEN GOTO 3460
       PRINT "The wizard says, 'Quit bothering me!'."
       IF HelpCnt > 2 THEN GOTO 3560
       GOTO 4410

 3460  IF NoLight = True AND HelpCnt < 4 THEN GOTO 3480
       GOTO 7720

 3480  PRINT ""
       PRINT "The wizard of 'ADVENTURE' will light your way for 25 moves!"
       NoLight    = False
       LanternLit = True
       OilLevel   = OilLevel + 25
       MovesMade  = 225
       Look       = False
       GOTO 4180

 3560  PRINT ""
       PRINT "'I, the wizard of 'ADVENTURE', have given you enough warnings!!'"
       PRINT ""
       PRINT "Now you will suffer this fate....."
       PRINT ""
       PRINT "The wizard turns you into stone!!!!"
       PitCnt = PitCnt + 1
       PRINT ""
       IF PitCnt > 1 THEN GOTO 10460
       GOTO 10120

       REM  *****  Some events.
 3670  IF DwarfHere <> False OR  MazePosn = 91 OR  MazePosn = 93 \
             OR Holding(20) <> False OR  MazePosn = 87 OR Cmd2$ = "Myself" \
             OR Cmd2$ = "Me" OR Cmd2$ = "Knight" \
          THEN GOTO 3710
       IF Test2 <> False THEN GOTO 7840
       GOTO 7880

       REM  *****  The P$.
 3710  IF Cmd2$ = "Me" OR Cmd2$ = "Myself" THEN GOTO 3740
       PRINT "With what?  Your bare hands?"
       GOTO 4410

 3740  PRINT "Are you sure that you want me to put an end to your miserable life!"
       PRINT ""
       PRINT "Well";
       GOSUB 11290
       IF LEFT$(Cmd1$, 1) = "Y" OR LEFT$(Cmd1$, 1) = "N" THEN GOTO 3830
       PRINT ""
       PRINT "Please answer (Yes or No) !!!!!"
       PRINT ""
       GOTO 3740

 3830  IF LEFT$(Cmd1$, 1) = "Y" THEN GOTO 10120
       PRINT "Ok!"
       GOTO 4360

 3860  IF MazePosn <> 91 AND MazePosn <> 93 THEN GOTO 7880
       PRINT "The frog hops just out of your reach. It seems impossible to catch him"
       GOTO 4410

 3890  IF Dragon <> False THEN GOTO 6390
       IF Holding(11) = False THEN GOTO 9600
       PRINT "The dragon dodges out of the way and promptly sits upon the axe where"
       PRINT "you cannot get it!"
       NoAxe = True
       Holding(11) = False
       Location(11) = 87
       HoldingCnt = HoldingCnt - 1
       GOTO 4410

 3980  PRINT "The dragon is sitting on it!"
       GOTO 4410

 4000  IF Holding(12) <> False THEN GOTO 4030
       PRINT "You have nothing that can kill it!"
       GOTO 4410

 4030  PRINT "The golden sword strikes home!"
       NoAxe = False
       Look = False
       Dirn1(87) = 0015
       Dragon = True
       GOTO 4180

 4090  PRINT "The water quickly rusts the armor and turns the knight into an "
       PRINT "iron statue.  He drops the golden sword."
       Holding(5)    = False
       Location(12)  = 15
       HoldingCnt    = HoldingCnt - 1
       BlackKnight   = True
       Look          = False
       GOTO 1650

       REM  *****  Check light.
 4180  IF INT(99 * RND) > 92 AND MazePosn > 25 THEN GOTO 1460
       IF MovesMade > 200 AND LanternDim = False THEN GOTO 4330
       IF MovesMade > 250 AND NoLight = False THEN GOTO 4220
       GOTO 4250

 4220  PRINT ""
       PRINT "Your lantern has run out of fuel!"
       NoLight = True
 4250  IF NoLight = False THEN GOTO 4270
       LanternLit = False
 4270  IF MazeDesc(MazePosn) <> 3 AND MazePosn < 25 THEN GOTO 4360
       IF LanternLit <> False THEN GOTO 4360
       PRINT ""
       PRINT "It is pitch dark!  If you proceed you will most likely fall into a pit"
       IF INT(99 * RND) > 85 THEN GOTO 10080
       GOTO 4410

 4330  PRINT ""
       PRINT "Your lantern is getting very dim!  I would look for a source of oil"
       LanternDim = True
 4360  PRINT ""
       IF MazeDesc(MazePosn) > 20 THEN GOTO 4390
       ON MazeDesc(MazePosn) \
          GOTO 1910,1930,1950,2040,2060,2090,2110,2140,2170,2200,2220,\
               2250,2270,2290,2310,2330,2350,2370,2390,2420
 4390  ON MazeDesc(MazePosn) - 20 \
          GOTO 2450,2470,2500,2560,2590,2610,2650,2680,2740,2800,\
               2850,2880,2900,2930,2950,2990,3020

       REM  *****  Input next command.
 4410  IF Look <> False THEN GOTO 4430
       IF MazePosn = 3 OR LanternLit <> False THEN GOTO 1650
 4430  PRINT ""
       PRINT "What is your command";
       GOSUB 11290
       IF Cmd1$ = "" THEN GOTO 7640
       REM  *****  Make the next move.
       MovesMade = MovesMade + 1
       IF Holding(20) <> False THEN Location(20) = MazePosn
       N = False
       E = False
       S = False
       W = False
       U = False
       D = False
       IF LEN(Cmd1$) > 1 THEN GOTO 4920
       REM  *****  Check for directional move.
 4580  IF LEFT$(Cmd1$, 1) <> "N" THEN GOTO 4620
       NewMazePosn = MazePosn - 5
       N = 1
       GOTO 4820

 4620  IF LEFT$(Cmd1$, 1) <> "E" THEN GOTO 4660
       NewMazePosn = MazePosn + 1
       E = 1
       GOTO 4820

 4660  IF LEFT$(Cmd1$, 1) <> "S" THEN GOTO 4700
       NewMazePosn = MazePosn + 5
       S = 1
       GOTO 4820

 4700  IF LEFT$(Cmd1$, 1) <> "W" THEN GOTO 4740
       NewMazePosn = MazePosn - 1
       W = 1
       GOTO 4820

 4740  IF LEFT$(Cmd1$, 1) <> "U" THEN GOTO 4780
       NewMazePosn = MazePosn - 25
       U = 1
       GOTO 4820

 4780  IF LEFT$(Cmd1$, 1) <> "D" THEN GOTO 4920
       NewMazePosn = MazePosn + 25
       D = 1
       GOTO 4820

 4820  IF NewMazePosn < 1 OR NewMazePosn > 200 GOTO 7740
       DirnMask = (Dirn1(MazePosn) - INT(Dirn1(MazePosn) / 100) * 100)
       GOSUB 11660
       IF LEFT$(Cmd1$, 1) <> "D" THEN GOTO 7950
       FOR I = 1 TO 2
          IF MazeMod(I) = MazePosn THEN GOTO 4900
       NEXT I
       GOTO 7950

 4900  PRINT "It is locked!"
       GOTO 4410

 4920  IF Cmd1$ <> "Walk" AND Cmd1$ <> "Crawl" AND Cmd1$ <> "Jump" \
                        AND Cmd1$ <> "Run" THEN GOTO 4990
       IF LEN(Cmd2$) <> False THEN GOTO 4960
       PRINT Cmd1$; " where";
       GOSUB 11440
 4960  IF Cmd2$ <> "North" AND Cmd2$ <> "East" AND Cmd2$ <> "South" \
                         AND Cmd2$ <> "West" AND Cmd2$ <> "Up" \
                         AND Cmd2$ <> "Down" THEN GOTO 7840
       Cmd1$ = Cmd2$
       GOTO 4580

 4990  IF Cmd1$ = "North" OR Cmd1$ = "South" OR Cmd1$ = "East" \
                        OR Cmd1$ = "West" OR Cmd1$ = "Down" \
                        OR Cmd1$ = "Up" THEN GOTO 4580
       REM  *****  Interpret non-directional commands.
 5010  GOSUB 11540
       IF Cmd1$ <> "Look" THEN GOTO 5060
       Look = False
       PRINT "I'm not allowed to give more detail!"
       GOTO 4180

 5060  IF Cmd1$ <> "Exit" AND Cmd1$ <> "Enter" THEN GOTO 5180
       IF MazePosn = 3 OR  MazePosn = 8 THEN GOTO 5090
       GOTO 7780

 5090  IF MazePosn = 8 THEN GOTO 5130
       IF Cmd1$ <> "Exit" THEN GOTO 7740
       MazePosn = 8
       GOTO 4180

 5130  IF Cmd1$ <> "Enter" THEN GOTO 7740
       MazePosn = 3
       PRINT "You walk thru a wooden door....."
       GOTO 4180

       GOTO 7740

 5180  IF Cmd1$ = "Inven" OR Cmd1$ = "Inventory" THEN GOTO 8950
       IF Cmd1$ = "Get" THEN GOTO 9110
       IF Cmd1$ <> "Light" AND Cmd1$ <> "Lite" THEN GOTO 5340
       IF NoLight <> False THEN GOTO 5240
       IF LEN(Cmd2$) <> False THEN GOTO 5270
       GOTO 7640

 5240  IF NoLight = False THEN GOTO 5270
       PRINT "Your lantern is out of oil!"
       GOTO 4180

 5270  IF Cmd2$ <> "Lantern" THEN GOTO 7840
       IF Holding(2) = False THEN GOTO 5320
       LanternLit = True
       PRINT "Your lantern is lit!"
       GOTO 4180

 5320  PRINT "You don't have a lantern!"
       GOTO 4410

 5340  IF Cmd1$ <> "Quit" AND Cmd2$ <> "Quit" THEN GOTO 5460
       PRINT ""
       PRINT "Do you really want to quit";
 5370  GOSUB 11290
       IF LEFT$(Cmd1$, 1) = "Y" OR LEFT$(Cmd1$, 1) = "N" THEN GOTO 5440
       PRINT "Answer the question!!!(Yes or No)"
       PRINT ""
       PRINT ""
       PRINT "Do you want to quit?";
       GOTO 5370

 5440  IF LEFT$(Cmd1$, 1) = "Y" THEN GOTO 10460
       GOTO 4180

 5460  IF Cmd1$ = "Drop" THEN GOTO 9600
 5470  IF Cmd1$ <> "Say" THEN GOTO 5530
       IF Say <> False THEN GOTO 9930
       IF LEN(Cmd2$) = False THEN GOTO 9070
 5500  PRINT ""
       PRINT "Okay, '"; Cmd2$; "'!"
       GOTO 4410

 5530  IF Cmd1$ <> "Open" AND Cmd1$ <> "Unlock" THEN GOTO 5760
       IF Cmd2$ <> "Sesame" THEN GOTO 5660
       IF O2 <> False THEN GOTO 5610
       O2 = True
       FOR I = 1 TO 200
          Dirn2(I) = Dirn1(I)
       NEXT I
       GOTO 4410

 5610  O2 = False
       FOR I = 1 TO 200
          Dirn1(I) = Dirn2(I)
       NEXT I
       GOTO 4410

 5660  IF Holding(1) <> False THEN GOTO 5690
       PRINT "You have no keys!"
       GOTO 4410

 5690  FOR I = 1 TO 2
          IF MazePosn = MazeMod(I) THEN GOTO 5730
       NEXT I
       GOTO 7780

 5730  MazeMod(I) = False
       PRINT "The keys have "; Word1LC$; "ed it!"
       GOTO 4410

 5760  IF Cmd1$ <> "Abracadbra" THEN GOTO 5900
       IF A1 <> False THEN GOTO 5860
       A1 = True
       ThingLimit = 20
       GOTO 4410

       A1 = False
       ThingLimit = 6
       FOR I = 20 TO 3 STEP -1
          IF HoldingCnt <= ThingLimit THEN GOTO 4410
          IF Holding(I) = False THEN GOTO 5880
 5860     Holding(I) = 0
          Location(I) = INT(100 * RND) + 1
 5880  NEXT I
       GOTO 4410

 5900  IF Cmd1$ <> "*scan" AND Cmd1$ <> "*s" THEN GOTO 6060
       IF Cmd2$ <> "Thing" AND Cmd2$ <> "Thing" THEN GOTO 6000
       PRINT ""
       PRINT ""
       PRINT "Locations of Things you are not holding."
       PRINT ""
       FOR I = 1 TO 20
          IF Holding(I) = False THEN PRINT I, Thing$(I), Location(I)
       NEXT I
       GOTO 4410

 6000  IF Cmd2$ <> "Location" AND Cmd2$ <> "Loc" THEN GOTO 7640
       PRINT ""
       PRINT ""
       PRINT "Maze position is "; MazePosn, "Location descriptor is "; MazeDesc(MazePosn)
       PRINT ""
       GOTO 4410

 6060  IF Cmd1$ <> "*goto" AND Cmd1$ <> "*g" THEN GOTO 6120
       IF LEN(Cmd2$) = False THEN GOTO 9070
       Look = False
       X = VAL(Cmd2$)
       IF X > 0 AND X <= 200 THEN MazePosn = X
       GOTO 4180

 6120  IF Cmd1$ <> "Drink" THEN GOTO 6210
       IF LEN(Cmd2$) = False THEN GOTO 9070
       IF Test1 = False THEN GOTO 7640
       IF Cmd2$ <> "Water" THEN GOTO 7900
       IF Holding(5) = 0 THEN GOTO 7920
       PRINT "Your water is gone!"
       Holding(5) = False
       HoldingCnt = HoldingCnt - 1
       GOTO 4410

 6210  IF Cmd1$ <> "Eat" THEN GOTO 6320
       IF LEN(Cmd2$) = False THEN GOTO 9070
       IF Test1 = False THEN GOTO 7640
       IF Test3 = False THEN GOTO 7800
       IF I < 3 THEN GOTO 7900
       PRINT "Thanks, don't mind if I do!"
       PRINT ""
       PRINT "Your "; Word2LC$; " was very tasty!"
       Holding(I) = False
       HoldingCnt = HoldingCnt - 1
       GOTO 4410

 6320  IF Cmd1$ <> "Throw" THEN GOTO 6530
       IF Cmd2$ <> "Axe" THEN GOTO 9600
       IF MazePosn = 87 THEN GOTO 3890
       IF Holding(11) <> False THEN GOTO 6390
       GOTO 9600

 6370  PRINT "There's nothing here to attack!"
       GOTO 4410

 6390  IF MazePosn = 15 THEN GOTO 9600
       IF DwarfHere = False THEN GOTO 6370
       Holding(11) = False
       Location(11) = MazePosn
       HoldingCnt = HoldingCnt - 1
       S$ = "You missed!"
       IF INT(99 * RND) > 70 THEN GOTO 6470
       S$ = "You killed a little dwarf.  His body vanishes in a *POOF* of pink smoke!"
 6470  PRINT S$
       DwarfCnt  = INT(3 * RND) + 1
       Look      = False
       PRINT ""
       DwarfHere = False
       GOTO 4180

 6530  IF Cmd1$ <> "Wave" AND Cmd1$ <> "Shake" THEN GOTO 6680
       IF Holding(13) = False OR  MazePosn <> 92 OR Cmd2$ <> "Wand" THEN GOTO 6580
       Drawbridge = True
       Dirn1(92)  = 0005
       GOTO 4360

 6580  IF Test2 <> False THEN GOTO 6650
       GOTO 7800

 6600  DwarfHere = False
       DwarfCnt = INT(2 * RND) + 1
       PRINT "The angry little dwarf sees the anger in the way that you "; Word1LC$
       PRINT "your axe and promptly heads for the nearest exit."
       GOTO 4410

 6650  IF DwarfHere <> False  AND Cmd2$ = "Axe" THEN GOTO 6600
       PRINT "Nothing happens!"
       GOTO 4410

 6680  IF Cmd1$ <> "Pay" THEN GOTO 6790
       IF Holding(15) <> False THEN GOTO 6720
       PRINT "No money.. no book!"
       GOTO 4410

 6720  IF MazePosn <> 170 THEN GOTO 7640
       PRINT "Thank you sir.  I hope you enjoy it!"
       Holding(8)  = True
       Location(8) = False
       HoldingCnt  = HoldingCnt + 1
       Fine        = True
       GOTO 4410

 6790  IF Cmd1$ <> "Give" THEN GOTO 6890
       IF Holding(5) <> False AND MazePosn = 145 AND Cmd2$ = "Water" THEN GOTO 6840
       IF Holding(5) = False THEN GOTO 9600
       GOTO 4410

       PRINT "Who are you going to give it to?"
 6840  PRINT "The old man drinks the water and walks off into the darkness!"
       Holding(5)    = False
       HoldingCnt    = HoldingCnt - 1
       MazeDesc(145) = 28
       GOTO 4180

 6890  IF Cmd1$ <> "Wet" THEN GOTO 7010
       IF Holding(5) <> False THEN GOTO 6930
       PRINT "With what?  Spit? Sweat?"
       GOTO 7840

 6930  IF MazePosn <> 157 THEN GOTO 7640
       PRINT "You slip and slide into........"
       PRINT ""
       Holding(5) = False
       Dirn1(157) = 0010
       HoldingCnt = HoldingCnt - 1
       MazePosn   = 159
       GOTO 4180

 7010  DwarfHere = False
       IF Cmd1$ <> "Read" OR Holding(8) = False THEN GOTO 7060
       IF Cmd2$ <> "Book" THEN GOTO 7840
       PRINT "The book reads, 'say magic word in the 'not same' maze!"
       GOTO 4410

 7060  IF Cmd1$ = "Kill" THEN GOTO 3670
       IF Cmd1$ <> "With" THEN GOTO 7120
       IF Cmd2$ <> "Axe" THEN GOTO 7840
       Cmd1$ = "Throw"
       Cmd2$ = "Axe"
       GOTO 6320

 7120  IF Cmd1$ <> MagicWord$ THEN GOTO 7160
       Cmd2$ = MagicWord$
       Cmd1$ = "Say"
       GOTO 5470

 7160  IF Cmd1$ <> "Why" THEN GOTO 7190
       PRINT "Because I said so!  That's why!!!!"
       GOTO 4410

 7190  IF Cmd1$ <> "You" AND Cmd1$ <> "Your" AND Cmd2$ <> "You" THEN GOTO 7220
       PRINT "If you don't like playing the game you can always 'Quit'!"
       GOTO 4410

 7220  IF Cmd1$ <> "Find" THEN GOTO 7250
       PRINT "I cannot tell you where remote things are located!"
       GOTO 4410

 7250  IF Cmd1$ = "Slay" AND Cmd2$ = "Dragon" THEN GOTO 4000
       IF Cmd1$ <> "Yes" THEN GOTO 7300
       IF MazePosn = 15 OR  MazePosn = 87 OR DwarfHere <> False  THEN GOTO 7840
       PRINT "You seem unsure of that answer!"
       GOTO 4410

 7300  IF Cmd1$ <> "Lift" THEN GOTO 7370
       IF LEN(Cmd2$) = False THEN GOTO 9070
       IF Test2 = False AND MazePosn <> 99 THEN GOTO 7880
       IF Cmd2$ <> "Matress" AND Cmd2$ <> "Matresses" THEN GOTO 6650
       Location(16) = True
       Look         = False
       GOTO 1650

 7370  IF Cmd1$ = "Kiss" THEN GOTO 3040
       IF Cmd1$ = "Please" AND Location(20) = MazePosn THEN GOTO 3300
       IF Cmd1$ = "Wait" AND Holding(20) <> False THEN GOTO 3340
       IF Cmd1$ = "Help" THEN GOTO 3410
       IF Cmd1$ <> "Listen" THEN GOTO 7440
       PRINT "Slosh..boil..drip..spurt..squirt......"
       GOTO 4410

 7440  IF Cmd1$ <> "Where" THEN GOTO 7470
       PRINT "I'm not really sure which way you're facing.  Try a compass heading."
       GOTO 4410

 7470  IF Cmd1$ <> "What" AND Cmd1$ <> "Who" AND Cmd1$ <> "When" AND Cmd1$ <> "How" THEN GOTO 7500
       PRINT "I refuse to answer on the grounds that it might incriminate me!"
       GOTO 4410

 7500  IF LEFT$(Cmd1$, 1) <> "N" THEN GOTO 7530
       PRINT "Why must you always be so negative?"
       GOTO 4410

 7530  IF Cmd1$ <> "Cause" AND Cmd1$ <> "Because" THEN GOTO 7560
       PRINT "That answer stinks!"
       GOTO 4410

 7560  IF Cmd2$ = "" THEN Q = True
       Cmd2$ = Cmd1$
       IF Test2 = False THEN GOTO 7720
       REM  *****  Some miscelaneous messages.
       PRINT "What do you want to do with the "; Word2LC$; "?"
       GOTO 4410

 7620  PRINT "You can't "; Word1LC$; " "; Word2LC$; "!"
       GOTO 4410

 7640  S$ = "I don't understand what you mean!"
       IF INT(99 * RND) > 50 THEN S$ = "What???"
       IF Q = False THEN GOTO 7700
       PRINT "I'm not yet familiar with that word!"
       Q = False
       GOTO 4410

 7700  PRINT S$
       GOTO 4410

 7720  PRINT "Nothing happens!"
       GOTO 4410

 7740  S$ = "You do not seem to know where you're going!"
       IF RND > 0.5 THEN S$ = "You can't go that way!"
       PRINT S$
       GOTO 4410

 7780  PRINT "There's nothing here to "; Word1LC$; "!"
       GOTO 4410

 7800  PRINT "You don't have that to "; Word1LC$; "!"
       GOTO 4410

 7820  PRINT "You are already holding the "; Word2LC$; "!"
       GOTO 4410

 7840  PRINT "C'mon, can't you be serious?"
       GOTO 4410

 7860  PRINT "You have nothing to "; Word1LC$; "!"
       GOTO 4410

 7880  PRINT "I see no "; Word2LC$; " here!"
       GOTO 4410

 7900  PRINT "I'm game.  Would you care to explain how?"
       GOTO 4410

 7920  PRINT "You have to get it first!"
       GOTO 4410

       REM  *****  Process directional moves.
 7950  IF MazeDesc(MazePosn) <> 6 THEN GOTO 8170
       IF N = False THEN GOTO 8010
       N = False
       E = 1
       NewMazePosn = MazePosn + 1
       GOTO 8180

 8010  IF E = False THEN GOTO 8060
       E = False
       S = 1
       NewMazePosn = MazePosn + 5
       GOTO 8190

 8060  IF S = False THEN GOTO 8110
       S = False
       W = 1
       NewMazePosn = MazePosn - 1
       GOTO 8200

 8110  IF W = False THEN GOTO 8170
       W = False
       N = 1
       NewMazePosn = MazePosn - 5
       GOTO 8170

       REM  *****  Check allowed directions.
 8170  IF N = 1 AND D(1) = 1 THEN GOTO 8280
 8180  IF E = 1 AND D(2) = 1 THEN GOTO 8280
 8190  IF S = 1 AND D(3) = 1 THEN GOTO 8280
 8200  IF W = 1 AND D(4) = 1 THEN GOTO 8280
       IF U = 1 AND D(5) = 1 THEN GOTO 8280
       IF D = 1 AND D(6) = 1 THEN GOTO 8280
       PRINT ""
       IF MazePosn = 87 THEN GOTO 8260
       GOTO 7740

 8260  S$ = "refuses to let you pass!"
       GOTO 2720

 8280  MazePosn = NewMazePosn
       Look = False
       GOTO 4180

       REM  *****  Look around at nearby scenes.
 8320  N = False
       E = False
       S = False
       W = False
       U = False
       D = False
       IF MovesMade > 50 +  INT(50 * RND) THEN  GOSUB 1140
       DirnMask = INT(Dirn1(MazePosn) / 100)
       GOSUB 11660
       N = D(1)
       E = D(2)
       S = D(3)
       W = D(4)
       U = D(5)
       D = D(6)
 8470  IF N = False THEN GOTO 8520
       Location = MazePosn - 5
       N = False
       PRINT "To the north is ";
       GOTO 8770

 8520  IF E = False THEN GOTO 8570
       Location = MazePosn + 1
       E = False
       PRINT "Along the east is ";
       GOTO 8770

 8570  IF S = False THEN GOTO 8620
       Location = MazePosn + 5
       S = False
       PRINT "Looking south is ";
       GOTO 8770

 8620  IF W = False THEN GOTO 8680
       Location = MazePosn - 1
       W = False
       PRINT "Appearing westerly is ";
       GOTO 8770

       Dirn1(I) = 0063
 8680  IF U = False THEN GOTO 8720
       Location = MazePosn - 25
       U = False
       GOTO 8770

 8720  IF D = False THEN GOTO 8760
       Location = MazePosn + 25
       D = False
       GOTO 8770

 8760  GOTO 4410
 8770  ON MazeDesc(Location) GOTO 8780, 8800, 2020, 8820, 8470, 8840, 8860, 8890
 8780  PRINT "a small building."
       GOTO 8470

 8800  PRINT "a shallow valley."
       GOTO 8470

 8820  PRINT "a river bed"
       GOTO 8470

 8840  PRINT "a beautiful forest."
       GOTO 8470

 8860  PRINT ""
       PRINT "A cobble path leads up to the surface."
       GOTO 8470

 8890  PRINT ""
       PRINT "A cobble path leads down into the cave."
       PRINT ""
       IF MazeMod(1) = False THEN PRINT "The grate is open."
       GOTO 8470

       REM  *****  Perform inventory.
 8950  PRINT ""
       PRINT "You are holding the following items:"
       PRINT ""
       X = False
       FOR I = 1 TO 19
          IF Holding(I) = False THEN  9030
          PRINT Thing$(I)
          X = True
       NEXT I
       IF X = False THEN PRINT "Nothing!"
       GOTO 4410

       REM  *****  Ask for Cmd2$.
 9070  PRINT Cmd1$; " what";
       GOSUB 11440
       GOTO 5010

       REM  *****  Perform 'Get' and 'Drop'.
 9110  IF HoldingCnt <> ThingLimit THEN GOTO 9140
       PRINT "You can't carry anything more.  You'll have to drop something first!"
       GOTO 4410

 9140  IF LEN(Cmd2$) = False THEN GOTO 9070
       IF Test3 = True THEN GOTO 7820
       IF Test2 <> False THEN GOTO 9220
       IF Cmd2$ = "Water" AND MazePosn = 59 THEN GOTO 9220
       IF Cmd2$ = "Frog" THEN GOTO 3860
       IF Location(20) = MazePosn THEN GOTO 3280
       IF Cmd2$ = "Matress" OR Cmd2$ = "Matresses" THEN GOTO 3380
       GOTO 7880

 9220  IF Cmd2$ <> "Water" OR Location(5) <> MazePosn THEN GOTO 9310
       IF Holding(5) <> False THEN GOTO 9290
       IF Holding(4) = False THEN GOTO 9270
       Holding(5) = True
       GOTO 9560

 9270  PRINT "You have nothing to carry the water in!"
       GOTO 4410

 9290  PRINT "You can't carry any more water!"
       GOTO 4410

 9310  IF Cmd2$ <> "Oil" OR Location(6) <> MazePosn THEN GOTO 9380
       PRINT "Your lantern is full again."
       Location(6) = False
       LanternDim = False
       OilLevel = MovesMade
       MovesMade = 1
       GOTO 4410

 9380  IF Cmd2$ = "Book" AND Fine = False AND MazePosn = 159 THEN GOTO 12150
       IF Cmd2$ <> "Book" OR Location(8) <> MazePosn THEN GOTO 9430
       Holding(8) = True
       Location(8) = False
       GOTO 9560

 9430  IF Cmd2$ <> "Treasure" OR Location(18) <> MazePosn THEN GOTO 9500
       IF MazeMod(2) <> False THEN GOTO 9480
       Holding(18) = True
       Location(18) = False
       GOTO 9560

 9480  PRINT "It's locked!"
       GOTO 4410

 9500  IF Cmd2$ <> "Axe" THEN GOTO 9520
       IF NoAxe <> False THEN GOTO 3980
 9520  Holding(I) = True
       Location(I) = False
       GOTO 9560

       GOTO 7880

 9560  PRINT "Ok!"
       HoldingCnt = HoldingCnt + 1
       GOTO 4410

       REM  *****  Drop things.
 9600  IF HoldingCnt <> False THEN GOTO 9620
       GOTO 7860

 9620  IF LEN(Cmd2$) = False THEN GOTO 9070
       IF Test3 <> False THEN GOTO 9680
       IF Cmd2$ = P$ THEN GOTO 3100
       IF Test1 = False THEN GOTO 7620
       PRINT "You are not carrying it!"
       GOTO 4410

 9680  IF Cmd2$ <> "Lantern" THEN GOTO 9700
       LanternLit = False
 9700  IF Cmd2$ <> "Bottle" THEN GOTO 9760
       IF Holding(5) = False THEN GOTO 9870
       Holding(5) = False
       HoldingCnt = HoldingCnt - 1
       PRINT "The bottle tipped over and the water spilled out of the bottle!"
       GOTO 9880

 9760  IF Cmd2$ <> "Statue" THEN GOTO 9860
       IF Location(9) = MazePosn THEN GOTO 9820
 9780  PRINT "The statue falls and breaks worthlessly"
       Holding(12) = False
       Location(12) = False
       GOTO 9900

 9820  IF Break <> False THEN GOTO 9780
       PRINT "The statue lands safely on the persian rug."
       Break = True
       GOTO 9880

 9860  IF Cmd1$ = "Throw" AND Cmd2$ = "Water" AND MazePosn = 15 AND BlackKnight = False THEN GOTO 4090
 9870  PRINT "Ok!"
 9880  Holding(I) = False
       Location(I) = MazePosn
 9900  HoldingCnt = HoldingCnt - 1
       GOTO 4410

       REM  *****  Magic words.
 9930  IF Cmd2$ <> MagicWord$ THEN GOTO 5500
       IF MazePosn <> 199 THEN GOTO 9980
       PRINT "A secret passage opens to the west!"
       Dirn1(199) = 0009
       GOTO 4410

 9980  IF MazePosn <> 3 THEN GOTO 10010
       MazePosn = 41
       GOTO 10030

10010  IF MazePosn <> 41 THEN GOTO 10040
       MazePosn = 3
10030  Look     = False
10040  IF MazePosn = 3 OR  MazePosn = 41 THEN GOTO 4180
       PRINT "Nothing happens!"
       GOTO 4410

       REM  *****  The pit.
10080  PRINT ""
       PitCnt = PitCnt + 1
       PRINT "You fell into a pit and are a mass of twisted flesh and bones."
       PRINT ""
10120  IF PitCnt > 1 THEN GOTO 10160
       PRINT ""
       PRINT "I might be able to reincarnate you!  Would you like me to try?"
       GOTO 10220

10160  PRINT "You've really done it this time.  I'm all out of fairy dust!"
       PRINT ""
       PRINT "You don't really expect me to do a decent reincarnation without it do"
       PRINT "you?"
       KillCnt  = False
       DwarfCnt = False
10220  PRINT ""
       PRINT "Well";
       IF PitCnt > 1 THEN GOTO 10400
       GOSUB 11290
       IF LEFT$(Cmd1$, 1) = "N" THEN GOTO 10460
       PRINT "Ready......one.two..three!  *POOF*"
       PitCnt = PitCnt + 1
       PRINT ""
       PRINT "You emerge from a cloud of fairy dust only to find yourself......."
       Look = False
       FOR I = 1 TO 20
          IF Holding(I) = False THEN GOTO 10360
          Location(I) = MazePosn
          IF I = 2 THEN Location(2) = 3
10360  NEXT I
       MazePosn = 3
       HoldingCnt = False
       GOTO 4360

10400  GOSUB 11290
       IF LEFT$(Cmd1$, 1) = "N" THEN GOTO 10460
       PRINT ""
       PRINT "Ok!  If you're so smart do it yourself!!"
       PRINT ""
       REM  *****  Calculate score.
10460  Points = False
       FOR I = 1 TO 5
          IF Location(I) = 3 THEN Points = Points + 10
       NEXT I
       FOR I = 6 TO 13
          IF Location(I) = 3 THEN Points = Points + 20
       NEXT I
       FOR I = 14 TO 19
          IF Location(I) = 3 THEN Points = Points + 30
       NEXT I
       IF Location(20) = 3 THEN Points = Points + 50
       IF Say <> False THEN Points = Points + 50
       IF OilLevel <> False THEN MovesMade = MovesMade + OilLevel
       Points = Points - INT(MovesMade / 10)
       PRINT ""
       PRINT "You scored "; Points ; " points out of a possible 350, using"; MovesMade ; " turns!"
       PRINT ""
       G$ = "RANK BEGINNER"
       IF Points > 50  THEN G$ = "NOVICE"
       IF Points > 100 THEN G$ = "EXPERIENCED"
       IF Points > 150 THEN G$ = "SEASONED"
       IF Points > 200 THEN G$ = "JR. MASTER"
       IF Points > 250 THEN G$ = "SR. MASTER"
       IF Points > 300 THEN G$ = "MASTER"
       IF Points = 350 THEN G$ = "WIZARD"
       PRINT "Your score qualifies you as a  *** '"; G$; "' ADVENTURER ***"
       PRINT ""
       FOR I = 50 TO 350 STEP 50
          IF I - Points > False THEN GOTO 10760
       NEXT I
10760  PRINT "To achieve the next higher rating you need "; I - Points ; " more points!"
       GOTO 12150

10780  REM  *****  Convert upper case to lower case.
       D0 = ASCII(D$)
       IF D0 < 65 OR D0 > 90 THEN RETURN
       D$ = CHReply$(D0 + 32)
       RETURN

10830  REM  *****  Convert lower case to upper case.
       D0 = ASCII(D$)
       IF D0 < 97 OR D0 > 122 THEN RETURN
       D$ = CHReply$(D0 - 32)
       RETURN

       REM  *****  Convert string to lower case.
10890  D$ = ""
       IF LEN(Cmd$) = False THEN GOTO 10950
       D$ = LEFT$(Cmd$, 1)
       GOSUB 10780  # toLower()
       IF LEN(Cmd$) = 1 THEN GOTO 10950
       D$ = D$ + RIGHT$(Cmd$, LEN(Cmd$) - 1)
10950  LowerCase$ = D$
       RETURN

       REM  *****  Convert to capitalized first letter.
10980  Cmd$ = ""
       Len = LEN(Word$)
       IF Len = False THEN RETURN
       D$ = LEFT$(Word$, 1)
       GOSUB 10830  # toUpper()
       Cmd$ = D$
       IF Len = 1 THEN RETURN
       FOR I = 2 TO Len
          D$ = MID$(Word$ , I, 1)
          GOSUB 10780  # toLower()
          Cmd$ = Cmd$ + D$
       NEXT I
       RETURN

       REM  *****  Split reply string.
11120  IF Reply$ = "" THEN GOTO 11240
       Len = LEN(Reply$)
       IF Len <> False AND LEFT$(Reply$, 1) = " " THEN GOTO 11240
       FOR I = 1 TO Len
          IF MID$(Reply$, I, 1) = " " THEN GOTO 11200
       NEXT I
       Reply2$ = ""
       GOTO 11220

11200  I = I - 1
       Reply2$ = MID$(Reply$, I + 2, Len - I)
11220  Reply1$ = LEFT$(Reply$, I)
       RETURN

11240  Reply1$ = ""
       Reply2$ = ""
       Len = False
       RETURN

       REM  *****  Input 1.
11290  INPUT Reply$
       PRINT ""
       GOSUB 11120  # Split Reply$ into 2 (words - Reply1$ and Reply2$)
       Word$ = Reply1$
       GOSUB 10980  # Capitalize (Operates on Word$ and returns Cmd$)
       Cmd1$ = Cmd$$
       GOSUB 10890  # LowerCase (Oerates on Cmd$ and returns LowerCase$)
       Word1LC$ = LowerCase$
       Word$ = Reply2$
       GOSUB 10980  # Capitalize (Operates on Word$ and returns Cmd$)
       Cmd2$ = Cmd$
       GOSUB 10890  # LowerCase (Oerates on Cmd$ and returns LowerCase$)
       Word2LC$ = LowerCase$
       RETURN

       REM  *****  Input 2.
11440  INPUT Reply$
       PRINT ""
       GOSUB 11120  # Split Reply$ into 2 (words - Reply1$ and Reply2$)
       Word$ = Reply1$
       GOSUB 10980  # Capitalize (Operates on Word$ and returns Cmd$)
       Cmd2$ = Cmd$
       GOSUB 10890  # LowerCase (Oerates on Cmd$ and returns LowerCase$)
       Word2LC$ = LowerCase$
       RETURN

       REM  *****  Test
11540  Test1 = False
       Test2 = False
       Test3 = False
       FOR I = 1 TO 19
          IF Cmd2$ = Thing$(I) THEN GOTO 11610
       NEXT I
       RETURN

11610  Test1 = True
       IF Location(I) = MazePosn THEN Test2 = True
       IF Holding(I) <> False THEN Test3 = True
       RETURN

       REM  *****  Decode directional data.
11660  FOR I = 1 TO 6
          Q = INT(DirnMask / 2)
          D(I) = DirnMask - 2 * Q
          DirnMask = Q
       NEXT I
       RETURN

       REM  *****  Data definition for maze.

       REM  Mase Descriptors

       DATA  9,  3,  1,  3,  3,  6,  6,  2,  6,  6
       DATA  3,  6,  2,  2,  3,  7,  2,  2,  6,  3
       DATA  3,  4,  4,  4, 11,  9, 17, 12, 12, 17
       DATA 19, 16, 20, 18, 21, 12, 17, 22, 23, 16
       DATA  8, 21, 12, 14, 24, 12, 16, 17, 12, 23
       DATA  9, 13, 13, 13, 13, 13, 25, 26,  5,  9
       DATA 26, 26, 27, 12, 12, 26, 26, 26, 26, 26
       DATA 26, 26, 26, 26, 26, 16, 17, 12, 12, 19
       DATA 12, 21, 19, 14, 16, 17, 28, 12, 12, 16
       DATA 29, 30, 29, 13, 34, 31, 36, 32, 33, 35
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37

       REM  Maze movement masks

       DATA 0034,  0004,  0000,  0006,  0014,  0015,  0015,  1514,  0015,  0015
       DATA 0011,  0015,  0015,  0007,  0013,  3234,  0015,  0015,  0015,  0011
       DATA 0010,  0010,  0011,  0011,  0011,  0034,  0014,  0010,  0010,  0014
       DATA 0018,  0009,  0013,  0034,  0015,  0010,  0014,  0034,  0013,  0012
       DATA 1618,  0015,  0010,  0005,  0015,  0010,  0009,  0011,  0010,  0000
       DATA 0034,  0010,  0010,  0010,  0010,  0014,  0000,  0018,  0016,  0034
       DATA 0015,  0013,  0014,  0010,  0010,  0015,  0014,  0014,  0015,  0015
       DATA 0003,  0009,  0011,  0011,  0011,  0011,  0014,  0010,  0010,  0018
       DATA 0010,  0015,  0018,  0005,  0012,  0011,  0011,  0010,  0010,  0009
       DATA 0004,  0001,  0006,  0010,  0010,  0011,  0011,  0011,  0008,  0032
       DATA 0018,  0018,  0018,  0018,  0018,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0018,  0018,  0018,  0018,  0009

       REM  Thing locations

       DATA 3,  3,  3,  3, 59, 69, 45,  0,  0,  0
       DATA 0,  0, 28, 44, 49,  0, 95, 33,  0,  0

12150  END
