#!/usr/bin/env python

"""
Advent Python Framework

Usage: advent.py -d 

The '-d'  option is used to enable debugging

The '-n <pos>' specifies the starting maze position
"""

import sys
import getopt
import string
import random
import game


#----------------------------------------------------------------------------

def main():
   try:
      opts, args = getopt.getopt(sys.argv[1:], "dn:v")
   except getopt.error, msg:
      print __doc__,
      return 1

   global posn 

   posn   = 3

   for o, a in opts:
      if o == '-p':
         posn = string.atoi(a)

   if args:
      for arg in args:
         show(arg)
   else:
      show(".")

   random.seed(None)

   game.go()

#----------------------------------------------------------------------------

def show(str):
   print str

#----------------------------------------------------------------------------

if __name__ == '__main__' or __name__ == sys.argv[0]:
    sys.exit(main())


#----------------------------------------------------------------------------

