/*
 *      Author:  Peter Harding  <plh@pha.com.au>
 *               P. O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  820 1261
 *               Fax:     (03)  578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [1.3.0] advent.c 17/08/2002";


//------------------------------------------------------------------------------

#include "config.h"

#include <stdio.h>
#include <errno.h>

#ifdef MAC
#include <console.h>
#include <stdlib.h>
#include <unix.h>
#endif MAC

#ifdef UNIX
#include  <signal.h>
#include  <setjmp.h>
#endif UNIX


#include "misc.h"
#include "global.h"
#include "advent.h"
#include "move.h"
#include "command.h"
#include "objects.h"
#include "objectGlobals.h"
#include "error.h"


//------------------------------------------------------------------------------

#define PRINCE          "Prince"
#define PRINCESS        "Princess"


//------------------------------------------------------------------------------

extern int
	errno;        //  Standard error return.

extern CMD_LINE
	*getReply();  // from command.c

extern void
	doAction();   // from functions.c?


//------------------------------------------------------------------------------

#ifdef     UNIX
jmp_buf
	env;

int
	pid, status;


void intr0(sig)
int  sig;
{
	signal(sig, intr0);
	longjmp(env, 0);
}	/* intr0 */


void intr1(sig)
int  sig;
{
	signal(sig, intr1);
	fflush(stdout);
	clearScreen();
	longjmp(env, 1);
}	/* intr1 */
#endif  /* UNIX */


//------------------------------------------------------------------------------

void initializeGame(void)
{
	int
		randVal;

	BOOLEAN
		asking;

	char
		reply[STR16];

	// clearScreen();

	titleStr(stdout, "A*d*v*e*n*t*u*r*e", SC_CENTRE);

	randomize();

	here      = 7;
	itemLimit = ITEM_LIMIT;
	asking    = _TRUE;

	while (asking) {
		// gotoXY(10, 0);

		fprintf(stdout, "Are you a boy or a girl ? ");

		// clearEoL();

		gets(reply);

		if (equivString("Boy", reply)) {
			asking  = FALSE;
			partner = PRINCESS;
		} else if (equivString("Girl", reply)) {
			asking  = FALSE;
			partner = PRINCE;
		} else
			fprintf(stdout, "\n\nPlease answer 'boy' or 'girl'\n");
	}

	if ((randVal = ran(3)) == 0)
		magicWord = "Xyzzy";
	else if (randVal == 1)
		magicWord = "Renob";
	else if (randVal == 2)
		magicWord = "Cigam";
	
	if (prompt("Are you ready to start? [%c] ", YES) == YES)
		fprintf(stdout, "Good, then off we go\n");
	else
		fprintf(stdout, "Why not then? -- we'll start without you!\n");
}	/* initializeGame */


//------------------------------------------------------------------------------

void play(void)
{

	CMD_LINE
		*cmd;

	loop = _TRUE;

	showLocation(here);

	while (loop == _TRUE) {
#ifdef     UNIX
		signal(SIGINT, intr1);
		setjmp(env);
#endif  /* UNIX */
		cmd = getReply();

		doAction(cmd);

		if ( showMap )
			map();

		if (debugFlg)
			debugLocn();

		if (here >= 25) {
			int
				picker;

			if ((picker = ran(10)) == 10)
				pirate();
			else if (picker > 7)
				dwarf();
		}
	}
}	/* play */


//------------------------------------------------------------------------------

int main(int argc,  char *argv[])
{
	int
		i,
		noWords;

#ifdef     MAC
	console_options.nrows = SC_LENGTH;
	console_options.ncols = SC_WIDTH;
	cshow(stdout);
#endif  /* MAC */

#ifdef     UNIX
	signal(SIGINT, intr0);
	readTermcap();
	setjmp(env);
#endif  /* UNIX */

	initializeGame();
	play();
	calcScores();
}	/* main */


//------------------------------------------------------------------------------

