       REM
       REM      ########## APPLE II ADVENTURE ##########
       REM
       REM      ***** Arrays *****
       REM
       REM      D1      Direction
       REM      M1      Maze descriptor
       REM      T       Thing location
       REM      M3      Maze modifier
       REM      P1      Holding thing
       REM      T$      Thing name
       REM
       REM      ***** OTHERS *****
       REM
       REM      B1      Drawbridge #
       REM      B2      Black knight #
       REM      B3      Break #
       REM      C1      Thing count
       REM      D2      Dwarf about #
       REM      D3      Dwarf count
       REM      D4      Dwarf here #
       REM      D5      Dragon #
       REM      D5      Dir
       REM      F1      Frog #
       REM      F2      Fine #
       REM      H1      Help
       REM      K1      Killed
       REM      L1      Look #
       REM      L2      Location
       REM      L3      Lantern lit #
       REM      L4      Lantern dim #
       REM      M$      Magic word
       REM      N1      No light #
       REM      N2      Pirate gone #
       REM      N3      No axe #
       REM      O1      Oil level
       REM      P2      Pit count
       REM      P3      Holding count
       REM      P4      Final score
       REM      S1      Shadowy figure #
       REM      S2      Shadow count
       REM      S3      Say #
       REM      T0      Thing limit
       REM      T1      Test 1
       REM      T2      Test 2
       REM      T3      Test 3
       REM      V1      Moves made
       REM      Z0      Zero
       REM      Z1      Posn in maze
       REM      Z2      New maze posn
       REM
       REM      ( NOTE: '#' -- Used as a flag. )
       REM
       REM      **********  Declare arrays.
       REM      **********  Declare arrays.
       DIM M1( 200 ), D1( 200 ), D2( 200 ), T( 20 ), D( 6 ), M3( 2 ), P1( 20 ), T$( 20 )
       REM      **********  Define names of things.
       T$( 1 ) = "Keys"
       T$( 2 ) = "Lantern"
       T$( 3 ) = "Food"
       T$( 4 ) = "Bottle"
       T$( 5 ) = "Water"
       T$( 6 ) = "Oil"
       T$( 7 ) = "Rope"
       T$( 8 ) = "Book"
       T$( 9 ) = "Carpet"
       T$( 10 ) = "Statue"
       T$( 11 ) = "Axe"
       T$( 12 ) = "Sword"
       T$( 13 ) = "Wand"
       T$( 14 ) = "Silver"
       T$( 15 ) = "Diamonds"
       T$( 16 ) = "Emerald"
       T$( 17 ) = "Crown"
       T$( 18 ) = "Treasure"
       M3( 1 ) = 16
       REM      **********  Define flag values.
       A0 = 99
       Z0 = 0
       REM      **********  Setup arrays which define maze structure.
       FOR I = 1 TO 200
       READ M1( I )
       NEXT I
       FOR I = 1 TO 200
       READ D1( I )
       D2( I ) = D1( I )
       NEXT I
       FOR I = 1 TO 20
       READ  T( I )
       NEXT I
       FOR I = 1 TO 20
       P1( I ) = Z0
       NEXT I
       REM      **********  Start of main program.

  940  PRINT "Are you a Boy or Girl ";
       GOSUB 11290
       IF C1$ = "Boy" OR C1$ = "Girl" THEN GOTO 1000
       PRINT ""
       PRINT "Please answer Boy or Girl !"
       GOTO 940

 1000  IF C1$ = "Boy" THEN P$ = "Princess"
       IF C1$ = "Girl" THEN P$ = "Prince"
       T$( 20 ) = P$
       M$ = "Xyzzy"
       IF INT( 99 * RND ) > 66 THEN M$ = "Cigam"
       IF INT( 99 * RND ) > 66 THEN M$ = "Renob"
       PRINT "                      *** ADVENTURE ***"
       PRINT ""
       PRINT ""
       REM      **********  Initialize miscelaneous values.
       T0 = 6
       Z1 = 8
       GOTO 4180

       REM      **********  Shadowy figure.
 1140  IF N2 <> Z0 THEN GOTO 1440
       IF S1 > Z0 THEN GOTO 1180
       IF INT( 99 * RND ) < 96 THEN GOTO 1440
       S1 = A0
 1180  PRINT ""
       PRINT "A shadowy figure is following you!"
       PRINT ""
       FOR I = 20 TO 7 STEP  - 1
       IF P1( I ) <> Z0 AND S2 > INT( 13 * RND ) + 7 THEN GOTO 1260
       NEXT I
       S2 = S2 + 1
       GOTO 1440

 1260  PRINT "The shadow leaps out of the darkness."
       PRINT ""
       PRINT "'Har har', cries a bearded pirate, 'me thinks me will take a littlle of"
       PRINT "yur booty!'"
       PRINT ""
       IF I <> 20 THEN GOTO 1340
       C$ = P$
       GOTO 1350

 1340  C$ = T$( I )
 1350  GOSUB 10890
       PRINT "That "; L$; " will do just fine!"
       PRINT ""
       PRINT "With that he scurries off to his treasure cave!!!!"
       PRINT ""
       P1( I ) = Z0
       T( I ) = 33
       N2 = A0
       P3 = P3 - 1
 1440  RETURN

       REM      **********  Dwarf.
 1460  PRINT ""
       IF D2 <> Z0 THEN GOTO 1530
       PRINT "An angry dwarf came in, threw a little axe which missed, cursed and ran"
       PRINT "away!"
       T( 11 ) = Z1
       D2 = A0
       GOTO 4360

 1530  IF D2 <> Z0 THEN D3 = D3 + 2
       D4 = A0
       PRINT "There's an angry dwarf in the room with you!  He throws a single knife"
       PRINT ""
       IF INT( D3 * RND ) > 4 THEN GOTO 1600
       PRINT "It misses!"
       GOTO 4360

 1600  PRINT "It hits you!"
       K1 = K1 + 1
       IF K1 = 2 THEN  GOTO 10120
       GOTO 4360

       REM      **********  Display things.
 1650  PRINT ""
       IF T( 1 ) = Z1 THEN PRINT "There's a set of keys here!"
       IF T( 2 ) = Z1 THEN PRINT "A lantern rests here!"
       IF T( 3 ) = Z1 THEN PRINT "There is tasty food here!"
       IF T( 4 ) = Z1 THEN PRINT "A small bottle is lying here!"
       IF T( 5 ) = Z1 THEN PRINT "There is much water here!"
       IF T( 6 ) = Z1 THEN PRINT "A small pool of oil is here!"
       IF T( 7 ) = Z1 THEN PRINT "A useful hemp rope is coiled here!"
       IF T( 8 ) = Z1 THEN PRINT "There is an ancient book on the ground!"
       IF T( 9 ) = Z1 THEN PRINT "There is a tiny marble statue in the corner."
       IF T( 10 ) = Z1 THEN PRINT "There is a persian carpet lying on the ground
       IF T( 11 ) = Z1 AND N3 = Z0 THEN PRINT "A little axe is here!"
       IF T( 12 ) = Z1 THEN PRINT "A golden sword lies here!"
       IF T( 13 ) = Z1 THEN PRINT "A magic wand floats in mid air!"
       IF T( 14 ) = Z1 THEN PRINT "Seven bars of silver lie here!"
       IF T( 15 ) = Z1 THEN PRINT "Many diamonds are scattered here!"
       IF T( 16 ) = Z1 THEN PRINT "A pea-sized emerald falls to the floor!"
       IF T( 17 ) = Z1 THEN PRINT "There's a king's crown here!"
       IF T( 18 ) = Z1 THEN PRINT "There's a pirate's treasure chest here!"
       IF P1( 20 ) = Z0 THEN GOTO 1870
       PRINT "The "; P$; " is still by your side."
       GOTO 1880

 1870  IF T( 20 ) = Z1 THEN PRINT "A "; P$; " patiently waits here!"
 1880  L1 = A0
       GOTO 4430

       REM      **********  Display scenes.
 1910  PRINT "You are inside a building, a safe place to store treasures."
       GOTO 8320

 1930  PRINT "You are on a very nicely groomed path."
       GOTO 8320

 1950  PRINT "You are in the forest."
       IF Z1 <> 15 THEN GOTO 8320
       IF B2 <> Z0 THEN GOTO 2020
       PRINT ""
       PRINT "A black knight in full iron armour is standing before you."
       PRINT "He is carrying a golden sword."
       GOTO 8320

 2020  PRINT "An iron statue of a black knight stands in front of you."
       GOTO 8320

 2040  PRINT "You are in a dried up stream bed of a once great river."
       GOTO 8320

 2060  PRINT "You are at the bottom of a climbable pit.  A small stream flows across"
       PRINT "the floor of the pit."
       GOTO 8320

 2090  PRINT "You are in a beautiful forest carrying the sounds of many animals"
       GOTO 8320

 2110  PRINT "You are at the entrance of a small cave.  A 3x3 iron grate keeps you"
       PRINT "from going down to where it looks like the cave opens up."
       GOTO 8320

 2140  PRINT "You are inside the cave entrance.  It is a good sized passage and  easy"
       PRINT "to walk in."
       GOTO 8320

 2170  PRINT "You are at the edge of a pit.  You can climb down but you might not be"
       PRINT "able to climb back up again."
       GOTO 8320

 2200  PRINT "You are in an old mine shaft that extends vertically in both directions"
       GOTO 8320

 2220  PRINT "You are standing beside a large sign flashing '"; M$; "'!"
       S3 = A0
       GOTO 8320

 2250  PRINT "You are traveling in a east-west tunnel."
       GOTO 8320

 2270  PRINT "You are walking in a east-west corridor."
       GOTO 8320

 2290  PRINT "You're in a large north-south passage."
       GOTO 8320

 2310  PRINT "You are in a small north-south cave."
       GOTO 8320

 2330  PRINT "You are in a room that connects to an alternate passage."
       GOTO 8320

 2350  PRINT "You are at an intersection of three corridors."
       GOTO 8320

 2370  PRINT "You are at the brink of an easily climbable pit."
       GOTO 8320

 2390  PRINT "You are at the bottom of a narrow shaft.  You could climb up but not"
       PRINT "back down."
       GOTO 8320

 2420  PRINT "You're in an enormous chamber of solid granite.  Exits lead in many"
       PRINT "directions."
       GOTO 8320

 2450  PRINT "You're in a cave of many exits."
       GOTO 8320

 2470  PRINT "You're in a beautiful cavern.  In the center of the cavern is a huge"
       PRINT "hole.  I think I hear the sound of water?"
       GOTO 8320

 2500  S$ = "a small crack"
       IF INT( 99 * RND ) > 50 THEN S$ = "a narrow tunnel"
       PRINT "You climb thru "; S$; " only to find that........"
       PRINT ""
       Z1 = Z1 - 7
       GOTO 4360

 2560  PRINT "You are in a spendid chamber decorated with strands of multi-coloured"
       PRINT "thread."
       GOTO 8320

 2590  Z1 = Z1 - 5
       GOTO 4180

 2610  S$ = "little, twisty"
       IF INT( 99 * RND ) > 50 THEN S$ = "twisty, litle"
       PRINT "You are in a "; S$; " maze!"
       GOTO 8320

 2650  PRINT "You are at a complex junction of three forks.  Obvious paths lead  east"
       print "and west."
       GOTO 8320

 2680  PRINT "You are at the dragon's lair.  His job is to protect the magic castle"
       PRINT "which lies to the south.  ";
       S$ = "refuses to let you enter."
       IF D5 <> Z0 THEN S$ = "lies dead off to one side."
 2720  PRINT "The dragon "; S$
       GOTO 8320

 2740  PRINT "You're in a small stone chamber of the magic castle."
       PRINT ""
       IF F1 <> Z0 THEN GOTO 8320
       PRINT "A small green frog happily hops to and fro across the floor of the"
       PRINT "chamber!"
       GOTO 8320

 2800  PRINT "You are standing on one side of a large moat that surrounds the castle"
       PRINT "You cannot jump or swim across."
       PRINT ""
       IF B1 <> Z0 THEN PRINT "The drawbridge is lowered to cross."
       GOTO 8320

 2850  PRINT "You are in the west hall of the magic castle.  Your footsteps echo"
       PRINT "endlessly."
       GOTO 8320

 2880  PRINT "You're in the eastern hall of the magic castle."
       GOTO 8320

 2900  PRINT "You are in a room where a bed is made from twelve matresses."
       IF P1( 17 ) <> Z0 THEN D1( 99 ) = 0010
       GOTO 8320

 2930  PRINT "Shhhh....you are in the king's chamber.  I think he's asleep."
       GOTO 8320

 2950  PRINT "The floor you were standing on has given way...you fall..and fall...and"
       PRINT "fall.....finally landing on solid ground................."
       Z1 = Z1 + 50
       GOTO 4180

 2990  PRINT "Welcome to the magic castle.  Although our ruler( King Dumb ) is stupid"
       PRINT "I hope you enjoy your visit."
       GOTO 8320

 3020  PRINT "You are in the castle dungeons."
       GOTO 8320

 3040  IF C2$ <> P$ THEN GOTO 3060
       IF P1( 20 ) <> Z0 OR T( 20 ) = Z1 THEN GOTO 3100
 3060  IF T2 <> Z0 THEN GOTO 6650
       IF T2 <> Z0 THEN GOTO 6650
       IF Z1 <> 93 AND Z1 <> 91 THEN GOTO 7880
       IF C2$ <> "Frog" AND C2$ <> P$ THEN GOTO 7840
 3100  IF C2$ = "Frog" THEN GOTO 3220
       IF T( 20 ) <> Z1 THEN GOTO 7880
       PRINT "The "; P$; " disappears in a puff of blue smoke............."
       PRINT ""
       PRINT "A small green frog leaps from the smoke and hurriedly hops off into"
       PRINT "the murky darkness of the chamber!"
       PRINT ""
       F1 = Z0
       T( 20 ) = Z0
       P1( 20 ) = Z0
       F3 = A0
       GOTO 4410

 3220  IF F3 <> Z0 THEN GOTO 6650
       PRINT "The room is filled with blue smoke and when the smoke clears......"
       PRINT ""
       F1 = A0
       T( 20 ) = Z1
       GOTO 1650

 3280  PRINT "The "; P$; " refuses to go by force!"
       GOTO 4410

 3300  PRINT "The "; P$; " accepts your offer and will walk by your side!"
       P1( 20 ) = A0
       T( 20 ) = Z0
       GOTO 4410

 3340  P1( 20 ) = Z0
       T( 20 ) = Z1
       L1 = Z0
       GOTO 1650

 3380  PRINT "They are too heavy to carry!"
       GOTO 4410

       REM      **********  Help.
 3410  H1 = H1 + 1
       IF H1 < INT( H1 * RND ) + H1 OR H1 < 2 AND P1( 2 ) <> Z0 THEN GOTO 3460
       PRINT "The wizard says, 'Quit bothering me!'."
       IF H1 > 2 THEN GOTO 3560
       GOTO 4410

 3460  IF N1 = A0 AND H1 < 4 THEN GOTO 3480
       GOTO 7720

 3480  PRINT ""
       PRINT "The wizard of 'ADVENTURE' will light your way for 25 moves!"
       N1 = Z0
       L3 = A0
       O1 = O1 + 25
       V1 = 225
       L1 = Z0
       GOTO 4180

 3560  PRINT ""
       PRINT "'I, the wizard of 'ADVENTURE', have given you enough warnings!!'"
       PRINT ""
       PRINT "Now you will suffer this fate....."
       PRINT ""
       PRINT "The wizard turns you into stone!!!!"
       P2 = P2 + 1
       PRINT ""
       IF P2 > 1 THEN GOTO 10460
       GOTO 10120

       REM      **********  Some events.
 3670  IF D4 <> Z0 OR  Z1 = 91 OR  Z1 = 93 OR P1( 20 ) <> Z0 OR  Z1 = 87 OR C2$ = "Myself" OR C2$ = "Me" OR C2$ = "Knight" THEN GOTO 3710
       IF T2 <> Z0 THEN GOTO 7840
       GOTO 7880

       REM      **********  The P$.
 3710  IF C2$ = "Me" OR C2$ = "Myself" THEN GOTO 3740
       PRINT "With what?  Your bare hands?"
       GOTO 4410

 3740  PRINT "Are you sure that you want me to put an end to your miserable life!"
       PRINT ""
       PRINT "Well";
       GOSUB 11290
       IF LEFT$( C1$, 1 ) = "Y" OR LEFT$( C1$, 1 ) = "N" THEN GOTO 3830
       PRINT ""
       PRINT "Please answer ( Yes or No ) !!!!!"
       PRINT ""
       GOTO 3740

 3830  IF LEFT$( C1$, 1 ) = "Y" THEN GOTO 10120
       PRINT "Ok!"
       GOTO 4360

 3860  IF Z1 <> 91 AND Z1 <> 93 THEN GOTO 7880
       PRINT "The frog hops just out of your reach. It seems impossible to catch him"
       GOTO 4410

 3890  IF D5 <> Z0 THEN GOTO 6390
       IF P1( 11 ) = Z0 THEN GOTO 9600
       PRINT "The dragon dodges out of the way and promptly sits upon the axe where"
       PRINT "you cannot get it!"
       N3 = A0
       P1( 11 ) = Z0
       T( 11 ) = 87
       P3 = P3 - 1
       GOTO 4410

 3980  PRINT "The dragon is sitting on it!"
       GOTO 4410

 4000  IF P1( 12 ) <> Z0 THEN GOTO 4030
       PRINT "You have nothing that can kill it!"
       GOTO 4410

 4030  PRINT "The golden sword strikes home!"
       N3 = Z0
       L1 = Z0
       D1( 87 ) = 0015
       D5 = A0
       GOTO 4180

 4090  PRINT "The water quickly rusts the armor and turns the knight into an "
       PRINT "iron statue.  He drops the golden sword."
       P1( 5 ) = Z0
       T( 12 ) = 15
       P3 = P3 - 1
       B2 = A0
       L1 = Z0
       GOTO 1650

       REM      **********  Check light.
 4180  IF INT( 99 * RND ) > 92 AND Z1 > 25 THEN GOTO 1460
       IF V1 > 200 AND L4 = Z0 THEN GOTO 4330
       IF V1 > 250 AND N1 = Z0 THEN GOTO 4220
       GOTO 4250

 4220  PRINT ""
       PRINT "Your lantern has run out of fuel!"
       N1 = A0
 4250  IF N1 = Z0 THEN GOTO 4270
       L3 = Z0
 4270  IF M1( Z1 ) <> 3 AND Z1 < 25 THEN GOTO 4360
       IF L3 <> Z0 THEN GOTO 4360
       PRINT ""
       PRINT "It is pitch dark!  If you proceed you will most likely fall into a pit"
       IF INT( 99 * RND ) > 85 THEN GOTO 10080
       GOTO 4410

 4330  PRINT ""
       PRINT "Your lantern is getting very dim!  I would look for a source of oil"
       L4 = A0
 4360  PRINT ""
       IF M1( Z1 ) > 20 THEN GOTO 4390
       ON M1( Z1 ) GOTO 1910,1930,1950,2040,2060,2090,2110,2140,2170,2200,2220,\
                        2250,2270,2290,2310,2330,2350,2370,2390,2420
 4390  ON M1( Z1 ) - 20 GOTO 2450,2470,2500,2560,2590,2610,2650,2680,2740,2800,\
                        2850,2880,2900,2930,2950,2990,3020

       REM      **********  Input next command.
 4410  IF L1 <> Z0 THEN GOTO 4430
       IF Z1 = 3 OR L3 <> Z0 THEN GOTO 1650
 4430  PRINT ""
       PRINT "What is your command";
       GOSUB 11290
       IF C1$ = "" THEN GOTO 7640
       REM      **********  Make the next move.
       V1 = V1 + 1
       IF P1( 20 ) <> Z0 THEN T( 20 ) = Z1
       N = Z0
       E = Z0
       S = Z0
       W = Z0
       U = Z0
       D = Z0
       IF LEN( C1$ ) > 1 THEN GOTO 4920
       REM      **********  Check for directional move.
 4580  IF LEFT$( C1$, 1 ) <> "N" THEN GOTO 4620
       Z2 = Z1 - 5
       N = 1
       GOTO 4820

 4620  IF LEFT$( C1$, 1 ) <> "E" THEN GOTO 4660
       Z2 = Z1 + 1
       E = 1
       GOTO 4820

 4660  IF LEFT$( C1$, 1 ) <> "S" THEN GOTO 4700
       Z2 = Z1 + 5
       S = 1
       GOTO 4820

 4700  IF LEFT$( C1$, 1 ) <> "W" THEN GOTO 4740
       Z2 = Z1 - 1
       W = 1
       GOTO 4820

 4740  IF LEFT$( C1$, 1 ) <> "U" THEN GOTO 4780
       Z2 = Z1 - 25
       U = 1
       GOTO 4820

 4780  IF LEFT$( C1$, 1 ) <> "D" THEN GOTO 4920
       Z2 = Z1 + 25
       D = 1
       GOTO 4820

 4820  IF Z2 < 1 OR Z2 > 200 GOTO 7740
       N0 = ( D1( Z1 ) - INT( D1( Z1 ) / 100 ) * 100 )
       GOSUB 11660
       IF LEFT$( C1$, 1 ) <> "D" THEN GOTO 7950
       FOR I = 1 TO 2
       IF M3( I ) = Z1 THEN GOTO 4900
       NEXT I
       GOTO 7950

 4900  PRINT "It is locked!"
       GOTO 4410

 4920  IF C1$ <> "Walk" AND C1$ <> "Crawl" AND C1$ <> "Jump" \
                        AND C1$ <> "Run" THEN GOTO 4990
       IF LEN( C2$ ) <> Z0 THEN GOTO 4960
       PRINT C1$; " where";
       GOSUB 11440
 4960  IF C2$ <> "North" AND C2$ <> "East" AND C2$ <> "South" \
                         AND C2$ <> "West" AND C2$ <> "Up" \
                         AND C2$ <> "Down" THEN GOTO 7840
       C1$ = C2$
       GOTO 4580

 4990  IF C1$ = "North" OR C1$ = "South" OR C1$ = "East" \
                        OR C1$ = "West" OR C1$ = "Down" \
                        OR C1$ = "Up" THEN GOTO 4580
       REM      **********  Interpret non-directional commands.
 5010  GOSUB 11540
       IF C1$ <> "Look" THEN GOTO 5060
       L1 = Z0
       PRINT "I'm not allowed to give more detail!"
       GOTO 4180

 5060  IF C1$ <> "Exit" AND C1$ <> "Enter" THEN GOTO 5180
       IF Z1 = 3 OR  Z1 = 8 THEN GOTO 5090
       GOTO 7780

 5090  IF Z1 = 8 THEN GOTO 5130
       IF C1$ <> "Exit" THEN GOTO 7740
       Z1 = 8
       GOTO 4180

 5130  IF C1$ <> "Enter" THEN GOTO 7740
       Z1 = 3
       PRINT "You walk thru a wooden door....."
       GOTO 4180

       GOTO 7740

 5180  IF C1$ = "Inven" OR C1$ = "Inventory" THEN GOTO 8950
       IF C1$ = "Get" THEN GOTO 9110
       IF C1$ <> "Light" AND C1$ <> "Lite" THEN GOTO 5340
       IF N1 <> Z0 THEN GOTO 5240
       IF LEN( C2$ ) <> Z0 THEN GOTO 5270
       GOTO 7640

 5240  IF N1 = Z0 THEN GOTO 5270
       PRINT "Your lantern is out of oil!"
       GOTO 4180

 5270  IF C2$ <> "Lantern" THEN GOTO 7840
       IF P1( 2 ) = Z0 THEN GOTO 5320
       L3 = A0
       PRINT "Your lantern is lit!"
       GOTO 4180

 5320  PRINT "You don't have a lantern!"
       GOTO 4410

 5340  IF C1$ <> "Quit" AND C2$ <> "Quit" THEN GOTO 5460
       PRINT ""
       PRINT "Do you really want to quit";
 5370  GOSUB 11290
       IF LEFT$( C1$, 1 ) = "Y" OR LEFT$( C1$, 1 ) = "N" THEN GOTO 5440
       PRINT "Answer the question!!!( Yes or No )"
       PRINT ""
       PRINT ""
       PRINT "Do you want to quit?";
       GOTO 5370

 5440  IF LEFT$( C1$, 1 ) = "Y" THEN GOTO 10460
       GOTO 4180

 5460  IF C1$ = "Drop" THEN GOTO 9600
 5470  IF C1$ <> "Say" THEN GOTO 5530
       IF S3 <> Z0 THEN GOTO 9930
       IF LEN( C2$ ) = Z0 THEN GOTO 9070
 5500  PRINT ""
       PRINT "Okay, '"; C2$; "'!"
       GOTO 4410

 5530  IF C1$ <> "Open" AND C1$ <> "Unlock" THEN GOTO 5760
       IF C2$ <> "Sesame" THEN GOTO 5660
       IF O2 <> Z0 THEN GOTO 5610
       O2 = A0
       FOR I = 1 TO 200
       D2( I ) = D1( I )
       NEXT I
       GOTO 4410

 5610  O2 = Z0
       FOR I = 1 TO 200
       D1( I ) = D2( I )
       NEXT I
       GOTO 4410

 5660  IF P1( 1 ) <> Z0 THEN GOTO 5690
       PRINT "You have no keys!"
       GOTO 4410

 5690  FOR I = 1 TO 2
       IF Z1 = M3( I ) THEN GOTO 5730
       NEXT I
       GOTO 7780

 5730  M3( I ) = Z0
       PRINT "The keys have "; L1$; "ed it!"
       GOTO 4410

 5760  IF C1$ <> "Abracadbra" THEN GOTO 5900
       IF A1 <> Z0 THEN GOTO 5860
       A1 = A0
       T0 = 20
       GOTO 4410

       A1 = Z0
       T0 = 6
       FOR I = 20 TO 3 STEP -1
       IF P3 <= T0 THEN GOTO 4410
       IF P1( I ) = Z0 THEN GOTO 5880
 5860  P1( I ) = 0
       T( I ) = INT( 100 * RND ) + 1
 5880  NEXT I
       GOTO 4410

 5900  IF C1$ <> "*scan" AND C1$ <> "*s" THEN GOTO 6060
       IF C2$ <> "Thing" AND C2$ <> "T" THEN GOTO 6000
       PRINT ""
       PRINT ""
       PRINT "Locations of Things you are not holding."
       PRINT ""
       FOR I = 1 TO 20
       IF P1( I ) = Z0 THEN PRINT I, T$( I ), T( I )
       NEXT I
       GOTO 4410

 6000  IF C2$ <> "Location" AND C2$ <> "Loc" THEN GOTO 7640
       PRINT ""
       PRINT ""
       PRINT "Maze position is "; Z1, "Location descriptor is "; M1( Z1 )
       PRINT ""
       GOTO 4410

 6060  IF C1$ <> "*goto" AND C1$ <> "*g" THEN GOTO 6120
       IF LEN( C2$ ) = Z0 THEN GOTO 9070
       L1 = Z0
       X = VAL( C2$ )
       IF X > 0 AND X <= 200 THEN Z1 = X
       GOTO 4180

 6120  IF C1$ <> "Drink" THEN GOTO 6210
       IF LEN( C2$ ) = Z0 THEN GOTO 9070
       IF T1 = Z0 THEN GOTO 7640
       IF C2$ <> "Water" THEN GOTO 7900
       IF P1( 5 ) = 0 THEN GOTO 7920
       PRINT "Your water is gone!"
       P1( 5 ) = Z0
       P3 = P3 - 1
       GOTO 4410

 6210  IF C1$ <> "Eat" THEN GOTO 6320
       IF LEN( C2$ ) = Z0 THEN GOTO 9070
       IF T1 = Z0 THEN GOTO 7640
       IF T3 = Z0 THEN GOTO 7800
       IF I < 3 THEN GOTO 7900
       PRINT "Thanks, don't mind if I do!"
       PRINT ""
       PRINT "Your "; L2$; " was very tasty!"
       P1( I ) = Z0
       P3 = P3 - 1
       GOTO 4410

 6320  IF C1$ <> "Throw" THEN GOTO 6530
       IF C2$ <> "Axe" THEN GOTO 9600
       IF Z1 = 87 THEN GOTO 3890
       IF P1( 11 ) <> Z0 THEN GOTO 6390
       GOTO 9600

 6370  PRINT "There's nothing here to attack!"
       GOTO 4410

 6390  IF Z1 = 15 THEN GOTO 9600
       IF D4 = Z0 THEN GOTO 6370
       P1( 11 ) = Z0
       T( 11 ) = Z1
       P3 = P3 - 1
       S$ = "You missed!"
       IF INT( 99 * RND ) > 70 THEN GOTO 6470
       S$ = "You killed a little dwarf.  His body vanishes in a *POOF* of pink smoke!"
 6470  PRINT S$
       D3 = INT( 3 * RND ) + 1
       L1 = Z0
       PRINT ""
       D4 = Z0
       GOTO 4180

 6530  IF C1$ <> "Wave" AND C1$ <> "Shake" THEN GOTO 6680
       IF P1( 13 ) = Z0 OR  Z1 <> 92 OR C2$ <> "Wand" THEN GOTO 6580
       B1 = A0
       D1( 92 ) = 0005
       GOTO 4360

 6580  IF T2 <> Z0 THEN GOTO 6650
       GOTO 7800

 6600  D4 = Z0
       D3 = INT( 2 * RND ) + 1
       PRINT "The angry little dwarf sees the anger in the way that you "; L1$
       PRINT "your axe and promptly heads for the nearest exit."
       GOTO 4410

 6650  IF D4 <> Z0  AND C2$ = "Axe" THEN GOTO 6600
       PRINT "Nothing happens!"
       GOTO 4410

 6680  IF C1$ <> "Pay" THEN GOTO 6790
       IF P1( 15 ) <> Z0 THEN GOTO 6720
       PRINT "No money.. no book!"
       GOTO 4410

 6720  IF Z1 <> 170 THEN GOTO 7640
       PRINT "Thank you sir.  I hope you enjoy it!"
       P1( 8 ) = A0
       T( 8 ) = Z0
       P3 = P3 + 1
       F2 = A0
       GOTO 4410

 6790  IF C1$ <> "Give" THEN GOTO 6890
       IF P1( 5 ) <> Z0 AND Z1 = 145 AND C2$ = "Water" THEN GOTO 6840
       IF P1( 5 ) = Z0 THEN GOTO 9600
       GOTO 4410

       PRINT "Who are you going to give it to?"
 6840  PRINT "The old man drinks the water and walks off into the darkness!"
       P1( 5 ) = Z0
       P3 = P3 - 1
       M1( 145 ) = 28
       GOTO 4180

 6890  IF C1$ <> "Wet" THEN GOTO 7010
       IF P1( 5 ) <> Z0 THEN GOTO 6930
       PRINT "With what?  Spit? Sweat?"
       GOTO 7840

 6930  IF Z1 <> 157 THEN GOTO 7640
       PRINT "You slip and slide into........"
       PRINT ""
       P1( 5 ) = Z0
       D1( 157 ) = 0010
       P3 = P3 - 1
       Z1 = 159
       GOTO 4180

 7010  D4 = Z0
       IF C1$ <> "Read" OR P1( 8 ) = Z0 THEN GOTO 7060
       IF C2$ <> "Book" THEN GOTO 7840
       PRINT "The book reads, 'say magic word in the 'not same' maze!"
       GOTO 4410

 7060  IF C1$ = "Kill" THEN GOTO 3670
       IF C1$ <> "With" THEN GOTO 7120
       IF C2$ <> "Axe" THEN GOTO 7840
       C1$ = "Throw"
       C2$ = "Axe"
       GOTO 6320

 7120  IF C1$ <> M$ THEN GOTO 7160
       C2$ = M$
       C1$ = "Say"
       GOTO 5470

 7160  IF C1$ <> "Why" THEN GOTO 7190
       PRINT "Because I said so!  That's why!!!!"
       GOTO 4410

 7190  IF C1$ <> "You" AND C1$ <> "Your" AND C2$ <> "You" THEN GOTO 7220
       PRINT "If you don't like playing the game you can always 'Quit'!"
       GOTO 4410

 7220  IF C1$ <> "Find" THEN GOTO 7250
       PRINT "I cannot tell you where remote things are located!"
       GOTO 4410

 7250  IF C1$ = "Slay" AND C2$ = "Dragon" THEN GOTO 4000
       IF C1$ <> "Yes" THEN GOTO 7300
       IF Z1 = 15 OR  Z1 = 87 OR D4 <> Z0  THEN GOTO 7840
       PRINT "You seem unsure of that answer!"
       GOTO 4410

 7300  IF C1$ <> "Lift" THEN GOTO 7370
       IF LEN( C2$ ) = Z0 THEN GOTO 9070
       IF T2 = Z0 AND Z1 <> 99 THEN GOTO 7880
       IF C2$ <> "Matress" AND C2$ <> "Matresses" THEN GOTO 6650
       T( 16 ) = A0
       L1 = Z0
       GOTO 1650

 7370  IF C1$ = "Kiss" THEN GOTO 3040
       IF C1$ = "Please" AND T( 20 ) = Z1 THEN GOTO 3300
       IF C1$ = "Wait" AND P1( 20 ) <> Z0 THEN GOTO 3340
       IF C1$ = "Help" THEN GOTO 3410
       IF C1$ <> "Listen" THEN GOTO 7440
       PRINT "Slosh..boil..drip..spurt..squirt......"
       GOTO 4410

 7440  IF C1$ <> "Where" THEN GOTO 7470
       PRINT "I'm not really sure which way you're facing.  Try a compass heading."
       GOTO 4410

 7470  IF C1$ <> "What" AND C1$ <> "Who" AND C1$ <> "When" AND C1$ <> "How" THEN GOTO 7500
       PRINT "I refuse to answer on the grounds that it might incriminate me!"
       GOTO 4410

 7500  IF LEFT$( C1$, 1 ) <> "N" THEN GOTO 7530
       PRINT "Why must you always be so negative?"
       GOTO 4410

 7530  IF C1$ <> "Cause" AND C1$ <> "Because" THEN GOTO 7560
       PRINT "That answer stinks!"
       GOTO 4410

 7560  IF C2$ = "" THEN Q = A0
       C2$ = C1$
       IF T2 = Z0 THEN GOTO 7720
       REM      **********  Some miscelaneous messages.
       PRINT "What do you want to do with the "; L2$; "?"
       GOTO 4410

 7620  PRINT "You can't "; L1$; " "; L2$; "!"
       GOTO 4410

 7640  S$ = "I don't understand what you mean!"
       IF INT( 99 * RND ) > 50 THEN S$ = "What???"
       IF Q = Z0 THEN GOTO 7700
       PRINT "I'm not yet familiar with that word!"
       Q = Z0
       GOTO 4410

 7700  PRINT S$
       GOTO 4410

 7720  PRINT "Nothing happens!"
       GOTO 4410

 7740  S$ = "You do not seem to know where you're going!"
       IF RND > 0.5 THEN S$ = "You can't go that way!"
       PRINT S$
       GOTO 4410

 7780  PRINT "There's nothing here to "; L1$; "!"
       GOTO 4410

 7800  PRINT "You don't have that to "; L1$; "!"
       GOTO 4410

 7820  PRINT "You are already holding the "; L2$; "!"
       GOTO 4410

 7840  PRINT "C'mon, can't you be serious?"
       GOTO 4410

 7860  PRINT "You have nothing to "; L1$; "!"
       GOTO 4410

 7880  PRINT "I see no "; L2$; " here!"
       GOTO 4410

 7900  PRINT "I'm game.  Would you care to explain how?"
       GOTO 4410

 7920  PRINT "You have to get it first!"
       GOTO 4410

       REM      **********  Process directional moves.
 7950  IF M1( Z1 ) <> 6 THEN GOTO 8170
       IF N = Z0 THEN GOTO 8010
       N = Z0
       E = 1
       Z2 = Z1 + 1
       GOTO 8180

 8010  IF E = Z0 THEN GOTO 8060
       E = Z0
       S = 1
       Z2 = Z1 + 5
       GOTO 8190

 8060  IF S = Z0 THEN GOTO 8110
       S = Z0
       W = 1
       Z2 = Z1 - 1
       GOTO 8200

 8110  IF W = Z0 THEN GOTO 8170
       W = Z0
       N = 1
       Z2 = Z1 - 5
       GOTO 8170

       REM      **********  Check allowed directions.
 8170  IF N = 1 AND D( 1 ) = 1 THEN GOTO 8280
 8180  IF E = 1 AND D( 2 ) = 1 THEN GOTO 8280
 8190  IF S = 1 AND D( 3 ) = 1 THEN GOTO 8280
 8200  IF W = 1 AND D( 4 ) = 1 THEN GOTO 8280
       IF U = 1 AND D( 5 ) = 1 THEN GOTO 8280
       IF D = 1 AND D( 6 ) = 1 THEN GOTO 8280
       PRINT ""
       IF Z1 = 87 THEN GOTO 8260
       GOTO 7740

 8260  S$ = "refuses to let you pass!"
       GOTO 2720

 8280  Z1 = Z2
       L1 = Z0
       GOTO 4180

       REM      **********  Look around at nearby scenes.
 8320  N = Z0
       E = Z0
       S = Z0
       W = Z0
       U = Z0
       D = Z0
       IF V1 > 50 +  INT( 50 * RND ) THEN  GOSUB 1140
       N0 = INT( D1( Z1 ) / 100 )
       GOSUB 11660
       N = D( 1 )
       E = D( 2 )
       S = D( 3 )
       W = D( 4 )
       U = D( 5 )
       D = D( 6 )
 8470  IF N = Z0 THEN GOTO 8520
       L2 = Z1 - 5
       N = Z0
       PRINT "To the north is ";
       GOTO 8770

 8520  IF E = Z0 THEN GOTO 8570
       L2 = Z1 + 1
       E = Z0
       PRINT "Along the east is ";
       GOTO 8770

 8570  IF S = Z0 THEN GOTO 8620
       L2 = Z1 + 5
       S = Z0
       PRINT "Looking south is ";
       GOTO 8770

 8620  IF W = Z0 THEN GOTO 8680
       L2 = Z1 - 1
       W = Z0
       PRINT "Appearing westerly is ";
       GOTO 8770

       D1( I ) = 0063
 8680  IF U = Z0 THEN GOTO 8720
       L2 = Z1 - 25
       U = Z0
       GOTO 8770

 8720  IF D = Z0 THEN GOTO 8760
       L2 = Z1 + 25
       D = Z0
       GOTO 8770

 8760  GOTO 4410
 8770  ON M1( L2 ) GOTO 8780, 8800, 2020, 8820, 8470, 8840, 8860, 8890
 8780  PRINT "a small building."
       GOTO 8470

 8800  PRINT "a shallow valley."
       GOTO 8470

 8820  PRINT "a river bed"
       GOTO 8470

 8840  PRINT "a beautiful forest."
       GOTO 8470

 8860  PRINT ""
       PRINT "A cobble path leads up to the surface."
       GOTO 8470

 8890  PRINT ""
       PRINT "A cobble path leads down into the cave."
       PRINT ""
       IF M3( 1 ) = Z0 THEN PRINT "The grate is open."
       GOTO 8470

       REM      **********  Perform inventory.
 8950  PRINT ""
       PRINT "You are holding the following items:"
       PRINT ""
       X = Z0
       FOR I = 1 TO 19
       IF P1( I ) = Z0 THEN  9030
       PRINT T$( I )
       X = A0
       NEXT I
       IF X = Z0 THEN PRINT "Nothing!"
       GOTO 4410

       REM      **********  Ask for C2$.
 9070  PRINT C1$; " what";
       GOSUB 11440
       GOTO 5010

       REM      **********  Perform 'Get' and 'Drop'.
 9110  IF P3 <> T0 THEN GOTO 9140
       PRINT "You can't carry anything more.  You'll have to drop something first!"
       GOTO 4410

 9140  IF LEN( C2$ ) = Z0 THEN GOTO 9070
       IF T3 = A0 THEN GOTO 7820
       IF T2 <> Z0 THEN GOTO 9220
       IF C2$ = "Water" AND Z1 = 59 THEN GOTO 9220
       IF C2$ = "Frog" THEN GOTO 3860
       IF T( 20 ) = Z1 THEN GOTO 3280
       IF C2$ = "Matress" OR C2$ = "Matresses" THEN GOTO 3380
       GOTO 7880

 9220  IF C2$ <> "Water" OR T( 5 ) <> Z1 THEN GOTO 9310
       IF P1( 5 ) <> Z0 THEN GOTO 9290
       IF P1( 4 ) = Z0 THEN GOTO 9270
       P1( 5 ) = A0
       GOTO 9560

 9270  PRINT "You have nothing to carry the water in!"
       GOTO 4410

 9290  PRINT "You can't carry any more water!"
       GOTO 4410

 9310  IF C2$ <> "Oil" OR T( 6 ) <> Z1 THEN GOTO 9380
       PRINT "Your lantern is full again."
       T( 6 ) = Z0
       L4 = Z0
       O1 = V1
       V1 = 1
       GOTO 4410

 9380  IF C2$ = "Book" AND F2 = Z0 AND Z1 = 159 THEN GOTO 12150
       IF C2$ <> "Book" OR T( 8 ) <> Z1 THEN GOTO 9430
       P1( 8 ) = A0
       T( 8 ) = Z0
       GOTO 9560

 9430  IF C2$ <> "Treasure" OR T( 18 ) <> Z1 THEN GOTO 9500
       IF M3( 2 ) <> Z0 THEN GOTO 9480
       P1( 18 ) = A0
       T( 18 ) = Z0
       GOTO 9560

 9480  PRINT "It's locked!"
       GOTO 4410

 9500  IF C2$ <> "Axe" THEN GOTO 9520
       IF N3 <> Z0 THEN GOTO 3980
 9520  P1( I ) = A0
       T( I ) = Z0
       GOTO 9560

       GOTO 7880

 9560  PRINT "Ok!"
       P3 = P3 + 1
       GOTO 4410

       REM      **********  Drop things.
 9600  IF P3 <> Z0 THEN GOTO 9620
       GOTO 7860

 9620  IF LEN( C2$ ) = Z0 THEN GOTO 9070
       IF T3 <> Z0 THEN GOTO 9680
       IF C2$ = P$ THEN GOTO 3100
       IF T1 = Z0 THEN GOTO 7620
       PRINT "You are not carrying it!"
       GOTO 4410

 9680  IF C2$ <> "Lantern" THEN GOTO 9700
       L3 = Z0
 9700  IF C2$ <> "Bottle" THEN GOTO 9760
       IF P1( 5 ) = Z0 THEN GOTO 9870
       P1( 5 ) = Z0
       P3 = P3 - 1
       PRINT "The bottle tipped over and the water spilled out of the bottle!"
       GOTO 9880

 9760  IF C2$ <> "Statue" THEN GOTO 9860
       IF T( 9 ) = Z1 THEN GOTO 9820
 9780  PRINT "The statue falls and breaks worthlessly"
       P1( 12 ) = Z0
       T( 12 ) = Z0
       GOTO 9900

 9820  IF B3 <> Z0 THEN GOTO 9780
       PRINT "The statue lands safely on the persian rug."
       B3 = A0
       GOTO 9880

 9860  IF C1$ = "Throw" AND C2$ = "Water" AND Z1 = 15 AND B2 = Z0 THEN GOTO 4090
 9870  PRINT "Ok!"
 9880  P1( I ) = Z0
       T( I ) = Z1
 9900  P3 = P3 - 1
       GOTO 4410

       REM      **********  Magic words.
 9930  IF C2$ <> M$ THEN GOTO 5500
       IF Z1 <> 199 THEN GOTO 9980
       PRINT "A secret passage opens to the west!"
       D1( 199 ) = 0009
       GOTO 4410

 9980  IF Z1 <> 3 THEN GOTO 10010
       Z1 = 41
       GOTO 10030

10010  IF Z1 <> 41 THEN GOTO 10040
       Z1 = 3
10030  L1 = Z0
10040  IF Z1 = 3 OR  Z1 = 41 THEN GOTO 4180
       PRINT "Nothing happens!"
       GOTO 4410

       REM      **********  The pit.
10080  PRINT ""
       P2 = P2 + 1
       PRINT "You fell into a pit and are a mass of twisted flesh and bones."
       PRINT ""
10120  IF P2 > 1 THEN GOTO 10160
       PRINT ""
       PRINT "I might be able to reincarnate you!  Would you like me to try?"
       GOTO 10220

10160  PRINT "You've really done it this time.  I'm all out of fairy dust!"
       PRINT ""
       PRINT "You don't really expect me to do a decent reincarnation without it do"
       PRINT "you?"
       K1 = Z0
       D3 = Z0
10220  PRINT ""
       PRINT "Well";
       IF P2 > 1 THEN GOTO 10400
       GOSUB 11290
       IF LEFT$( C1$, 1 ) = "N" THEN GOTO 10460
       PRINT "Ready......one.two..three!  *POOF*"
       P2 = P2 + 1
       PRINT ""
       PRINT "You emerge from a cloud of fairy dust only to find yourself......."
       L1 = Z0
       FOR I = 1 TO 20
       IF P1( I ) = Z0 THEN GOTO 10360
       T( I ) = Z1
       IF I = 2 THEN T( 2 ) = 3
10360  NEXT I
       Z1 = 3
       P3 = Z0
       GOTO 4360

10400  GOSUB 11290
       IF LEFT$( C1$, 1 ) = "N" THEN GOTO 10460
       PRINT ""
       PRINT "Ok!  If you're so smart do it yourself!!"
       PRINT ""
       REM      **********  Calculate score.
10460  P4 = Z0
       FOR I = 1 TO 5
       IF T( I ) = 3 THEN P4 = P4 + 10
       NEXT I
       FOR I = 6 TO 13
       IF T( I ) = 3 THEN P4 = P4 + 20
       NEXT I
       FOR I = 14 TO 19
       IF T( I ) = 3 THEN P4 = P4 + 30
       NEXT I
       IF T( 20 ) = 3 THEN P4 = P4 + 50
       IF S3 <> Z0 THEN P4 = P4 + 50
       IF O1 <> Z0 THEN V1 = V1 + O1
       P4 = P4 - INT( V1 / 10 )
       PRINT ""
       PRINT "You scored "; P4 ; " points out of a possible 350, using"; V1 ; " turns!"
       PRINT ""
       G$ = "RANK BEGINNER"
       IF P4 > 50 THEN G$ = "NOVICE"
       IF P4 > 100 THEN G$ = "EXPERIENCED"
       IF P4 > 150 THEN G$ = "SEASONED"
       IF P4 > 200 THEN G$ = "JR. MASTER"
       IF P4 > 250 THEN G$ = "SR. MASTER"
       IF P4 > 300 THEN G$ = "MASTER"
       IF P4 = 350 THEN G$ = "WIZARD"
       PRINT "Your score qualifies you as a  *** '"; G$; "' ADVENTURER ***"
       PRINT ""
       FOR I = 50 TO 350 STEP 50
       IF I - P4 > Z0 THEN GOTO 10760
       NEXT I
10760  PRINT "To achieve the next higher rating you need "; I - P4 ; " more points!"
       GOTO 12150

10780  REM      **********  Convert upper case to lower case.
       D0 = ASCII( D$ )
       IF D0 < 65 OR D0 > 90 THEN RETURN
       D$ = CHR$( D0 + 32 )
       RETURN

10830  REM      **********  Convert lower case to upper case.
       D0 = ASCII( D$ )
       IF D0 < 97 OR D0 > 122 THEN RETURN
       D$ = CHR$( D0 - 32 )
       RETURN

       REM      **********  Convert string to lower case.
10890  D$ = ""
       IF LEN( C$ ) = Z0 THEN GOTO 10950
       D$ = LEFT$( C$, 1 )
       GOSUB 10780
       IF LEN( C$ ) = 1 THEN GOTO 10950
       D$ = D$ + RIGHT$( C$, LEN( C$ ) - 1 )
10950  L$ = D$
       RETURN

       REM      **********  Convert to capitalized first letter.
10980  C$ = ""
       L = LEN( W$ )
       IF L = Z0 THEN RETURN
       D$ = LEFT$( W$, 1 )
       GOSUB 10830
       C$ = D$
       IF L = 1 THEN RETURN
       FOR I = 2 TO L
       D$ = MID$( W$ , I, 1 )
       GOSUB 10780
       C$ = C$ + D$
       NEXT I
       RETURN

       REM      **********  Parse input string.
11120  IF R$ = "" THEN GOTO 11240
       L = LEN( R$ )
       IF L <> Z0 AND LEFT$( R$, 1 ) = " " THEN GOTO 11240
       FOR I = 1 TO L
       IF MID$( R$, I, 1 ) = " " THEN GOTO 11200
       NEXT I
       R2$ = ""
       GOTO 11220

11200  I = I - 1
       R2$ = MID$( R$, I + 2, L - I )
11220  R1$ = LEFT$( R$, I )
       RETURN

11240  R1$ = ""
       R2$ = ""
       L = Z0
       RETURN

       REM      **********  Input 1.
11290  INPUT R$
       PRINT ""
       GOSUB 11120
       W$ = R1$
       GOSUB 10980
       C1$ = C$
       GOSUB 10890
       L1$ = L$
       W$ = R2$
       GOSUB 10980
       C2$ = C$
       GOSUB 10890
       L2$ = L$
       RETURN

       REM      **********  Input 2.
11440  INPUT R$
       PRINT ""
       GOSUB 11120
       W$ = R1$
       GOSUB 10980
       C2$ = C$
       GOSUB 10890
       L2$ = L$
       RETURN

       REM      **********  Test
11540  T1 = Z0
       T2 = Z0
       T3 = Z0
       FOR I = 1 TO 19
       IF C2$ = T$( I ) THEN GOTO 11610
       NEXT I
       RETURN

11610  T1 = A0
       IF T( I ) = Z1 THEN T2 = A0
       IF P1( I ) <> Z0 THEN T3 = A0
       RETURN

       REM      **********  Decode directional data.
11660  FOR I = 1 TO 6
       Q = INT( N0 / 2 )
       D( I ) = N0 - 2 * Q
       N0 = Q
       NEXT I
       RETURN

       REM      **********  Data definition for maze.
       DATA  9,  3,  1,  3,  3,  6,  6,  2,  6,  6
       DATA  3,  6,  2,  2,  3,  7,  2,  2,  6,  3
       DATA  3,  4,  4,  4, 11,  9, 17, 12, 12, 17
       DATA 19, 16, 20, 18, 21, 12, 17, 22, 23, 16
       DATA  8, 21, 12, 14, 24, 12, 16, 17, 12, 23
       DATA  9, 13, 13, 13, 13, 13, 25, 26,  5,  9
       DATA 26, 26, 27, 12, 12, 26, 26, 26, 26, 26
       DATA 26, 26, 26, 26, 26, 16, 17, 12, 12, 19
       DATA 12, 21, 19, 14, 16, 17, 28, 12, 12, 16
       DATA 29, 30, 29, 13, 34, 31, 36, 32, 33, 35
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 37, 37, 37, 37, 37, 37, 37, 37, 37, 37
       DATA 0034,  0004,  0000,  0006,  0014,  0015,  0015,  1514,  0015,  0015
       DATA 0011,  0015,  0015,  0007,  0013,  3234,  0015,  0015,  0015,  0011
       DATA 0010,  0010,  0011,  0011,  0011,  0034,  0014,  0010,  0010,  0014
       DATA 0018,  0009,  0013,  0034,  0015,  0010,  0014,  0034,  0013,  0012
       DATA 1618,  0015,  0010,  0005,  0015,  0010,  0009,  0011,  0010,  0000
       DATA 0034,  0010,  0010,  0010,  0010,  0014,  0000,  0018,  0016,  0034
       DATA 0015,  0013,  0014,  0010,  0010,  0015,  0014,  0014,  0015,  0015
       DATA 0003,  0009,  0011,  0011,  0011,  0011,  0014,  0010,  0010,  0018
       DATA 0010,  0015,  0018,  0005,  0012,  0011,  0011,  0010,  0010,  0009
       DATA 0004,  0001,  0006,  0010,  0010,  0011,  0011,  0011,  0008,  0032
       DATA 0018,  0018,  0018,  0018,  0018,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063,  0063
       DATA 0063,  0063,  0063,  0063,  0063,  0018,  0018,  0018,  0018,  0009
       DATA 3,  3,  3,  3, 59, 69, 45,  0,  0,  0
       DATA 0,  0, 28, 44, 49,  0, 95, 33,  0,  0
12150  END
