#!/usr/bin/env python


#------------------------------------------------------------------------------

Scene = (
   "a gloomy grotto",
   "a small building",
   "a nicely groomed path",
   "a great and eerie forest",
   "the dried up bed of a once great river",
   "the bottom of a climable pit",
   "a beautiful forest",
   "the entrance of a small cave",
   "the cave enterance",
   "the edge of a pit",
   "an old mine shaft",
   "a misty passage",
   "an east-west tunnel",
   "an east-west corridor",
   "a large north-south passage",
   "a small north-south cave",
   "a room that connects to an alternating passage",
   "the intersection of three corridors",
   "the brink of an easily climable pit",
   "the bottom of a narrow shaft",
   "an enormous chamber hewn into solid granite",
   "a cave of many exits",
   "a beautiful cavern",
   "",
   "a splendid chamber decorated with multi-coloured strands",
   "",
   "",
   "a complex junction of three forks",
   "the dragons lair",
   "a small stone chamber",
   "the edge of a large moat which surrounds the castle",
   "the western hall of the magic castle",
   "the eastern hall of the magic castle",
   "a room containing a bed made from twelve matresses",
   "the King's chamber",
   "",
   "",
   "an enormous underground sea"
)


#------------------------------------------------------------------------------

def showLocation(here):
   idx = descriptor[here]

   if (idx == 0):
      print "You seem to be floating in %s" % Scene[idx]
      if (firstGlimpse):
         print   "It is like being..."
   elif (idx == 1):
      print "You are inside %s" % Scene[idx]
      if (firstGlimpse):
         print   "It is a safe place to store treasure."
   elif (idx == 2):
      print "You are on %s." % Scene[idx]
   elif (idx == 3):
      print "You are in %s." % Scene[idx]

      if (here == 14):
         if (knightAbout):
            print "A black knight in full iron armour stands in a glade before you."
            print "He is carrying a goldern sword"
         else:
            print "There is an ancient iron statue of a knight in the glade"
   elif (idx == 4):
      print "You are walking along %s." % Scene[idx]
   elif (idx == 5):
      print "You are at %s." % Scene[idx]
      if (firstGlimpse):
         print "A small stream flows across the ground and into a crevice."
   elif (idx == 6):
      print "You are walking through %s." % Scene[idx]
      if (firstGlimpse):
         print "The sound of many birds and animals fills the air."
   elif (idx == 7):
      print "You are at %s." % Scene[idx]
      if (firstGlimpse):
         print "A 3X3 iron grate bars your way to where the cave appears to open up."
   elif (idx == 8):
      print "You are inside %s." % Scene[idx]
      if (firstGlimpse):
         print "A large passage opens up ahead."
   elif (idx == 9):
      print "You are at %s." % Scene[idx]
      if (firstGlimpse):
         print "You can climb down, but you might not be able to climb back up again."
   elif (idx == 10):
      print "You are in %s that extends vertically in both directions." % Scene[idx]
   elif (idx == 11):
      print "You are in %s." % Scene[idx]
      print "You are standing beside a large sign flashing '%s'!" % magicWord
      mysticFlg = TRUE
   elif (idx == 12):
      print "You are in %s." % Scene[idx]
   elif (idx == 13):
      print "You are walking along %s." % Scene[idx]
   elif (idx == 14):
      print "You are in %s." % Scene[idx]
   elif (idx == 15):
      print "You are in %s." % Scene[idx]
   elif (idx == 16):
      print "You are in %s." % Scene[idx]
   elif (idx == 17):
      print "You are at %s." % Scene[idx]
   elif (idx == 18):
      print "You are at %s." % Scene[idx]
   elif (idx == 19):
      print "You are at %s you could climb up but not back down." % Scene[idx]
   elif (idx == 20):
      print "You are in %s." % Scene[idx]
      if (firstGlimpse):
         print "Exits lead in many directions."
   elif (idx == 21):
      print "You are in %s." % Scene[idx]
   elif (idx == 22):
      print "You are walking through %s." % Scene[idx]
      if (firstGlimpse):
         print "At its center is a large hole."
         print "SHHH!..I think I hear the sound of water!"
   elif (idx == 23):
      if (rand(99) > 50):
         s = "a narow tunnel"
      else:
         s = "a small crack"
      print "You climb through %s only to find that........" % s
      here -= 7
      showLocation(here)
   elif (idx == 24):
      print "You are in %s." % Scene[idx]
   elif (idx == 25):
      here -= 5
      checkLantern()
   elif (idx == 26):
      if (rand(99) > 50):
         s = "twisty, little"
      else:
         s = "little, twisty"
      print "You are in a %s maze!" % s
   elif (idx == 27):
      print "You are in %s." % Scene[idx]
      if (firstGlimpse):
         print "Obvious paths lead east and west."
   elif (idx == 28):
      print "You have stumbled into %s." % Scene[idx]
      if (firstGlimpse):
         print "His job is to protect the enchanted castle which lies to the south."
         if (dragonAbout):
            s = "refuses to let you enter."
         else:
            s = "lies dead off to one side."
         print "The dragon %s" % s
   elif (idx == 29):
      print "You are in %s." % Scene[idx]
      if (frogAbout):
         print "A small green frog happily hops to and fro across the floor of the"
         print "chamber!"
   elif (idx == 30):
      print "You are standing on %s." % Scene[idx]
      if (firstGlimpse):
         print "You can neither jump nor swim across."
         if (drawbridgeDown):
            print "The drawbridge is lowered to cross."
   elif (idx == 31):
      print "You are in %s." % Scene[idx]
      if (firstGlimpse):
         print "Your footsteps echo endlessly."
   elif (idx == 32):
      print "You are in %s." % Scene[idx]
   elif (idx == 33):
      print "You are in %s." % Scene[idx]
      if (list[_Partner].held):
         moveCode[98] = 0x0A
   elif (idx == 34):
      print "You are in %s." % Scene[idx]
      if (firstGlimpse):
         print "SHHHH!... I think he's asleep!"
   elif (idx == 35):
      print "The floor you were standing on has given way."
      print "You fall..and fall...and fall................"
      print "finally landing on solid ground.............."
      here += 50
      checkLantern()
   elif (idx == 36):
      if (firstGlimpse):
         print "Welcome to the Magic Castle."
         print "I hope you enjoy your visit even though our ruler is stupid."
   elif (idx == 37):
      print "You are in the castle dungeons."
   elif (idx == 38):
      print "You are adrift in %s." % Scene[idx]
      if (firstGlimpse):
         irand = rand(100)
         if (irand < 40):
            print "It seems to go on forever."
         elif (irand < 65):
            print "A fog seems to be moving in."
         elif (irand < 80):
            print "The fog swirls about you.  It seems to have a life of its own."
         elif (irand < 90):
            print "Mysterious lights seem to hover on the edge of your vision."
         elif (irand < 99):
            print "A deep swell apears out of nowhere."

   firstGlimpse = FALSE

   if (debugFlg):
      print "***Maze descriptor = %d" % idx

#------------------------------------------------------------------------------

def cmd_look():
   for direction in range(6):
      location = lookTowards(direction)

      if (location != ERROR):
         idx = descriptor[location]

         if (direction == NORTH):
            print "To the north is %s."     % Scene[idx]
         elif (direction == EAST):
            print "Over to the east is %s." % Scene[idx]
         elif (direction == SOUTH):
            print "To the south is %s."     % Scene[idx]
         elif (direction == WEST):
            print "To the west is %s."      % Scene[idx]
         elif (direction == UP):
            print "Up above is %s."         % Scene[idx]
         elif (direction == DOWN):
            print "Down below is %s."       % Scene[idx]

   print ""

   showLocation(here)

   lookForObjects(here)

#------------------------------------------------------------------------------

def listScenes():
   for i in range(len(Scene)):
      print "<%s>" % Scene[i]

#------------------------------------------------------------------------------

