#!/usr/bin/env python

#===== Movement ===============================================================

def lookTowards(dirn):
   if (lookCode[here] & allowed[dirn]):
      showLocation(here)
      return(here + increment[dirn])
   else:
      return(ERROR)


#------------------------------------------------------------------------------

def allowedDirections(here):
   dirnStr = "NESWUD"

   for i in range(6):
      if (moveCode[here] & allowed[i]):
         allowedStr[i] = dirnStr[i]
      else:
         allowedStr[i] = ' '

   return allowedStr


#------------------------------------------------------------------------------

def levelStr(level):
   if (level == 0):
      lStr = "Surface"
   else:
      lStr = "Cavern level %d" % level

   return lStr

#------------------------------------------------------------------------------

def debugLocn():
   level = here / 25,
   y     = ((here % 25 ) / 5) + 1,
   x     = ((here % 25 ) % 5) + 1

   print "Maze position: %s  locn (%d,%d)  [%s]" % (levelStr(level), x, y, allowedDirections(here))
#         print "Maze position: %d [0x%x]", here, moveCode[here])


#------------------------------------------------------------------------------

def map():
   level = here / 25,
   y     = ((here % 25 ) / 5) + 1,
   x     = ((here % 25 ) % 5) + 1

   print "Locn: %d  Level: %s  [%d,%d]" % (here, levelStr(level), x, y)

   for row in range(6):
      print "+-----+-----+-----+-----+-----+" 

      for col in range(6):
         locn = (level * 25) + ((row * 5) + col)

         if (moveCode[locn] & allowed[NORTH]):
            c_north = '^'
         else:
            c_north = ' '

         if (moveCode[locn] & allowed[UP]):
            c_up = 'u'
         else:
            c_up = ' '

         print "|%c %c  " % (c_up, c_north),

      print "|"

      # print "|     |     |     |     |     |" )

      for col in range(6):
         locn = (level * 25) + ((row * 5) + col)

         if (moveCode[locn] & allowed[WEST]):
            c_west = '<'
         else:
            c_west = ' '

         if (moveCode[locn] & allowed[EAST]):
            c_east = '>'
         else:
            c_east = ' '

         if (locn == here):
            c_here = '*'
         else:
            c_here = ' '

         print "|%c %c %c" % (c_west, c_here, c_east),

      print "|"

      # print "|     |     |     |     |     |" )

      for col in range(6):
         locn = (level * 25) + ((row * 5) + col)

         if (moveCode[locn] & allowed[SOUTH]):
            c_south = 'v'
         else:
            c_south = ' '

         if (moveCode[locn] & allowed[DOWN]):
            c_down = 'd'
         else:
            c_down = ' '

         c_thing = ' '

         print "|%c %c  " % (c_down, c_south, c_thing),

      print "|"

   print "+-----+-----+-----+-----+-----+"

#------------------------------------------------------------------------------

def move(dirn):
   if (moveCode[here] & allowed[dirn]):
      oldLocn  = here
      here    += increment[dirn]

      if (descriptor[here] != descriptor[oldLocn]):
         firstGlimpse    = TRUE

      showLocation(here)
      lookForObjects(here)
   else:
      print "I'm sorry you can't go that way!"

#------------------------------------------------------------------------------

def cmd_go(cmd):
   if (cmd[0][0:1] == "N"):
      move(NORTH)
   elif (cmd[0][0:1] == "E"):
      move(EAST)
   elif (cmd[0][0:1] == "S"):
      move(SOUTH)
   elif (cmd[0][0:1] == "W"):
      move(WEST)
   elif (cmd[0][0:1] == "U"):
      move(UP)
   elif (cmd[0][0:1] == "D"):
      move(DOWN)
   else:
      print "Which way? ..."      

#------------------------------------------------------------------------------

def cmd_goNorth():
   move(NORTH)


def cmd_goEast():
   move(EAST)


def cmd_goSouth():
   move(SOUTH)


def cmd_goWest():
   move(WEST)


def cmd_goUp():
   move(UP)


def cmd_goDown():
   move(DOWN)


#------------------------------------------------------------------------------

def cmd_enter():
   global here

   if (here == 7):
      here = 2
      print "\nYou walk through a wooden door..."
      showLocation(here)
      lookForObjects(here)
   else:
      print "Enter where?"

#------------------------------------------------------------------------------

def cmd_leave():
   global here

   if (here == 2):
      here = 7
   else:
      print "I'm not sure which way you are facing.  Try a compass!"

#------------------------------------------------------------------------------

def checkLantern():
   global lanternDim
   global noLight

   if ((rand(99) > 92) and (here > 25)):
      pirate()

   if ((movesMade > 200) and (not lanternDim)):
      print "Your lantern is getting very dim!\n"
      print "I would look for a source of oil\n"
      lanternDim = TRUE
   elif ((movesMade > 250) and (not noLight)):
      print "Your lantern has run out of fuel!\n"
      noLight = TRUE
   elif (noLight):
      lanternLit = FALSE

   if (((descriptor[here] != 3) and (here < 25)) or not lanternLit):
      print "It is pitch dark!\n"
      sleep(1)
      print "If you proceed you will most likely fall into a pit"
      sleep(2)
      if (rand(99) > 85):
         pit()

#------------------------------------------------------------------------------

def cmd_queryThing(cmd):
   print "What shall I do with the %s?\n" % cmd[1]


#------------------------------------------------------------------------------

def cmd_debug(cmd):
   if (debugFlg):
      debugFlg = FALSE
   else:
      debugFlg = TRUE

#------------------------------------------------------------------------------

def cmd_drink(cmd):
   print "Drink \"%s\"? ...\n" % cmd[1]

#------------------------------------------------------------------------------

def cmd_drop(cmd):
   global broken
   global holding
   global location
   global itemCnt
   global lanternLit

   if (itemCnt == 0):
      print "You don't have anything to drop!"
      return

   if (len(cmd[1]) == 0):
      reply = raw_input("What do you want to drop? ")
      l = len(reply)
      if (l == 0):
         print "\nSorry, if you won't tell me what to drop, I can't do it!\n"
         return
      cmd[1] = reply

   idx = matchObject(cmd[1])

   if (idx == -1):
      print "I don't know how to drop '%s'.\n\n" % cmd[1]
      return

   if (holding[idx] == FALSE):
      print "You dont have that to drop!\n"
   else:
      holding[idx] = FALSE
      location[idx] = here
      itemCnt -= 1

      if (Objects[idx][0] == "Lantern"):
         lanternLit = FALSE
         print "Ok!\n"
      elif (Objects[idx][0] == "Bottle"):
         print "The bottle tipped over and the water spilled out of the bottle!\n"
      elif (Objects[idx][0] == "Statue"):
         if (Objects["Carpet"][0] != here):
            print "The statue falls and breaks worthlessly"
            location["Statue"] = -1
            broken = TRUE
         else:
            print "The statue lands safely on the persian rug.\n"
      else:
         print "Ok!\n"

#------------------------------------------------------------------------------

def cmd_eat(cmd):
   print "Eat \"%s\"? ..." % cmd[1]


#------------------------------------------------------------------------------

def cmd_find(cmd):
   print "Find \"%s\"? ..." % cmd[1]


#------------------------------------------------------------------------------

def cmd_get(cmd):
   global holding
   global itemCnt
   global lanternDim
   global location
   global movesMade
   global oilLevel

   if (itemCnt == itemLimit):
      print "You can't carry anything more."
      print "You'll have to drop something first!\n"
      return

   if (len(cmd[1]) == 0):
      reply = raw_input("What do you want to pick up ? ")
      len = strlen(reply)
      if (len == 0):
         print "Sorry, if you won't tell me what to pick up I can't get it!\n"
         return

      cmd[1] = reply

   idx = matchObject(cmd[1])

   if (idx == -1):
      print "I don't know how to get '%s'." %  cmd[1]
      return

   if (holding[idx]):
      if (Objects[id] == "Water"):
         print "You can't carry any more water!"
      else:

         print "You already holding that!"

   elif (location[idx] != here):
      print "There is no %s here!", cmd[1]
      if (debugFlg):
         print "locn = %d\n" % location[idx]
   else:
      if (Object[idx][0] == "Water"):
         if (not holding["Bottle"]):
            print "You have nothing to carry the water in!\n"
            return

      elif (Object[idx][0] == "Oil"):
         print "Your lantern is full again.\n"
         lanternDim = FALSE
         oilLevel = movesMade
         movesMade = 1

      elif (Object[idx][0] == "Book"):
         if (not fine and (here == 159)):
            # goto L12150
            return

      elif (Object[idx][0] == "Axe"):
         if ((here == 86) and not axeVisible):
            print "The dragon is sitting on it!"
            return

      elif (Object[idx][0] == "Treasure"):
         if (chestLocked):
            print "It's locked!"
            return

      print "Ok!"

      holding[idx]   = TRUE
      location[idx]  = -1
      itemCnt        += 1

#------------------------------------------------------------------------------

def cmd_give(cmd):
   print "[cmd_give]"

#------------------------------------------------------------------------------

def cmd_help(cmd):
   print "[cmd_help]"

#------------------------------------------------------------------------------

def cmd_how(cmd):
   print "I refuse to answer on the grounds that it might incriminate me!"

#------------------------------------------------------------------------------

def cmd_inventory(cmd):
   if (itemCnt > 0):
      print "\nYou are holding the following:\n"
      for idx in range(len(Objects)):
         if (holding[Objects[idx]] == TRUE):
            print "   %s\n", Objects[idx]
   else:
      print "\nYou are not holding anything!\n"

#------------------------------------------------------------------------------

def cmd_kill(cmd):
   print "[cmd_kill]"

#------------------------------------------------------------------------------

def cmd_kiss(cmd):
   print "[cmd_kiss]"

#------------------------------------------------------------------------------

def cmd_lift(cmd):
   print "[cmd_lift]"

#------------------------------------------------------------------------------

def cmd_light(cmd):
   print "[cmd_light]"

#------------------------------------------------------------------------------

def cmd_listen(cmd):
   if (rand(5) <= 2):
      print "Slosh, boil, drip, spurt, squirt ..."
   else:
      print "I don't hear anything"

#------------------------------------------------------------------------------

def cmd_map(cmd):
   global showMap

   if (showMap):
      showMap = FALSE
   else:
      showMap = TRUE

#------------------------------------------------------------------------------

def cmd_move(cmd):
   cmd_go(cmd)

#------------------------------------------------------------------------------

def cmd_no(cmd):
   print "[cmd_no]"

#------------------------------------------------------------------------------

def cmd_open(cmd):
   print "[cmd_open]"

#------------------------------------------------------------------------------

def cmd_pay(cmd):
   print "[cmd_pay]"

#------------------------------------------------------------------------------

def cmd_please(cmd):
   print "[cmd_please]"

#------------------------------------------------------------------------------

def cmd_quit(cmd):
   global loop

   print "\n\n\n"

   reply = raw_input("Do you really want to quit ? [YES] ")
   if (reply == YES):
      loop = FALSE

#------------------------------------------------------------------------------

def cmd_say(cmd):
   global here
   global firstGlimpse

   if (equivString(magicWord, cmd[1])):
      if (here == 199):
         print "A secret passage opens to the west!\n"
         moveCode[199] = 9
      elif (here == HUT):
         here         = CAVE_ENTRANCE
         firstGlimpse = FALSE
      elif (here == CAVE_ENTRANCE):
         here         = HUT
         firstGlimpse = FALSE
      else:
         print "Nothing happens!"
   else:
      print "Okay, '%s'!\n" % cmd[1]

#------------------------------------------------------------------------------

def cmd_shake(cmd):
   print "[cmd_shake]"

#------------------------------------------------------------------------------

def cmd_slay(cmd):
   print "[cmd_slay]"

#------------------------------------------------------------------------------

def cmd_undefined(cmd):
   print "I don't know what you mean!"


#------------------------------------------------------------------------------

def cmd_unlock(cmd):
   print "[cmd_unlock]"


#------------------------------------------------------------------------------

def cmd_wave(cmd):
   print "[cmd_wave]"

#------------------------------------------------------------------------------

def cmd_wet(cmd):
   print "[cmd_wet]"

#------------------------------------------------------------------------------

def cmd_what(cmd):
   print "I refuse to answer on the grounds that it might incriminate me!"

#------------------------------------------------------------------------------

def cmd_when(cmd):
   print "I refuse to answer on the grounds that it might incriminate me!"

#------------------------------------------------------------------------------

def cmd_where(cmd):
   if (debugFlg):
      print "here = %d, moveCode = %d" % (here, moveCode[here])

   print "I'm not really sure which way you're facing.  Try a compass heading."

#------------------------------------------------------------------------------

def cmd_who(cmd):
   print "[cmd_who]"

#------------------------------------------------------------------------------

def cmd_yes(cmd):
   print "[cmd_yes]"

#====== Debugging =============================================================

def cmd_toggleDebug(void):
   if (debugFlg):
      debugFlg = FALSE
   else:
      debugFlg = TRUE

#------------------------------------------------------------------------------

def cmd_teleport():
   reply = raw_input("Where do you want to go ? ")

   new_posn = int(reply)

   if ((new_posn >= 0) and (new_posn <= 125)):
      here = new_posn

   firstGlimpse    = TRUE

   showLocation(here)

   lookForObjects(here)

#------------------------------------------------------------------------------

def cmd_scanScenes():
   listScenes()

#------------------------------------------------------------------------------

