#!/usr/bin/env jython

import java.lang as lang
import java.awt as awt
import javax.swing as swing


#-------------------------------------------------------------------------------------

names=['Groucho','Chicko','Harpo']

quotes = {"Groucho":"Say the secret word!","Chicko":"Viaduct?","Harpo":"HONK!"}


#-------------------------------------------------------------------------------------

def buttonPressed(event):
   field.text = quotes[event.source.text]


def exit(event):
   lang.System.exit(0)

def createButton(name):
   return swing.JButton(name, preferredSize=(100,20),actionPerformed=buttonPressed)


#-------------------------------------------------------------------------------------

win = swing.JFrame("Welcome to Jython", size=(400,200), windowClosing=exit)

win.contentPane.layout = awt.FlowLayout()

field = swing.JTextField(preferredSize=(200,20))

win.contentPane.add(field)

buttons=[createButton(each) for each in names]

for eachButton in buttons:
   win.contentPane.add(eachButton)


win.pack()
win.show()


#-------------------------------------------------------------------------------------
# win.size=(400,100)
# eachButton.preferredSize = (100,20)

