/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class TableItem
extends Item {
    Table parent;
    int background;
    int foreground;

    public TableItem(Table parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TableItem(Table parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        int pixel = this.background == -1 ? this.parent.getBackgroundPixel() : this.background;
        return Color.win32_new(this.getDisplay(), pixel);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hwnd = this.parent.handle;
        int hwndHeader = OS.SendMessage(hwnd, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (index < 0 || index >= count) {
            return new Rectangle(0, 0, 0, 0);
        }
        int gridWidth = 0;
        if (this.parent.getLinesVisible()) {
            gridWidth = this.parent.getGridLineWidth();
        }
        RECT rect = new RECT();
        rect.top = index;
        rect.left = 2;
        OS.SendMessage(hwnd, 4152, itemIndex, rect);
        if (index == 0) {
            RECT iconRect = new RECT();
            iconRect.left = 1;
            OS.SendMessage(hwnd, 4152, itemIndex, iconRect);
            rect.left = iconRect.left - gridWidth;
        }
        int width = rect.right - rect.left - gridWidth;
        int height = rect.bottom - rect.top - gridWidth;
        if ((Widget.COMCTL32_MAJOR << 16 | Widget.COMCTL32_MINOR) >= 327760) {
            rect.top -= gridWidth;
        }
        return new Rectangle(rect.left + gridWidth, rect.top + gridWidth, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return false;
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 61440;
        lvItem.iItem = index;
        int result = OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
        return result != 0 && (lvItem.state >> 12 & 1) == 0;
    }

    public Display getDisplay() {
        Table parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public Color getForeground() {
        this.checkWidget();
        int pixel = this.foreground == -1 ? this.parent.getForegroundPixel() : this.foreground;
        return Color.win32_new(this.getDisplay(), pixel);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return false;
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 61440;
        lvItem.iItem = index;
        int result = OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
        return result != 0 && lvItem.state >> 12 > 2;
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (index == 0) {
            return super.getImage();
        }
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return null;
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 2;
        lvItem.iItem = itemIndex;
        lvItem.iSubItem = index;
        if (OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem) == 0) {
            return null;
        }
        if (lvItem.iImage >= 0) {
            return this.parent.imageList.get(lvItem.iImage);
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hwnd = this.parent.handle;
        int hwndHeader = OS.SendMessage(hwnd, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (index < 0 || index >= count) {
            return new Rectangle(0, 0, 0, 0);
        }
        int gridWidth = 0;
        if (this.parent.getLinesVisible()) {
            gridWidth = this.parent.getGridLineWidth();
        }
        RECT rect = new RECT();
        rect.top = index;
        rect.left = 1;
        OS.SendMessage(hwnd, 4152, itemIndex, rect);
        if (index == 0) {
            RECT iconRect = new RECT();
            iconRect.left = 1;
            OS.SendMessage(hwnd, 4152, itemIndex, iconRect);
            rect.left = iconRect.left - gridWidth;
        }
        int width = rect.right - rect.left - gridWidth;
        int height = rect.bottom - rect.top - gridWidth;
        if ((Widget.COMCTL32_MAJOR << 16 | Widget.COMCTL32_MINOR) >= 327760) {
            rect.top -= gridWidth;
        }
        return new Rectangle(rect.left + gridWidth, rect.top + gridWidth, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return 0;
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 16;
        lvItem.iItem = index;
        OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
        return lvItem.iIndent;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText(int index) {
        this.checkWidget();
        if (index == 0) {
            return super.getText();
        }
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            this.error(12);
        }
        int cchTextMax = 1024;
        int hwnd = this.parent.handle;
        int hHeap = OS.GetProcessHeap();
        int byteCount = cchTextMax * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 1;
        lvItem.iItem = itemIndex;
        lvItem.iSubItem = index;
        lvItem.pszText = pszText;
        lvItem.cchTextMax = cchTextMax;
        int result = OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), cchTextMax);
        OS.MoveMemory(buffer, pszText, byteCount);
        OS.HeapFree(hHeap, 0, pszText);
        if (result == 0) {
            this.error(12);
        }
        return buffer.toString(0, buffer.strlen());
    }

    void redraw() {
        if (this.parent.drawCount > 0) {
            return;
        }
        int hwnd = this.parent.handle;
        if (!OS.IsWindowVisible(hwnd)) {
            return;
        }
        int index = this.parent.indexOf(this);
        RECT rect = new RECT();
        rect.left = 0;
        if (OS.SendMessage(hwnd, 4110, index, rect) != 0) {
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        this.background = pixel;
        this.redraw();
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 61440;
        lvItem.iItem = index;
        OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
        int state = lvItem.state >> 12;
        if (checked) {
            if ((state & 1) != 0) {
                ++state;
            }
        } else if ((state & 1) == 0) {
            --state;
        }
        lvItem.state = state << 12;
        this.parent.ignoreSelect = true;
        OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
        this.parent.ignoreSelect = false;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        this.foreground = pixel;
        this.redraw();
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 61440;
        lvItem.iItem = index;
        OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
        int state = lvItem.state >> 12;
        if (grayed) {
            if (state <= 2) {
                state += 2;
            }
        } else if (state > 2) {
            state -= 2;
        }
        lvItem.state = state << 12;
        this.parent.ignoreSelect = true;
        OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
        this.parent.ignoreSelect = false;
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        int itemIndex;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (index == 0) {
            super.setImage(image);
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 2;
        lvItem.iItem = itemIndex;
        lvItem.iSubItem = index;
        lvItem.iImage = this.parent.imageIndex(image);
        if (OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem) != 0) {
            if (index == 0) {
                this.parent.setScrollWidth();
            }
            this.parent.fixCheckboxImageList();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwnd = this.parent.handle;
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 16;
        lvItem.iItem = index;
        lvItem.iIndent = indent;
        OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        int itemIndex;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (index == 0) {
            super.setText(string);
        }
        int hwnd = this.parent.handle;
        int hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), string, true);
        int byteCount = buffer.length() * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 1;
        lvItem.iItem = itemIndex;
        lvItem.pszText = pszText;
        lvItem.iSubItem = index;
        if (OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem) != 0 && index == 0) {
            this.parent.setScrollWidth();
        }
        OS.HeapFree(hHeap, 0, pszText);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

