/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(this.handle, msg, wParam, lParam);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        int bits = OS.GetWindowLong(this.handle, -16);
        OS.AdjustWindowRectEx(rect, bits, false, OS.GetWindowLong(this.handle, -20));
        if (this.horizontalBar != null) {
            rect.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rect.right += OS.GetSystemMetrics(2);
        }
        int nWidth = rect.right - rect.left;
        int nHeight = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, nWidth, nHeight);
    }

    ScrollBar createScrollBar(int type) {
        ScrollBar bar = new ScrollBar(this, type);
        if ((this.state & 0x1000) != 0) {
            bar.setMaximum(100);
            bar.setThumb(10);
        }
        return bar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        return new Rectangle(0, 0, rect.right, rect.bottom);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseWidget() {
        if (this.horizontalBar != null) {
            this.horizontalBar.releaseResources();
        }
        if (this.verticalBar != null) {
            this.verticalBar.releaseResources();
        }
        this.verticalBar = null;
        this.horizontalBar = null;
        super.releaseWidget();
    }

    int widgetExtStyle() {
        return super.widgetExtStyle();
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x10000;
        if ((this.style & 0x100) != 0) {
            bits |= 0x100000;
        }
        if ((this.style & 0x200) != 0) {
            bits |= 0x200000;
        }
        return bits;
    }

    TCHAR windowClass() {
        return this.getDisplay().windowClass;
    }

    int windowProc() {
        return this.getDisplay().windowProc;
    }

    LRESULT WM_HSCROLL(int wParam, int lParam) {
        LRESULT result = super.WM_HSCROLL(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((lParam == 0 || lParam == this.handle) && this.horizontalBar != null) {
            return this.wmScroll(this.horizontalBar, 276, wParam, lParam);
        }
        return result;
    }

    LRESULT WM_MOUSEWHEEL(int wParam, int lParam) {
        Event event;
        int position;
        LRESULT result = super.WM_MOUSEWHEEL(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 0x1000) != 0) {
            if ((wParam & 0xC) != 0) {
                return result;
            }
            int delta = wParam >> 16;
            int code = delta < 0 ? 1 : 0;
            if ((delta = Math.abs(delta)) < 120) {
                return result;
            }
            if (this.verticalBar != null) {
                int[] value = new int[1];
                OS.SystemParametersInfo(104, 0, value, 0);
                int count = value[0] * delta / 120;
                int i = 0;
                while (i < count) {
                    OS.SendMessage(this.handle, 277, code, 0);
                    ++i;
                }
                return LRESULT.ZERO;
            }
            if (this.horizontalBar != null) {
                int count = delta / 120;
                int i = 0;
                while (i < count) {
                    OS.SendMessage(this.handle, 276, code, 0);
                    ++i;
                }
                return LRESULT.ZERO;
            }
            return result;
        }
        int vPosition = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int hPosition = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int code = this.callWindowProc(522, wParam, lParam);
        if (this.verticalBar != null && (position = this.verticalBar.getSelection()) != vPosition) {
            event = new Event();
            event.detail = position < vPosition ? 0x1000005 : 0x1000006;
            this.verticalBar.sendEvent(13, event);
        }
        if (this.horizontalBar != null && (position = this.horizontalBar.getSelection()) != hPosition) {
            event = new Event();
            event.detail = position < vPosition ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendEvent(13, event);
        }
        return new LRESULT(code);
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        int code = this.callWindowProc(5, wParam, lParam);
        super.WM_SIZE(wParam, lParam);
        if (code == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(code);
    }

    LRESULT WM_VSCROLL(int wParam, int lParam) {
        LRESULT result = super.WM_VSCROLL(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((lParam == 0 || lParam == this.handle) && this.verticalBar != null) {
            return this.wmScroll(this.verticalBar, 277, wParam, lParam);
        }
        return result;
    }

    LRESULT wmScroll(ScrollBar bar, int msg, int wParam, int lParam) {
        LRESULT result = null;
        if ((this.state & 0x1000) != 0) {
            int type = msg == 276 ? 0 : 1;
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = 28;
            info.fMask = 21;
            OS.GetScrollInfo(this.handle, type, info);
            info.fMask = 4;
            int code = wParam & 0xFFFF;
            switch (code) {
                case 8: {
                    return null;
                }
                case 4: 
                case 5: {
                    info.nPos = info.nTrackPos;
                    break;
                }
                case 6: {
                    info.nPos = info.nMin;
                    break;
                }
                case 7: {
                    info.nPos = info.nMax;
                    break;
                }
                case 1: {
                    info.nPos += bar.getIncrement();
                    break;
                }
                case 0: {
                    int increment = bar.getIncrement();
                    info.nPos = Math.max(info.nMin, info.nPos - increment);
                    break;
                }
                case 3: {
                    info.nPos += bar.getPageIncrement();
                    break;
                }
                case 2: {
                    int pageIncrement = bar.getPageIncrement();
                    info.nPos = Math.max(info.nMin, info.nPos - pageIncrement);
                }
            }
            OS.SetScrollInfo(this.handle, type, info, true);
        } else {
            int code = this.callWindowProc(msg, wParam, lParam);
            result = code == 0 ? LRESULT.ZERO : new LRESULT(code);
        }
        bar.wmScrollChild(wParam, lParam);
        return result;
    }
}

