/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    void clearArea(int x, int y, int width, int height) {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        int hDC = OS.GetDCEx(this.handle, 0, 26);
        this.drawBackground(hDC, rect);
        OS.ReleaseDC(this.handle, hDC);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    void releaseWidget() {
        if (this.caret != null) {
            this.caret.releaseResources();
        }
        this.caret = null;
        super.releaseWidget();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        this.checkWidget();
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if (OS.IsWinCE) {
            OS.UpdateWindow(this.handle);
        } else {
            int flags = 384;
            OS.RedrawWindow(this.handle, null, 0, flags);
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        int deltaX = destX - x;
        int deltaY = destY - y;
        int flags = 6;
        if (all) {
            flags |= 1;
        }
        OS.ScrollWindowEx(this.handle, deltaX, deltaY, rect, null, 0, null, flags);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.isFocusControl()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if (this.caret != null) {
            this.caret.setFont(font);
        }
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }
}

