/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.Library;

public class Callback {
    Object object;
    String method;
    String signature;
    int argCount;
    int address;
    boolean isStatic;
    boolean isArrayBased;

    static {
        Library.loadLibrary("swt");
    }

    public Callback(Object object, String method, int argCount) {
        this(object, method, argCount, false);
    }

    public Callback(Object object, String method, int argCount, boolean isArrayBased) {
        this.object = object;
        this.method = method;
        this.argCount = argCount;
        this.isStatic = object instanceof Class;
        this.isArrayBased = isArrayBased;
        if (isArrayBased) {
            this.signature = "([I)I";
        } else {
            switch (argCount) {
                case 0: {
                    this.signature = "()I";
                    break;
                }
                case 1: {
                    this.signature = "(I)I";
                    break;
                }
                case 2: {
                    this.signature = "(II)I";
                    break;
                }
                case 3: {
                    this.signature = "(III)I";
                    break;
                }
                case 4: {
                    this.signature = "(IIII)I";
                    break;
                }
                default: {
                    this.signature = "(";
                    int i = 0;
                    while (i < argCount) {
                        this.signature = String.valueOf(this.signature) + "I";
                        ++i;
                    }
                    this.signature = String.valueOf(this.signature) + ")I";
                }
            }
        }
        this.address = Callback.bind(this);
    }

    static synchronized native int bind(Callback var0);

    public void dispose() {
        if (this.object == null) {
            return;
        }
        Callback.unbind(this);
        this.signature = null;
        this.method = null;
        this.object = null;
        this.address = 0;
    }

    public int getAddress() {
        return this.address;
    }

    public static native String getPlatform();

    public static final synchronized native void setEnabled(boolean var0);

    public static final synchronized native boolean getEnabled();

    static final void ignoreCallbacks(boolean ignore) {
        Callback.setEnabled(!ignore);
    }

    public static final synchronized native void reset();

    static final synchronized native void unbind(Callback var0);
}

