/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public final class FontData {
    public LOGFONT data;
    public int height;
    String lang;
    String country;
    String variant;

    public FontData() {
        this.data = new LOGFONT();
        this.data.lfCharSet = 1;
        this.height = 12;
    }

    FontData(LOGFONT data, int height) {
        this.data = data;
        this.height = height;
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string.indexOf(124);
        if (end == -1) {
            SWT.error(5);
        }
        String version1 = string.substring(start, end);
        try {
            if (Integer.parseInt(version1) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((end = string.indexOf(124, start = end + 1)) == -1) {
            SWT.error(5);
        }
        String name = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        int height = 0;
        try {
            height = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        this.data = new LOGFONT();
        this.data.lfCharSet = 1;
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
        if (end == -1) {
            return;
        }
        String platform = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            return;
        }
        String version2 = string.substring(start, end);
        if (platform.equals("WINDOWS") && version2.equals("1")) {
            LOGFONT newData = new LOGFONT();
            try {
                start = end + 1;
                end = string.indexOf(124, start);
                if (end == -1) {
                    return;
                }
                newData.lfHeight = Integer.parseInt(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfWidth = Integer.parseInt(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfEscapement = Integer.parseInt(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfOrientation = Integer.parseInt(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfWeight = Integer.parseInt(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfItalic = Byte.parseByte(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfUnderline = Byte.parseByte(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfStrikeOut = Byte.parseByte(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfCharSet = Byte.parseByte(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfOutPrecision = Byte.parseByte(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfClipPrecision = Byte.parseByte(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfQuality = Byte.parseByte(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                newData.lfPitchAndFamily = Byte.parseByte(string.substring(start, end));
                start = end + 1;
            }
            catch (NumberFormatException numberFormatException) {
                this.setName(name);
                this.setHeight(height);
                this.setStyle(style);
                return;
            }
            char[] lfFaceName = new char[32];
            string.getChars(start, string.length(), lfFaceName, 0);
            newData.lfFaceName0 = lfFaceName[0];
            newData.lfFaceName1 = lfFaceName[1];
            newData.lfFaceName2 = lfFaceName[2];
            newData.lfFaceName3 = lfFaceName[3];
            newData.lfFaceName4 = lfFaceName[4];
            newData.lfFaceName5 = lfFaceName[5];
            newData.lfFaceName6 = lfFaceName[6];
            newData.lfFaceName7 = lfFaceName[7];
            newData.lfFaceName8 = lfFaceName[8];
            newData.lfFaceName9 = lfFaceName[9];
            newData.lfFaceName10 = lfFaceName[10];
            newData.lfFaceName11 = lfFaceName[11];
            newData.lfFaceName12 = lfFaceName[12];
            newData.lfFaceName13 = lfFaceName[13];
            newData.lfFaceName14 = lfFaceName[14];
            newData.lfFaceName15 = lfFaceName[15];
            newData.lfFaceName16 = lfFaceName[16];
            newData.lfFaceName17 = lfFaceName[17];
            newData.lfFaceName18 = lfFaceName[18];
            newData.lfFaceName19 = lfFaceName[19];
            newData.lfFaceName20 = lfFaceName[20];
            newData.lfFaceName21 = lfFaceName[21];
            newData.lfFaceName22 = lfFaceName[22];
            newData.lfFaceName23 = lfFaceName[23];
            newData.lfFaceName24 = lfFaceName[24];
            newData.lfFaceName25 = lfFaceName[25];
            newData.lfFaceName26 = lfFaceName[26];
            newData.lfFaceName27 = lfFaceName[27];
            newData.lfFaceName28 = lfFaceName[28];
            newData.lfFaceName29 = lfFaceName[29];
            newData.lfFaceName30 = lfFaceName[30];
            newData.lfFaceName31 = lfFaceName[31];
            this.data = newData;
        }
    }

    public FontData(String name, int height, int style) {
        if (name == null) {
            SWT.error(4);
        }
        this.data = new LOGFONT();
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
        this.data.lfCharSet = 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        LOGFONT lf = ((FontData)object).data;
        return this.data.lfCharSet == lf.lfCharSet && this.data.lfHeight == lf.lfHeight && this.data.lfWidth == lf.lfWidth && this.data.lfEscapement == lf.lfEscapement && this.data.lfOrientation == lf.lfOrientation && this.data.lfWeight == lf.lfWeight && this.data.lfItalic == lf.lfItalic && this.data.lfUnderline == lf.lfUnderline && this.data.lfStrikeOut == lf.lfStrikeOut && this.data.lfCharSet == lf.lfCharSet && this.data.lfOutPrecision == lf.lfOutPrecision && this.data.lfClipPrecision == lf.lfClipPrecision && this.data.lfQuality == lf.lfQuality && this.data.lfPitchAndFamily == lf.lfPitchAndFamily && this.data.lfFaceName0 == lf.lfFaceName0 && this.data.lfFaceName1 == lf.lfFaceName1 && this.data.lfFaceName2 == lf.lfFaceName2 && this.data.lfFaceName3 == lf.lfFaceName3 && this.data.lfFaceName4 == lf.lfFaceName4 && this.data.lfFaceName5 == lf.lfFaceName5 && this.data.lfFaceName6 == lf.lfFaceName6 && this.data.lfFaceName7 == lf.lfFaceName7 && this.data.lfFaceName8 == lf.lfFaceName8 && this.data.lfFaceName9 == lf.lfFaceName9 && this.data.lfFaceName10 == lf.lfFaceName10 && this.data.lfFaceName11 == lf.lfFaceName11 && this.data.lfFaceName12 == lf.lfFaceName12 && this.data.lfFaceName13 == lf.lfFaceName13 && this.data.lfFaceName14 == lf.lfFaceName14 && this.data.lfFaceName15 == lf.lfFaceName15 && this.data.lfFaceName16 == lf.lfFaceName16 && this.data.lfFaceName17 == lf.lfFaceName17 && this.data.lfFaceName18 == lf.lfFaceName18 && this.data.lfFaceName19 == lf.lfFaceName19 && this.data.lfFaceName20 == lf.lfFaceName20 && this.data.lfFaceName21 == lf.lfFaceName21 && this.data.lfFaceName22 == lf.lfFaceName22 && this.data.lfFaceName23 == lf.lfFaceName23 && this.data.lfFaceName24 == lf.lfFaceName24 && this.data.lfFaceName25 == lf.lfFaceName25 && this.data.lfFaceName26 == lf.lfFaceName26 && this.data.lfFaceName27 == lf.lfFaceName27 && this.data.lfFaceName28 == lf.lfFaceName28 && this.data.lfFaceName29 == lf.lfFaceName29 && this.data.lfFaceName30 == lf.lfFaceName30 && this.data.lfFaceName31 == lf.lfFaceName31;
    }

    int EnumLocalesProc(int lpLocaleString) {
        int length = 8;
        TCHAR buffer = new TCHAR(0, length);
        int byteCount = length * TCHAR.sizeof;
        OS.MoveMemory(buffer, lpLocaleString, byteCount);
        int lcid = Integer.parseInt(buffer.toString(0, buffer.strlen()), 16);
        int size = OS.GetLocaleInfo(lcid, 89, buffer, length);
        if (size <= 0 || !this.lang.equals(buffer.toString(0, size - 1))) {
            return 1;
        }
        if (!(this.country == null || (size = OS.GetLocaleInfo(lcid, 90, buffer, length)) > 0 && this.country.equals(buffer.toString(0, size - 1)))) {
            return 1;
        }
        size = OS.GetLocaleInfo(lcid, 4100, buffer, length);
        if (size <= 0) {
            return 1;
        }
        int cp = Integer.parseInt(buffer.toString(0, size - 1));
        int[] lpCs = new int[8];
        OS.TranslateCharsetInfo(cp, lpCs, 2);
        this.data.lfCharSet = (byte)lpCs[0];
        return 0;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        char[] chars = new char[]{this.data.lfFaceName0, this.data.lfFaceName1, this.data.lfFaceName2, this.data.lfFaceName3, this.data.lfFaceName4, this.data.lfFaceName5, this.data.lfFaceName6, this.data.lfFaceName7, this.data.lfFaceName8, this.data.lfFaceName9, this.data.lfFaceName10, this.data.lfFaceName11, this.data.lfFaceName12, this.data.lfFaceName13, this.data.lfFaceName14, this.data.lfFaceName15, this.data.lfFaceName16, this.data.lfFaceName17, this.data.lfFaceName18, this.data.lfFaceName19, this.data.lfFaceName20, this.data.lfFaceName21, this.data.lfFaceName22, this.data.lfFaceName23, this.data.lfFaceName24, this.data.lfFaceName25, this.data.lfFaceName26, this.data.lfFaceName27, this.data.lfFaceName28, this.data.lfFaceName29, this.data.lfFaceName30, this.data.lfFaceName31};
        int index = 0;
        while (index < chars.length) {
            if (chars[index] == '\u0000') break;
            ++index;
        }
        return new String(chars, 0, index);
    }

    public int getStyle() {
        int style = 0;
        if (this.data.lfWeight == 700) {
            style |= 1;
        }
        if (this.data.lfItalic != 0) {
            style |= 2;
        }
        return style;
    }

    public int hashCode() {
        return this.data.lfCharSet ^ this.data.lfHeight ^ this.data.lfWidth ^ this.data.lfEscapement ^ this.data.lfOrientation ^ this.data.lfWeight ^ this.data.lfItalic ^ this.data.lfUnderline ^ this.data.lfStrikeOut ^ this.data.lfCharSet ^ this.data.lfOutPrecision ^ this.data.lfClipPrecision ^ this.data.lfQuality ^ this.data.lfPitchAndFamily ^ this.data.lfFaceName0 ^ this.data.lfFaceName1 ^ this.data.lfFaceName2 ^ this.data.lfFaceName3 ^ this.data.lfFaceName4 ^ this.data.lfFaceName5 ^ this.data.lfFaceName6 ^ this.data.lfFaceName7 ^ this.data.lfFaceName8 ^ this.data.lfFaceName9 ^ this.data.lfFaceName10 ^ this.data.lfFaceName11 ^ this.data.lfFaceName12 ^ this.data.lfFaceName13 ^ this.data.lfFaceName14 ^ this.data.lfFaceName15 ^ this.data.lfFaceName16 ^ this.data.lfFaceName17 ^ this.data.lfFaceName18 ^ this.data.lfFaceName19 ^ this.data.lfFaceName20 ^ this.data.lfFaceName21 ^ this.data.lfFaceName22 ^ this.data.lfFaceName23 ^ this.data.lfFaceName24 ^ this.data.lfFaceName25 ^ this.data.lfFaceName26 ^ this.data.lfFaceName27 ^ this.data.lfFaceName28 ^ this.data.lfFaceName29 ^ this.data.lfFaceName30 ^ this.data.lfFaceName31;
    }

    public void setHeight(int height) {
        if (height < 0) {
            SWT.error(5);
        }
        this.height = height;
    }

    public void setLocale(String locale) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (locale != null) {
            int secondSep;
            int sep = 95;
            int length = locale.length();
            int firstSep = locale.indexOf(sep);
            if (firstSep == -1) {
                firstSep = secondSep = length;
            } else {
                secondSep = locale.indexOf(sep, firstSep + 1);
                if (secondSep == -1) {
                    secondSep = length;
                }
            }
            if (firstSep > 0) {
                this.lang = locale.substring(0, firstSep);
            }
            if (secondSep > firstSep + 1) {
                this.country = locale.substring(firstSep + 1, secondSep);
            }
            if (length > secondSep + 1) {
                this.variant = locale.substring(secondSep + 1);
            }
        }
        if (this.lang == null) {
            this.data.lfCharSet = 1;
        } else {
            Callback callback = new Callback(this, "EnumLocalesProc", 1);
            int lpEnumLocalesProc = callback.getAddress();
            OS.EnumSystemLocales(lpEnumLocalesProc, 2);
            callback.dispose();
        }
    }

    public void setName(String name) {
        if (name == null) {
            SWT.error(4);
        }
        char[] chars = new char[32];
        int length = name.length();
        name.getChars(0, length <= 31 ? length : 31, chars, 0);
        this.data.lfFaceName0 = chars[0];
        this.data.lfFaceName1 = chars[1];
        this.data.lfFaceName2 = chars[2];
        this.data.lfFaceName3 = chars[3];
        this.data.lfFaceName4 = chars[4];
        this.data.lfFaceName5 = chars[5];
        this.data.lfFaceName6 = chars[6];
        this.data.lfFaceName7 = chars[7];
        this.data.lfFaceName8 = chars[8];
        this.data.lfFaceName9 = chars[9];
        this.data.lfFaceName10 = chars[10];
        this.data.lfFaceName11 = chars[11];
        this.data.lfFaceName12 = chars[12];
        this.data.lfFaceName13 = chars[13];
        this.data.lfFaceName14 = chars[14];
        this.data.lfFaceName15 = chars[15];
        this.data.lfFaceName16 = chars[16];
        this.data.lfFaceName17 = chars[17];
        this.data.lfFaceName18 = chars[18];
        this.data.lfFaceName19 = chars[19];
        this.data.lfFaceName20 = chars[20];
        this.data.lfFaceName21 = chars[21];
        this.data.lfFaceName22 = chars[22];
        this.data.lfFaceName23 = chars[23];
        this.data.lfFaceName24 = chars[24];
        this.data.lfFaceName25 = chars[25];
        this.data.lfFaceName26 = chars[26];
        this.data.lfFaceName27 = chars[27];
        this.data.lfFaceName28 = chars[28];
        this.data.lfFaceName29 = chars[29];
        this.data.lfFaceName30 = chars[30];
        this.data.lfFaceName31 = chars[31];
    }

    public void setStyle(int style) {
        this.data.lfWeight = (style & 1) == 1 ? 700 : 0;
        this.data.lfItalic = (style & 2) == 2 ? (byte)1 : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeight());
        buffer.append("|");
        buffer.append(this.getStyle());
        buffer.append("|");
        buffer.append("WINDOWS|1|");
        buffer.append(this.data.lfHeight);
        buffer.append("|");
        buffer.append(this.data.lfWidth);
        buffer.append("|");
        buffer.append(this.data.lfEscapement);
        buffer.append("|");
        buffer.append(this.data.lfOrientation);
        buffer.append("|");
        buffer.append(this.data.lfWeight);
        buffer.append("|");
        buffer.append(this.data.lfItalic);
        buffer.append("|");
        buffer.append(this.data.lfUnderline);
        buffer.append("|");
        buffer.append(this.data.lfStrikeOut);
        buffer.append("|");
        buffer.append(this.data.lfCharSet);
        buffer.append("|");
        buffer.append(this.data.lfOutPrecision);
        buffer.append("|");
        buffer.append(this.data.lfClipPrecision);
        buffer.append("|");
        buffer.append(this.data.lfQuality);
        buffer.append("|");
        buffer.append(this.data.lfPitchAndFamily);
        buffer.append("|");
        char[] faceName = new char[]{this.data.lfFaceName0, this.data.lfFaceName1, this.data.lfFaceName2, this.data.lfFaceName3, this.data.lfFaceName4, this.data.lfFaceName5, this.data.lfFaceName6, this.data.lfFaceName7, this.data.lfFaceName8, this.data.lfFaceName9, this.data.lfFaceName10, this.data.lfFaceName11, this.data.lfFaceName12, this.data.lfFaceName13, this.data.lfFaceName14, this.data.lfFaceName15, this.data.lfFaceName16, this.data.lfFaceName17, this.data.lfFaceName18, this.data.lfFaceName19, this.data.lfFaceName20, this.data.lfFaceName21, this.data.lfFaceName22, this.data.lfFaceName23, this.data.lfFaceName24, this.data.lfFaceName25, this.data.lfFaceName26, this.data.lfFaceName27, this.data.lfFaceName28, this.data.lfFaceName29, this.data.lfFaceName30, this.data.lfFaceName31};
        int i = 0;
        while (i < faceName.length && faceName[i] != '\u0000') {
            buffer.append(faceName[i++]);
        }
        return buffer.toString();
    }

    public static FontData win32_new(LOGFONT data, int height) {
        return new FontData(data, height);
    }
}

