/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    private COMObject iDropSource;
    private COMObject iDataObject;
    private int refCount;
    private Control control;
    private Transfer[] transferAgents = new Transfer[0];
    private Listener controlListener;
    private int dataEffect;
    private static final String DRAGSOURCEID = "DragSource";
    private static int CFSTR_PERFORMEDDROPEFFECT = Transfer.registerType("Performed DropEffect");
    static /* synthetic */ Class class$0;

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.createCOMInterfaces();
        this.AddRef();
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12) {
                    DragSource.this.dispose();
                }
                if (event.type == 29) {
                    DragSource.this.drag();
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2008, typedListener);
        this.addListener(2000, typedListener);
        this.addListener(2001, typedListener);
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[5];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 1;
        this.iDropSource = new COMObject(nArray){

            public int method0(int[] args) {
                return DragSource.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return DragSource.this.AddRef();
            }

            public int method2(int[] args) {
                return DragSource.this.Release();
            }

            public int method3(int[] args) {
                return DragSource.this.QueryContinueDrag(args[0], args[1]);
            }

            public int method4(int[] args) {
                return DragSource.this.GiveFeedback(args[0]);
            }
        };
        int[] nArray2 = new int[12];
        nArray2[0] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 2;
        nArray2[9] = 4;
        nArray2[10] = 1;
        nArray2[11] = 1;
        this.iDataObject = new COMObject(nArray2){

            public int method0(int[] args) {
                return DragSource.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return DragSource.this.AddRef();
            }

            public int method2(int[] args) {
                return DragSource.this.Release();
            }

            public int method3(int[] args) {
                return DragSource.this.GetData(args[0], args[1]);
            }

            public int method5(int[] args) {
                return DragSource.this.QueryGetData(args[0]);
            }

            public int method7(int[] args) {
                return DragSource.this.SetData(args[0], args[1], args[2]);
            }

            public int method8(int[] args) {
                return DragSource.this.EnumFormatEtc(args[0], args[1]);
            }
        };
    }

    private void onDispose() {
        this.Release();
        if (this.control != null && this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private int opToOs(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 4;
        }
        if ((operation & 2) != 0) {
            osOperation |= 2;
        }
        return osOperation;
    }

    private int osToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 4) != 0) {
            operation |= 4;
        }
        if ((osOperation & 2) != 0) {
            operation |= 2;
        }
        return operation;
    }

    private void disposeCOMInterfaces() {
        if (this.iDropSource != null) {
            this.iDropSource.dispose();
        }
        this.iDropSource = null;
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    private void drag() {
        if (this.transferAgents == null || this.getStyle() == 0) {
            return;
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.doit = true;
        try {
            this.notifyListeners(2008, event);
        }
        catch (Throwable throwable) {
            return;
        }
        if (!event.doit) {
            return;
        }
        this.dataEffect = 0;
        int[] pdwEffect = new int[1];
        int operations = this.opToOs(this.getStyle());
        int result = COM.DoDragDrop(this.iDataObject.getAddress(), this.iDropSource.getAddress(), operations, pdwEffect);
        int operation = this.osToOp(pdwEffect[0]);
        event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        if (this.dataEffect == 2 && (operation == 0 || operation == 1)) {
            this.dataEffect = 8;
        }
        if (this.dataEffect == 0) {
            this.dataEffect = operation;
        }
        event.detail = this.dataEffect;
        event.doit = result == 262400;
        try {
            this.notifyListeners(2000, event);
        }
        catch (Throwable throwable) {}
    }

    private int EnumFormatEtc(int dwDirection, int ppenumFormatetc) {
        Object[] formats;
        if (dwDirection == 2) {
            return -2147467263;
        }
        TransferData[] allowedDataTypes = new TransferData[]{};
        int i = 0;
        while (i < this.transferAgents.length) {
            formats = this.transferAgents[i].getSupportedTypes();
            TransferData[] newAllowedDataTypes = new TransferData[allowedDataTypes.length + formats.length];
            System.arraycopy(allowedDataTypes, 0, newAllowedDataTypes, 0, allowedDataTypes.length);
            System.arraycopy(formats, 0, newAllowedDataTypes, allowedDataTypes.length, formats.length);
            allowedDataTypes = newAllowedDataTypes;
            ++i;
        }
        OleEnumFORMATETC enumFORMATETC = new OleEnumFORMATETC();
        enumFORMATETC.AddRef();
        formats = new FORMATETC[allowedDataTypes.length];
        int i2 = 0;
        while (i2 < formats.length) {
            formats[i2] = allowedDataTypes[i2].formatetc;
            ++i2;
        }
        enumFORMATETC.setFormats((FORMATETC[])formats);
        OS.MoveMemory(ppenumFormatetc, new int[]{enumFORMATETC.getAddress()}, 4);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    private int GetData(int pFormatetc, int pmedium) {
        if (pFormatetc == 0 || pmedium == 0) {
            return -2147024809;
        }
        if (this.QueryGetData(pFormatetc) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, pFormatetc, 20);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.dataType = transferData;
        try {
            this.notifyListeners(2001, event);
        }
        catch (Throwable throwable) {
            return -2147467259;
        }
        if (event.data == null) {
            return -2147221404;
        }
        Transfer transfer = null;
        int i = 0;
        while (i < this.transferAgents.length) {
            if (this.transferAgents[i].isSupportedType(event.dataType)) {
                transfer = this.transferAgents[i];
                break;
            }
            ++i;
        }
        if (transfer == null) {
            return -2147221404;
        }
        transfer.javaToNative(event.data, transferData);
        COM.MoveMemory(pmedium, transferData.stgmedium, 12);
        return transferData.result;
    }

    public Display getDisplay() {
        if (this.control == null) {
            DND.error(24);
        }
        return this.control.getDisplay();
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private int GiveFeedback(int dwEffect) {
        return 262402;
    }

    private int QueryContinueDrag(int fEscapePressed, int grfKeyState) {
        if (fEscapePressed != 0) {
            return 262401;
        }
        if ((grfKeyState & 0x13) == 0) {
            return 262400;
        }
        return 0;
    }

    private int QueryGetData(int pFormatetc) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, pFormatetc, 20);
        transferData.type = transferData.formatetc.cfFormat;
        int i = 0;
        while (i < this.transferAgents.length) {
            if (this.transferAgents[i].isSupportedType(transferData)) {
                return 0;
            }
            ++i;
        }
        return -2147221404;
    }

    private int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, 16);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIDropSource)) {
            OS.MoveMemory(ppvObject, new int[]{this.iDropSource.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIDataObject)) {
            OS.MoveMemory(ppvObject, new int[]{this.iDataObject.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new int[1], 4);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2000, listener);
        this.removeListener(2001, listener);
    }

    private int SetData(int pFormatetc, int pmedium, int fRelease) {
        if (pFormatetc == 0 || pmedium == 0) {
            return -2147024809;
        }
        FORMATETC formatetc = new FORMATETC();
        COM.MoveMemory(formatetc, pFormatetc, 20);
        if (formatetc.cfFormat == CFSTR_PERFORMEDDROPEFFECT && formatetc.tymed == 1) {
            STGMEDIUM stgmedium = new STGMEDIUM();
            COM.MoveMemory(stgmedium, pmedium, 12);
            int[] ptrEffect = new int[1];
            OS.MoveMemory(ptrEffect, stgmedium.unionField, 4);
            int[] effect = new int[1];
            OS.MoveMemory(effect, ptrEffect[0], 4);
            this.dataEffect = this.osToOp(effect[0]);
        }
        if (fRelease == 1) {
            COM.ReleaseStgMedium(pmedium);
        }
        return 0;
    }

    public void setTransfer(Transfer[] transferAgents) {
        this.transferAgents = transferAgents;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }
}

