/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private COMObject iDataObject;
    private int refCount;
    private final int MAX_RETRIES = 10;
    private Transfer[] transferAgents = new Transfer[0];
    private Object[] data = new Object[0];
    private int CFSTR_PREFERREDDROPEFFECT;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        TCHAR chFormatName = new TCHAR(0, "Preferred DropEffect", true);
        this.CFSTR_PREFERREDDROPEFFECT = OS.RegisterClipboardFormat(chFormatName);
        this.createCOMInterfaces();
        this.AddRef();
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    public void dispose() {
        this.Release();
    }

    public Object getContents(Transfer transfer) {
        int[] ppv = new int[1];
        int retries = 0;
        while (COM.OleGetClipboard(ppv) != 0 && retries < 10) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            ++retries;
        }
        if (retries == 10) {
            return null;
        }
        IDataObject dataObject = new IDataObject(ppv[0]);
        TransferData[] allowed = transfer.getSupportedTypes();
        TransferData match = null;
        int i = 0;
        while (i < allowed.length) {
            if (dataObject.QueryGetData(allowed[i].formatetc) == 0) {
                match = allowed[i];
                break;
            }
            ++i;
        }
        if (match == null) {
            return null;
        }
        match.pIDataObject = ppv[0];
        return transfer.nativeToJava(match);
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error(5);
        }
        this.data = data;
        this.transferAgents = dataTypes;
        int retries = 0;
        int result = 0;
        while ((result = COM.OleSetClipboard(this.iDataObject.getAddress())) != 0 && retries < 10) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            ++retries;
        }
        if (retries == 10) {
            DND.error(2002, result);
        }
        if (COM.OleIsCurrentClipboard(this.iDataObject.getAddress()) != 0) {
            return;
        }
        retries = 0;
        while (COM.OleFlushClipboard() != 0 && retries < 10) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            ++retries;
        }
        if (retries == 10) {
            DND.error(2002, result);
        }
        this.data = new Object[0];
        this.transferAgents = new Transfer[0];
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[12];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 1;
        nArray[11] = 1;
        this.iDataObject = new COMObject(nArray){

            public int method0(int[] args) {
                return Clipboard.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Clipboard.this.AddRef();
            }

            public int method2(int[] args) {
                return Clipboard.this.Release();
            }

            public int method3(int[] args) {
                return Clipboard.this.GetData(args[0], args[1]);
            }

            public int method5(int[] args) {
                return Clipboard.this.QueryGetData(args[0]);
            }

            public int method8(int[] args) {
                return Clipboard.this.EnumFormatEtc(args[0], args[1]);
            }
        };
    }

    private void disposeCOMInterfaces() {
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    private int EnumFormatEtc(int dwDirection, int ppenumFormatetc) {
        Object[] formats;
        if (dwDirection == 2) {
            return -2147467263;
        }
        TransferData[] allowedDataTypes = new TransferData[]{};
        int i = 0;
        while (i < this.transferAgents.length) {
            formats = this.transferAgents[i].getSupportedTypes();
            TransferData[] newAllowedDataTypes = new TransferData[allowedDataTypes.length + formats.length];
            System.arraycopy(allowedDataTypes, 0, newAllowedDataTypes, 0, allowedDataTypes.length);
            System.arraycopy(formats, 0, newAllowedDataTypes, allowedDataTypes.length, formats.length);
            allowedDataTypes = newAllowedDataTypes;
            ++i;
        }
        OleEnumFORMATETC enumFORMATETC = new OleEnumFORMATETC();
        enumFORMATETC.AddRef();
        formats = new FORMATETC[allowedDataTypes.length + 1];
        int i2 = 0;
        while (i2 < allowedDataTypes.length) {
            formats[i2] = allowedDataTypes[i2].formatetc;
            ++i2;
        }
        FORMATETC dropeffect = new FORMATETC();
        dropeffect.cfFormat = this.CFSTR_PREFERREDDROPEFFECT;
        dropeffect.dwAspect = 1;
        dropeffect.lindex = -1;
        dropeffect.tymed = 1;
        formats[formats.length - 1] = dropeffect;
        enumFORMATETC.setFormats((FORMATETC[])formats);
        OS.MoveMemory(ppenumFormatetc, new int[]{enumFORMATETC.getAddress()}, 4);
        return 0;
    }

    private int GetData(int pFormatetc, int pmedium) {
        if (pFormatetc == 0 || pmedium == 0) {
            return -2147024809;
        }
        if (this.QueryGetData(pFormatetc) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, pFormatetc, 20);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            STGMEDIUM stgmedium = new STGMEDIUM();
            stgmedium.tymed = 1;
            stgmedium.unionField = OS.GlobalAlloc(64, 4);
            OS.MoveMemory(stgmedium.unionField, new int[]{1}, 4);
            stgmedium.pUnkForRelease = 0;
            COM.MoveMemory(pmedium, stgmedium, 12);
            return 0;
        }
        int transferIndex = -1;
        int i = 0;
        while (i < this.transferAgents.length) {
            if (this.transferAgents[i].isSupportedType(transferData)) {
                transferIndex = i;
                break;
            }
            ++i;
        }
        if (transferIndex == -1) {
            return -2147221404;
        }
        this.transferAgents[transferIndex].javaToNative(this.data[transferIndex], transferData);
        COM.MoveMemory(pmedium, transferData.stgmedium, 12);
        return transferData.result;
    }

    private int QueryGetData(int pFormatetc) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, pFormatetc, 20);
        transferData.type = transferData.formatetc.cfFormat;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            return 0;
        }
        int i = 0;
        while (i < this.transferAgents.length) {
            if (this.transferAgents[i].isSupportedType(transferData)) {
                return 0;
            }
            ++i;
        }
        return -2147221404;
    }

    private int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, 16);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIDataObject)) {
            OS.MoveMemory(ppvObject, new int[]{this.iDataObject.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new int[1], 4);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    public String[] getAvailableTypeNames() {
        int[] ppv = new int[1];
        int retrys = 0;
        while (COM.OleGetClipboard(ppv) != 0 && retrys < 10) {
            ++retrys;
        }
        if (retrys == 10) {
            return null;
        }
        IDataObject dataObject = new IDataObject(ppv[0]);
        int[] ppFormatetc = new int[1];
        int rc = dataObject.EnumFormatEtc(1, ppFormatetc);
        dataObject.Release();
        if (rc != 0) {
            DND.error(1);
        }
        IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(ppFormatetc[0]);
        int rgelt = OS.GlobalAlloc(64, 20);
        int[] pceltFetched = new int[1];
        iEnumFORMATETC.Reset();
        String[] types = new String[]{};
        block20: while (iEnumFORMATETC.Next(1, rgelt, pceltFetched) == 0 && pceltFetched[0] == 1) {
            FORMATETC formatetc = new FORMATETC();
            COM.MoveMemory(formatetc, rgelt, 20);
            int maxSize = 128;
            TCHAR buffer = new TCHAR(0, maxSize);
            int size = OS.GetClipboardFormatName(formatetc.cfFormat, buffer, maxSize);
            String type = null;
            if (size != 0) {
                type = buffer.toString(0, size);
            } else {
                switch (formatetc.cfFormat) {
                    case 15: {
                        type = "CF_HDROP";
                        break;
                    }
                    case 1: {
                        type = "CF_TEXT";
                        break;
                    }
                    case 2: {
                        type = "CF_BITMAP";
                        break;
                    }
                    case 3: {
                        type = "CF_METAFILEPICT";
                        break;
                    }
                    case 4: {
                        type = "CF_SYLK";
                        break;
                    }
                    case 5: {
                        type = "CF_DIF";
                        break;
                    }
                    case 6: {
                        type = "CF_TIFF";
                        break;
                    }
                    case 7: {
                        type = "CF_OEMTEXT";
                        break;
                    }
                    case 8: {
                        type = "CF_DIB";
                        break;
                    }
                    case 9: {
                        type = "CF_PALETTE";
                        break;
                    }
                    case 10: {
                        type = "CF_PENDATA";
                        break;
                    }
                    case 11: {
                        type = "CF_RIFF";
                        break;
                    }
                    case 12: {
                        type = "CF_WAVE";
                        break;
                    }
                    case 13: {
                        type = "CF_UNICODETEXT";
                        break;
                    }
                    case 14: {
                        type = "CF_ENHMETAFILE";
                        break;
                    }
                    case 16: {
                        type = "CF_LOCALE";
                        break;
                    }
                    case 17: {
                        type = "CF_MAX";
                        break;
                    }
                    default: {
                        continue block20;
                    }
                }
            }
            String[] newTypes = new String[types.length + 1];
            System.arraycopy(types, 0, newTypes, 0, types.length);
            newTypes[types.length] = type;
            types = newTypes;
        }
        OS.GlobalFree(rgelt);
        iEnumFORMATETC.Release();
        return types;
    }
}

