/* 
 *  This is a sample implementation of the Transaction Processing Performance 
 *  Council Benchmark B coded in Java and ANSI SQL2. 
 *
 *  This version is using one connection per thread to parallellize
 *  server operations.
 */ 

import java.sql.*;

class JDBCBench
{

    int failed_transactions = 0;
    int transaction_count = 0;
    static int n_clients = 10;
    static int n_txn_per_client = 10;
    long start_time = 0;
    
    static boolean verbose = false;
    
    MemoryWatcherThread MemoryWatcher;
    
    /* main program,    creates a 1-tps database:  i.e. 1 branch, 10 tellers,...
     *                    runs one TPC BM B transaction
     */
     
    public static void main(String[] Args)
    {
      String DriverName = "";
      String DBUrl = "";
      String DBUser = "informix";
      String DBPasswd = "informix";
      boolean do_baseline = false;
      
      for (int i = 0; i < Args.length; i++) {
        if (Args[i].equals("-clients")) {
            if (i + 1 < Args.length) {
                i++;
                n_clients = Integer.parseInt(Args[i]);
            }
        }
        else if (Args[i].equals("-driver")) {
            if (i + 1 < Args.length) {
                i++;
                DriverName = Args[i];
            }
        } 
        else if (Args[i].equals("-url")) {
            if (i + 1 < Args.length) {
                i++;
                DBUrl = Args[i];
            }
        }
        else if (Args[i].equals("-username")) {
            if (i + 1 < Args.length) {
                i++;
                DBUser = Args[i];
            }
        }
        else if (Args[i].equals("-password")) {
            if (i + 1 < Args.length) {
                i++;
                DBPasswd = Args[i];
            }
        }
        else if (Args[i].equals("-baseline")) {
            do_baseline = true;
        }
        else if (Args[i].equals("-tpc")) {
            if (i + 1 < Args.length) {
                i++;
                n_txn_per_client = Integer.parseInt(Args[i]);
            }
        }
        else if (Args[i].equals("-v")) {
            verbose = true;
        }
      }
      
      if (DriverName.length() == 0 || DBUrl.length() == 0) {
        System.out.println("usage: java JDBCBench -driver [driver_class_name] -url [url_to_db] [-v] [-tpc n] [-clients]");
    System.out.println();
    System.out.println("-v      verbose error messages");
    System.out.println("-tpc    transactions per client");
    System.out.println("-clients    number of simultaneous clients"); 
        System.exit(-1);
      }
      
      System.out.println("*********************************************************");
      System.out.println("* JDBCBench v1.0 (PTC)                                  *");
      System.out.println("*********************************************************");
      System.out.println();
      System.out.println("Driver: " + DriverName);
      System.out.println("URL:" + DBUrl);
      System.out.println();
      System.out.println("Number of clients: " + n_clients);
      System.out.println("Number of transactions per client: " + n_txn_per_client);
      System.out.println();
      
      try {
        Class.forName(DriverName);
    Connection C = connect(DBUrl, DBUser, DBPasswd);
        
        JDBCBench Me = new JDBCBench(C, DBUrl, do_baseline, DBUser, DBPasswd );
      }
      catch (Exception E) {
        System.out.println(E.getMessage());
        E.printStackTrace();
      }
    }
    
    public JDBCBench(Connection C, String url, boolean do_baseline, String user, String pass)
    {
        try {
            System.out.println("* Starting Benchmark Run *");
            MemoryWatcher = new MemoryWatcherThread();
            MemoryWatcher.start();
            
            start_time = System.currentTimeMillis();
            
            for (int i = 0; i < n_clients; i++) {
                Thread Client = null;
                if (do_baseline)
                    Client = new ClientThread(n_txn_per_client,url, user, pass);
                else
                    Client = new ClientThreadPS(n_txn_per_client,url, user, pass);
                Client.start();
            }
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            E.printStackTrace();
        }
    }

    public void reportDone()
    {
        n_clients--;
        
        if (n_clients <= 0) {
            MemoryWatcher.interrupt();
        
            long end_time = System.currentTimeMillis(); 
            double completion_time = ((double)end_time - (double)start_time) / 1000;
            System.out.println("* Benchmark finished *");
            System.out.println("\n* Benchmark Report *" );
            System.out.println("--------------------\n");
            System.out.println("Time to execute " +  transaction_count + " transactions: "  + completion_time + " seconds.");
            System.out.println("Max/Min memory usage: " + MemoryWatcher.max + " / " + MemoryWatcher.min + " kb");
            System.out.println(failed_transactions + " / " + transaction_count + " failed to complete.");
            System.out.println("Transaction rate: " + (transaction_count - failed_transactions) / completion_time + " txn/sec.");

        System.exit(0);
        }
        
    }

    public synchronized void incrementTransactionCount()
    {
    transaction_count++;
    }
    
    public synchronized void incrementFailedTransactionCount()
    {
    failed_transactions++;
    }
            
    public static int getRandomInt(int lo, int hi)
    {
          int ret = 0;
          
          ret = (int)(Math.random() * (hi - lo + 1));
          ret += lo;
          
          return ret;
    }
    
    public static int getRandomID(int type)
    {
        int min, max, num;

        max = min = 0;

        return (getRandomInt(min, max));
    }

    public static Connection connect(String DBUrl, String DBUser, String DBPasswd)
    {
    try {
        Connection conn = DriverManager.getConnection(DBUrl, DBUser, DBPasswd);
        return conn;
    } catch (Exception E) {
        System.out.println(E.getMessage());
        E.printStackTrace();
    }

    return null;
    }
    
    public static void connectClose(Connection c)
    {
    try {
        c.close();
    } catch (Exception E) {
        System.out.println(E.getMessage());
        E.printStackTrace();
    }
    }

    class ClientThread extends Thread 
    {
        int ntrans = 0;
        Connection Conn;

        String Query = "";

        public ClientThread(int number_of_txns,String url, String user, String pass) 
        {
            ntrans = number_of_txns;

        Conn = connect(url, user, pass);

        Query += "SELECT * ";
        Query += "FROM opt_tariff_line_item_location  ";
        Query += "WHERE tariff_table_identifier = 2 and  ";
        Query += "tariff_discount_level_low_number <= 1 and  ";
        Query += "tariff_discount_level_high_number >= 1 and  ";
        Query += "tariff_line_item_low_break_value <= 0.5 and  ";
        Query += "0.5 < tariff_line_item_high_break_value and  ";
        Query += "zone_origin_identifier = 225 and  ";
        Query += "zone_destination_identifier = 172 ";

        }
        
        public void run()
        {
            while (ntrans-- > 0) {
                if (doOne() == 178.0)
                    incrementTransactionCount();
                else
                    incrementFailedTransactionCount();
            }
            reportDone();

        connectClose(Conn);
        }
                       
        /*
         *  doOne() - Executes a single TPC BM B transaction.
         */
    
        float doOne()
        {
            try {
                Statement stmt = Conn.createStatement();

                ResultSet RS = stmt.executeQuery(Query);
                       
                stmt.clearWarnings();
                
                float aBalance = 0.0f;
                
                while (RS.next()) {
                    aBalance = RS.getFloat(9);
                }

                stmt.close();

                return aBalance;
            }
            catch (SQLException E) {
                if (verbose) {
                    System.out.println("Transaction failed: " + E.getMessage());
                    E.printStackTrace();
                } 
                incrementFailedTransactionCount();
            }
            return 0;
    
        }           /* end of DoOne         */
        
    
          
 
    }
    
    class ClientThreadPS extends Thread 
    {
        int ntrans = 0;
    Connection Conn;

    PreparedStatement pstmt;

        public ClientThreadPS(int number_of_txns,String url, String user, String pass) 
        {
            ntrans = number_of_txns;

        Conn = connect(url, user, pass);
        
        try {
        String Query = "";

/*
        pstmt.setInt(1,2);
        pstmt.setInt(2,1);
        pstmt.setInt(3,1);
        pstmt.setFloat(4,0.5);
        pstmt.setFloat(5,0.5);
        pstmt.setInt(6,225);
        pstmt.setInt(7,172);
*/
        Query += "SELECT * ";
        Query += "FROM opt_tariff_line_item_location ";
        Query += "WHERE tariff_table_identifier = ? and ";
        Query += "tariff_discount_level_low_number <= ? and ";
        Query += "tariff_discount_level_high_number >= ? and ";
        Query += "tariff_line_item_low_break_value <= ? ";
        Query += "and ? < tariff_line_item_high_break_value and ";
        Query += "zone_origin_identifier = ? and ";
        Query += "zone_destination_identifier = ?";

        pstmt = Conn.prepareStatement(Query);     

        } catch (Exception E) {
        System.out.println(E.getMessage());
        E.printStackTrace();
        }
        }
        
        public void run()
        {
            while (ntrans-- > 0) {
                
                if (doOne() == 178.0)
                    incrementTransactionCount();
                else
                    incrementFailedTransactionCount();
            }
            reportDone();

        try {
        pstmt.close();
        } catch (Exception E) {
        System.out.println(E.getMessage());
        E.printStackTrace();
        }

        connectClose(Conn);
        }
                       
        /*
         *  doOne() - Executes a single TPC BM B transaction.
         */
    
        float doOne()
        {
            try {
                pstmt.setInt(1,2);
                pstmt.setInt(2,1);
                pstmt.setInt(3,1);
                pstmt.setFloat(4,0.5f);
                pstmt.setFloat(5,0.5f);
                pstmt.setInt(6,225);
                pstmt.setInt(7,172);
                       
                ResultSet RS = pstmt.executeQuery();
                pstmt.clearWarnings();
                
                float aBalance = 0.0f;
                
                while (RS.next()) {
                    aBalance = RS.getFloat(9);
                }

                return aBalance;
            }
            catch (SQLException E) {
                if (verbose) {
                    System.out.println("Transaction failed: " + E.getMessage());
                    E.printStackTrace();
                } 
                incrementFailedTransactionCount();
            }
            return 0;
    
        }           /* end of DoOne         */
        
    
          
 
    }
    
    class MemoryWatcherThread extends Thread
    {
        long min = 0;
        long max = 0;
        
        public void run()
        {
            min = Runtime.getRuntime().freeMemory();
            
            for (;;) {
                long currentFree = Runtime.getRuntime().freeMemory();
                long currentAlloc = Runtime.getRuntime().totalMemory();
                long used = currentAlloc - currentFree;
                
                if (used < min)
                    min = used;
                if (used > max)
                    max = used;
                    
                try {
                    sleep(100);
                }
                catch (InterruptedException E) {}
            }
         }
    }
                
                
            
}

