/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxXAPooledConnection;
import com.informix.jdbcx.IfxXAResource;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class IfxXAReusableConnection
extends IfxSqliConnect {
    IfxPooledConnection parentPooledConn;
    private Properties dsProps;
    private boolean xaOpened = false;
    boolean startXA = false;
    Trace trace = null;

    public IfxXAReusableConnection(IfxPooledConnection ifxPooledConnection, String string, Properties properties) throws SQLException {
        super(string, properties);
        if (this.externalVersion.startsWith("8")) {
            throw IfxErrMsg.getSQLException((int)-79834, (IfxConnection)this);
        }
        this.parentPooledConn = ifxPooledConnection;
        this.dsProps = properties;
        this.startXA = false;
        this.trace = super.getTrace();
    }

    protected void finalize() {
        try {
            if (((IfxXAPooledConnection)this.parentPooledConn).connOpen) {
                this.hardClose();
            }
        }
        catch (Exception exception) {}
    }

    public void close() throws SQLException {
        this.parentPooledConn.notifyListeners();
    }

    void hardClose() throws SQLException {
        try {
            this.clearTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.dbName != null) {
            ((IfxXAPooledConnection)this.parentPooledConn).closeDBforXA();
        }
        super.close();
    }

    public void commit() throws SQLException {
        if (this.startXA) {
            throw IfxErrMsg.getSQLException((int)-700, (IfxConnection)this);
        }
        super.commit();
    }

    public void rollback() throws SQLException {
        if (this.startXA) {
            throw IfxErrMsg.getSQLException((int)-700, (IfxConnection)this);
        }
        super.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.startXA) {
            throw IfxErrMsg.getSQLException((int)-700, (IfxConnection)this);
        }
        super.setAutoCommit(bl);
    }

    String getServerName() {
        return this.dsProps.getProperty("INFORMIXSERVER");
    }

    public boolean isXAConnection() {
        return true;
    }

    public boolean inXATransaction() {
        return this.startXA;
    }

    protected void clearTransactions() throws SQLException {
        Xid xid = null;
        IfxXAResource ifxXAResource = ((IfxXAPooledConnection)this.parentPooledConn).xaRes;
        if (this.inXATransaction()) {
            if (ifxXAResource.xidList != null && ifxXAResource.xidList.size() > 0) {
                xid = (Xid)ifxXAResource.xidList.lastElement();
                try {
                    ifxXAResource.end(xid, 0x4000000);
                    ifxXAResource.rollback(xid);
                }
                catch (XAException xAException) {
                    throw new SQLException(xAException.errorCode + ": " + xAException.toString());
                }
            }
        } else if (this.isInUserTransaction()) {
            this.rollback();
        } else if (ifxXAResource != null && ifxXAResource.xidList != null) {
            while (ifxXAResource.xidList.size() > 0) {
                xid = (Xid)ifxXAResource.xidList.elementAt(0);
                try {
                    ifxXAResource.rollback(xid);
                }
                catch (XAException xAException) {
                    try {
                        ifxXAResource.forget(xid);
                    }
                    catch (XAException xAException2) {
                        throw new SQLException(xAException.errorCode + ": " + xAException.toString());
                    }
                }
            }
        }
        if (ifxXAResource != null) {
            ifxXAResource.removeXidList();
        }
    }

    private void printXidList() {
        Vector vector;
        IfxXAResource ifxXAResource = ((IfxXAPooledConnection)this.parentPooledConn).xaRes;
        if (ifxXAResource != null && (vector = ifxXAResource.xidList) != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                System.out.println(enumeration.nextElement());
            }
        }
    }
}

