/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxReUsableConnection;
import com.informix.jdbcx.IfxSqliConnReUsableConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class IfxPooledConnection
implements PooledConnection {
    private Vector listeners = null;
    private Properties DSProp = null;
    private IfxReUsableConnection conn = null;
    private IfxConnectionPoolDataSource cpds = null;
    protected long timeInPool = 0L;
    Trace trace = null;

    public IfxPooledConnection() throws SQLException {
        this.listeners = new Vector();
        this.DSProp = null;
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IfxPooledConnection(IfxConnectionPoolDataSource ifxConnectionPoolDataSource) throws SQLException {
        this.cpds = ifxConnectionPoolDataSource;
        this.conn = null;
        this.listeners = new Vector();
        Properties properties = this.DSProp = this.cpds.getDsProperties();
        synchronized (properties) {
            int n;
            String string = this.DSProp.getProperty("IFMX_CPM_MAX_CONNECTIONS");
            if (string == null || string.length() == 0) {
                string = "-1";
            }
            if ((n = Integer.parseInt(string)) != -1 && this.cpds.getConnectionCount() >= n) {
                throw IfxErrMsg.getLocSQLException((int)-79831, (String)this.cpds.getIfxCLIENT_LOCALE());
            }
            this.establishConnection();
            this.cpds.incConnectionCount(1);
        }
    }

    public Connection getConnection() throws SQLException {
        return (Connection)((Object)this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.conn == null) {
            return;
        }
        IfxConnectionPoolDataSource ifxConnectionPoolDataSource = this.cpds;
        synchronized (ifxConnectionPoolDataSource) {
            this.conn.hardClose();
            this.cpds.incConnectionCount(-1);
        }
        this.conn = null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.removeElement(connectionEventListener);
    }

    void notifyListeners() throws SQLException {
        this.notifyListenersOfErrors(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListenersOfErrors(SQLException sQLException) throws SQLException {
        int n = 0;
        int n2 = 0;
        ConnectionEventListener connectionEventListener = null;
        Vector vector = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        n = vector.size();
        n2 = 0;
        while (n2 < n) {
            connectionEventListener = (ConnectionEventListener)vector.elementAt(n2);
            if (sQLException != null) {
                connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
                throw sQLException;
            }
            connectionEventListener.connectionClosed(new ConnectionEvent(this));
            ++n2;
        }
    }

    private void establishConnection() throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string3 = this.DSProp.getProperty("IFXHOST");
        string4 = this.DSProp.getProperty("PORTNO");
        if (string3 != null && string4 != null) {
            string = string3 + ":" + string4;
        }
        if ((string2 = this.DSProp.getProperty("DATABASE")) != null) {
            SQLException sQLException = null;
            this.DSProp.remove("DATABASE");
            try {
                this.conn = this.getClientServerReUsable(string, string2);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            catch (Exception exception) {
                sQLException = IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString(), (String)this.cpds.getIfxCLIENT_LOCALE());
            }
            this.DSProp.setProperty("DATABASE", string2);
            if (sQLException != null) {
                throw sQLException;
            }
        } else {
            throw IfxErrMsg.getLocSQLException((int)-79716, (String)"Missing DATABASE Property", (String)this.cpds.getIfxCLIENT_LOCALE());
        }
    }

    public void setTimeInPool() {
        this.timeInPool = System.currentTimeMillis();
    }

    private IfxReUsableConnection getClientServerReUsable(String string, String string2) throws SQLException {
        if (!this.cpds.checkIsDirect()) {
            IfxSqliConnReUsableConnection ifxSqliConnReUsableConnection = null;
            ifxSqliConnReUsableConnection = new IfxSqliConnReUsableConnection(this, string, this.DSProp, string2);
            return ifxSqliConnReUsableConnection;
        }
        Constructor constructor = this.cpds.getReUsableCons();
        Object[] objectArray = new Object[]{this, string, this.DSProp, string2};
        if (constructor != null) {
            try {
                this.conn = (IfxReUsableConnection)constructor.newInstance(objectArray);
                return this.conn;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString());
            }
        }
        try {
            String string3 = "com.informix.jdbcx.IfxDirConnReUsableConnection";
            Class<?> clazz = Class.forName(string3);
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            Class[] classArray = new Class[]{this.getClass(), string.getClass(), this.DSProp.getClass(), string2.getClass()};
            Constructor<?> constructor2 = clazz.getConstructor(classArray);
            this.cpds.setReUsableCons(constructor2);
            this.conn = (IfxReUsableConnection)constructor2.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString());
        }
        return this.conn;
    }
}

