/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class Decimal {
    private static final int NUM_FRACT_DIGITS = 5;
    public static final String digChar = "0123456789";
    public static final int DEC_T_SIZE = 22;
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    protected short dec_exp = 0;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts = 0;
    protected byte[] dec_dgts;
    protected int lenOfFirstField;
    protected short precStored;
    protected byte pdigs = 0;
    protected byte pscale = 0;
    protected boolean timestamp = false;
    protected byte startCode = 0;
    protected byte endCode = (byte)15;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    public static Hashtable TU_Exp_Table = new Hashtable(12, 1.0f);

    public Decimal() {
    }

    public Decimal(short s, short s2, short s3, byte[] byArray) {
        this.dec_exp = s;
        this.dec_pos = s2;
        this.dec_ndgts = s3;
        if (byArray != null) {
            this.dec_dgts = byArray;
        } else {
            this.dec_dgts = new byte[s3 > 0 ? s3 : (short)1];
            Decimal.byfill(this.dec_dgts, (byte)0);
        }
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - 2];
        int n = 2;
        while (n < byArray.length) {
            byArray2[n - 2] = byArray[n];
            ++n;
        }
        this.init(byArray2, 0, byArray2.length, (short)0);
    }

    public Decimal(byte[] byArray, short s) {
        this.init(byArray, 0, byArray.length, s);
    }

    public Decimal(byte[] byArray, int n, int n2, short s) {
        this.init(byArray, n, n2, s);
    }

    public Decimal(byte[] byArray, short s, boolean bl) {
        this.timestamp = bl;
        this.init(byArray, 0, byArray.length, s);
    }

    public Decimal(byte[] byArray, int n, int n2, short s, boolean bl) {
        this.timestamp = bl;
        this.init(byArray, n, n2, s);
    }

    public Decimal(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        int n4 = 0;
        this.dec_pos = 1;
        char c2 = string.charAt(0);
        if (c2 == '-') {
            this.dec_pos = 0;
            ++n;
        } else if (c2 == '+') {
            ++n;
        }
        if (n > 0) {
            --n3;
        }
        int n5 = n;
        while (n5 < string.length() && string.charAt(n5) != '.') {
            ++n2;
            ++n5;
        }
        if (n5 != string.length()) {
            bl = true;
            --n3;
            n2 += this.extractExponent(string, n5);
        }
        if (n2 % 2 != 0) {
            ++n3;
            this.dec_exp = (short)((n2 + 1) / 2);
            n4 = 1;
        } else {
            this.dec_exp = (short)(n2 / 2);
        }
        if (n3 % 2 == 1) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        Decimal.byfill(byArray, (byte)0);
        n5 = 0;
        while (n5 < string.length() && string.charAt(n5) != 'E') {
            int n6 = digChar.indexOf(string.charAt(n5));
            if (n6 != -1) {
                byArray[n4] = (byte)n6;
                ++n4;
            }
            ++n5;
        }
        this.dec_ndgts = (short)(n3 / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        int n7 = 0;
        while (n7 < this.dec_dgts.length) {
            this.dec_dgts[n7] = (byte)(byArray[2 * n7] * 10 + byArray[2 * n7 + 1]);
            ++n7;
        }
        if (this.dec_ndgts > 16 && this.dec_dgts[16] >= 50 && this.dec_dgts[15] < 99) {
            this.dec_dgts[15] = (byte)(this.dec_dgts[15] + 1);
            byte[] byArray2 = this.dec_dgts;
            this.dec_dgts = new byte[16];
            this.dec_ndgts = (short)16;
            Decimal.bycopy(byArray2, 0, this.dec_dgts, 0);
        }
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(String string, short s) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        int n4 = 0;
        this.dec_pos = 1;
        char c2 = string.charAt(0);
        if (c2 == '-') {
            this.dec_pos = 0;
            ++n;
        } else if (c2 == '+') {
            ++n;
        }
        if (n > 0) {
            --n3;
        }
        int n5 = n;
        while (n5 < string.length() && string.charAt(n5) != '.') {
            ++n2;
            ++n5;
        }
        if (n5 != string.length()) {
            bl = true;
            --n3;
            n2 += this.extractExponent(string, n5);
        }
        if (n2 % 2 != 0) {
            ++n3;
            this.dec_exp = (short)((n2 + 1) / 2);
            n4 = 1;
        } else {
            this.dec_exp = (short)(n2 / 2);
        }
        if (n3 % 2 == 1) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        Decimal.byfill(byArray, (byte)0);
        n5 = 0;
        while (n5 < string.length() && string.charAt(n5) != 'E') {
            int n6 = digChar.indexOf(string.charAt(n5));
            if (n6 != -1) {
                byArray[n4] = (byte)n6;
                ++n4;
            }
            ++n5;
        }
        this.dec_ndgts = (short)(n3 / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        int n7 = 0;
        while (n7 < this.dec_dgts.length) {
            this.dec_dgts[n7] = (byte)(byArray[2 * n7] * 10 + byArray[2 * n7 + 1]);
            ++n7;
        }
        if (this.dec_ndgts > 16 && this.dec_dgts[16] >= 50) {
            this.dec_dgts[15] = (byte)(this.dec_dgts[15] + 1);
            byte[] byArray2 = this.dec_dgts;
            this.dec_dgts = new byte[16];
            this.dec_ndgts = (short)16;
            Decimal.bycopy(byArray2, 0, this.dec_dgts, 0);
        }
        this.dec_exp = (short)((Decimal.tuLen(s) + 10 - Decimal.tuEnd((byte)s) + 1) / 2);
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(BigDecimal bigDecimal) {
        this(bigDecimal.toString());
        this.pscale = (byte)bigDecimal.scale();
    }

    public Decimal(boolean bl, byte[] byArray, int n, short s) {
        this.dec_pos = bl ? (short)0 : 1;
        this.dec_ndgts = (short)n;
        this.dec_exp = (short)((Decimal.tuLen(s) + 10 - Decimal.tuEnd((byte)s) + 1) / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        System.arraycopy(byArray, 0, this.dec_dgts, 0, this.dec_ndgts);
    }

    public Decimal(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.dec_pos = 1;
        if (n != 0) {
            this.dec_ndgts = (short)10;
            this.dec_exp = (short)7;
            this.dec_dgts = new byte[this.dec_ndgts];
            this.dec_dgts[0] = (byte)(n / 100);
            this.dec_dgts[1] = (byte)(n % 100);
            this.dec_dgts[2] = (byte)n2;
            this.dec_dgts[3] = (byte)n3;
            this.dec_dgts[4] = (byte)n4;
            this.dec_dgts[5] = (byte)n5;
            this.dec_dgts[6] = (byte)n6;
            this.dec_dgts[7] = (byte)(n7 / 1000);
            this.dec_dgts[8] = (byte)(n7 % 1000 / 10);
            this.dec_dgts[9] = (byte)(n7 % 10 * 10);
        } else {
            this.dec_ndgts = (short)3;
            this.dec_exp = (short)3;
            this.dec_dgts = new byte[this.dec_ndgts];
            this.dec_dgts[0] = (byte)n4;
            this.dec_dgts[1] = (byte)n5;
            this.dec_dgts[2] = (byte)n6;
        }
    }

    public final void setTimestampQualifier(short s) {
        this.setT();
        this.precStored = s;
        this.unpackPrecision(s);
    }

    public final void setT() {
        this.timestamp = true;
    }

    public final void unpackPrecision(short s) {
        this.pdigs = (byte)(s >> 8);
        if (!this.timestamp) {
            this.pscale = (byte)(s & 0xFF);
        } else {
            byte by = (byte)(s & 0xF);
            if (by > 10) {
                this.pscale = (byte)(by - 10);
            } else {
                by = 0;
            }
            byte by2 = (byte)(s & 0xFF);
            this.startCode = (byte)(by2 >> 4 & 0xF);
            this.endCode = (byte)(by2 & 0xF);
            this.lenOfFirstField = Decimal.tuFLen(s);
        }
    }

    protected void computePrecision() {
        this.pdigs = (byte)(this.dec_ndgts * 2);
    }

    protected void computeScale() {
        this.pscale = (byte)((this.dec_ndgts - this.dec_exp) * 2);
    }

    public byte[] getPrecision() {
        byte[] byArray = new byte[]{this.pdigs, this.pscale};
        return byArray;
    }

    protected void init(byte[] byArray, int n, int n2, short s) {
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return;
        }
        this.precStored = s;
        this.unpackPrecision(s);
        this.dec_dgts = new byte[n2 - 1];
        Decimal.bycopy(byArray, n + 1, this.dec_dgts, 0);
        short s2 = byArray[n];
        this.dec_pos = 1;
        if ((s2 & 0x80) == 0) {
            Decimal.decComplement(this.dec_dgts, 0);
            s2 = (short)(s2 ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = s2 = (short)((s2 & 0x7F) - 64);
        boolean bl = true;
        int n3 = 1;
        while (n3 < n2) {
            if (byArray[n + n3] != 0) {
                bl = false;
                break;
            }
            ++n3;
        }
        this.dec_ndgts = bl ? (short)0 : (short)(n2 - 1);
        if (this.pdigs == 0) {
            this.computePrecision();
        }
        if (this.pscale == 0) {
            this.computeScale();
        }
    }

    protected int extractExponent(String string, int n) {
        int n2 = 0;
        boolean bl = true;
        int n3 = n;
        while (n3 < string.length() && string.charAt(n3) != 'E') {
            ++n3;
        }
        if (n3 == string.length()) {
            return n2;
        }
        if (string.charAt(++n3) == '+') {
            ++n3;
        } else if (string.charAt(n3) == '-') {
            ++n3;
            bl = false;
        }
        int n4 = n3;
        while (n4 < string.length()) {
            n2 = n2 * 10 + digChar.indexOf(string.charAt(n4));
            ++n4;
        }
        return bl ? n2 : -n2;
    }

    public static byte[] byfill(byte[] byArray, byte by) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return byArray;
    }

    public static char[] charfill(char[] cArray, int n, int n2, char c2) {
        int n3 = n;
        while (n3 <= n2 && n3 < cArray.length) {
            cArray[n3] = c2;
            ++n3;
        }
        return cArray;
    }

    public static void bycopy(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2;
        int n4 = n;
        while (n4 < byArray.length && n3 < byArray2.length) {
            byArray2[n3] = byArray[n4];
            ++n4;
            ++n3;
        }
    }

    public static void charcopy(char[] cArray, int n, int n2, char[] cArray2, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 < cArray.length && n5 <= n2 && n4 < cArray2.length) {
            cArray2[n4] = cArray[n5];
            ++n5;
            ++n4;
        }
    }

    public static byte[] decComplement(byte[] byArray, int n) {
        int n2 = 100;
        int n3 = byArray.length - 1;
        while (n3 >= n) {
            if (byArray[n3] != 0 || n2 != 100) {
                byArray[n3] = (byte)(n2 - byArray[n3]);
                n2 = 99;
            }
            --n3;
        }
        return byArray;
    }

    public byte[] javaToIfx() {
        byte[] byArray = new byte[this.dec_ndgts + 3];
        boolean bl = false;
        Decimal.byfill(byArray, (byte)0);
        int n = this.dec_ndgts + 1;
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        if (this.dec_pos == -1) {
            return byArray;
        }
        byArray[2] = (byte)(this.dec_exp + 64 & 0x7F);
        Decimal.bycopy(this.dec_dgts, 0, byArray, 3);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                byArray[2] = (byte)(byArray[2] | 0x80);
            } else {
                Decimal.decComplement(byArray, 3);
                byArray[2] = (byte)(byArray[2] ^ 0x7F);
            }
        } else {
            byArray[2] = (byte)(byArray[2] | 0x80);
        }
        return byArray;
    }

    public byte[] javaToDec_t() {
        int n;
        byte[] byArray = new byte[22];
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_exp), 0, byArray, 0, 2);
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_pos), 0, byArray, 2, 2);
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_ndgts), 0, byArray, 4, 2);
        if (this.dec_dgts == null) {
            this.dec_dgts = new byte[16];
            Decimal.byfill(this.dec_dgts, (byte)0);
        }
        if ((n = this.dec_dgts.length) > 16) {
            n = 16;
        }
        System.arraycopy(this.dec_dgts, 0, byArray, 6, n);
        return byArray;
    }

    public static Decimal dec_tToJava(byte[] byArray) {
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 2);
        System.arraycopy(byArray, 2, byArray3, 0, 2);
        System.arraycopy(byArray, 4, byArray4, 0, 2);
        System.arraycopy(byArray, 6, byArray5, 0, 16);
        short s = IfxToJavaType.IfxToJavaSmallInt(byArray2);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(byArray3);
        short s3 = IfxToJavaType.IfxToJavaSmallInt(byArray4);
        return new Decimal(s, s2, s3, byArray5);
    }

    public char[] sigdigToChar() {
        char[] cArray = new char[this.dec_ndgts * 2];
        int n = 0;
        while (n < this.dec_ndgts) {
            cArray[n * 2] = digChar.charAt(this.dec_dgts[n] / 10);
            cArray[n * 2 + 1] = digChar.charAt(this.dec_dgts[n] % 10);
            ++n;
        }
        return cArray;
    }

    public int sigdigToInt(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            n3 = n3 * 100 + this.dec_dgts[n4];
            ++n4;
        }
        return n3;
    }

    public BigDecimal numericValue() {
        if (this.dec_pos == -1) {
            return new BigDecimal("");
        }
        BigDecimal bigDecimal = new BigDecimal(this.stringValue());
        return bigDecimal;
    }

    public boolean isNull() {
        return this.dec_pos == -1;
    }

    public final Double doubleValue() {
        return new Double(this.numericValue().doubleValue());
    }

    public final Float floatValue() {
        return new Float(this.numericValue().floatValue());
    }

    public String stringValue() {
        char[] cArray;
        if (this.dec_pos == -1) {
            return "";
        }
        int n = this.dec_exp * 2;
        int n2 = -1;
        if (this.dec_ndgts <= 0 && this.dec_exp == 0) {
            return "0.0";
        }
        char[] cArray2 = this.sigdigToChar();
        if (n > 0) {
            if (n <= cArray2.length) {
                cArray = new char[cArray2.length + 2];
                Decimal.charcopy(cArray2, 0, n - 1, cArray, 1);
                cArray[n + 1] = 46;
                if (n != cArray2.length) {
                    Decimal.charcopy(cArray2, n, cArray2.length - 1, cArray, n + 2);
                }
            } else {
                cArray = new char[n + 2];
                Decimal.charcopy(cArray2, 0, cArray2.length - 1, cArray, 1);
                Decimal.charfill(cArray, cArray2.length + 1, n, '0');
                cArray[n + 1] = 46;
            }
        } else {
            cArray = new char[(n *= -1) + cArray2.length + 3];
            cArray[1] = 48;
            cArray[2] = 46;
            Decimal.charfill(cArray, 3, n + 2, '0');
            Decimal.charcopy(cArray2, 0, cArray2.length, cArray, n + 3);
        }
        char[] cArray3 = Decimal.trimZerosFB(cArray, 1);
        cArray3[0] = this.dec_pos == 1 ? 48 : 45;
        return new String(cArray3);
    }

    protected static char[] trimZerosFB(char[] cArray, int n) {
        int n2 = n;
        while (n2 < cArray.length && cArray[n2] == '0') {
            ++n2;
        }
        if (n2 == cArray.length) {
            char[] cArray2 = new char[2];
            cArray2[1] = 48;
            return cArray2;
        }
        int n3 = cArray.length - 1;
        while (n3 >= n2 && cArray[n3] == '0') {
            --n3;
        }
        char[] cArray3 = new char[n3 - n2 + 2];
        int n4 = 1;
        int n5 = n2;
        while (n5 <= n3) {
            cArray3[n4] = cArray[n5];
            ++n5;
            ++n4;
        }
        return cArray3;
    }

    public static byte[] fromBindToTuple(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        Decimal.byfill(byArray2, (byte)0);
        if (byArray.length - 2 < n) {
            n = byArray.length - 2;
        }
        System.arraycopy(byArray, 2, byArray2, 0, n);
        return byArray2;
    }

    public static byte tuEnd(byte by) {
        byte by2 = (byte)(by & 0xF);
        return by2;
    }

    public static byte tuStart(byte by) {
        byte by2 = (byte)(by >> 4 & 0xF);
        return by2;
    }

    public static byte tuLen(short s) {
        byte by = (byte)(s >> 8 & 0xFF);
        return by;
    }

    public static byte[] encodeDateTimePrecision(byte[] byArray, byte by, byte by2) {
        byArray[0] = (byte)(by2 - by + (by == 0 ? 4 : 2));
        byArray[1] = (byte)(by << 4 | by2);
        return byArray;
    }

    public static byte[] encodeIntervalPrecision(byte[] byArray, byte by, byte by2, byte by3) {
        byArray[0] = (byte)(by3 - by2 + by);
        byArray[1] = (byte)(by2 << 4 | by3);
        return byArray;
    }

    public static int tuFLen(short s) {
        byte by = Decimal.tuLen(s);
        byte by2 = Decimal.tuEnd((byte)s);
        byte by3 = Decimal.tuStart((byte)s);
        int n = by - (by2 - by3);
        return n;
    }

    public Timestamp timestampValue() {
        GregorianCalendar gregorianCalendar;
        if (!this.timestamp) {
            return null;
        }
        if (this.dec_pos == -1) {
            return null;
        }
        int[] nArray = new int[7];
        int n = 0;
        while (n < 7) {
            nArray[n] = 0;
            ++n;
        }
        this.fromIfxToArray(nArray);
        if (nArray[0] == 0 || nArray[1] == 0 || nArray[2] == 0) {
            gregorianCalendar = new GregorianCalendar();
            if (nArray[0] == 0) {
                nArray[0] = 1700;
            }
            if (nArray[1] == 0) {
                nArray[1] = gregorianCalendar.get(2) + 1;
            }
            if (nArray[2] == 0) {
                nArray[2] = 1;
            }
        }
        gregorianCalendar = new GregorianCalendar(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
        long l = gregorianCalendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(nArray[6]);
        return timestamp;
    }

    public Interval intervalValue() {
        int n = Interval.getStartCode(this.precStored);
        byte by = Interval.getEndCode(this.precStored);
        int[] nArray = new int[7];
        int n2 = 0;
        while (n2 < 7) {
            nArray[n2] = 0;
            ++n2;
        }
        this.fromIfxToArray(nArray);
        n2 = n > 10 ? 6 : n / 2;
        long l = 0L;
        long l2 = 0L;
        int n3 = n;
        while (n3 < 11) {
            switch (n3) {
                case 0: {
                    l += (long)nArray[n2] * 12L;
                    break;
                }
                case 2: {
                    l += (long)nArray[n2];
                    break;
                }
                case 4: {
                    l += (long)nArray[n2] * 86400L;
                    break;
                }
                case 6: {
                    l += (long)nArray[n2] * 3600L;
                    break;
                }
                case 8: {
                    l += (long)nArray[n2] * 60L;
                    break;
                }
                case 10: {
                    l += (long)nArray[n2];
                    break;
                }
            }
            n3 += 2;
            ++n2;
        }
        l2 = nArray[6];
        if (this.dec_pos == 0) {
            l *= -1L;
            l2 *= -1L;
        }
        Interval interval = null;
        try {
            interval = n >= 4 ? new IntervalDF(l, l2, this.precStored) : new IntervalYM((int)l, this.precStored);
        }
        catch (Exception exception) {
            return null;
        }
        return interval;
    }

    void fromIfxToArray(int[] nArray) {
        int n;
        short s = Interval.getLength(this.precStored);
        byte by = Interval.getStartCode(this.precStored);
        byte by2 = Interval.getEndCode(this.precStored);
        short s2 = (short)(s - (by2 - by));
        byte by3 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n4 = by > 10 ? 6 : by / 2;
        int n5 = this.dec_ndgts - 1;
        while (n5 > 0) {
            if (this.dec_dgts[n5] != 0) break;
            this.dec_ndgts = (short)(this.dec_ndgts - 1);
            --n5;
        }
        int n6 = (s + (by2 & 1) + 1) / 2;
        int n7 = (s + 10 - by2 + 1) / 2;
        byte[] byArray = new byte[n6];
        Decimal.byfill(byArray, (byte)0);
        if (this.dec_ndgts > 0 && n7 >= this.dec_exp) {
            System.arraycopy(this.dec_dgts, 0, byArray, n7 - this.dec_exp, this.dec_ndgts);
        }
        if ((by3 = by) != 12) {
            n = s2 / 2;
            if ((s2 & 1) > 0) {
                ++n;
            }
            while (n3 < n) {
                n2 *= 100;
                n2 += byArray[n3];
                ++n3;
            }
            by3 = (byte)(by3 + 2);
            nArray[n4++] = n2;
        }
        while (by3 <= by2 && by3 <= 10) {
            nArray[n4++] = byArray[n3];
            by3 = (byte)(by3 + 2);
            ++n3;
        }
        n2 = 0;
        if (by2 > 10) {
            by3 = 11;
            while (by3 <= by2) {
                n2 *= 100;
                n2 += byArray[n3];
                ++n3;
                by3 = (byte)(by3 + 2);
            }
            n = 15 - by2 - 1 + 4;
            if ((n & 1) == 0) {
                ++n;
            }
            int n8 = 0;
            while (n8 < n) {
                n2 *= 10;
                ++n8;
            }
            nArray[n4] = n2;
        }
    }

    public static Decimal numericToDecimal(BigDecimal bigDecimal) {
        return new Decimal(bigDecimal);
    }

    static {
        TU_Exp_Table.put(new Integer(0), new Integer(5));
        TU_Exp_Table.put(new Integer(2), new Integer(4));
        TU_Exp_Table.put(new Integer(4), new Integer(3));
        TU_Exp_Table.put(new Integer(6), new Integer(2));
        TU_Exp_Table.put(new Integer(8), new Integer(1));
        TU_Exp_Table.put(new Integer(10), new Integer(0));
        TU_Exp_Table.put(new Integer(11), new Integer(-1));
        TU_Exp_Table.put(new Integer(12), new Integer(-1));
        TU_Exp_Table.put(new Integer(13), new Integer(-2));
        TU_Exp_Table.put(new Integer(14), new Integer(-2));
        TU_Exp_Table.put(new Integer(15), new Integer(-3));
    }
}

