/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSQLOutput;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.SQLUDTOutput;
import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;

public class IfxUDTOutput
extends IfxSQLOutput
implements SQLUDTOutput,
IfmxUDTSQLOutput {
    private static final int NO_ALIGNMENT = -1;
    private boolean autoAlignmentEnabled = true;

    IfxUDTOutput() {
    }

    IfxUDTOutput(IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
    }

    private void checkAlignment(int n, int n2) throws SQLException {
        if (this.autoAlignmentEnabled && n2 != -1) {
            int n3 = this.getCurrentPosition();
            int n4 = (n3 + n + (n2 - 1) & ~(n2 - 1)) - (n3 + n);
            try {
                while (n4-- > 0) {
                    this.os.write(0);
                    super.adjustTotalDataSize();
                }
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    public void writeString(String string, int n) throws SQLException {
        this.checkAlignment(n, -1);
        try {
            int n2 = n - string.length();
            byte[] byArray = string.getBytes();
            this.os.write(byArray, 0, string.length() > n ? n : string.length());
            while (n2-- > 0) {
                this.os.write(0);
            }
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeByte(byte by) throws SQLException {
        this.checkAlignment(1, -1);
        try {
            this.os.writeByte(by);
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeBoolean(boolean bl) throws SQLException {
        byte by = 0;
        if (bl) {
            by = 1;
        }
        try {
            this.writeByte(by);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeShort(short s) throws SQLException {
        this.checkAlignment(2, 2);
        super.writeShort(s);
    }

    public void writeInt(int n) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeInt(n);
    }

    public void writeLong(long l) throws SQLException {
        try {
            short s = 1;
            if (l < 0L) {
                s = -1;
                l = -l;
            }
            long l2 = l & 0xFFFFFFFFL;
            this.writeInt((int)l2);
            int n = (int)(l >> 32);
            this.writeInt(n);
            this.writeShort(s);
            if (this.autoAlignmentEnabled) {
                this.writeByte((byte)0);
                this.writeByte((byte)0);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeFloat(float f2) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeFloat(f2);
    }

    public void writeDouble(double d2) throws SQLException {
        this.checkAlignment(8, 8);
        super.writeDouble(d2);
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        try {
            this.checkAlignment(2, 2);
            this.os.write(new Decimal(bigDecimal).javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeBytes(byte[] byArray, int n) throws SQLException {
        try {
            this.checkAlignment(n, -1);
            int n2 = n - byArray.length;
            this.os.write(byArray);
            while (n2-- > 0) {
                this.os.write(0);
            }
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        try {
            Decimal decimal = JavaToIfxType.convertTimestampToDecimal(timestamp);
            short s = 4365;
            this.checkAlignment(2, 2);
            this.os.writeShort(s);
            this.os.write(decimal.javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeCharacterStream(Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeCharacterStream(Reader).", this.conn);
    }

    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeAsciiStream(InputStream).", this.conn);
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeBinaryStream(InputStream).", this.conn);
    }

    public void writeObject(SQLData sQLData) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeObject(SQLData).", this.conn);
    }

    public void writeRef(Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeRef(Ref).", this.conn);
    }

    void writeIfxLocator(IfxLocator ifxLocator) throws SQLException {
        this.writeBytes(ifxLocator.getRawLocator());
    }

    public void writeBlob(Blob blob) throws SQLException {
        if (!(blob instanceof IfxBblob)) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeBlob(Blob).", this.conn);
        }
        this.writeIfxLocator(((IfxBblob)blob).getLocator());
    }

    public void writeClob(Clob clob) throws SQLException {
        if (!(clob instanceof IfxCblob)) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeClob(Clob).", this.conn);
        }
        this.writeIfxLocator(((IfxCblob)clob).getLocator());
    }

    public void writeStruct(Struct struct) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeStruct(Struct).", this.conn);
    }

    public void writeArray(Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeArray(Array).", this.conn);
    }

    public void writeInterval(Interval interval) throws SQLException {
        try {
            Object var2_2 = null;
            short s = 0;
            s = interval.getQualifier();
            Decimal decimal = interval instanceof IntervalYM ? JavaToIfxType.convertIntervalToDecimal((IntervalYM)interval) : JavaToIfxType.convertIntervalToDecimal((IntervalDF)interval);
            this.checkAlignment(2, 2);
            this.os.writeShort(s);
            this.os.write(decimal.javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.getMessage(), this.conn);
        }
    }

    public int length() {
        return super.length();
    }

    public void setAutoAlignment(boolean bl) {
        this.autoAlignmentEnabled = bl;
    }

    public boolean getAutoAlignment() {
        return this.autoAlignmentEnabled;
    }

    public void skipBytes(int n) throws SQLException {
        this.setCurrentPosition(this.bStream.getCount() + n);
    }

    public int getCurrentPosition() {
        return this.bStream.getCount();
    }

    public void setCurrentPosition(int n) throws SQLException {
        if (n < 0 || n > this.bStream.getTotalDataSize()) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        this.bStream.setCount(n);
    }

    public int available() {
        return this.bStream.getTotalDataSize() - this.bStream.getCount();
    }

    public IfxUDTInfo getUDTInfo(int n) throws SQLException {
        return this.conn.getUDTInfo(n);
    }

    public IfxUDTInfo getUDTInfo(String string, String string2) throws SQLException {
        return this.conn.getUDTInfo(string, string2);
    }

    public void writeURL(URL uRL) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeURL()", this.conn);
    }
}

