/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.sql.SQLException;

public class IfxIntervalYM
extends IfxObject {
    private IntervalYM value = null;

    public IfxIntervalYM() throws SQLException {
        this.setIfxType(14);
    }

    IfxIntervalYM(IntervalYM intervalYM) throws SQLException {
        this.setIfxType(14);
        this.value = intervalYM;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.setEncodedLength(this.value.getQualifier());
        }
    }

    public IntervalYM value() {
        return this.value;
    }

    public byte[] toIfx() {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(this.value);
        return byArray;
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(this.value);
        return Decimal.fromBindToTuple(byArray, IfxDecimal.decLength(this.encodedLength));
    }

    public void fromIfx(byte[] byArray, short s) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    public void fromIfx(byte[] byArray, int n, int n2, short s) throws SQLException {
        this.value = (IntervalYM)IfxToJavaType.IfxToJavaInterval(byArray, n, n2, s);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value.setQualifier((short)this.encodedLength);
        }
    }

    public String toString() {
        if (this.isNull() || this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
            this.value = null;
            return;
        }
        if (this.value == null) {
            this.value = new IntervalYM();
        }
        this.value.fromString(string);
        this.unnullify();
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public Interval toInterval() throws SQLException {
        return this.toIntervalYM();
    }

    public IntervalYM toIntervalYM() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromIntervalYM(IntervalYM intervalYM) throws SQLException {
        if (intervalYM == null) {
            this.nullify();
        } else {
            this.value = intervalYM;
            this.unnullify();
        }
    }

    public short getEncodedLength() {
        if (this.value == null) {
            return (short)this.encodedLength;
        }
        return this.value.getQualifier();
    }
}

