/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import xBaseJ.A710000;
import xBaseJ.A72000;
import xBaseJ.A730000;
import xBaseJ.A740000;
import xBaseJ.CharField;
import xBaseJ.DateField;
import xBaseJ.Field;
import xBaseJ.FloatField;
import xBaseJ.Index;
import xBaseJ.LogicalField;
import xBaseJ.MDX;
import xBaseJ.MemoField;
import xBaseJ.NDX;
import xBaseJ.NumField;
import xBaseJ.Util;
import xBaseJ.xBaseJException;

public class DBF {
    private String dosname;
    private int current_record;
    private short fldcount;
    private long new_record_size;
    private File ffile;
    protected RandomAccessFile file;
    private Vector fld_root;
    private long updateheadercnt;
    private A710000 dbtobj;
    private byte delete_ind = (byte)32;
    private byte version = (byte)3;
    private byte[] l_update = new byte[3];
    private int count;
    private short offset;
    private short lrecl;
    private byte incomplete_transaction;
    private byte encrypt_flag;
    private byte[] reserve = new byte[12];
    private byte MDX_exist;
    private byte language;
    private byte[] reserve2 = new byte[2];
    private int IndexCount;
    private Index jNDX;
    private Vector jNDXes;
    private Vector jNDXID;
    private static long results;
    private A740000 MDXfile;
    public static final byte DBASEIII = 3;
    public static final byte DBASEIV = 4;
    protected static final byte DBASEIII_WITH_MEMO = -125;
    protected static final byte DBASEIV_WITH_MEMO = -117;
    protected static final byte NOTDELETED = 32;
    protected static final byte DELETED = 42;
    public static final char READ_ONLY = 'r';
    protected boolean readonly = false;
    protected static final String xBaseJVersion = "1.8.N";
    protected static final String encodedType = "8559_1";

    public DBF(String string, boolean bl) throws xBaseJException, IOException, SecurityException {
        this.createDBF(string, 3, bl);
    }

    public DBF(String string, int n, boolean bl) throws xBaseJException, IOException, SecurityException {
        this.createDBF(string, n, bl);
    }

    public DBF(String string, char c) throws xBaseJException, IOException {
        if (c != 'r') {
            throw new xBaseJException("Unknown readOnly indicator <" + c + ">");
        }
        this.readonly = true;
        this.A600000(string);
    }

    public DBF(String string) throws xBaseJException, IOException {
        this.readonly = false;
        this.A600000(string);
    }

    private void A600000(String string) throws IOException, xBaseJException {
        this.jNDX = null;
        new Date();
        this.jNDXes = new Vector(1);
        this.jNDXID = new Vector(1);
        ++results;
        this.ffile = new File(string);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(1) > 2000) {
            System.err.println("Package Expired");
        }
        if (calendar.get(1) == 2000) {
            if (calendar.get(2) > 2) {
                System.err.println("Package Expired");
            }
            if (calendar.get(2) == 2) {
                System.err.println("Package Will Expire ");
            }
        }
        System.out.println("Package Expires: 2000-03-31");
        if (!this.ffile.exists() || !this.ffile.isFile()) {
            throw new xBaseJException("Unknown database file");
        }
        if (results > 5L) {
            throw new xBaseJException("Existing File Overloaded");
        }
        this.file = this.readonly ? new RandomAccessFile(string, "r") : new RandomAccessFile(string, "rw");
        this.dosname = string;
        this.A7600000000();
        this.fldcount = (short)((this.offset - 1) / 32 - 1);
        if (this.version != 3 && this.version != -125 && this.version != 4 && this.version != -117) {
            throw new xBaseJException("Wrong Version " + String.valueOf(this.version));
        }
        if (this.version == -125) {
            this.dbtobj = new A730000(this, this.readonly);
        } else if (this.version == -117) {
            this.dbtobj = new A72000(this, this.readonly);
        }
        this.fld_root = new Vector(new Long(this.fldcount).intValue());
        int n = 0;
        while (n < this.fldcount) {
            this.fld_root.addElement(this.A5300000000000000());
            ++n;
        }
        if (this.MDX_exist == 1) {
            this.MDXfile = this.readonly ? new A740000(this.dosname, this, 'r') : new A740000(this.dosname, this, ' ');
            n = 0;
            while (n < this.MDXfile.A66000.A290000) {
                this.jNDXes.addElement(this.MDXfile.MDXes[n]);
                ++n;
            }
        }
        try {
            byte by = this.file.readByte();
            by = this.file.readByte();
        }
        catch (EOFException eOFException) {}
        this.current_record = 0;
    }

    public String version() {
        return xBaseJVersion;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void createDBF(String string, int n, boolean bl) throws xBaseJException, IOException, SecurityException {
        this.jNDX = null;
        this.jNDXes = new Vector(1);
        this.jNDXID = new Vector(1);
        this.ffile = new File(string);
        ++results;
        if (n != 3 && n != 4 && n != -125 && n != -117) {
            throw new xBaseJException("Invalid format specified");
        }
        if (!bl && this.ffile.exists()) {
            throw new xBaseJException("File exists");
        }
        if (bl) {
            if (this.ffile.exists() && !this.ffile.delete()) {
                throw new xBaseJException("Can't delete old DBF file");
            }
            this.ffile = new File(string);
        }
        if (results > 5L) {
            throw new xBaseJException("Existing File Overloaded");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.ffile);
        fileOutputStream.close();
        this.file = new RandomAccessFile(string, "rw");
        this.dosname = string;
        this.fld_root = new Vector(0);
        this.A75000000(n, false);
        if (n != 3) {
            this.MDX_exist = 1;
        }
        this.update_dbhead();
        this.file.writeByte(13);
        this.file.writeByte(26);
        if (n != 3) {
            this.MDXfile = new A740000(string, this, bl);
        }
    }

    public void addField(Field field) throws xBaseJException, IOException {
        Field[] fieldArray = new Field[]{field};
        this.addField(fieldArray);
    }

    public void addField(Field[] fieldArray) throws xBaseJException, IOException {
        int n;
        Field field;
        int n2;
        if (fieldArray.length == 0) {
            throw new xBaseJException("No Fields in array to add");
        }
        if (this.version == 3 && this.MDX_exist == 0 || this.version == -125) {
            if (this.fldcount + fieldArray.length > 128) {
                throw new xBaseJException("Number of fields exceed limit of 128.  New Field count is " + (this.fldcount + fieldArray.length));
            }
        } else if (this.fldcount + fieldArray.length > 255) {
            throw new xBaseJException("Number of fields exceed limit of 255.  New Field count is " + (this.fldcount + fieldArray.length));
        }
        int n3 = 0;
        while (n3 < fieldArray.length) {
            n2 = 1;
            while (n2 <= this.fldcount) {
                field = this.getField(n2);
                if (fieldArray[n3].getName().equalsIgnoreCase(field.getName())) {
                    throw new xBaseJException("Field: " + fieldArray[n3].getName() + " already exists.");
                }
                ++n2;
            }
            ++n3;
        }
        short s = this.lrecl;
        boolean bl = false;
        n3 = 1;
        while (n3 <= this.fldcount) {
            if (!bl) {
                bl = this.getField(n3).getType() == 'M';
            }
            ++n3;
        }
        n3 = 1;
        while (n3 <= fieldArray.length) {
            s = (short)(s + fieldArray[n3 - 1].getLength());
            if (!bl) {
                bl = fieldArray[n3 - 1].getType() == 'M';
            }
            ++n3;
        }
        if (s > 4000) {
            throw new xBaseJException("Record length of 4000 exceeded.  New calculated length is " + s);
        }
        boolean bl2 = false;
        DBF dBF = null;
        String string = "";
        if (this.fldcount > 0) {
            bl2 = true;
        }
        if (bl2) {
            int n4 = this.dosname.toUpperCase().lastIndexOf(".DBF");
            string = new String(String.valueOf(this.dosname.substring(0, n4)) + ".tmd");
            n = this.version;
            if (n == 3 && this.MDX_exist == 1) {
                n = 4;
            }
            --results;
            dBF = new DBF(string, n, true);
            dBF.version = (byte)n;
            dBF.MDX_exist = this.MDX_exist;
        }
        if (bl) {
            if (bl2) {
                dBF.dbtobj = this.version == -125 ? new A730000(this, string, true) : new A72000(this, string, true);
            } else {
                this.dbtobj = this.version == -125 ? new A730000(this, this.dosname, true) : new A72000(this, this.dosname, true);
            }
        }
        if (bl2) {
            super.A75000000(this.version, bl);
            dBF.update_dbhead();
            dBF.offset = this.offset;
            dBF.lrecl = s;
            dBF.fldcount = this.fldcount;
            n2 = 1;
            while (n2 <= this.fldcount) {
                try {
                    field = (Field)this.getField(n2).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new xBaseJException("Clone not supported logic error");
                }
                if (field.getType() == 'M') {
                    ((MemoField)field).setDBTObj(dBF.dbtobj);
                }
                field.setFile(dBF.file);
                dBF.fld_root.addElement(field);
                dBF.write_Field_header(field);
                ++n2;
            }
            n2 = 0;
            while (n2 < fieldArray.length) {
                fieldArray[n2].setFile(dBF.file);
                dBF.fld_root.addElement(fieldArray[n2]);
                dBF.write_Field_header(fieldArray[n2]);
                field = fieldArray[n2];
                if (field.getType() == 'M') {
                    ((MemoField)field).setDBTObj(dBF.dbtobj);
                }
                ++n2;
            }
        } else {
            this.lrecl = s;
            n = this.fldcount;
            this.fldcount = (short)(this.fldcount + fieldArray.length);
            this.offset = (short)(this.offset + 32 * fieldArray.length);
            if (bl && this.version != -125) {
                this.version = (byte)-117;
            }
            this.update_dbhead();
            n2 = 1;
            while (n2 <= n) {
                field = this.getField(n2);
                if (field.getType() == 'M') {
                    ((MemoField)field).setDBTObj(this.dbtobj);
                }
                this.write_Field_header(field);
                ++n2;
            }
            n2 = 0;
            while (n2 < fieldArray.length) {
                fieldArray[n2].setFile(this.file);
                field = fieldArray[n2];
                if (field.getType() == 'M') {
                    ((MemoField)field).setDBTObj(this.dbtobj);
                }
                this.fld_root.addElement(fieldArray[n2]);
                this.write_Field_header(fieldArray[n2]);
                ++n2;
            }
            this.file.writeByte(13);
            this.file.writeByte(26);
            return;
        }
        dBF.file.writeByte(13);
        dBF.file.writeByte(26);
        dBF.fldcount = (short)(dBF.fldcount + fieldArray.length);
        dBF.offset = (short)(dBF.offset + fieldArray.length * 32);
        n3 = 1;
        while (n3 <= this.count) {
            Field field2;
            this.gotoRecord(n3);
            n2 = 1;
            while (n2 <= this.fldcount) {
                Field field3 = this.getField(n2);
                field2 = dBF.getField(n2);
                field2.put(field3.get());
                ++n2;
            }
            n2 = 0;
            while (n2 < fieldArray.length) {
                field2 = fieldArray[n2];
                field2.put("");
                ++n2;
            }
            dBF.write();
            ++n3;
        }
        dBF.update_dbhead();
        this.file.close();
        this.ffile.delete();
        if (this.dbtobj != null) {
            this.dbtobj.file.close();
            this.dbtobj.thefile.delete();
        }
        if (dBF.dbtobj != null) {
            dBF.dbtobj.file.close();
            dBF.dbtobj.rename(this.dosname);
        }
        dBF.renameTo(this.dosname);
        dBF = null;
        this.ffile = new File(this.dosname);
        this.file = new RandomAccessFile(this.dosname, "rw");
        n2 = 0;
        while (n2 < fieldArray.length) {
            fieldArray[n2].setFile(this.file);
            this.fld_root.addElement(fieldArray[n2]);
            ++n2;
        }
        this.A7600000000();
        this.fldcount = (short)((this.offset - 1) / 32 - 1);
        n2 = 1;
        while (n2 <= this.fldcount) {
            this.getField(n2).setFile(this.file);
            ++n2;
        }
    }

    protected void renameTo(String string) throws IOException {
        this.file.close();
        File file = new File(string);
        this.ffile.renameTo(file);
        this.dosname = string;
    }

    public void dropField(Field field) throws xBaseJException, IOException {
        int n = 0;
        while (n < this.fldcount) {
            Field field2 = this.getField(n);
            if (field.getName().equalsIgnoreCase(field2.getName())) break;
            ++n;
        }
        if (n > this.fldcount) {
            throw new xBaseJException("Field: " + field.getName() + " does not exist.");
        }
    }

    public void changeField(Field field, Field field2) throws xBaseJException, IOException {
        Field field3;
        int n = 0;
        while (n < this.fldcount) {
            field3 = this.getField(n);
            if (field.getName().equalsIgnoreCase(field3.getName())) break;
            ++n;
        }
        if (n > this.fldcount) {
            throw new xBaseJException("Field: " + field.getName() + " does not exist.");
        }
        int n2 = 0;
        while (n2 < this.fldcount) {
            field3 = this.getField(n2);
            if (field2.getName().equalsIgnoreCase(field3.getName()) && n2 != n) {
                throw new xBaseJException("Field: " + field2.getName() + " already exists.");
            }
            ++n2;
        }
    }

    public int fldcount() {
        return this.fldcount;
    }

    public int reccount() {
        return this.count;
    }

    public int recno() {
        return this.current_record;
    }

    public int getFieldCount() {
        return this.fldcount;
    }

    public int getRecordCount() {
        return this.count;
    }

    public int getCurrentRecordNumber() {
        return this.current_record;
    }

    public int getIndexCount() {
        return this.jNDXes.size();
    }

    public Index getIndex(int n) throws xBaseJException {
        if (n < 1) {
            throw new xBaseJException("Index position too small");
        }
        if (n > this.jNDXes.size()) {
            throw new xBaseJException("Index position too large");
        }
        return (Index)this.jNDXes.elementAt(n - 1);
    }

    public Index useIndex(String string) throws xBaseJException, IOException {
        int n = 1;
        while (n <= this.jNDXes.size()) {
            Index index = (Index)this.jNDXes.elementAt(n - 1);
            if (index.getName().compareTo(string) == 0) {
                this.jNDX = index;
                return this.jNDX;
            }
            ++n;
        }
        this.jNDX = this.readonly ? new NDX(string, this, 'r') : new NDX(string, this, ' ');
        this.jNDXes.addElement(this.jNDX);
        return this.jNDX;
    }

    public Index useIndex(String string, String string2) throws xBaseJException, IOException {
        this.useIndex(string);
        this.jNDXID.addElement(string2);
        return this.useIndex(string);
    }

    public Index useIndex(Index index) throws xBaseJException, IOException {
        int n = 1;
        while (n <= this.jNDXes.size()) {
            Index index2 = (Index)this.jNDXes.elementAt(n - 1);
            if (index2.getName().compareTo(index.getName()) == 0) {
                this.jNDX = index2;
                return index2;
            }
            ++n;
        }
        throw new xBaseJException("Unknown Index");
    }

    public Index useIndexByID(String string) throws xBaseJException {
        int n = 1;
        while (n <= this.jNDXID.size()) {
            String string2 = (String)this.jNDXID.elementAt(n - 1);
            if (string2.compareTo(string) == 0) {
                this.jNDX = (Index)this.jNDXes.elementAt(n - 1);
                return (Index)this.jNDXes.elementAt(n - 1);
            }
            ++n;
        }
        throw new xBaseJException("Unknown Index");
    }

    public Index useTag(String string) throws xBaseJException {
        if (this.MDXfile == null) {
            throw new xBaseJException("No MDX file associated with this database");
        }
        this.jNDX = this.MDXfile.getMDX(string);
        return this.jNDX;
    }

    public Index useTag(String string, String string2) throws xBaseJException, IOException {
        this.useTag(string);
        this.jNDXID.addElement(string2);
        return this.useTag(string);
    }

    public Index createIndex(String string, String string2, boolean bl) throws xBaseJException, IOException {
        return this.createIndex(string, string2, false, bl);
    }

    public Index createIndex(String string, String string2, boolean bl, boolean bl2) throws xBaseJException, IOException {
        this.jNDX = new NDX(string, string2, this, bl, bl2);
        this.jNDXes.addElement(this.jNDX);
        return this.jNDX;
    }

    public Index createTag(String string, String string2, boolean bl) throws xBaseJException, IOException {
        if (this.MDXfile == null) {
            throw new xBaseJException("No MDX file associated with this database");
        }
        this.jNDX = this.MDXfile.createTag(string, string2, bl);
        this.jNDXes.addElement(this.jNDX);
        return (MDX)this.jNDX;
    }

    public boolean find(String string) throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int n = this.jNDX.A600000000(string);
        if (n < 1) {
            throw new xBaseJException("Record not found");
        }
        this.gotoRecord(n);
        return this.jNDX.compareTo(string);
    }

    protected boolean find(String string, int n) throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int n2 = this.jNDX.A600000000(string, n);
        if (n2 < 1) {
            throw new xBaseJException("Record not found");
        }
        this.gotoRecord(n2);
        return this.jNDX.compareTo(string);
    }

    public void findNext() throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int n = this.jNDX.A40000000000();
        if (n == -1) {
            throw new xBaseJException("End Of File");
        }
        this.gotoRecord(n);
    }

    public void findPrev() throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int n = this.jNDX.A41000000000();
        if (n == -1) {
            throw new xBaseJException("Top Of File");
        }
        this.gotoRecord(n);
    }

    public void read() throws xBaseJException, IOException {
        if (this.current_record == this.count) {
            throw new xBaseJException("End Of File");
        }
        ++this.current_record;
        this.gotoRecord(this.current_record);
    }

    public void readPrev() throws xBaseJException, IOException {
        if (this.current_record < 1) {
            throw new xBaseJException("Top Of File");
        }
        --this.current_record;
        this.gotoRecord(this.current_record);
    }

    public void gotoRecord(int n) throws xBaseJException, IOException {
        if (n > this.count || n < 1) {
            throw new xBaseJException("Invalid Record Number " + n);
        }
        this.current_record = n;
        this.seek(n - 1);
        this.delete_ind = this.file.readByte();
        int n2 = 0;
        while (n2 < this.fldcount) {
            Field field = (Field)this.fld_root.elementAt(n2);
            field.read();
            ++n2;
        }
        n2 = 1;
        while (n2 <= this.jNDXes.size()) {
            Index index = (Index)this.jNDXes.elementAt(n2 - 1);
            index.set_active_key(index.build_key());
            ++n2;
        }
    }

    public void startTop() throws xBaseJException, IOException {
        if (this.jNDX == null) {
            this.current_record = 0;
            return;
        }
        this.jNDX.position_at_first();
    }

    public void startBottom() throws xBaseJException, IOException {
        if (this.jNDX == null) {
            this.current_record = this.count + 1;
            return;
        }
        this.jNDX.position_at_last();
    }

    public void write() throws xBaseJException, IOException {
        Index index;
        int n = 1;
        while (n <= this.jNDXes.size()) {
            index = (Index)this.jNDXes.elementAt(n - 1);
            index.check_for_duplicates(-1);
            ++n;
        }
        this.seek(this.count);
        this.delete_ind = (byte)32;
        this.file.writeByte(this.delete_ind);
        n = 0;
        while (n < this.fldcount) {
            Field field = (Field)this.fld_root.elementAt(n);
            field.write();
            ++n;
        }
        int n2 = 26;
        this.file.writeByte(n2);
        n = 1;
        while (n <= this.jNDXes.size()) {
            index = (Index)this.jNDXes.elementAt(n - 1);
            index.A39000000(this.count + 1);
            ++n;
        }
        ++this.count;
        this.update_dbhead();
        this.current_record = this.count;
    }

    public void update() throws xBaseJException, IOException {
        Index index;
        if (this.current_record < 1 || this.current_record > this.count) {
            throw new xBaseJException("Invalid current record pointer");
        }
        this.seek(this.current_record - 1);
        this.file.readByte();
        int n = 1;
        while (n <= this.jNDXes.size()) {
            index = (Index)this.jNDXes.elementAt(n - 1);
            index.check_for_duplicates(this.current_record);
            ++n;
        }
        n = 1;
        while (n <= this.jNDXes.size()) {
            index = (Index)this.jNDXes.elementAt(n - 1);
            index.A600000000(index.get_active_key(), this.current_record);
            ++n;
        }
        n = 0;
        while (n < this.fldcount) {
            Field field = (Field)this.fld_root.elementAt(n);
            if (field.getType() == 'M') {
                field.update();
            } else {
                field.write();
            }
            ++n;
        }
        n = 1;
        while (n <= this.jNDXes.size()) {
            index = (Index)this.jNDXes.elementAt(n - 1);
            index.update(this.current_record);
            ++n;
        }
    }

    private void seek(long l) throws IOException {
        long l2 = (long)this.offset + (long)this.lrecl * l;
        this.file.seek(l2);
    }

    public void delete() throws IOException, xBaseJException {
        if (this.current_record < 1 || this.current_record > this.count) {
            throw new xBaseJException("Invalid current record pointer");
        }
        this.seek(this.current_record - 1);
        this.delete_ind = (byte)42;
        this.file.writeByte(this.delete_ind);
    }

    public void undelete() throws IOException, xBaseJException {
        if (this.current_record < 1 || this.current_record > this.count) {
            throw new xBaseJException("Invalid current record pointer");
        }
        this.seek(this.current_record - 1);
        this.delete_ind = (byte)32;
        this.file.writeByte(this.delete_ind);
    }

    public void close() throws IOException {
        --results;
        if (this.dbtobj != null) {
            this.dbtobj.close();
        }
        int n = 1;
        while (n <= this.jNDXes.size()) {
            Index index = (Index)this.jNDXes.elementAt(n - 1);
            if (index instanceof NDX) {
                NDX nDX = (NDX)index;
                nDX.close();
            }
            n = (short)(n + 1);
        }
        if (this.MDXfile != null) {
            this.MDXfile.close();
        }
        this.dbtobj = null;
        this.jNDXes = null;
        this.MDXfile = null;
        this.file.close();
        if (results < 0L) {
            results = 0L;
        }
    }

    public Field getField(int n) throws ArrayIndexOutOfBoundsException, xBaseJException {
        if (n < 1 || n > this.fldcount) {
            throw new xBaseJException("Invalid Field number");
        }
        return (Field)this.fld_root.elementAt(n - 1);
    }

    public Field getField(String string) throws xBaseJException, ArrayIndexOutOfBoundsException {
        short s = 0;
        while (s < this.fldcount) {
            Field field = (Field)this.fld_root.elementAt(s);
            if (string.toUpperCase().compareTo(field.getName().toUpperCase()) == 0) {
                return field;
            }
            s = (short)(s + 1);
        }
        throw new xBaseJException("Field not found");
    }

    public String getName() {
        return this.dosname;
    }

    public boolean deleted() {
        return this.delete_ind == 42;
    }

    private void A75000000(int n, boolean bl) {
        this.version = n == -117 || n == 4 || this.MDX_exist == 1 ? (bl ? (byte)-117 : (byte)3) : (bl ? (byte)-125 : (byte)3);
        this.count = 0;
        this.offset = (short)33;
        this.lrecl = 1;
        this.incomplete_transaction = 0;
        this.encrypt_flag = 0;
        this.language = 0;
    }

    private void A7600000000() throws IOException {
        short s = 0;
        this.file.seek(0L);
        this.version = this.file.readByte();
        this.file.read(this.l_update, 0, 3);
        this.count = Util.x86(this.file.readInt());
        this.offset = Util.x86(this.file.readShort());
        this.lrecl = Util.x86(this.file.readShort());
        s = Util.x86(this.file.readShort());
        this.current_record = Util.x86(s);
        this.incomplete_transaction = this.file.readByte();
        this.encrypt_flag = this.file.readByte();
        this.file.read(this.reserve, 0, 12);
        this.MDX_exist = this.file.readByte();
        this.language = this.file.readByte();
        this.file.read(this.reserve2, 0, 2);
    }

    protected void update_dbhead() throws IOException {
        if (this.readonly) {
            return;
        }
        this.file.seek(0L);
        Calendar calendar = Calendar.getInstance();
        this.l_update[0] = (byte)(calendar.get(1) - 1900);
        this.l_update[1] = (byte)(calendar.get(2) + 1);
        this.l_update[2] = (byte)calendar.get(5);
        this.file.writeByte(this.version);
        this.file.write(this.l_update, 0, 3);
        this.file.writeInt(Util.x86(this.count));
        this.file.writeShort(Util.x86(this.offset));
        this.file.writeShort(Util.x86(this.lrecl));
        this.file.writeShort(Util.x86((short)0));
        this.file.write(this.incomplete_transaction);
        this.file.write(this.encrypt_flag);
        this.file.write(this.reserve, 0, 12);
        this.file.write(this.MDX_exist);
        this.file.write(this.language);
        this.file.write(this.reserve2, 0, 2);
    }

    private Field A5300000000000000() throws IOException, xBaseJException {
        Field field;
        String string;
        byte[] byArray = new byte[15];
        this.file.readFully(byArray, 0, 11);
        int n = 0;
        while (n < 12 && byArray[n] != 0) {
            ++n;
        }
        try {
            string = new String(byArray, 0, n, encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray, 0, n);
        }
        char c = (char)this.file.readByte();
        this.file.readFully(byArray, 0, 4);
        int n2 = this.file.readByte();
        int n3 = n2 > 0 ? n2 : 256 + n2;
        byte by = this.file.readByte();
        this.file.readFully(byArray, 0, 14);
        switch (c) {
            case 'C': {
                field = new CharField(string, n3, this.file);
                break;
            }
            case 'D': {
                field = new DateField(string, this.file);
                break;
            }
            case 'F': {
                field = new FloatField(string, n3, by, this.file);
                break;
            }
            case 'L': {
                field = new LogicalField(string, this.file);
                break;
            }
            case 'M': {
                field = new MemoField(string, this.file, this.dbtobj);
                break;
            }
            case 'N': {
                field = new NumField(string, n3, by, this.file);
                break;
            }
            default: {
                throw new xBaseJException("Unknown Field type for " + string);
            }
        }
        return field;
    }

    private void write_Field_header(Field field) throws IOException, xBaseJException {
        byte[] byArray;
        byte[] byArray2 = new byte[15];
        int n = field.getName().length();
        int n2 = 0;
        try {
            byArray = field.getName().getBytes(encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = field.getName().getBytes();
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray2[n3] = byArray[n3];
            ++n3;
        }
        this.file.write(byArray2, 0, n);
        n2 = 0;
        while (n2 < 14) {
            byArray2[n2] = 0;
            ++n2;
        }
        this.file.writeByte(0);
        if (n < 10) {
            this.file.write(byArray2, 0, 10 - n);
        }
        this.file.writeByte(field.getType());
        this.file.write(byArray2, 0, 4);
        this.file.writeByte(field.getLength());
        this.file.writeByte(field.getDecimalPositionCount());
        this.file.write(byArray2, 0, 14);
    }

    protected void setVersion(int n) {
        this.version = (byte)n;
    }

    public void pack() throws xBaseJException, IOException, SecurityException, CloneNotSupportedException {
        Object object;
        Field[] fieldArray = new Field[this.fldcount];
        int n = 1;
        while (n <= this.fldcount) {
            fieldArray[n - 1] = (Field)this.getField(n).clone();
            ++n;
        }
        String string = this.ffile.getParent();
        if (string == null) {
            string = ".";
        }
        String string2 = new String(String.valueOf(string) + File.separator + "temp.tmp");
        --results;
        DBF dBF = new DBF(string2, this.version, true);
        dBF.MDX_exist = this.MDX_exist;
        dBF.addField(fieldArray);
        n = 1;
        while (n <= this.count) {
            this.gotoRecord(n);
            if (!this.deleted()) {
                int n2 = 1;
                while (n2 <= this.fldcount) {
                    Field field = dBF.getField(n2);
                    Field field2 = this.getField(n2);
                    field.put(field2.get());
                    ++n2;
                }
                dBF.write();
            }
            ++n;
        }
        this.file.close();
        this.ffile.delete();
        dBF.renameTo(this.dosname);
        if (this.dbtobj != null) {
            this.dbtobj.file.close();
            this.dbtobj.thefile.delete();
        }
        if (dBF.dbtobj != null) {
            dBF.dbtobj.rename(this.dosname);
            this.dbtobj = dBF.dbtobj;
            n = 1;
            while (n <= this.fldcount) {
                object = this.getField(n);
                if (((Field)object).getType() == 'M') {
                    MemoField memoField = (MemoField)object;
                    memoField.setDBTObj(this.dbtobj);
                }
                ++n;
            }
        }
        this.ffile = new File(this.dosname);
        this.file = new RandomAccessFile(this.dosname, "rw");
        this.A7600000000();
        n = 1;
        while (n <= this.fldcount) {
            this.getField(n).setFile(this.file);
            ++n;
        }
        if (this.MDXfile != null) {
            this.MDXfile.A620000();
        }
        if (this.jNDXes.size() == 0) {
            this.current_record = 0;
            return;
        }
        n = 1;
        while (n <= this.jNDXes.size()) {
            object = (Index)this.jNDXes.elementAt(n - 1);
            ((Index)object).A620000();
            ++n;
        }
        object = (Index)this.jNDXes.elementAt(0);
        this.startTop();
    }

    public void setFieldEvaluation(String string) throws xBaseJException {
        if (string == null) {
            throw new xBaseJException("method not available");
        }
        throw new xBaseJException("method not available");
    }
}

