/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ.Client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;
import xBaseJ.Client.CharField;
import xBaseJ.Client.DateField;
import xBaseJ.Client.Field;
import xBaseJ.Client.FloatField;
import xBaseJ.Client.LogicalField;
import xBaseJ.Client.MemoField;
import xBaseJ.Client.NumField;
import xBaseJ.Message;
import xBaseJ.xBaseJException;

public class DBF {
    Socket socketId;
    String connectionID;
    InputStream inputStream;
    OutputStream outputStream;
    DataInputStream dataInStream;
    DataOutputStream dataOutStream;
    private short fldcount;
    private Vector fld_root;
    private Field tField;
    String DBFname;
    String NDX;
    String currentKey;
    String host;
    int port;
    long currentRecord;
    boolean deleted = false;

    public DBF(String string, String string2, int n) throws xBaseJException, IOException, UnknownHostException {
        new Date();
        this.fld_root = new Vector();
        this.host = new String(string2);
        this.port = n;
        this.DBFname = new String(string);
        this.startSocket();
        Message message = new Message();
        message.setHeader("Open", this.DBFname);
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.connectionID = message2.getField("ConnectionID");
        this.fldcount = (short)Integer.parseInt(message2.getField("Fldcount"));
        int n2 = 0;
        while (n2 < this.fldcount) {
            Field field = this.A5300000000000000(message2, n2);
            this.fld_root.addElement(field);
            ++n2;
        }
        if (n2 == 0) {
            throw new xBaseJException("Field count error");
        }
    }

    public void setLock(boolean bl) throws xBaseJException, IOException {
        this.startSocket();
        Message message = new Message();
        if (bl) {
            message.setHeader("Lock", this.DBFname);
        } else {
            message.setHeader("Unlock", this.DBFname);
        }
        message.setField("ConnectionID", this.connectionID);
        message.setField("LockType", "LockTable");
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
    }

    public void setRecordLock(boolean bl) throws xBaseJException, IOException {
        if (this.currentRecord < 1L) {
            throw new xBaseJException("Invalid record position");
        }
        this.startSocket();
        Message message = new Message();
        if (bl) {
            message.setHeader("Lock", this.DBFname);
        } else {
            message.setHeader("Unlock", this.DBFname);
        }
        message.setField("ConnectionID", this.connectionID);
        message.setField("LockType", "LockRecord");
        message.setField("CurrentRecord", String.valueOf(this.currentRecord));
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.NDX = null;
    }

    public void useIndex(String string) throws xBaseJException, IOException {
        this.startSocket();
        Message message = new Message();
        message.setHeader("useIndex", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.setField("Index", string);
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.NDX = null;
        this.endSocket();
        this.NDX = string;
    }

    public boolean find(String string) throws xBaseJException, IOException {
        if (this.NDX == null) {
            throw new xBaseJException("Index not defined");
        }
        this.startSocket();
        Message message = new Message();
        message.setHeader("find", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.setField("Index", this.NDX);
        message.setField("key", string);
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.currentKey = message2.getField(2);
        this.currentRecord = Integer.parseInt(message2.getField(3));
        this.deleted = message2.getField(4).compareTo("deleted") == 0;
        boolean bl = message2.getField(5).compareTo("true") == 0;
        int n = 1;
        while (n <= this.fldcount) {
            Field field = this.getField(n);
            field.put(message2.getField(n + 5));
            ++n;
        }
        return bl;
    }

    public void findNext() throws xBaseJException, IOException {
        if (this.NDX == null) {
            throw new xBaseJException("Index not defined");
        }
        this.startSocket();
        Message message = new Message();
        message.setHeader("find_next", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.setField("Index", this.NDX);
        message.setField("key", this.currentKey);
        message.setField("recno", String.valueOf(this.currentRecord));
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.currentKey = message2.getField(1);
        this.currentRecord = Integer.parseInt(message2.getField(2));
        this.deleted = message2.getField(3).compareTo("deleted") == 0;
        int n = 1;
        while (n <= this.fldcount) {
            Field field = this.getField(n);
            field.put(message2.getField(n + 3));
            ++n;
        }
    }

    public void findPrev() throws xBaseJException, IOException {
        if (this.NDX == null) {
            throw new xBaseJException("Index not defined");
        }
        this.startSocket();
        Message message = new Message();
        message.setHeader("find_prev", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.setField("Index", this.NDX);
        message.setField("key", this.currentKey);
        message.setField("recno", String.valueOf(this.currentRecord));
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.currentKey = message2.getField(1);
        this.currentRecord = Integer.parseInt(message2.getField(2));
        this.deleted = message2.getField(3).compareTo("deleted") == 0;
        int n = 1;
        while (n <= this.fldcount) {
            Field field = this.getField(n);
            field.put(message2.getField(n + 3));
            ++n;
        }
    }

    private void startSocket() throws xBaseJException, IOException {
        this.socketId = new Socket(this.host, this.port);
        this.inputStream = this.socketId.getInputStream();
        this.dataInStream = new DataInputStream(this.inputStream);
        this.outputStream = this.socketId.getOutputStream();
        this.dataOutStream = new DataOutputStream(this.outputStream);
    }

    private void endSocket() throws xBaseJException, IOException {
        this.socketId.close();
    }

    public int fldcount() {
        return this.fldcount;
    }

    public int recno() {
        return (int)this.currentRecord;
    }

    public int reccount() throws xBaseJException, IOException {
        return this.getRecordCount();
    }

    public int getFieldCount() {
        return this.fldcount;
    }

    public int getCurrentRecordNumber() {
        return (int)this.currentRecord;
    }

    public int getRecordCount() throws xBaseJException, IOException {
        this.startSocket();
        Message message = new Message();
        message.setHeader("Reccount", this.DBFname);
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        return Integer.parseInt(message2.getField("Reccount"));
    }

    public void read() throws xBaseJException, IOException {
        this.gotoRecord(this.currentRecord + 1L);
    }

    public void readPrev() throws xBaseJException, IOException {
        this.gotoRecord(this.currentRecord - 1L);
    }

    public void gotoRecord(long l) throws xBaseJException, IOException {
        this.startSocket();
        Message message = new Message();
        message.setHeader("Read", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        if (l < 1L) {
            throw new xBaseJException("Invalid record position");
        }
        message.setField("CurrentRecord", String.valueOf(l));
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.deleted = message2.getField(1).compareTo("deleted") == 0;
        int n = 1;
        while (n <= this.fldcount) {
            Field field = this.getField(n);
            field.put(message2.getField(n + 1));
            ++n;
        }
        this.currentRecord = l;
    }

    public void write() throws xBaseJException, IOException {
        this.startSocket();
        Message message = new Message();
        message.setHeader("Write", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        int n = 1;
        while (n <= this.fldcount) {
            Field field = this.getField(n);
            message.setField(field.name(), field.get());
            ++n;
        }
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
        this.deleted = false;
    }

    public void update() throws xBaseJException, IOException {
        this.startSocket();
        Message message = new Message();
        message.setHeader("Update", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.setField("CurrentRecord", String.valueOf(this.currentRecord));
        int n = 1;
        while (n <= this.fldcount) {
            Field field = this.getField(n);
            message.setField(field.name(), field.get());
            ++n;
        }
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.deleted = message2.getField(1).compareTo("deleted") == 0;
        this.endSocket();
    }

    public void delete() throws IOException, xBaseJException {
        if (this.currentRecord < 1L) {
            throw new xBaseJException("Invalid record position");
        }
        this.startSocket();
        Message message = new Message();
        message.setHeader("Delete", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.setField("CurrentRecord", String.valueOf(this.currentRecord));
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
    }

    public void undelete() throws IOException, xBaseJException {
        if (this.currentRecord < 1L) {
            throw new xBaseJException("Invalid record position");
        }
        this.startSocket();
        Message message = new Message();
        message.setHeader("Undelete", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.setField("CurrentRecord", String.valueOf(this.currentRecord));
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
    }

    public void close() throws IOException, xBaseJException {
        if (this.currentRecord < 1L) {
            throw new xBaseJException("Invalid record position");
        }
        this.startSocket();
        Message message = new Message();
        message.setHeader("Unlock", this.DBFname);
        message.setField("ConnectionID", this.connectionID);
        message.write(this.dataOutStream);
        Message message2 = new Message(this.dataInStream);
        this.endSocket();
    }

    public Field getField(int n) throws ArrayIndexOutOfBoundsException, xBaseJException {
        if (n < 1 || n > this.fldcount) {
            throw new xBaseJException("Invalid Field number");
        }
        return (Field)this.fld_root.elementAt(n - 1);
    }

    public Field getField(String string) throws xBaseJException, ArrayIndexOutOfBoundsException {
        short s = 0;
        while (s < this.fldcount) {
            Field field = (Field)this.fld_root.elementAt(s);
            if (string.toUpperCase().compareTo(field.name().toUpperCase()) == 0) {
                return field;
            }
            s = (short)(s + 1);
        }
        throw new xBaseJException("Field not found");
    }

    public String getName() {
        return this.DBFname;
    }

    public boolean deleted() throws IOException, xBaseJException {
        return this.deleted;
    }

    private Field A5300000000000000(Message message, int n) throws IOException, xBaseJException {
        Field field;
        String string = message.getField(n * 4 + 3);
        char c = message.getField(n * 4 + 4).charAt(0);
        int n2 = Integer.parseInt(message.getField(n * 4 + 5));
        int n3 = Integer.parseInt(message.getField(n * 4 + 6));
        switch (c) {
            case 'C': {
                field = new CharField(string, n2);
                break;
            }
            case 'D': {
                field = new DateField(string);
                break;
            }
            case 'F': {
                field = new FloatField(string, n2, n3);
                break;
            }
            case 'L': {
                field = new LogicalField(string);
                break;
            }
            case 'M': {
                field = new MemoField(string);
                break;
            }
            case 'N': {
                field = new NumField(string, n2, n3);
                break;
            }
            default: {
                throw new xBaseJException("Unknown Field type for " + string);
            }
        }
        return field;
    }
}

