/*
 *      Author:  Peter Harding  <plh@pha.com.au>
 *               Peter Harding & Associates Pty. Ltd.
 *               P.O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   03 9820 1261
 *               Fax:     03 9578 7810
 *               Mobile:  0418 375 085
 */

static char
	id[] = "@(#) [3.0.12] args.c 09/12/94";

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <errno.h>

#include "misc.h"
#include "simple.h"
#include "local.h"
#include "workload.h"
#include "global.h"
#include "ecodes.h"


/********************************************************************/

extern char
	*optarg,
	*argstr,
	*thisProgram;

extern int
	no,
	msg_type,
	optind,
	mode,
	debugFlg,
	verboseFlg;


/********************************************************************/

#define  OPTLIST        "a:dm:ps:tvxz:" 


/********************************************************************/

int
	vardataCmtFlg;

getArgs( argc, argv )
int  argc;
char *argv[];
{
	int
		ch,
		i;

	while ( ( ch = getopt( argc, argv, OPTLIST ) ) != ERROR )      {
		switch ( ch ) {
			case 'a':
			case 'z':
				no = atoi( optarg );
			case 'p':
			case 't':
			case 'x':
				mode   = ch;
				break;

			case 'm':
				msg_type = atoi( optarg );

			case 'd':
				debugFlg = TRUE;
				break;

			case 's':
				mode   = ch;
				argstr = optarg;
				break;

			case 'v':
				verboseFlg = TRUE;
				break;

			default:
				fprintf( stdout, "Unknown argument" );
				exit( 1 );
		}
	}

	fflush( stdout );
}	/* getArgs */


/********************************************************************/

