
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>

#include "misc.h"
#include "base64.h"
#include "md4.h"
#include "ntlm.h"


//----------------------------------------------------------------------------

char
	*argstr,
	*user      = "pharding",
	*domain    = "exchange",
   *host      = "SIRIUS",
	*passwd    = "test1ng";

int
	no         = 1,
	msg_type   = 1,
	mode       = 0,
	debugFlg   = 0,
   verboseFlg = 0;

uchar
	lm_hpw[] = { 0x91, 0x90, 0x16, 0xf6, 0x4e, 0xc7, 0xb0, 0x0b, 0xa2, 0x35, 0x02, 0x8c, 0xa5, 0x0c, 0x7a, 0x03 },
	nt_hpw[] = { 0x8c, 0x1b, 0x59, 0xe3, 0x2e, 0x66, 0x6d, 0xad, 0xf1, 0x75, 0x74, 0x5f, 0xad, 0x62, 0xca, 0x33 };


//----------------------------------------------------------------------------

struct trios {
	char *t1;
	char *t2;
	char *t3;
};

typedef struct trios
	TRIOS;

TRIOS
	x[] = {
{  //  0
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAA=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGg9LMVDe6h4SgAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMAkxXMd0reXb9a7l1mVY4kNXJZd/HQXfRdY3vbSNB6Gx5tToa/lHNcXuJZTqXl2BVn"
},
{  //  1
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAB=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGgEkW7IEbRJ0UAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMArgU/0wHHnADFF2y6UTX8w4sQ44HxxB6r6jUCyWIaVBMq++F9nToJjRNYGecZwcNu"
},
{  //  2
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAC=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGgdlLhcOZoO9QAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMA6f3XbSDy+IVk81y35379HLGFkhTCiHwBDVvhsF1QRrIVpk9+fEnJYOV/ikeORG0L"
},
{  //  3
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAA=",
"TlRMTVNTUAACAAAAAAAAADAAAAABggAANCGensAEyVAAAAAAAAAAAAAAAAAwAAAA=",
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAA="
},
{  //  4
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAA=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGgmfeS6G3PHwkAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMAnuhgW7CxtGuTo2WWBuHeCbJ4COyQyB/avcyCurCmMvL6ixn5xSgeY2XT/OQxNTEO"
},
{  //  5
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAB=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGgZ6aYKCbyPxcAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==\"",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMA6PXFlsrzpWuMXbZw1a3cihayV4XSrQJoNCDWlQAsgUw9LTCNP1eyzwsyRzU3aIkB"
},
{  //  6
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAB=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGg00hS4mLgd+sAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMAZcWD3F/DrBjWn9aYCdfkMze+PGQYINV2k6B9x/PwKvMcPaJYjmCg23D+4vNlp8Ez",
},
{  //  7
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAB=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGgJ55XWCUxW9kAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMAjuyqNT0vz2o2UDyHd50d9at+zJsM2du3lPM9ziC4niZXyr37czb+9yvzRyQi4iTE"
},
{  //  8
"TlRMTVNTUAABAAAAB7IAoAsACwAmAAAABgAGACAAAABTSVJJVVNTRVdMLkNPTS5BVU==",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGgFyrCeGsZZhEAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAF4AAAAYABgAdgAAAAwADABAAAAABgAGAEwAAAAMAAwAUgAAAAAAAACOAAAABYKAoFMASQBSAEkAVQBTAHoAeQB4AFMASQBSAEkAVQBTABYA3BYJxGBhQDghDTlNQg6sfa0DBVAdZ15hMa3Uelzn9hhWMN1Ya8tb/ENUBkNF6s=="
},
{  //  9
"TlRMTVNTUAABAAAAB4IAoAAAAAAAAAAAAAAAAAAAAAC=",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGgi2mwiM9nE6cAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMApUTxcG/Duw8NGCc0vESVqr+k1QH7gRBptFPkbe8bIdoA99mKq3dTPaTIcDzoHUEN"
},
{  // 10
"",
"TlRMTVNTUAACAAAAEAAQADAAAAAFgoGg/aowmNg68nAAAAAAAAAAADAAMABAAAAARQBYAEMASABBAE4ARwBFAAIAEABFAFgAQwBIAEEATgBHAEUAAQAIAEUARABFAE4AAwAIAGUAZABlAG4AAAAAAA==",
"TlRMTVNTUAADAAAAGAAYAGwAAAAYABgAhAAAABAAEABAAAAAEAAQAFAAAAAMAAwAYAAAAAAAAACcAAAABYKAoGUAeABjAGgAYQBuAGcAZQBwAGgAYQByAGQAaQBuAGcAUwBJAFIASQBVAFMA/pdrSs5FXJ3+Q2nAQqFbKOEhWojHXidzPanFwo2iBxfRDzz3aYWx6PX5eeK+vVjS"
},
0
	};


//----------------------------------------------------------------------------

void
tst_authstr(
	int no,
	int msg_type
)
{
	char
		*sp,
		buf[ 1024 ];

	int
		len;

	switch ( msg_type ) {
		case 1:
			sp = x[no].t1;
			break;

		case 2:
			sp = x[no].t2;
			break;

		default:
			sp = x[no].t3;
			break;
	}

	fprintf( stderr, "Decoding: \"%s\"\n", sp );

	sp = base64decode( sp, &len );

	fprintf( stderr, " Decoded: (%d)\n", len );
	fprints( stderr, sp, len,  70, "<<<", 1 );

	switch ( msg_type ) {
		case 1:
   		disp_t1m( (TYPE_1_MSG*)sp );
			break;

		case 2:
   		disp_t2m( (TYPE_2_MSG*)sp );
			break;

		case 3:
   		disp_t3m( (TYPE_3_MSG*)sp );
			break;

	}
}	/* tst_authstr */


//----------------------------------------------------------------------------

void
tst_base64(
	char *str
)
{
	char
		*sp,
		buf[ 1024 ];

	int
		len;

	fprintf( stderr, "Encoding: \"%s\"\n", str );

	strcpy( buf, base64encode( str, 0 ));

	fprintf( stderr, " Encoded: \"%s\"\n", buf );

   sp = buf;

	fprintf( stderr, "Decoding: \"%s\"\n", sp );

	sp = base64decode( sp, &len );

	fprintf( stderr, " Decoded: (%d)\n", len );
	fprints( stderr, sp, len,  70, "<<<", 1 );
}	/* tst_base64 */


//----------------------------------------------------------------------------

void
tst_t1msg(
	void
)
{
	int
		mlen;

	char
		*host       = "eden",
		*domain     = "EXCHANGE";

	TYPE_1_MSG
		*pt1m;

	//pt1m = t1m_init( host, domain, &mlen );
	pt1m = t1m_init( 0, 0, &mlen );

   fprints( stderr, (char*)pt1m, mlen, 70, "<<<", 1 );

	disp_t1m( pt1m );

	fprintf( stderr, "Base64 Encoded:  \"%s\"\n\n", base64encode( (char*)pt1m, mlen ));
}	/* tst_t1msg */


//----------------------------------------------------------------------------

void
tst_t2msg(
	void
)
{
	int
		mlen;

	char
		*nonce = "ABCDEFGH";

	TYPE_2_MSG
		*pt2m;

	pt2m = t2m_init( nonce, &mlen );

   fprints( stderr, (char*)pt2m, mlen, 70, "<<<", 1 );

	disp_t2m( pt2m );

	fprintf( stderr, "Base64 Encoded:  \"%s\"\n\n", base64encode( (char*)pt2m, mlen ));
}	/* tst_t2msg */


//----------------------------------------------------------------------------

char*
chk_t2msg(
	void
)
{
}	/* chk_t2m */


//----------------------------------------------------------------------------

void
tst_t3msg(
	void
)
{
	char
		*user       = "pharding",
		*host       = "eden",
		*domain     = "EXCHANGE",
		*lm_resp    = "012345678901234567890123",
		*nt_resp    = "012345678901234567890123";


	int
		mlen;

	TYPE_3_MSG
		*pt3m;

	pt3m = t3m_init( user, host, domain, lm_resp, nt_resp, &mlen );

   fprints( stderr, (char*)pt3m, mlen, 70, "<<<", 1 );

	disp_t3m( pt3m );

	fprintf( stderr, "Base64 Encoded:  \"%s\"\n\n", base64encode( (char*)pt3m, mlen ));
}	/* tst_t3msg */


//----------------------------------------------------------------------------

void
tst_passwd(
	char *passwd
)
{
	char
		*sp;

	uchar
		lm_passwd[14],
		lm_hash[21],
		nt_hash[21];

	create_lm_passwd( passwd, lm_passwd );

   fprintf( stderr, "LanManager Password:\n" );
   fprints( stderr, lm_passwd, 14, 70, "<<<", 1 );

	create_nt_hashed_passwd( passwd, nt_hash );

   fprintf( stderr, "NT Hashed Password:\n" );
   fprints( stderr, nt_hash, 21, 70, "<<<", 1 );

   sp = (char*)base64encode( nt_hash, 21 );

   fprintf( stderr, "Base64 Encoded NT Hashed Password:\n" );
   fprintf( stderr, "%s\n", sp );
}	/* tst_passwd */


//----------------------------------------------------------------------------

void
tst_samba(
	void
)
{
	uchar
		*passwd             = "test1ng",
		*pass1              = "aluminium12",
		*pass2              = "aluminium12",
      p14[14],
      p16[16],
      unenc_new_pw[16],
      unenc_old_pw[16],
      unenc_tst_pw[16];

	fprintf( stderr, "\n       lm_hpw:\n" );
	dispno( "      ", 16, lm_hpw );

   memset( (void*)p14, 0, 14 );
   strcpy( p14, passwd );
   upper( p14 );

   fprintf( stderr, "%s\n\n", p14 );

	E_P16((uchar*) p14, (uchar*)p16);

	fprintf( stderr, "          p14:\n" );
	fprints( stderr, p14, 14, 70, "<<<", 1 );
	dispno( "      ", 14, p14 );
	fprintf( stderr, "          p16:\n" );
	fprints( stderr, p16, 16, 70, "<<<", 1 );
	dispno( "      ", 16, p16 );
 

   D_P16( p16, pass2, unenc_new_pw );

	fprintf( stderr, " unenc_new_pw:\n" );
	fprints( stderr, unenc_new_pw, 16, 70, "<<<", 1 );
	dispno( "      ", 16, unenc_new_pw );
 
   D_P16( unenc_new_pw, pass1, unenc_old_pw );

	fprintf( stderr, " unenc_old_pw:\n" );
	fprints( stderr, unenc_old_pw, 16, 70, "<<<", 1 );
	dispno( "      ", 16, unenc_old_pw );
 

   strncpy( unenc_tst_pw, unenc_old_pw, 16 );

   D_P16( unenc_old_pw, pass2, unenc_new_pw );

	fprintf( stderr, " unenc_new_pw:\n" );
	fprints( stderr, unenc_new_pw, 16, 70, "<<<", 1 );
	dispno( "      ", 16, unenc_new_pw );
 
   D_P16( unenc_new_pw, pass1, unenc_old_pw );

	fprintf( stderr, " unenc_old_pw:\n" );
	fprints( stderr, unenc_old_pw, 16, 70, "<<<", 1 );
	dispno( "      ", 16, unenc_old_pw );
 

   D_P16( unenc_tst_pw, pass2, unenc_new_pw );

	fprintf( stderr, " unenc_new_pw:\n" );
	fprints( stderr, unenc_new_pw, 16, 70, "<<<", 1 );
	dispno( "      ", 16, unenc_new_pw );
 
   D_P16( unenc_new_pw, pass1, unenc_old_pw );

	fprintf( stderr, " unenc_old_pw:\n" );
	fprints( stderr, unenc_old_pw, 16, 70, "<<<", 1 );
	dispno( "      ", 16, unenc_old_pw );

}	/* tst_samba */


//----------------------------------------------------------------------------
void
tst_samba1(
	void
)
{
	uchar
		*c8                 = "12345678",
		*passwd             = "test1ng",
		p24[24];

	fprintf( stderr, "\n       lm_hpw:\n" );
	dispno( "      ", 16, lm_hpw );

	SMBencrypt( passwd, c8, p24 );

	fprintf( stderr, "  passwd: %s\n", passwd );
	fprintf( stderr, "      c8: \"%s\"\n", c8 );
	fprintf( stderr, "     p24:\n" );
	fprints( stderr, p24, 24, 70, "<<<", 1 );
	dispno( "      ", 24, p24 );
}	/* tst_samba1 */


//----------------------------------------------------------------------------

void
tst_authent(
	int no
)
{
	char
		*nonce,
		*sp,
		buf[ 1024 ];

	int
		len;

	TYPE_3_MSG
		*pt3m;

	sp = x[no].t2;

	fprintf( stderr, "Decoding: \"%s\"\n", sp );

	sp = base64decode( sp, &len );

	fprintf( stderr, " Decoded: (%d)\n", len );
	fprints( stderr, sp, len,  70, "<<<", 1 );

   nonce = get_nonce( ( TYPE_2_MSG*)sp );

	fprintf( stderr, "   Nonce:\n" );
	fprints( stderr, nonce, 8,  70, "<<<", 1 );

	dispno( "     ", 8, nonce );

	pt3m = build_t3m( user, passwd, host, domain, nonce, &len, 1 );

	disp_t3m( pt3m );
}	/* tst_authent */


//----------------------------------------------------------------------------

int main(
	int argc,
	char *argv[]
)
{
	getArgs( argc, argv );

	switch ( mode ) {
		case 'a':
			tst_authstr( no, msg_type );
			break;

		case 'p':
			tst_passwd( passwd );
			break;

		case 's':
			tst_base64( argstr );
			break;

		case 't':
			tst_t1msg();
			tst_t2msg();
			tst_t3msg();
			break;

		case 'x':
			tst_samba();
			break;

		case 'z':
			tst_authent( no );
			break;

	}
}	/* main */


//----------------------------------------------------------------------------
