/*
 *     Author:    Peter Harding    <plh@pha.com.au>
 *                Peter Harding & Associates Pty. Ltd.
 *                Level 6,
 *                170 Queen Street,
 *                MELBOURNE, VIC, 3000
 *
 *                Phone:    03 9641 2222
 *                Fax:      03 9641 2200
 *                Mobile:   0418 375 085
 *
 *      Copyright (C) Peter Harding, 2002
 *
 *           @(#) [1.0.0] ntlm.h 23/05/2002
 *
 *  $Id:$
 */

#ifndef   _NTLM_H_
#define   _NTLM_H_


//----------------------------------------------------------------------------

#define LITTLE_ENDIAN(val)   ((((val) & 0xff) << 8) | (((val) & 0xff00 )>>8))


//----------------------------------------------------------------------------

typedef unsigned char
	BYTE;


//----------------------------------------------------------------------------

/*
 *  struct type_1_msg_hdr {
 * 	BYTE    protocol[8];     // "NTLMSSP\0"
 *    BYTE    type;            //  0x01
 *    BYTE    unused1[3];      //  Unused
 *    short   flags;           //  0xb203
 *    BYTE    unused2[2];      //  Unused
 * 
 *    short   dom_length;      //  Domain string length
 *    short   dom_length2;     //  Domain string length (again)
 *    short   dom_offset;      //  Domain string offset
 *    BYTE    unused3[2];      //  Unused
 * 
 *    short   host_length;     //  Host string length
 *    short   host_length2;    //  Host string length (again)
 *    short   host_offset;     //  Host string offset
 *    BYTE    unused4[2];      //  Unused
 * };
 */

struct type_1_msg_hdr {
	BYTE    protocol[8];     // "NTLMSSP\0"
   BYTE    type;            //  0x0100
   BYTE    unused1[3];        //  Unused
   short   flags;           //  0xb203
   short   unknown1;        //  Unused

   BYTE    unused2[16];      //  Unused
};
typedef struct type_1_msg_hdr
	TYPE_1_MSG_HDR;


struct type_1_msg {
	TYPE_1_MSG_HDR  hdr;
   char           *hostdom;
   // BYTE    host[];       //  Host string (ASCII)
   // BYTE    dom[];        //  Domain string (ASCII)
};

typedef struct type_1_msg
	TYPE_1_MSG;


//----------------------------------------------------------------------------
/*
 * struct type_2_msg_hdr {
 * 	BYTE    protocol[8];     // "NTLMSSP\0"
 *    BYTE    type;            //  0x02 '^B'
 *    BYTE    unused1[2];      //  Unused
 *    short   length1;         //  
 *    short   length2;         //  
 *    short   msg_len;         //  0x28 'O'
 *    short   unknown1;        //  
 *    short   flags;           //  0x8201
 *    short   unknown2;        //  
 * 
 *    BYTE    nonce[8];        //  Server nonce
 *    BYTE    unused4[8];      //  Unused
 *    short   unknown3;        //  
 *    short   unknown4;        //  
 *    short   unknown5;        //  
 *    short   unknown6;        //  
 * };
 */


struct type_2_msg_hdr {
	BYTE    protocol[8];     // "NTLMSSP\0"
   BYTE    type;            //  0x02
   BYTE    unused1[3];      //  NULL 
   short   dom1_length;     //  
   short   dom1_length2;    //  
   short   dom1_offset;     //  
   BYTE    unused2[2];      //  NULL 
   short   flags;           //  0x8201
   short   unknown1;        //  0x81A0 

   BYTE    nonce[8];        //  Server nonce
   BYTE    unused3[8];      //  NULL
   short   pld_length;     //  
   short   pld_length2;     //  
   short   pld_offset;      //  
   BYTE    unused4[2];      //  NULL
};

typedef struct type_2_msg_hdr
	TYPE_2_MSG_HDR;

struct type_2_msg {
	TYPE_2_MSG_HDR  hdr;
   char           *strings;
   // BYTE    dom[];        //  Domain string (ASCII)
   // BYTE    dom[];        //  Domain string (ASCII)
   // BYTE    host[];       //  Host string (ASCII)
   // BYTE    host[];       //  Host string (ASCII)
};

typedef struct type_2_msg
	TYPE_2_MSG;


//----------------------------------------------------------------------------

struct type_3_msg_hdr {
	BYTE    protocol[8];     // "NTLMSSP\0"
   BYTE    type;            //  0x03
   BYTE    unused1[3];      //  Unused

   short   lm_resp_length;  //  LanManager response length (always 0x18)
   short   lm_resp_length2; //  LanManager response length (again)
   short   lm_resp_offset;  //  LanManager response offset
   BYTE    unused2[2];      //  Unused

   short   nt_resp_length;  //  NT response length (always 0x18)
   short   nt_resp_length2; //  NT response length (again)
   short   nt_resp_offset;  //  NT response offset
   BYTE    unused3[2];      //  Unused

   short   dom_length;      //  Domain string length
   short   dom_length2;     //  Domain string length (again)
   short   dom_offset;      //  Domain string offset
   BYTE    unused4[2];      //  Unused

   short   user_length;     //  User name string length
   short   user_length2;    //  User name string length (again)
   short   user_offset;     //  User name string offset
   BYTE    unused5[2];      //  Unused

   short   host_length;     //  Host string length
   short   host_length2;    //  Host string length (again)
   short   host_offset;     //  Host string offset
   BYTE    unused6[6];      //  Unused

   short   msg_len;         // 
   BYTE    unused7[2];      //  Unused

   short   flags;           //  0x8201
   short   unknown1;        //
};

typedef struct type_3_msg_hdr
	TYPE_3_MSG_HDR;


struct type_3_msg {
	TYPE_3_MSG_HDR  hdr;
   char           *strings;
   // BYTE    host[];       //  Host string (ASCII)
   // BYTE    dom[];        //  Domain string (ASCII)
};

typedef struct type_3_msg
	TYPE_3_MSG;


//----------------------------------------------------------------------------

extern TYPE_1_MSG
	type1msg;


//----------------------------------------------------------------------------

TYPE_1_MSG *t1m_init( char *host, char *domain, int *plength );
TYPE_2_MSG *t2m_init( char *nonce, int *plength );
TYPE_3_MSG *t3m_init( char *user, char *host, char *domain, char *lm_resp, char *nt_resp, int *plength );

void disp_t1m( TYPE_1_MSG_HDR* phdr );
void disp_t2m( TYPE_2_MSG_HDR* pmsg );
void disp_t3m( TYPE_3_MSG_HDR* phdr );

char* get_nonce( TYPE_2_MSG_HDR* pmsg );

void build_t3m( char *user, char *passwd, char *host, char *domain, char *nonce );


//----------------------------------------------------------------------------


void calc_resp(unsigned char *keys, unsigned char *plaintext, unsigned char *results);
void create_responses( char *nonce, char *lm_hpw, char *nt_hpw );

void create_lm_passwd( const char *passwd, uchar *p14 );
void create_lm_hashed_passwd( const char *passwd, uchar *p21 );
void create_nt_hashed_passwd( const char *passwd, uchar *p21 );


//----------------------------------------------------------------------------

#endif /* _NTLM_H_ */


