/*
 *      Author:   Peter Harding  <plh@performiq.com.au>
 *                PerformIQ Pty. Ltd.
 *                Level 6,
 *                170 Queen Street
 *                MELBOURNE, VIC, 3000
 *
 *                Phone:   (03)  9641 2222
 *                Fax:     (03)  9641 2200
 *                Mobile:  0418 375 085
 */

static char
	id[] = "@(#) [3.0.12] lib.c 09/12/94";


/********************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#include <errno.h>

#include "misc.h"
#include "simple.h"
#include "local.h"
#include "threads.h"
#include "funckey.h"
#include "global.h"
#include "ecodes.h"


/********************************************************************/

extern int
	errno;


/********************************************************************/

#ifdef ANSIC
void handleLock( char* );
#else
void handleLock();
#endif


/********************************************************************/

static struct timeval
	microtimer;

void
startTimer(
	void
)
{
	long
		t;

#ifdef    DYNIX_PTX
	( void )get_process_stats( &microtimer, getpid(),
		( struct process_stats* )0, ( struct process_stats* )0 );
#else
	gettimeofday( &microtimer, ( struct timezone* )0 );
#endif /* DYNIX_PTX */
}	/* startTimer */


/********************************************************************/

float
chkTimer(
	float *pf
)
{
	long
		msec,
		sec,
		t;

	struct timeval
		tv;

	float
		f;

#ifdef    DYNIX_PTX
	( void )get_process_stats( &tv, getpid(),
		( struct process_stats* )0, ( struct process_stats* )0 );
#else
	gettimeofday( &tv, ( struct timezone* )0 );
#endif /* DYNIX_PTX */


	msec     = ( tv.tv_usec - microtimer.tv_usec ) / 1000;
	sec      = ( ( tv.tv_sec - microtimer.tv_sec ) * 1000 );

	t        = sec + msec;

	f = t * 0.001;

#if 0
	fprintf( stderr, "%d -> %.3f\n", t, f );
#endif

	*pf = f;

	return f;
}	/* chkTimer */


/********************************************************************/

void
msleep(
	int millisec
)
{
	struct timeval
		tv;

	int
		microsec;

	microsec = millisec * 1000;

	tv.tv_usec = microsec % 1000000;
	tv.tv_sec  = microsec / 1000000;

	select( 0, 0, 0, 0, &tv );
}	// msleep


/********************************************************************/

char *trim(
#ifdef    _ANSI_PROTO_ 
	char* str
)
#else
		str )
	char* str;
#endif /* _ANSI_PROTO_ */
{
	char
		*sp;


	sp = str + strlen( str ) - 1;

	while ( sp && ( *sp == ' ' ) )
	{
		*sp-- = '\0';
	}

	sp = str;

	while ( sp && ( *sp == ' ' ) )
	{
		*sp++ = '\0';
	}

	return sp;
}	/* trim */


/********************************************************************/
 
void upper(
	char *str
)
{
	int
		i,
		len;

	if ( str && *str ) {
		len = strlen( str );

		for ( i = 0; i < len; i++ )
			str[ i ] = toupper( str[ i ] );
	}
}	/* upper */


/********************************************************************/

int
parseArgs(
#ifdef    _ANSI_PROTO_ 
	int   argc,
	char *argv[],
	char *args
)
#else
		argc, argv, args )
	int   argc;
	char *argv[];
	char *args;
#endif /* _ANSI_PROTO_ */
{
	int
		cnt = 0;

	char
		*DELIM    = ":",
		*sp;

	sp = strtok( args, DELIM );

	argv[ cnt++ ] = sp;

	while ( sp && ( cnt < argc ) ) {
		sp            = strtok( NULL, DELIM );
		argv[ cnt++ ] = sp;
	}

	return cnt;
}	/* parseArgs */


/********************************************************************/

int
theHour()
{
	int
		hour;

	char
		line[128];

//	strcpy( line, shell( "date \"+%H\"" ) );
	sscanf( line, "%d", &hour );
	return( hour );
}	/* theHour */


/********************************************************************/

int
theMinute()
{
	int
		minute;

	char
		line[128];

//	strcpy( line, shell( "date \"+%M\"" ) );
	sscanf( line, "%d", &minute );
	return( minute );
}	/* theMinute */


/********************************************************************/

#if FALSE
getRange()
{
	int
		res;

	long
		dispTime,
		endTime,
		lastTime,
		startTime,
		theHour,
		theMinute,
        theTime;

	char
		line[128];

//	strcpy( line, shell( "date \"+%H%M\"" ) );
	sscanf( line, "%d", &res );
	res += 120;

	theHour           = res / 100;
	theMinute         = res % 100;
	theTime           = theHour * 60 + theMinute;

	lastTime          = range.DispHour * 60 + range.DispMinute;

	if ( theTime < lastTime + 3 ) {
		theTime       = lastTime + 3;
		if ( theTime > 24 * 60 ) {
			userLog( "Ran out of minutes ..." );
			rteExit( 12 );
		}
	}

	dispTime          = theTime;
	startTime         = theTime + 1;
	endTime           = theTime + 2;

	range.DispHour    = dispTime / 60;
	range.DispMinute  = dispTime % 60;
	range.StartHour   = startTime / 60;
	range.StartMinute = startTime % 60;
	range.EndHour     = endTime / 60;
	range.EndMinute   = endTime % 60;

	sprintf( msgBuf, "Disp  = %02d:%02d", range.DispHour, range.DispMinute );
	userLog( msgBuf );
	sprintf( msgBuf, "Start = %02d:%02d", range.StartHour, range.StartMinute );
	userLog( msgBuf );
	sprintf( msgBuf, "End   = %02d:%02d", range.EndHour, range.EndMinute );
	userLog( msgBuf );
}	/* getRange */

#endif /* FALSE */


//----------------------------------------------------------------------------

int
unicode(
	char       *buf,
	const char *str
)
{
	int
		i,
		len;

	if (!buf) {
		return -1;
   }

	buf[ 0 ] = '\0';
	
	if (!str)
		return -1;

	len = strlen( str );

	for ( i = 0; i < len; i++ )
	{
		buf[ 2 * i ]     = str[ i ];
		buf[ 2 * i + 1 ] = 0;
	}

	return 2 * len;
}	/* unicode */


//----------------------------------------------------------------------------

void
dispno(
   char    *filler,
   int      no,
   uchar*   u
)
{
   int
      i;

   fprintf( stderr, "%s", filler );
   for ( i = 0; i < no; i++ )
      fprintf( stderr, "0x%02x ", u[ i ] );
   fprintf( stderr, " [Hex]\n" );


   fprintf( stderr, "%s ", filler );
   for ( i = 0; i < no; i++ )
      fprintf( stderr, "%03o  ", u[ i ] );
   fprintf( stderr, "[Octal]\n" );


   fprintf( stderr, "%s ", filler );
   for ( i = 0; i < no; i++ )
      fprintf( stderr, "%3d  ", u[ i ] );
   fprintf( stderr, "[Decimal]\n" );
}  /* dispno */


//----------------------------------------------------------------------------

