
//---------------------------------------------------------------------------

#include <stdio.h>
#include <time.h>
#include <pwd.h>
#include <strings.h>
#include <sys/fcntl.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>

#include "byteorder.h"


//---------------------------------------------------------------------------

#define False (0)
#define True  (1)
#define Auto  (2)

/* zero a structure */
#define ZERO_STRUCT(x) memset((char *)&(x), 0, sizeof(x))

/* free memory if the pointer is valid and zero the pointer */
#ifndef SAFE_FREE
#define SAFE_FREE(x) do { if ((x) != NULL) {free((x)); (x)=NULL;} } while(0)
#endif

#define DEBUG(x,y)  ;

#ifndef  MIN
#define  MIN(x, y)   ((x < y) ? (x) : (y))
#endif


//---------------------------------------------------------------------------

typedef int
	BOOL;

typedef unsigned char
	uchar;

typedef unsigned short
	uint16;

typedef unsigned int
	uint32;

typedef short
	int16;

/* ucs2 string types. */

typedef uint16 smb_ucs2_t;

typedef smb_ucs2_t wpstring[1024];


/* UNISTR2 - unicode string size (in uint16 unicode chars) and buffer */

typedef struct unistr2_info
{
  uint32 uni_max_len;
  uint32 undoc;
  uint32 uni_str_len;
  /* unicode characters. ***MUST*** be little-endian. 
     **must** be null-terminated and the uni_str_len should include
     the NULL character */
  uint16 *buffer;

} UNISTR2;


//---------------------------------------------------------------------------

/* The following definitions come from lib/genrand.c  */

void set_rand_reseed_data(unsigned char *data, size_t len);
void generate_random_buffer( unsigned char *out, int len, BOOL do_reseed_now);
char *generate_random_str(size_t len);


//---------------------------------------------------------------------------
