/*
 *      Author:  Peter Harding  <plh@pha.com.au>
 *               Peter Harding & Associates Pty. Ltd.
 *               492 St. Kilda Road,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   03 820 1261
 *               Fax:     03 578 7810
 *               Mobile:  ( 018 ) 375 085
 */

static char
	id[] = "@( # ) [3.1.0] grp_pro.c 09/21/94";

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <string.h>
#include <errno.h>

#include "misc.h"
#include "simple.h"
#include "local.h"
#include "funckey.h"
#include "threads.h"
#include "global.h"
#include "ecodes.h"
#include "connect.h"


#define INCR 5


extern int
	errno;

static char
	cookieSet[ MEDIUM_STR ] = "";


/********************************************************************/

void HttpTransfer(const char* httpline)
{
	char buf[ MEDIUM_STR ];
	int noRead, totalRead = 0;
	int contentLength = 0;
	int gotHeaderEnd = 0;

	loginHttp();

	sendStr( httpline );

/*
HTTP/1.1 200 OK
Date: Tue, 18 Apr 2000 23:48:33 GMT
Server: Apache/1.3.6 (Unix)
Last-Modified: Thu, 06 Jan 2000 22:08:19 GMT
ETag: "143c4-de2-38751253"
Accept-Ranges: bytes
Content-Length: 3554
Connection: close
Content-Type: text/html
*/
	do
	{
		char matchbuf[ MEDIUM_STR ];

		match("HTTP/|Content-Length: |\n|Set-Cookie: ", maxWait, "grp_ll - <000>" );
		switch (matchIdx)
		{
			case 0:
				match("\n", maxWait, "grp_ll - <000>" );
				getMatchedBuf(matchbuf, MEDIUM_STR);
				matchbuf[MEDIUM_STR-1] = 0;
				matchbuf[strlen(matchbuf)-1] = 0;
				sprintf(buf, "HTTP response: HTTP/%s", matchbuf);
				userLog(buf);
				break;
			case 1:
				match("\n", maxWait, "grp_ll - <000>" );
				getMatchedBuf(matchbuf, MEDIUM_STR);
				matchbuf[MEDIUM_STR-1] = 0;
				contentLength = atoi(matchbuf);
				sprintf(buf, "Content Length: %d", contentLength);
				userLog(buf);
				break;
			case 2:
				if (getMatchedLen() == 1)
					gotHeaderEnd = 1;
				break;
			case 3:
				match("\n", maxWait, "grp_ll - <000>" );
				getMatchedBuf(matchbuf, MEDIUM_STR);
				/*
				srtncpy(cookiename, matchbuf, (int)(strchr(matchbuf, '=')-matchbuf));
				if (strstr(cookieSet, cookiename))
				{
					Replace cookie
				}

				*/

				if (strcmp(cookieSet, ""))
				{
					strcat(cookieSet, "; ");
				}
				strncat(cookieSet, matchbuf, (int)(strchr(matchbuf, ';')-matchbuf));
				userLog(matchbuf);
				userLog(cookieSet);

				break;
		}
	} while (!gotHeaderEnd);

/*
	while ( contentLength && totalRead < contentLength )
	{
		int toRead = MEDIUM_STR > contentLength - totalRead ?
			MEDIUM_STR : contentLength - totalRead;
		if ( ( noRead = read( session->In, buf, toRead ) ) == ERROR )
		{
			userLog("Read Error");
			closeSession();
			return;
		}
		if (noRead == 0)
		{
			userLog("Not enough data to cover content length");
			closeSession();
			return;
		}
		totalRead += noRead;
	}
*/

	logoutHttp();
}	/* HttpTransfer */


/********************************************************************/

void HttpGet(const char* path)
{
	char buf[ MEDIUM_STR ];
	char cookie[ MEDIUM_STR ] = "";

	if (strcmp(cookieSet, ""))
	{
		sprintf(cookie, "Cookie: %s\n", cookieSet);
	}
	sprintf(buf, "GET %s HTTP/1.0\nHost: livelink\n%s\n", path, cookie);
	HttpTransfer(buf);
}	/* HttpGet */


/********************************************************************/

void HttpPost(const char* path, const char* postdata)
{
	char buf[ MEDIUM_STR ];
	char cookie[ MEDIUM_STR ] = "";

	if (strcmp(cookieSet, ""))
	{
		sprintf(cookie, "Cookie: %s\n", cookieSet);
	}

	sprintf(buf, "POST %s HTTP/1.0\nContent-Length: %d\nContent-Type: application/x-www-form-urlencoded\nHost: livelink\n%s\n%s", path, strlen(postdata), cookie, postdata);
	HttpTransfer(buf);
}	/* HttpPost */


/********************************************************************/

void llTest()
{
	userLog( "START - llTest ..." );

	markThreadStart();

	/* login( NO ); Http is stateless so there's no real log in or log out. */

/*
	HttpGet("/notthere");
	HttpGet("/corporate_systems/incidents/20000414.CUSTACCCT--died_from_hostname_change/Log.txt");
	HttpPost("/cgi-bin/htsearch", "config=htdig&restrict=&exclude=&method=and&format=builtin-long&sort=score&words=Test");
*/

/*
http://livelink/livelink/livelink.exe?func=LL.getlogin&NextURL=%2Flivelink%2Flivelink%2Eexe
*/

/*
	userLog( "Log in" );
	HttpGet("/livelink/livelink.exe");

	userLog( "Redirected login" );
	HttpGet("/livelink/livelink.exe?func=LL.getlogin&NextURL=%2Flivelink%2Flivelink.exe");

	userLog( "Send password" );
	HttpPost("/livelink/livelink.exe", "func=ll.login&CurrentClientTime=&NextURL=/livelink/livelink.exe&Username=rharris&Password=&SUBMIT=Log-in");

	userLog( "Front menu" );
	HttpGet("/livelink/livelink.exe");

	userLog( "Browse 141" );
	HttpGet("/livelink/livelink.exe?func=ll&objtype=141&objaction=browse");

	userLog( "Get PSP 2313" );
	HttpGet("/livelink/livelink.exe?func=ll&objId=2313&objAction=browse&sort=name");
*/

	userLog( "Run search" );
	HttpGet("/livelink/pspsearch.asp");

	userLog( "Retrieve PSP 00002525" );
	HttpPost("/livelink/pspresult.asp", "PSP=2525&txtFlatUnitNumber=&txtHouseNumber=&txtStreetName=&cmbStreetType=&txtPostCode=");

	/* logout( NO ); */

	userLog( "END - llTest ..." );

	markThreadFinish();
}	/* llTest */


/********************************************************************/

