/*

 *      Author:  Peter Harding  <plh@pha.com.au>
 *
 *               Peter Harding & Associates Pty. Ltd.
 *               Level 5, 6195,
 *               492 St. Kilda Road,
 *               MELBOURNE, VIC, 3004
 *
 *               P.O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   03 9820 1261
 *               Fax:     03 9578 7810
 *               Mobile:  0418 375 085
 *
 *           Copyright (C) Peter Harding, 1997
 */

static char
   id[] = "@(#) [1.3.0] grp_ll.c 10/05/00";


/********************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/file.h>
#include <sys/time.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <signal.h>
#include <ctype.h>

#include <sys/socket.h>
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>

#include "misc.h"
#include "simple.h"
#include "trace.h"
#include "local.h"
#include "global.h"
#include "dcl_getdata.h"
#include "cookie.h"
#include "ntlm.h"
#include "base64.h"
#include "md4.h"
#include "des.h"


//----------------------------------------------------------------------------

#define NO_OBJ        128
#define NO_GIFS      1434

#define HTML       0x0000
#define IMAGE      0x0001

#define RCVBUFLEN  204800

#define SPACER ":::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"


//----- HREF types -----------------------------------------------------------

#define  BROWSE   1
#define  CONFIG   2
#define  FETCH    3
#define  INFO     4
#define  SHOW     5


//----- Document types -------------------------------------------------------

#define PLACE     1
#define DOCUMENT  2


//----------------------------------------------------------------------------

struct psp {
   char  objId[ 32 ];
   char  pspId[ 32 ];
};

typedef struct psp
   PSP;


//----------------------------------------------------------------------------

#define MAXOBJID    9000000

typedef struct llbrowse
   LLBROWSE;

struct llbrowse {
   LLBROWSE   *Next;   
   int         ObjId;
   int         Boid;
   char        Title[ 32 ];
   char        URL[ 256 ];
};

LLBROWSE 
   *llb[ MAXOBJID ],
   *llb_head           = (LLBROWSE*)0,
   *llb_tail           = (LLBROWSE*)0,
   *llb_curr           = (LLBROWSE*)0;


//----------------------------------------------------------------------------

extern int
   errno,
   noSends;

extern char
   *snd[];


//----------------------------------------------------------------------------

int
   xx = 0,
   newVersion                               = 1,  // LiveLink V9.1
   notAuthorized                            = 0,
   invalidNode                              = 0,
   displayErrors                            = 1,
   gatherFlg                                = 0,
   calledObjId                              = 0,
   parentObjId                              = 0,
   keepAlive                                = 0,
   ntlmDbg                                  = 0,
   ntlmSendMsg                              = 0,
   ntlmType                                 = 0,
   sendCnt,
   sendSock                                 = UNDEFINED,
   sendFd,
   statusCode,
   trcShowLine                              = 0;

static int
   loggedIn                                 = FALSE;  // Also read as Authenticated?

char
   *user                                    = APPL_ID,
   *passwd                                  = APPL_PASSWD,
   *domain                                  = DOMAIN,
   *webClient                               = WEB_CLIENT,
   *webServer                               = WEB_SERVER,
   *pObjId,
   *pPspId,

   // NTLM stuff
   *pnonce                                  = (char*)0,
   *b64encoded_ntlm_msg                     = (char*)0,

   // Web objects
   docId[ 256 ],
   url[ 256 ],
   gif[ 256 ],
   jpg[ 256 ],

   // LiveLink Cookies
   llInProgress[ 256 ],
   llCookie[ 256 ],
   llTZCookie[ 256 ],
   llView_ID[ 256 ],
   ntlmMsg[ 256 ];

FILE
   *bfp                                     = (FILE*)NULL,
   *xfp                                     = (FILE*)NULL,
   *lfp                                     = (FILE*)NULL,
   *tfp;

PSP
   psp[ NO_OBJ ];

static int
   ierr,
   objIdList[ NO_OBJ ],
   nodeIdList[ NO_OBJ ],
   titleList[ NO_OBJ ],
   firstTime                                = 1,
   noNode                                   = 0,
   useNode,
   noObj                                    = 0,
   noPsp                                    = 0;



//----------------------------------------------------------------------------

void  userLog( char *s );

void  initiateConnection( char *webserver );
void  sendSequence( int startIdx, int endIdx );
void  sendTest( void );
void  browseFolders( void );
void  sendGifs( void );
  
int   hex( char *s );
void  lc( char *buf, int len );
void  parsePSP( int type, char buf[], int len, int cnt );
void  parseDoc( int type, char buf[], int len, int cnt );
void  parseXxx( int type, char buf[], int len, int cnt );
void  authenticate( int type, char buf[], int len, int cnt );
void  parseBody( int objType, char buf[], int len, int cnt );
void  parseReply( void  );

void  getDocs( void );

// Script sequences

void  ll_v815_login( void);
void  ll_v910_login( void);
void  ll_pspSearch( void );
void  ntlm_authenticate( void );


//----- LLB Routines --------------------------------------------------------

void
llb_add(
   int   objId,
   char *title,
   char *url,
   int   boid
)
{
   if ( objId < MAXOBJID ) {
      LLBROWSE
         *pLlb;

      if ( ( pLlb = malloc( sizeof( LLBROWSE ) ) ) != (LLBROWSE*)0 ) {
         if ( llb_tail ) {
            llb_tail->Next = pLlb;
         } else {
            llb_head       = pLlb;
            llb_curr       = pLlb;
         }

         llb_tail          = pLlb;

         pLlb->Next        = 0;
         pLlb->ObjId       = objId;
         pLlb->Boid        = boid;

         strcpy( pLlb->Title, title );
         strcpy( pLlb->URL,   url );

         llb[ objId ]      = pLlb;

         fprintf( stderr, "%d  \"%s\"  \"%s\"  (%d)\n",
             pLlb->ObjId, pLlb->Title, pLlb->URL, pLlb->Boid );
      }
   } else {
      fprintf( stdout, "MAXOBJID exceeded -> %d\n", objId );
   }
}   // llb_add


//----------------------------------------------------------------------------


void
llb_list(
   void
)
{
   LLBROWSE
      *pLlb;

   int
      cnt = 0;

   pLlb = llb_head;

   while ( pLlb ) {
      fprintf( stderr, "%5d  %d  \"%s\"  \"%s\"  (%d)\n",
         cnt++, pLlb->ObjId, pLlb->Title, pLlb->URL, pLlb->Boid );

      pLlb = pLlb->Next;
   }
}   // llb_list


//----------------------------------------------------------------------------

void
llb_save(
   void
)
{
   int
      i;

   FILE
      *fp;

   if ( ( fp = fopen( "boid.lst", "w" ) ) == (FILE*)0 ) {
      fprintf( stderr, "Open failed (\"boid.lst\"\n" );
      exit( 11 );
   }

   for ( i = 0; i < MAXOBJID; i++ ) {
      if ( llb[i] ) {
         fprintf( fp, "%d|%d|%s|%s\n", i, llb[i]->Boid, llb[i]->Title, llb[i]->URL );
      }
   }

   fflush( fp );
   fclose( fp );
}   // llb_save


//----------------------------------------------------------------------------

void
initiateConnection(
#ifdef    ANSI_PROTO
   char *server
#endif /* ANSI_PROTO */
)
{
   long
      theAddress;

   int
      thePort;

   u_short
      b0, b1, b2, b3;

   struct hostent
      *hostEnt;

   struct servent
      *servEnt;

   struct sockaddr_in
      theSocket;

   if ( tfp )
      fprintf( tfp, "[initiateConnection] to \"%s\"\n", server );

   if ( ( hostEnt = gethostbyname( server ) ) == (struct hostent*)0 ) {
      perror( "gethostbyname" );
      userLog( "gethostbyname" );
      exit( 1 );
   }

   b0 = *(hostEnt->h_addr_list[0] + 0) & 0xff;
   b1 = *(hostEnt->h_addr_list[0] + 1) & 0xff;
   b2 = *(hostEnt->h_addr_list[0] + 2) & 0xff;
   b3 = *(hostEnt->h_addr_list[0] + 3) & 0xff;

   theAddress  = (b0 << 24) + (b1 << 16) + (b2 <<  8) + b3;

   if ( firstTime ) {
      fprintf( stderr, "Connecting to: %s\n", hostEnt->h_name);
      fprintf( stderr, "IP Address: %d.%d.%d.%d\n",
            b0 & 0xff, b1 & 0xff, b2 & 0xff, b3 & 0xff);
      firstTime = 0;
   }

#ifdef    TRACE
   if ( tfp ) {
      fprintf( tfp, "name: %s\n", hostEnt->h_name);
      fprintf( tfp, "type: %d\n", hostEnt->h_addrtype);
      //fprintf( tfp, "alias: %s\n", *hostEnt->h_aliases);
      fprintf( tfp, "length: %d\n", hostEnt->h_length);

      fprintf( tfp, "IP Address: %d.%d.%d.%d\n",
         b0 & 0xff, b1 & 0xff, b2 & 0xff, b3 & 0xff);

      fflush( tfp );
   }
#endif /* TRACE */

/*
   if ((servEnt = getservbyname( "http", "tcp")) == (struct servent*)0 ) {
      perror("getservbyname");
      userLog("getservbyname");
      exit( 1 );
   }

   thePort              = servEnt->s_port;
*/
   thePort              = 80;

#ifdef    TRACE
   if ( tfp ) {
      fprintf( tfp, "Got port %d for %s\n", thePort, "http" );
      fflush( tfp );
   }
#endif /* TRACE */

   if ( ( sendSock = socket( PF_INET, SOCK_STREAM, IPPROTO_TCP ) ) == 0 ) {
      sprintf(msgBuf,
         "[initiateConnection] socket() failed (errno %d)", errno);
      userLog( msgBuf );
      exit( 1 );
   }

#ifdef    TRACE
   if ( tfp ) {
      fprintf( tfp, "@@@ sendSock = %d\n", sendSock );
      fflush( tfp );
   }
#endif /* TRACE */

   theSocket.sin_family = PF_INET;
   theSocket.sin_port   = thePort;
   theSocket.sin_addr.s_addr = theAddress;

   if ( ( ierr = connect( sendSock, ( struct sockaddr* )&theSocket,
         sizeof( struct sockaddr_in ) ) ) == ERROR ) {
      sprintf(msgBuf,
         "[initiateConnection] connect() failed (errno %d)", errno);
      userLog(msgBuf);
      exit( 1 );
   }

#ifdef    TRACE
   if ( tfp ) {
      fprintf( tfp, "@@@ conect() -> %d\n", ierr );
      fflush( tfp );
   }
#endif /* TRACE */
}   /* initiateConnection */


/********************************************************************/

void
sendSequence(
   int startIdx,
   int endIdx
)
{
   int
      exhaustedCnt           = 0,
      i                      = 0,
      len,
      n,
      sendLen;

   char
      connectFlg             = ' ',
      useCookie              = ' ',
      *objStr,
      *pspStr                = "2525",
      *ep,
      *sp,
      tmpStr[ 32 ],
      sendDetails[ 256 ],
      *pSendBuf,
      sndBuf[ 10240 ];

   i = startIdx;

   fprintf( tfp, "****************** Into sendSequence()\n" );
   fflush( tfp );

   while ( 1 ) {
      sprintf( msgBuf, "Keep Alive %d  Socket %d", keepAlive, sendSock );
      userLog( msgBuf );

      if ( !keepAlive ) {
         if ( sendSock != UNDEFINED ) {
            close( sendSock );
            sendSock = UNDEFINED;
         }
         userLog("Initiate Connection!" );
         initiateConnection( host );
         connectFlg = '*';
      } else
         connectFlg = ' ';

      sendCnt = i;

      msleep( 100 );

      if (( i < 0 ) || ( i >= noSends )) {
         fprintf( stderr, "[sendSequence]  Invalid index value %d [0..%d]\n", i, noSends - 1 );
         break;
      }

      if ( sp = strstr( snd[ i ], "objId=" ) ) {
         int
            len;

         sp  += 6;
         ep   = strchr( sp, '&' );

         if ( ep ) {
            len           = ep - sp;

            strncpy( tmpStr, sp, len );

            tmpStr[ len ] = '\0';

            parentObjId   = calledObjId;
            calledObjId   = atoi( tmpStr );
         }
      }

      sp = strstr( snd[ i ], "%s" );

      if ( sp ) {
         useCookie = '*';

         if ( i == 25 ) {
            dsGetNext( ds_PSP, 90 );
            pspStr = dsGetField( ds_PSP, 0 );

            sprintf( msgBuf, "Using PSP %s", pspStr );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ], user, llInProgress, llCookie, llTZCookie, pspStr );
         } else if ( i == 29 ) {
            sprintf( msgBuf, "Using PSP %s  ObjId %s", pPspId, pObjId );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ], atoi( pObjId ), atoi( pPspId ),
               user, llInProgress, llCookie, llTZCookie );
         } else if ( i == 30 ) {
            dsGetNext( ds_PSPObj, 90 );
            pspStr = dsGetField( ds_PSPObj, 0 );
            objStr = dsGetField( ds_PSPObj, 1 );

            sprintf( msgBuf, "Using PSP %s  ObjId %s", pspStr, objStr );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ], user, atoi( objStr ), atoi( pspStr ),
               llInProgress, llCookie, llTZCookie );
         } else if ( i == 113 ) {
            dsGetNext( ds_PSP, 90 );
            pspStr = dsGetField( ds_PSP, 0 );

            sprintf( msgBuf, "Using PSP %s", pspStr );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ],
               user, llInProgress, llCookie, llTZCookie, atoi( pspStr ) );
         } else if ( ( i == 69 ) || ( i == 75 ) || ( i == 140 ) ) {
            dsGetNext( ds_PSP, 90 );
            pspStr = dsGetField( ds_PSP, 0 );

            sprintf( msgBuf, "Using PSP %s", pspStr );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ],
               user, llInProgress, llCookie, llTZCookie, atoi( pspStr ) );
         //} else if (( i == 186 ) || ( i == 276 ) || (( i >= 310 ) && ( i <= 312 ))) {  // LLGather
         } else if (( i == 186 ) || ( i == 276 )) {  // LLGather
            char
               *objId,
               *title,
               *url;

//            fprintf( stderr, "XXX llb_head 0x%08x\n", llb_head );

            if ( llb_head == (LLBROWSE*)0 ) {
               LLBROWSE
                  *pLlb;

               fprintf( stderr, ":::::::::::: Starting from scratch ::::::::::\n" );

               // objId = "2000";
               // title = "Top Level";
               // url   = "/livelink/livelink.exe?func=ll&objId=2000&objAction=browse&sort=name";
               objId = "3073632";
               title = "Word";
               url   = "/livelink/livelink.exe?func=ll&objId=3073632&objAction=browse&sort=name";

               if ( ( pLlb = malloc( sizeof(LLBROWSE) ) ) != (LLBROWSE*)0 ) {
                  llb_head       = pLlb;
                  llb_tail       = pLlb;
                  llb_curr       = pLlb;

                  llb[ 2000 ]    = pLlb;

                  pLlb->Next     = (LLBROWSE*)0;
                  pLlb->ObjId    = atoi( objId );
                  pLlb->Boid     = 2;

                  strcpy( pLlb->Title, title );
                  strcpy( pLlb->URL,   url );
               }
            } else {
               while ( 1 ) {
//                  fprintf( stderr, "XXX llb_curr       0x%08x\n", llb_curr );  // DBG
//                  fprintf( stderr, "XXX llb_curr->Next 0x%08x\n", llb_curr->Next );  // DBG
//                  fprintf( stderr, "XXX llb[ 0x%08x ] = %d\n", llb_curr, llb[ llb_curr->ObjId] );  // DBG

                  if ( llb_curr->Next != (LLBROWSE*)0 ) {
                     llb_curr = llb_curr->Next;
                  } else {
                     if ( exhaustedCnt++ > 3 )
                        break;
                     fprintf( stdout, "**************************** Browse list exhausted - restarting\n" );
                     llb_curr = llb_head;
                  }

//                  fprintf( stderr, "XXX ObjId %d  boid %d\n", llb_curr->ObjId, llb_curr->Boid );  // DBG

                  if ( llb_curr->Boid == 1 ) {
//                     fprintf( stderr, "Selecting: %d\n", llb_curr->ObjId );
                     llb_curr->Boid = 2;
                     break; 
                  } else {
//                     fprintf( stderr, "Skipping: %d\n", llb_curr->ObjId );
                  }
               }

               sprintf( tmpStr, "%d", llb_curr->ObjId );

               objId   = tmpStr;
               title   = llb_curr->Title;
               url     = llb_curr->URL;
            }

//            fprintf( stderr, "%s - %s\n", objId, title );

            sprintf( msgBuf, "Using URL %s", url );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ],
               url, llInProgress, llCookie, llTZCookie );


         //-------------------------------------------------------------------

         //} else if (( i == 187 ) || (i == 277) || (( i >= 310 ) && ( i <= 312 ))) {  // LLBrowse/browse
         } else if (( i == 187 ) || (i == 277)) {  // LLBrowse/browse
            char
               *objId,
               *nameStr,
               *urlStr;

            dsGetNext( ds_BrowseObj, 90 );

            objId   = dsGetField( ds_BrowseObj, 0 );
            nameStr = dsGetField( ds_BrowseObj, 1 );
            urlStr  = dsGetField( ds_BrowseObj, 2 );

            fprintf( stderr, "                    [%s] \"%s\"\n", objId, nameStr );

            sprintf( msgBuf, "Using URL %s", urlStr );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ],
               urlStr, llInProgress, llCookie, llTZCookie );
         //} else if (( i == 188 ) || ( i == 278 ) || (( i >= 310 ) && ( i <= 312 ))) {  // LLFetch/fetch
         } else if (( i == 188 ) || ( i == 278 )) {  // LLFetch/fetch
            char
               *objId,
               *nameStr,
               *urlStr;

            dsGetNext( ds_FetchObj, 90 );

            objId   = dsGetField( ds_FetchObj, 0 );
            nameStr = dsGetField( ds_FetchObj, 1 );
            urlStr  = dsGetField( ds_FetchObj, 2 );

            fprintf( stdout, "                   [%s] \"%s\"\n", objId, nameStr );
            fflush( stdout );

            sprintf( msgBuf, "Using URL %s", urlStr );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ],
               urlStr, llInProgress, llCookie, llTZCookie );
         } else if (( i == 189 ) || ( i == 279 )  || (( i >= 310 ) && ( i <= 312 ))) {  // LLInfo/info
            char
               *objId,
               *nameStr,
               *urlStr;

            dsGetNext( ds_InfoObj, 90 );

            objId   = dsGetField( ds_InfoObj, 0 );
            nameStr = dsGetField( ds_InfoObj, 1 );
            urlStr  = dsGetField( ds_InfoObj, 2 );

            fprintf( stderr, "                   [%s] \"%s\"\n", objId, nameStr );

            sprintf( msgBuf, "Using URL %s", urlStr );
            userLog( msgBuf );

            if (( i == 311 ) || ( i == 312 )) {
               sprintf( sndBuf, snd[ i ],
                  urlStr, b64encoded_ntlm_msg, llInProgress, llCookie, llTZCookie );
            } else {
               sprintf( sndBuf, snd[ i ],
                  urlStr, llInProgress, llCookie, llTZCookie );
            }

            fprintf( stderr, "XXXX\n" );
         //} else if (( i == 190 ) || ( i == 280 ) || (( i >= 310 ) && ( i <= 312 ))) {  // LLShow/show
         } else if (( i == 190 ) || ( i == 280 ) || (i == 329 )) {  // LLShow/show
            char
               *objId,
               *nameStr,
               *htmlStr,
               *sizeStr,
               *urlStr;

            dsGetNext( ds_ShowObj, 90 );

            objId   = dsGetField( ds_ShowObj, 0 );
            nameStr = dsGetField( ds_ShowObj, 1 );
            htmlStr = dsGetField( ds_ShowObj, 2 );
            sizeStr = dsGetField( ds_ShowObj, 3 );
            urlStr  = dsGetField( ds_ShowObj, 4 );

            strcpy( docId, objId );

            fprintf( stdout, "                   [%s] \"%s\" (%s)\n", objId, nameStr, sizeStr );
            fflush( stdout );

            sprintf( msgBuf, "Showing Doc (%s) URL %s", sizeStr, urlStr );
            userLog( msgBuf );

            sprintf( sndBuf, snd[ i ],
               urlStr, llInProgress, llCookie, llTZCookie );
         } else if ( ( ( i >= 81 ) && ( i <= 111 ) ) || ( ( i >= 112 ) && ( i <= 118 ))) {

/* New %s substition mechanism?
            if ( strstr( snd[ i ], "LLUser" ) {
               sprintf( sndBuf, snd[ i ],
                  user, llInProgress, llCookie, llTZCookie );
            } else if ( strstr( snd[ i ], "LLInProgress" ) {
               sprintf( sndBuf, snd[ i ],
                  llInProgress, llCookie, llTZCookie );
            } else
               pSendBuf  = snd[ i ];
*/

            sprintf( sndBuf, snd[ i ],
               user, llInProgress, llCookie, llTZCookie );

      //-------------------------------------------------------------------------

         } else if (( i >= 313 ) && ( i <= 315 )) {  // New HLBrowse
            static char
               *objId;

            if ( i == 313 ) {
               dsGetNext( ds_BrowseObj, 90 );

               objId   = dsGetField( ds_BrowseObj, 0 );
            }

            // fprintf( stderr, "                   [%s]\n", objId );

            sprintf( msgBuf, "Showing Doc (objId=%s)", objId );
            userLog( msgBuf );

            if ( ntlmDbg )
               fprintf( stderr, "                   <NTLM>  Send encoded type %d msg\n", ntlmType );

            if ( i == 313 ) {
               sprintf( sndBuf, snd[ i ],
                  objId, llInProgress, llCookie, llTZCookie );
            } else {
               if ( ntlmType == 1 )
                  useCookie = '1';
               else
                  useCookie = '3';

               if ( strstr( snd[ i ], "LLInProgress" ))
                  sprintf( sndBuf, snd[ i ], objId, b64encoded_ntlm_msg, llInProgress, llCookie, llTZCookie );
               else
                  sprintf( sndBuf, snd[ i ], objId, b64encoded_ntlm_msg );

               ntlmType = 0;
            }

      //-------------------------------------------------------------------------

         } else if (( i >= 328 ) && ( i <= 328 )) {  // LLFolder
            char
               *objId,
               *url;

            fprintf( stderr, "LLFolder           XXXX\n" );
            if ( i == 328 ) {
               dsGetNext( ds_FolderObj, 90 );

               objId = dsGetField( ds_FolderObj, 0 );
               url   = dsGetField( ds_FolderObj, 3 );
            }

            fprintf( stderr, "LLFolder           [%s]\n", objId );

            sprintf( msgBuf, "Showing Doc (objId=%s)", objId );
            userLog( msgBuf );

            if ( i == 328 ) {
               sprintf( sndBuf, snd[ i ],
                  url, llInProgress, llCookie, llTZCookie );
            } else {
            }

      //-------------------------------------------------------------------------

         } else if (( i >= 330 ) && ( i <= 332 )) {  // JPG in new LLShow Variant


            if ( ntlmDbg )
               fprintf( stderr, "                   <NTLM>  Send encoded type %d msg\n", ntlmType );

            if ( i == 330 ) {
               if ( xx++ == 0 )
               strcpy( llView_ID, getCookie( "LLView_ID" ));

               sprintf( sndBuf, snd[ i ],
                  jpg, docId, docId, docId, llInProgress, llCookie, llTZCookie, llView_ID );
            } else {
               if ( ntlmType == 1 )
                  useCookie = '1';
               else
                  useCookie = '3';

               sprintf( sndBuf, snd[ i ], jpg, docId, docId, docId,
                  b64encoded_ntlm_msg, llInProgress, llCookie, llTZCookie, llView_ID );

               ntlmType = 0;
            }


      //-------------------------------------------------------------------------

         } else if (( i >= 135 ) && ( i <= 141 )) {
            sprintf( sndBuf, snd[ i ],
               user, llInProgress, llCookie, llTZCookie );
         } else if (( i >= 117 ) && ( i <= 134 )) {
            sprintf( sndBuf, snd[ i ],
               user, llInProgress, llCookie, llTZCookie );
         } else if ( i == 78 ) {
            sprintf( sndBuf, snd[ i ],
                titleList[ useNode ], nodeIdList[ useNode ], titleList[ useNode ],
               user, llInProgress, llCookie, llTZCookie );
         } else if ( ( i == 79 ) || ( i == 80 ) ) {
            sprintf( sndBuf, snd[ i ],
                titleList[ useNode ], nodeIdList[ useNode ], titleList[ useNode ],
               user, llInProgress, llCookie, llTZCookie );

         //----- Add new user page -----

         } else if ( i == 142 ) {
            userLog( "Send #142" );
            sprintf( sndBuf, snd[ i ],
               user, llInProgress, llCookie, llTZCookie );

/*--- Should be ahandled by code added yesterday which does a strstr() on
      snd[] to work out what we need to sprintf over it... - plh [31/05/2002]
         } else if (( i > 148 ) && ( i < 190 )) {
            userLog( "Send > 142" );
            sprintf( sndBuf, snd[ i ],
               llInProgress, llCookie, llTZCookie );
*/

      //---- sendGifs ------------------------

         } else if ( i == 275 ) {
               char
                  *gif;

               gif = dsGetNextIndexed( ds_Gifs, rteRand( NO_GIFS ), 90 );
               
               sprintf( sndBuf, snd[ i ], gif );


      //---- NTLM ------------------------

         } else if ( i == 193 ) {
            userLog( "Initiate NTLM login" );
         } else if ( ntlmSendMsg ) {
            // fprintf( stderr, "Attempt to send NTLM encoded msg [0x%08x]\n", b64encoded_ntlm_msg );
            // fprintf( stderr, "%s\n", b64encoded_ntlm_msg );
            sprintf( msgBuf, "Send NTLM Msg \"%s\"", b64encoded_ntlm_msg );
            userLog( msgBuf );

            if ( ntlmDbg )
               fprintf( stderr, "                   <NTLM>  Send encoded type %d msg\n", ntlmType );

            if ( ntlmType == 1 )
               useCookie = '1';
            else
               useCookie = '3';

            if ( strstr( snd[ i ], "LLInProgress" ))
               sprintf( sndBuf, snd[ i ], b64encoded_ntlm_msg, llInProgress, llCookie, llTZCookie );
            else
               sprintf( sndBuf, snd[ i ], b64encoded_ntlm_msg );

            ntlmType = 0;


      //----------------------------------

         } else {
            if ( strstr( snd[ i ], "LLInProgress" )) {
               if ( strstr( snd[ i ], "user" ))
                  sprintf( sndBuf, snd[ i ], user, llInProgress, llCookie, llTZCookie );
               else
                  sprintf( sndBuf, snd[ i ], llInProgress, llCookie, llTZCookie );
            }
         }

         pSendBuf  = sndBuf;
         sendLen   = strlen( sndBuf );
      } else {  // No %s in sendBuf!
         useCookie = '-';
         pSendBuf  = snd[ i ];
         sendLen   = strlen( snd[ i ] );
      }

      markQueryStart();

      if ( ( n = write( sendSock, pSendBuf, sendLen ) ) == -1 ) {
         if ( tfp ) {
            fprintf( tfp, "write() -> errno = %d\n", errno );
            fflush( tfp );
         }
         perror( "write()" );
         exit( 1 );
      }

      // fprintf( stderr, "@@@@@ %d bytes written\n", n );  // DBG


      tic( sessionIdx );

      markQueryFinish( "Send" );

      // fprintf( stderr, "[XXXX]  Before title 0x%08x %d\n", pSendBuf, sendLen );
      // fprints( stderr, pSendBuf, sendLen, 70, "<<<", 0 );

      if ( sp = strchr( pSendBuf, '\r' ) ) {
         strncpy( msgBuf, pSendBuf, sp - pSendBuf );
         msgBuf[ sp - pSendBuf ] = '\0';
   
         sprintf( sendDetails, "%c %s", useCookie, msgBuf );

         sprintf( msgBuf, "%c[%04d]  Len %4d  %s", connectFlg, i, n, sendDetails );
         userLog( msgBuf );

         fprintf( stdout, "%s\n", msgBuf );
         fflush( stdout );
      }

      if ( tfp ) {
         fprintf( tfp, "\n[%d]  Wrote %d bytes:\n", i, n );
         fprints( tfp, pSendBuf, sendLen, 70, 0 );
         fprintf( tfp, "\n" );
         fflush( tfp );
      }

      markQueryStart();
      parseReply();
      sprintf( msgBuf, "Reply_%d", i );
      markQueryFinish( msgBuf );


      if ( ( ++i > endIdx ) || finished() ) {
         if ( finished() ) {
            close( sendSock );
            sendSock = UNDEFINED;
         }
         break;
      }
   }

   TRACE( TRC_LEAVING, "Leaving sendSequence()" );
}   /* sendSequence */


/********************************************************************/

int
hex( char *s )
{
   int
      i,
      len,
      x,
      val = 0;

   char
      ch;

   len = strlen( s );

   for ( i = 0; i < len; i++ ) {
      ch = toupper( s[ i ] );

      if ( ch == ' ' )
         break;

      switch ( ch ) {
         case '0':
         case '1':
         case '2':
         case '3':
         case '4':
         case '5':
         case '6':
         case '7':
         case '8':
         case '9':
            x = ch - '0';
            break;
         case 'A':
         case 'B':
         case 'C':
         case 'D':
         case 'E':
         case 'F':
            x = ch - 'A' + 10; 
            break;
         default:
            x = 0;
      }
      val = ( val * 16 ) + x;
   }

   return val;
}   /* hex */


/********************************************************************/

void
authenticate(
   int  type,
   char buf[],
   int  len,
   int  cnt
)
{
   char
      *cp,
      *pName,
      *pValue;

   fprintf( stdout, "                   Authenticating user\n" );
   fflush( stdout );

   parseBody( HTML, buf, len, cnt );


   //cp      = buf + len; // Not sure why - plh 30/05/2002
   cp      = buf;

   cp      = strstr( cp, "Set-Cookie:" );


   if ( tfp ) {
      fprintf( tfp, "cp 0x%08x\n", cp ); 
      fflush( tfp );
   }

   cp      = strchr( cp, ' ' );
   pName   = ++cp;
   cp      = strchr( cp, '=' );
   *cp++   = '\0';

   pValue  = cp;
   cp      = strchr( cp, ';' );
   *cp++   = '\0';

   strcpy( llInProgress, pValue );

   if ( tfp ) {
      fprintf( tfp, " Name: \"%s\"\n", pName ); 
      fprintf( tfp, "Value: \"%s\"\n", pValue ); 
      fflush( tfp );
   }

   cp      = strstr( cp, "Set-Cookie:" );

   cp      = strchr( cp, ' ' );
   pName   = ++cp;
   cp      = strchr( cp, '=' );
   *cp++   = '\0';

   pValue  = cp;
   cp      = strchr( cp, ';' );
   *cp++   = '\0';

   strcpy( llCookie, pValue );

   if ( tfp ) {
      fprintf( tfp, " Name: \"%s\"\n", pName ); 
      fprintf( tfp, "Value: \"%s\"\n", pValue ); 
      fflush( tfp );
   }

   cp      = strstr( cp, "Set-Cookie:" );

   cp      = strchr( cp, ' ' );
   pName   = ++cp;
   cp      = strchr( cp, '=' );
   *cp++   = '\0';

   pValue  = cp;
   cp      = strchr( cp, ';' );
   *cp++   = '\0';

   strcpy( llTZCookie, pValue );

   if ( tfp ) {
      fprintf( tfp, " Name: \"%s\"\n", pName ); 
      fprintf( tfp, "Value: \"%s\"\n", pValue ); 
      fflush( tfp );
   }

   fprintf( stdout, "                   Authentication completed\n" );
   fflush( stdout );
}  // authenticate


/********************************************************************/

void
parsePSP(
   int  type,
   char buf[],
   int  len,
   int  cnt
)
{
   char
      objId[ 32 ],
      pspId[ 32 ],
      *cp,
      *pVal;

   TRACE( TRC_INTO, "Into parsePSP()" );

   noPsp = 0;

   parseBody( HTML, buf, len, cnt );

   cp   = (void*)(buf + len);

   while ( 1 ) {
      cp = strstr( cp, "width=\"1%\"><a href=\"/livelink/psp.exe?func=fetch&objid=" );

      if ( cp ) {  // Got a PSP
         cp    += 59;
         pVal   = ++cp;
         cp     = strchr( cp, '\r' );
         *cp++  = '\0';

         strcpy( psp[ noPsp ].objId, pVal );

         cp    += 14;
         pVal   = cp;
         cp     = strchr( cp, '\r' );
         *cp++  = '\0';

         strcpy( psp[ noPsp ].pspId, pVal );

         sprintf( msgBuf, "%d,%s", atoi( psp[ noPsp ].pspId ), psp[ noPsp ].objId );

         dsStoreCsvData( ds_PSPObj, msgBuf, 30 );

         noPsp++;
      } else
         break;
   }

   if ( tfp ) {
      fprintf( tfp, "*********** Found %d PSPs\n", noPsp ); 
      fflush( tfp );
   }

   TRACE( TRC_LEAVING, "Leaving parsePSP()" );
}   // parsePSP


/********************************************************************/

void
parseDoc(
   int  type,
   char buf[],
   int  len,
   int  cnt
)
{
/*
 * 
 * View:
 * /livelink/llview.exe/148?func=doc.View&nodeId=107338&docTitle=148&vernum=1
 * /livelink/llview.exe/147?func=doc.View&nodeId=107122&docTitle=147&vernum=1
 * 
 * Location:
 * /livelink/livelink.exe?func=ll&objId=101056&objAction=browse
 * 
 * Info:
 * /livelink/livelink.exe?func=ll&objId=107122&objAction=properties&
 *     nexturl=%2Flivelink%2Flivelink%2Eexe
 * /livelink/livelink.exe?func=ll&objId=107338&objAction=properties&
 *     nexturl=%2Flivelink%2Flivelink%2Eexe
 * 
 * Fetch:
 * /livelink/livelink.exe/107122/147.tiff?func=doc.Fetch&nodeid=107122&vernum=1
 * /livelink/livelink.exe/107338/148.tiff?func=doc.Fetch&nodeid=107338&vernum=1
 * 
 */

   char
      *cp,
      *pVal;

   int
      found,
      i,
      mCnt,
      iNodeId,
      iObjId,
      iTitle;

   TRACE( TRC_INTO, "Into parseDoc()" );

   parseBody( HTML, buf, len, cnt );

   noObj  = 0;
   noNode = 0;

   cp   = (char*)( buf + cnt );

   while ( 1 ) {
      cp = strstr( cp, "href=\"/livelink" );
      if ( cp ) {  // Got a PSP
         pVal   = cp + 6;
         cp     = strchr( cp, '>' );
         --cp;
         *cp++  = '\0';

         if ( strstr( pVal, "properties" ) ) { // Info
            sscanf( pVal, "/livelink/livelink.exe?func=ll&objId=%d&", &iObjId );
            fprintf( stderr, "ObjId [%d]\n", iObjId );

            found = 0;

            for ( i = 0; i < noObj; i++ ) {
               if ( objIdList[ i ] == iObjId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               objIdList[ noObj++ ] = iObjId;
            }
         } else if ( strstr( pVal, "tiff" ) ) { // Fetch
            sscanf( pVal, "/livelink/livelink.exe/%d/%d.tiff",
               &iNodeId, &iTitle );
            fprintf( stderr, "Fetch:   NodeId [%d]  Title [%d]\n",
               iNodeId, iTitle );

            found = 0;

            for ( i = 0; i < noNode; i++ ) {
               if ( nodeIdList[ i ] == iNodeId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               nodeIdList[ noNode ]  = iNodeId;
               titleList[ noNode++ ] = iTitle;
            }
         } else if ( strstr( pVal, "func=ll" ) ) { // Location
            sscanf( pVal, "/livelink/livelink.exe?func=ll&objId=%d&objAction=browse", &iObjId );
            fprintf( stderr, "Location:  ObjId [%d]\n", iObjId );

            found = 0;

            for ( i = 0; i < noObj; i++ ) {
               if ( objIdList[ i ] == iObjId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               objIdList[ noObj++ ] = iObjId;
            }
         } else if ( strstr( pVal, "func=doc.view&" ) ) { // View
            sscanf( pVal, "/livelink/llview.exe/%d?func=doc.View&nodeId=%d&docTitle=",
               &iTitle, &iNodeId );
            fprintf( stderr, "Location:  NodeId [%d]  Title [%d]\n",
               iNodeId, iTitle );

            found = 0;

            for ( i = 0; i < noNode; i++ ) {
               if ( nodeIdList[ i ] == iNodeId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               nodeIdList[ noNode ]  = iNodeId;
               titleList[ noNode++ ] = iTitle;
            }
         }

         // fprintf( stderr, "LLVIEW [%s]\n", pVal );
         if ( tfp ) {
            fprintf( tfp, "LLVIEW [%s]\n", pVal );
            fflush( tfp );
         }

         //dsStoreCsvData( ds_PSPObj, msgBuf, 30 );

         if ( noObj > NO_OBJ - 1 )
            break;
      } else
         break;
   }

   for ( i = 0; i < noObj; i++ ) {
      if ( tfp ) {
         fprintf( tfp, "ObjId  %d\n",
            objIdList[ i ] );
         fflush( tfp );
      }
      fprintf( stderr, "ObjId  %d\n",
         objIdList[ i ] );
   }

   for ( i = 0; i < noNode; i++ ) {
      if ( tfp ) {
         fprintf( tfp, "Node  %d  Title %d\n",
            nodeIdList[ i ], titleList[ i ] );
         fflush( tfp );
      }
      fprintf( stderr, "Node  %d  Title %d\n",
         nodeIdList[ i ], titleList[ i ] );
   }

   if ( tfp )
      fflush( tfp );

   TRACE( TRC_LEAVING, "Leaving parseDoc()" );
}   // parseDoc


/********************************************************************/

void
parseXxx(
   int  type,
   char buf[],
   int  len,
   int  cnt
)
{
/*
 * 
 * View:
 * /livelink/llview.exe/148?func=doc.View&nodeId=107338&docTitle=148&vernum=1
 * /livelink/llview.exe/147?func=doc.View&nodeId=107122&docTitle=147&vernum=1
 * 
 * Location:
 * /livelink/livelink.exe?func=ll&objId=101056&objAction=browse
 * 
 * Info:
 * /livelink/livelink.exe?func=ll&objId=107122&objAction=properties&
 *     nexturl=%2Flivelink%2Flivelink%2Eexe
 * /livelink/livelink.exe?func=ll&objId=107338&objAction=properties&
 *     nexturl=%2Flivelink%2Flivelink%2Eexe
 * 
 * Fetch:
 * /livelink/livelink.exe/107122/147.tiff?func=doc.Fetch&nodeid=107122&vernum=1
 * /livelink/livelink.exe/107338/148.tiff?func=doc.Fetch&nodeid=107338&vernum=1
 * 
 */

   char
      *cp,
      *pVal;

   int
      found,
      i,
      mCnt,
      iNodeId,
      iObjId,
      iTitle;

   TRACE( TRC_INTO, "Into parseXxx()" );

   parseBody( HTML, buf, len, cnt );

   noObj  = 0;
   noNode = 0;

   cp   = (char*)( buf + cnt );

   while ( 1 ) {
      cp = strstr( cp, "href=\"/livelink" );
      if ( cp ) {  // Got a PSP
         pVal   = cp + 6;
         cp     = strchr( cp, '>' );
         --cp;
         *cp++  = '\0';

         if ( strstr( pVal, "properties" ) ) { // Info
            sscanf( pVal, "/livelink/livelink.exe?func=ll&objId=%d&", &iObjId );
            fprintf( stderr, "ObjId [%d]\n", iObjId );

            found = 0;

            for ( i = 0; i < noObj; i++ ) {
               if ( objIdList[ i ] == iObjId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               objIdList[ noObj++ ] = iObjId;
            }
         } else if ( strstr( pVal, "tiff" ) ) { // Fetch
            sscanf( pVal, "/livelink/livelink.exe/%d/%d.tiff",
               &iNodeId, &iTitle );
            fprintf( stderr, "Fetch:   NodeId [%d]  Title [%d]\n",
               iNodeId, iTitle );

            found = 0;

            for ( i = 0; i < noNode; i++ ) {
               if ( nodeIdList[ i ] == iNodeId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               nodeIdList[ noNode ]  = iNodeId;
               titleList[ noNode++ ] = iTitle;
            }
         } else if ( strstr( pVal, "func=ll" ) ) { // Location
            sscanf( pVal, "/livelink/livelink.exe?func=ll&objId=%d&objAction=browse", &iObjId );
            fprintf( stderr, "Location:  ObjId [%d]\n", iObjId );

            found = 0;

            for ( i = 0; i < noObj; i++ ) {
               if ( objIdList[ i ] == iObjId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               objIdList[ noObj++ ] = iObjId;
            }
         } else if ( strstr( pVal, "func=doc.view&" ) ) { // View
            sscanf( pVal, "/livelink/llview.exe/%d?func=doc.View&nodeId=%d&docTitle=",
               &iTitle, &iNodeId );
            fprintf( stderr, "Location:  NodeId [%d]  Title [%d]\n",
               iNodeId, iTitle );

            found = 0;

            for ( i = 0; i < noNode; i++ ) {
               if ( nodeIdList[ i ] == iNodeId ) {
                  found = 1;
                  break;
               }
            }

            if ( !found ) {
               nodeIdList[ noNode ]  = iNodeId;
               titleList[ noNode++ ] = iTitle;
            }
         }

         // fprintf( stderr, "LLVIEW [%s]\n", pVal );
         if ( tfp ) {
            fprintf( tfp, "LLVIEW [%s]\n", pVal );
            fflush( tfp );
         }

         //dsStoreCsvData( ds_PSPObj, msgBuf );

         if ( noObj > NO_OBJ - 1 )
            break;
      } else
         break;
   }

   for ( i = 0; i < noObj; i++ ) {
      if ( tfp )
         fprintf( tfp, "ObjId  %d\n",
            objIdList[ i ] );
      fprintf( stderr, "ObjId  %d\n",
         objIdList[ i ] );
   }

   for ( i = 0; i < noNode; i++ ) {
      if ( tfp )
         fprintf( tfp, "Node  %d  Title %d\n",
            nodeIdList[ i ], titleList[ i ] );
      fprintf( stderr, "Node  %d  Title %d\n",
         nodeIdList[ i ], titleList[ i ] );
   }

   if ( tfp )
      fflush( tfp );

   TRACE( TRC_LEAVING, "Leaving parseXxx()" );
}   // parseXxx


/********************************************************************/

char*
strHrefType(
   int hrefType
)
{
   switch ( hrefType ) {
      case 1:
         return "BROWSE";

      case 2:
         return "CONFIG";

      case 3:
         return "FETCH";

      case 4:
         return "INFO";

      case 5:
         return "SHOW";

      default:
         return "UNDEFINED";
   }
}   // strHrefType


/********************************************************************/

void
parseHref(
   char *buf
)
{
   char
      docName[ 128 ],
      docTitle[ 128 ],
      objIdStr[ 128 ],
      objActionStr[ 128 ],
      nextUrlStr[ 256 ],
      altStr[ 1024 ],
      urlStr[ 1024 ],
      hrefStr[ 1024 ],
      tmpStr[ 256 ],
      *bp,
      *ep,
      *hp,
      *ip,
      *np,
      *sp,
      *pArg,
      *description;

   int
      i,
      docCnt              = 0,
      objId               = 0,
      hrefType            = UNDEFINED,
      sortByName          = 0,
      len                 = 0,
      objtype             = 0,
      docSize             = 0,
      saveData            = 0;

   TRACE( TRC_INTO, "Into parseHref()" );

   bp = buf;


   if ( ep = strstr( bp, ".jpg" ) ) {
      char
         *xp;

      xp = ep;
      i  = 0;

      while (i < 10) {
         if (*xp == '"' ) {
            xp++;
            break;
         } else
            xp--;
         i++;
      }

      strncpy( jpg, xp, i + 4 );

      jpg[ i + 4 ] = '\0';

      fprintf(stderr, ">>>>>%s\n", jpg );
   }


   bp = buf;

   objtype = UNDEFINED;

   while ( sp = strstr( bp, "<A HREF=" ) ) {
      hp  = sp + 9;             // Move to first character after quote
      sp  = strchr( hp, '"' );  // The end of the HREF URL

      if ( !sp )
         break;

      len = sp - hp;

      strncpy( urlStr, hp, len );

      urlStr[ len ] = '\0';

      sp  = strchr( sp, '>' );  // The end of the start HREF tag element

      if ( !sp )
         break;

      if ( ( ep = strstr( sp, "</A>" ) ) == 0 ) {  // Problem - no end HREF tag
         fprintf( stdout, "No end HREF tag" );
         fflush( stdout );
         return;
      }

      len            = ep - sp - 1;

      strncpy( hrefStr, sp + 1, len );

      hrefStr[ len ] = '\0';
      altStr[ 0 ]    = '\0';

      if ( ip = strstr( hrefStr, "<IMG" ) ) {
         if ( np = strstr( ip + 5, "<IMG" ) )
            ip = np;

         if ( ip = strstr( ip + 5, "ALT=" ) ) {
            ip += 5;
            np = strchr( ip, '"' );

            if ( !np )
               break;

            len = np - ip;

            strncpy( altStr, ip, len );

            altStr[ len ] = '\0';
         }

         description = altStr;
      } else {
         if ( ip = strstr( hrefStr, "<FONT" ) ) {
            ip += 6;

            ip = strchr( ip, '>' );

            if ( !ip )
               break;

            ip++;

            if ( np = strstr( hrefStr, "</FONT>" ) ) {
               len = np - ip;
            } else {
               len = 0;
            }

            strncpy( hrefStr, ip, len );

            hrefStr[ len ] = '\0';
         }

         description = hrefStr;
      }

      hrefType = UNDEFINED;

      if ( strstr( hrefStr, "Configure" ) ) {
         hrefType = CONFIG;
      } else if ( strstr( hrefStr, "Fetch" ) ) {
         hrefType = FETCH;
      } else if ( strstr( hrefStr, "Info" ) ) {
         hrefType = INFO;
      }

      if ( strstr( urlStr, "/livelink" ) ) {
         if ( ip = strstr( urlStr, "livelink.exe?" ) ) {
            ip  += 13;
            pArg = ip;
         }

         if ( ip = strstr( urlStr, "llview.exe/" ) ) {
            ip  += 11;
            pArg = ip;

            if ( np = strstr( ip, "func=doc.View" ) ) {

               hrefType = SHOW;

               if ( np = strstr( sp, " KB&nbsp;" ) ) {
                  char
                     sizeStr[ 128 ],
                     *kp;

                  int
                     i = 0;

                  docCnt++;
                  // fprintf( stdout, "KB\n" );
                  // fflush( stdout );

                  kp = np;

                  while ( ( *np != '>' ) && ( i++ < 20 ) )
                     np--;

                  if ( *np == '>' ) {
                     np++;

                     len = kp - np;

                     strncpy( sizeStr, np, len );

                     sizeStr[ len ] = '\0';

                     docSize = atoi( sizeStr );
                  }
               }
            }
         }

         if ( hrefType != SHOW ) { // A place
            if ( ip = strstr( pArg, "objId=" ) ) {
               ip  += 6;
               if ( np = strchr( ip, '&' ) ) {
                  len             = np - ip;
                  strncpy( objIdStr, ip, len );
                  objIdStr[ len ] = '\0';
                  objId           = atoi( objIdStr );
               }
            } else if ( ip = strstr( pArg, "nodeid=" ) ) {
               ip  += 7;
               if ( np = strchr( ip, '&' ) ) {
                  len             = np - ip;
                  strncpy( objIdStr, ip, len );
                  objIdStr[ len ] = '\0';
               } else {
                  strcpy( objIdStr, ip );
               }
               objId              = atoi( objIdStr );
            } else
               objId = 0;

            if ( ip = strstr( pArg, "objAction=" ) ) {
               ip  += 10;
               if ( np = strchr( ip, '&' ) ) {
                  len             = np - ip;
                  strncpy( objActionStr, ip, len );
                  objActionStr[ len ] = '\0';
               }
            } else
               objActionStr[ 0 ] = '\0';

            if ( !strcmp( objActionStr, "properties" ) )
               hrefType = INFO;
            else if ( !strcmp( objActionStr, "browse" ) )
               hrefType = BROWSE;

            if ( strstr( pArg, "sort=name" ) )
               sortByName = 1;
            else
               sortByName = 0;

            if ( ip = strstr( pArg, "nexturl=" ) ) {
               ip  += 8;
               strcpy( nextUrlStr, ip );
            } else
               nextUrlStr[ 0 ] = '\0';

            if ( xfp && strstr( pArg, "Up One Level" ) ) {
               fprintf( xfp, ">>>>> Parent objId %d\n", objId );
            }

            if ( tfp ) {
               fprintf( tfp, "{::%s::%s::}\n", urlStr, hrefStr );
               fprintf( tfp, ":%d:%s:%s:%d:%s:\n", 
                  objId, description, objActionStr, sortByName, pArg );
               fflush( tfp );
            }

            if ( xfp ) {
               fprintf( xfp, "[%s]:%d:%s:%s:%s:\n", 
                  strHrefType( hrefType ), objId, description, objActionStr, urlStr );
               fflush( xfp );
            }

         } else if ( hrefType == SHOW ) {  // A document
            if ( ip = strchr( pArg, '?' ) ) {
               len             = ip - pArg;
               strncpy( docName, pArg, len );
               docName[ len ] = '\0';
            } else
               docName[ 0 ] = '\0';

            if ( ip = strstr( pArg, "nodeId=" ) ) {
               ip  += 7;
               if ( np = strchr( ip, '&' ) ) {
                  len             = np - ip;
                  strncpy( objIdStr, ip, len );
                  objIdStr[ len ] = '\0';
               } else {
                  strcpy( objIdStr, ip );
               }
               objId           = atoi( objIdStr );
            } else
               objId = 0;

            if ( ip = strstr( pArg, "docTitle=" ) ) {
               ip  += 9;
               strcpy( docTitle, ip );
            } else
               docTitle[ 0 ] = '\0';

            if ( tfp ) {
               fprintf( tfp, "{::%s::%s::}\n", urlStr, hrefStr );
               fprintf( tfp, ":%d:%s:%s:%s:%s:\n", 
                  objId, description, docName, docTitle, pArg );
               fflush( tfp );
            }

            if ( xfp ) {
               fprintf( xfp, "[%s]:%d:%s:%s:%d:%s\n", 
                  strHrefType( hrefType ), objId, description, docName, docSize, urlStr );
               fflush( xfp );
            }
         }
      }

      bp = ep;

      switch ( hrefType ) {
         case BROWSE:
            if ( strstr( urlStr, "sort=name" ) && strcmp( description, "Folder" ) ) {
               if ( !strchr( description, ',' ) && !strchr( urlStr, ',' ) ) {
                  sprintf( tmpStr, "%d,%s,%s", 
                     objId, description, urlStr );
                  if ( saveData )
                     dsStoreCsvData( ds_BrowseObj, tmpStr, 30 );
               }

               if ( gatherFlg ) {
                  if ( objId < MAXOBJID ) {
                     if ( llb[ objId ] == (LLBROWSE*) 0 ) {
                        LLBROWSE
                           *pLlb;

                        // fprintf( stderr, ">>>>>>>>> Gathering ObjId: %d\n", objId );

                        if ( ( pLlb = malloc( sizeof( LLBROWSE ) ) ) != (LLBROWSE*)0 ) {
                           if ( llb_tail ) {
                              llb_tail->Next = pLlb;
                           } else {
                              llb_head       = pLlb;
                              llb_curr       = pLlb;
                           }

                           llb_tail          = pLlb;

                           llb[ objId ]      = pLlb;   

                           pLlb->Next        = 0;
                           pLlb->ObjId       = objId;
                           pLlb->Boid        = 1;

                           strcpy( pLlb->Title, description );
                           strcpy( pLlb->URL,   urlStr );
                        }
                     } else {
                        // fprintf( stderr, "====>> Already have ObjId: %d\n", objId );
                     }
                  } else {
                     fprintf( stdout, "MAXOBJID exceeded -> %d\n", objId );
                  }
               }
            }
            break;

         case FETCH:
            if ( !strchr( description, ',' ) && !strchr( urlStr, ',' ) ) {
               sprintf( tmpStr, "%d,%s,%s", 
                  objId, description, urlStr );
                  if ( saveData )
                     dsStoreCsvData( ds_FetchObj, tmpStr, 30 );
            }
            break;

         case INFO:
            if ( !strcmp( description, "Info" ) ) {
               if ( !strchr( description, ',' ) && !strchr( urlStr, ',' ) ) {
                  sprintf( tmpStr, "%d,%s,%s", 
                     objId, description, urlStr );
                  if ( saveData )
                     dsStoreCsvData( ds_InfoObj, tmpStr, 30 );
               }
            }
            break;

         case SHOW:
            if ( strcmp( description, "Document" ) ) {
               if ( !strchr( description, ',' ) && !strchr( docName, ',' ) && !strchr( urlStr, ',' ) ) {
                  sprintf( tmpStr, "%d,%s,%s,%d,%s", 
                     objId, description, docName, docSize, urlStr );
                  if ( saveData )
                     dsStoreCsvData( ds_ShowObj, tmpStr, 30 );
               }
            }
            break;
      }
   }

   if ( docCnt ) {
      fprintf( stdout, "                   ***** Found %d Document(s)\n", docCnt );
      fflush( stdout );
   }

   TRACE( TRC_LEAVING, "Leaving parseHref()" );
}   // parseHref


/********************************************************************/

void parseBody(
   int  type,
   char buf[],
   int  headerLen,
   int  cnt
)
{
   char
      tagStr[ 16 ],
      titleStr[ 128 ],
      *pBuf,
      *ep,
      *tp,
      *xp;

   int
      bytesRead,
      len,
      waitTime       = 10;

   TRACE( TRC_INTO, "Into parseBody()" );

   sprintf( tagStr, "%d", cnt );

   if ( type == HTML ) {
      pBuf = (void*)(buf + headerLen);

      bytesRead = readto( pBuf, RCVBUFLEN - headerLen, "/HTML|/html", waitTime, tagStr );

      fprintf( tfp, "::::: bytesRead %d\n", bytesRead );

      pBuf[ bytesRead ]  = '\0';

      len                = headerLen + bytesRead;
 
      if ( strstr( pBuf, "[Invalid node specified.]" )) {
         invalidNode = TRUE;
         TRACE( TRC_NOISY, "[parseBody]  Invalid node\n" );
      }

      if ( strstr( pBuf, "You are not authorized to view this page" )) {
         notAuthorized = TRUE;
         TRACE( TRC_NOISY, "[parseBody]  Not authorized\n" );
      }

      if ( ( xp = strstr( pBuf, "<TITLE>" ) ) != 0 ) {
         xp = strchr( xp, '>' );
         xp++;

         ep = strstr( buf, "</TITLE>" );

         tp = titleStr;

         while ( ( xp < ep ) && ( ( tp - titleStr ) < 128 ) ) {
            *tp++ = *xp++;
         }

         *tp = '\0';

         sprintf( msgBuf, "Page Title: %s", titleStr );
         userLog( msgBuf );

         if ( xfp ) {
            fprintf( xfp, "***** %d ** Page Title: %s *****\n", calledObjId, titleStr );
            fflush( xfp );
         }

         fprintf( stdout, "                   Page Title: %s\n", titleStr );
         fflush( stdout );
      }

      while ( xp = strstr( pBuf, "<!--" ) ) {
         if ( ep  = strstr( xp, "-->" ) ) {
            ep += strlen( "-->" );

            while ( *ep ) {
               *xp++ = *ep++;
            }

            *xp = '\0';
         }
      }

      while ( xp = strstr( pBuf, "<SCRIPT" ) ) {
         if ( ep  = strstr( xp, "</SCRIPT>" ) ) {
            ep += strlen( "</SCRIPT>" );

            while ( *ep ) {
               *xp++ = *ep++;
            }

            *xp = '\0';
         }
      }
   }

   parseHref( buf );

   // bytesRead = strlen( buf );

   if ( trcFlg & TRC_SHOW_CONTENT ) {
      fprintf( tfp, "===================\n" ); 
      fprintf( tfp, "header 0x%08x -> %d\n", buf, headerLen ); 
      fprints( tfp, buf, headerLen, 70, "<<<" );
      fprintf( tfp, "===================\n" ); 
      fprintf( tfp, "body 0x%08x -> %d\n", buf, len ); 
      fprints( tfp, buf, len, 70, "<<<" );
      fprintf( tfp, "===================\n" ); 
      fflush( tfp );
   }

   TRACE( TRC_LEAVING, "Leaving parseBody()" );
}   // parseBody


/********************************************************************/

void
lc(
   char *buf,
   int   len
)
{
   int
      i;

   for ( i = 0; i < len; i++ )
      buf[ i ] = tolower( buf[ i ] );
}   // lc


/********************************************************************/

void
parseReply( void  )
{
   BOOLEAN
      headerComplete = FALSE;

   char
      rcvBuf[ RCVBUFLEN ],
      verStr[ 32 ],
      codeStr[ 32 ],
      statusStr[ 32 ],
      param[ 32 ],
      value[ 256 ],
      line[ 256 ],
      titleStr[ 256 ],
      *pAppend,
      *xp, *ep,
      *lp,
      *rp,
      *tp,
      *sp;


   int
      chunked       = 0,
      getChunk      = 1,
      chunkLen      = 0,
      contentLength,
      parsedContentLength = -1,
      cnt           = 0,
      i             = 0,
      chunkIdx      = 0,
      idx           = 0,
      linelen,
      n,
      rcvLen        = 0,
      textFlg       = 0;

   keepAlive        = 1;
   invalidNode      = 0;
   notAuthorized    = 0;
   ntlmSendMsg      = 0;
   ntlmType         = 0;
   rp               = rcvBuf;

   TRACE( TRC_INTO, "Into parseReply()" );

   memset( rcvBuf, 0, RCVBUFLEN );

   while ( 1 ) {
      pAppend = (void*)(rcvBuf + rcvLen);

      // fprintf( stderr, "read() len %d\n", rcvLen );

      if ( ( n = read( sendSock, pAppend, RCVBUFLEN - rcvLen ) ) == 0 ) {
         if ( tfp ) {
            fprintf( tfp, "0 bytes read exiting\n" );
            fflush( tfp );
         }
         break;
      }

      rcvLen           += n;
      rcvBuf[ rcvLen ]  = '\0';

      if ( xfp && ( parentObjId || calledObjId ) ) {
         fprintf( xfp, "Parent ObjId %d  Called ObjId %d\n", parentObjId, calledObjId );
         fflush( xfp );
      }

      if ( tfp ) {
         fprintf( tfp, "***** Read %d bytes - idx %d  rcvLen %d  hc %d\n",
            n, idx, rcvLen, headerComplete );
         fflush( tfp );
      }

      //sleep( 1 );

      if ( rcvLen > 0 ) {
          //fprintf( stderr, "RcvBuf: (%d)\n", rcvLen );
          //fprints( stderr, rcvBuf, rcvLen, 70, "<<<" );
         //sleep( 1 );
      }

      while ( idx < rcvLen ) {
         if ( !headerComplete ) {  // Get header stuff...
            sp = rp;
            tp = sp;

            while ( *tp && ( *tp != '\n' ) )  // Find next <LF>
               tp++;

            if ( !*tp ) {  // Run out of buffer so go back and read some more.
               break;
            }

            lp = line;

            while ( sp < tp ) {
               idx++;
               *lp++ = *sp++;   
            }

            sp++; idx++;
            rp = sp;

            if ( *--lp == '\r' ) {
               *lp = '\0';
            }

            linelen = strlen( line );

            if ( tfp && trcShowLine ) {
               fprintf( tfp, "Line [%d] - \"%s\"\n", linelen, line );
            }

            if ( cnt++ == 0 ) {  // Parse out HTTP - This needs to be a lot smarter
               sscanf( line, "HTTP/%s %s %s", verStr, codeStr, statusStr );
               statusCode = atoi( codeStr );
               if ( tfp ) {
                  fprintf( tfp, "Header: \"%s\"\n", line );
                  fprintf( tfp, "HTTP Version \"%s\"  Status Code \"%s\"  Status Msg \"%s\"\n",
                     verStr, codeStr, statusStr );
                  fflush( tfp );
               }
            } else {  // Now for the rest of the header
               if ( linelen == 0 ) {  // Now for the content!
                  headerComplete = TRUE;
                  i = 0;
                  break;
               }

               lp = line;

               while ( *lp != ':' )
                  lp++;

               *lp++ = '\0';

               while ( *lp == ' ' )
                  lp++;

               if ( !strcmp( line, "Content-Length" )
                     ||
                    !strcmp( line, "Content-length" ) ) {
                  parsedContentLength = atoi( lp );
               }

               if ( !strcmp( line, "Content-Type" )
                     ||
                    !strcmp( line, "Content-type" ) ) {
                  if ( !strcmp( lp, "text/html" ) )
                     textFlg = 1;
               }

               if ( !strcmp( line, "Connection" )
                     ||
                    !strcmp( line, "Proxy-Connection" ) ) {
                  if ( !strcmp( lp, "Keep-Alive" ) )
                     keepAlive = 1;
                  else if ( !strcmp( lp, "close" ) )
                     keepAlive = 0;
               }

               if ( !strcmp( line, "Transfer-Encoding" ) ) {
                  if ( !strcmp( lp, "chunked" ) )
                     chunked  = 1;
                     getChunk = 1;
               }

               if ( !strcmp( line, "WWW-Authenticate" ) ) {
                  if ( !strcmp( lp, "NTLM" ) ) {
                     int
                        mlen;

                     TYPE_1_MSG
                        *pt1m;

                     ntlmSendMsg = 1;
                     ntlmType    = 1;

                     pt1m = t1m_init( 0, 0, &mlen );

                     b64encoded_ntlm_msg = base64encode( (char*)pt1m, mlen );

                     userLog( ">>>>> Parsed \"NTLM\"" );

                     if ( ntlmDbg )
                        fprintf( stderr,"                   <NTLM>  Auth required: Build Type 1 Message  \"%s\"\n",
                           b64encoded_ntlm_msg );

                  } else if ( !strncmp( lp, "Negotiate ", 10 ) ) {
                     char
                        *b64encoded_t2m;

                     int
                        mlen;

                     TYPE_2_MSG
                        *pt2m;

                     TYPE_3_MSG
                        *pt3m;

                     ntlmSendMsg = 1;
                     ntlmType    = 3;

                     b64encoded_t2m = lp + 10;

                     pt2m = ( TYPE_2_MSG*)base64decode( b64encoded_t2m, 0 );

                     pnonce = get_nonce( pt2m );

                     userLog( ">>>>> Parsed Type 2 Msg" );
                     userLog( b64encoded_t2m );

                     // fprintf( stderr, "Nonce: (%d)\n", 8 );
                     // fprints( stderr, pnonce, 8, 70, "<<<", 1 );

                     if ( pnonce ) {
                        pt3m = build_t3m( user, passwd, webClient, domain, pnonce, &mlen, 0 );

                        // fprintf( stderr, "Type 3 Msg: (%d)\n", mlen );
                        // fprints( stderr, (char*)pt3m, mlen, 70, "<<<", 1 );

                        b64encoded_ntlm_msg = base64encode( (char*)pt3m, mlen );
                     } else
                        b64encoded_ntlm_msg = "******* BOGUS NONCE *******";

                     if ( ntlmDbg )
                        fprintf( stderr, "                   <NTLM>  Authorizing: Build Type 3 Msg: \"%s\"\n",
                           b64encoded_ntlm_msg );
                  }
               }

               if ( tfp ) {
                  fprintf( tfp, "Parameter \"%s\"  Value \"%s\"\n", line, lp );
                  fflush( tfp );
               }
            }
         } else
            break;
      }

      if ( headerComplete ) {  // %%%%%
         if (    ( sendCnt ==   1 )
             ||  ( sendCnt ==   7 )
             ||  ( sendCnt ==  19 )
             ||  ( sendCnt ==  25 )
             || (( sendCnt >=  81 ) && ( sendCnt <= 112 ))
             || (( sendCnt >= 118 ) && ( sendCnt <= 120 ))
             || (( sendCnt >= 122 ) && ( sendCnt <= 124 ))
             ||  ( sendCnt == 126 )
             ||  ( sendCnt == 129 )
             ||  ( sendCnt == 131 )
             ||  ( sendCnt == 133 )
             ||  ( sendCnt == 135 )
             ||  ( sendCnt == 139 )
             ||  ( sendCnt == 141 )
             ||  ( sendCnt == 142 )
             ||  ( sendCnt == 163 )
             ||  ( sendCnt == 173 )
             ||  ( sendCnt == 179 )
             ||  ( sendCnt == 180 )
             ||  ( sendCnt == 182 )
             ||  ( sendCnt == 185 )
             ||  ( sendCnt == 186 )
             ||  ( sendCnt == 187 )
             ||  ( sendCnt == 189 )
             ||  ( sendCnt == 190 )
             ||  ( sendCnt == 276 )
             ||  ( sendCnt == 277 )
             ||  ( sendCnt == 279 )
             ||  ( sendCnt == 280 )
             ||  ( sendCnt == 310 )
             ||  ( sendCnt == 311 )
             ||  ( sendCnt == 312 )
             ||  ( sendCnt == 313 )
             ||  ( sendCnt == 328 )
             ||  ( sendCnt == 329 )
             ||  ( sendCnt == 330 )
             ||  ( sendCnt == 332 )
            ) {  // Just HTML!

            parseCookies( rcvBuf, rcvLen );
            listCookies();

            parseBody( HTML, rcvBuf, rcvLen, sendCnt );
            break;
         } else if (( sendCnt == 5 ) || ( sendCnt == 203 )) {
            /* if ( strstr( sendBuf, "post" ) && strstr( sendBuf, "ll.getlogin&")) */
            authenticate( HTML, rcvBuf, rcvLen, sendCnt );
            break;
         } else if ( sendCnt == 25 ) {
            /* if ( strstr( sendBuf, "post" ) && strstr( sendBuf, "pspsearch.asp" )) */
            parsePSP( HTML, rcvBuf, rcvLen, sendCnt );
            break;
         } else if (( sendCnt == 75 )||( sendCnt == 113 ) || ( sendCnt == 140 )) {
            /* if ( strstr( sendBuf, "post" ) && strstr( sendBuf, "ll&")) */
            parseDoc( HTML, rcvBuf, rcvLen, sendCnt );
            break;

         } else {  // Not sure what it is
            contentLength = rcvLen - idx;

            if ( !chunked && ( parsedContentLength == -1 ) ) {  // Read what we have!
               fprintf( tfp, "No Content-Length in header!   rcvLen %d  idx %d\n",
                  rcvLen, idx );
               parsedContentLength = contentLength;
            }

            if ( !chunked && ( contentLength != parsedContentLength ) ) {
               if ( tfp ) {
                  fprintf( tfp,
                     "::::: rcvLen %d  idx %d  rp - rcvBuf %d  Diff %d  ContentLength %d\n",
                     rcvLen, idx, rp - rcvBuf, contentLength, parsedContentLength );
               }
               continue;  // Go read some more...
            }

            if ( textFlg ) {
               if ( tfp ) {
                  fprintf( tfp,
                     "====> rcvLen %d  idx %d  rp - rcvBuf %d  Diff %d  ContentLength %d\n",
                     rcvLen, idx, rp - rcvBuf, contentLength, parsedContentLength );
                  fprintf( tfp, "%s\n", SPACER );
                  // fprints( tfp, rp, contentLength, 70, "<<<" );
                  fflush( tfp );
               }

               while ( i < contentLength ) {
                  tp = sp;

                  while ( *tp && ( *tp != '\n' ) )  // Find next <LF>
                     tp++;

                  if ( !*tp ) {  // Run out of buffer so go back and read some more.
                     break;
                  }

                  lp = line;

                  while ( sp < tp ) {
                     chunkIdx++;
                     i++;
                     *lp++ = *sp++;   
                  }

                  sp++; i++; chunkIdx++;

                  *lp = '\0';

                  if ( *--lp == '\r' ) {
                     *lp = '\0';
                  }

                  if ( chunked && getChunk ) {
                     chunkLen = hex( line ) + 2;
                     getChunk = 0;
                     chunkIdx = 0;
                     if ( tfp ) {
                        fprintf( tfp, "[%05d] \"%s\" <<<\n", chunkIdx, line );
                        fprintf( tfp, "[getChunk] chunkLen = %d 0x%x  i %d  contentLen %d\n",
                           chunkLen, chunkLen, i, contentLength );
                     }
                  }

                  if ( chunkIdx == chunkLen ) {
                     getChunk = 1;
                  }

                  if ( chunkLen == 2 ) {
                     parsedContentLength = contentLength;
                     // Chunk read completed...
                  }

                  if ( tfp ) {
                     fprintf( tfp, "[%05d]%s\n", chunkIdx, line );
                     fflush( tfp );
                  }
               }

               if ( tfp ) {
                  fprintf( tfp, "%s\n", SPACER );
                  fflush( tfp );
               }
            } else {  // textFlg *NOT* set so presumably is an image
               if ( tfp ) {
                  fprintf( tfp,
                     "=====> rcvLen %d  idx %d  rp - rcvBuf %d  ContentLength %d  Parsed CL %d\n",
                     rcvLen, idx, rp - rcvBuf, contentLength, parsedContentLength );
                  fprintf( tfp, "%s\n", SPACER );
               // fprints( tfp, rp, contentLength, 70, "<<<" );

                  if ( statusCode == 304 )
                     fprintf( tfp, "*Not Modified*\n" );
                  else
                     fprints( tfp, rp, 100, 70, "<<<" );

                  fprintf( tfp, "%s\n", SPACER );
                  fflush( tfp );
               }
            }

            if ( contentLength == parsedContentLength ) {
               if ( tfp ) {
                  // fprintf( tfp, "****> contentLength == parsedContentLength\n" );
                  // fflush( tfp );
               }
               break;
            }
         }

      }  // header complete
   }

   // grep for "You are not authorized to view this page" in page content if HTML
   if ( textFlg ) {
      int
         ierr;

      rcvBuf[ rcvLen ] = '\0';

      if ( strstr( rcvBuf, "[Invalid node specified.]" )) {
         invalidNode = TRUE;
         TRACE( TRC_NOISY, "[parseBody]  Invalid node\n" );
      }

      if ( strstr( rcvBuf, "You are not authorized to view this page" )) {
         notAuthorized = TRUE;
         TRACE( TRC_NOISY, "[parseBody]  Not authorized\n" );
      }
   }

   if ( notAuthorized && displayErrors )
      fprintf( stderr, "                   ***** Not Authorized *****\n" );

   if ( invalidNode && displayErrors  )
      fprintf( stderr, "                   ***** Invalid Node specified *****\n" );

   TRACE( TRC_LEAVING, "Leaving parseReply()" );
}   /* parseReply */


/********************************************************************/

void
ll_login(
   void
)
{
   loggedIn = TRUE;

   rteSleep( 1, 'L' );

   if ( newVersion )
      sendSequence( 198, 224 );  // This does V9.1 login sequence
   else
      sendSequence( 0, 18 );     // This does V8.15 login sequence

   rteSleep( 1, 'A' );
}   /* ll_v815_login */


/********************************************************************/

void
ll_sales_n_service(
   void
)
{
   sendSequence( 19, 24 );
}   /* ll_sales_n_service */


/********************************************************************/

void
ll_pspSearch(
   void
)
{
   if ( !loggedIn ) {
      ll_login();
      ll_sales_n_service();
   }

   sendSequence( 25, 26 );
}   /* ll_pspSearch */


/********************************************************************/

void
ll_pspDownload(
   void
)
{
   int
      i;

   if ( !loggedIn ) {
      ll_login();
      ll_sales_n_service();
      ll_pspSearch();
   }

   rteSleep( 1, 'D' );

   for ( i = 0; i < noPsp; i++ ) {
      pPspId = psp[ i ].pspId;
      pObjId = psp[ i ].objId;

      sendSequence( 29, 29 );
   }

   rteSleep( 1, 'A' );
}   /* ll_pspDownload */

/********************************************************************/

void
sendTest(
   void
)
{
   int
      i;


   rteSleep( 1, 'S' );

/*
   ll_login();

   for ( i = 0; i < 600; i++ ) {
      msleep( 200 );
      ll_pspSearch();
      ll_pspDownload();

      if ( finished() )
         break;
   }
*/
      sendSequence( 198, 224 );  // This does V9.1 login sequence


   rteSleep( 1, 'A' );
}   /* sendTest */


/********************************************************************/

void
sendGifs(
   void
)
{
   int
      delay,
      i;

   if ( !loggedIn )
      ll_login();

   for ( i = 0; i < 100; i++ ) {
      sendSequence( 275, 275 );

      if ( notAuthorized )
         sendSequence( 193, 195 );

      delay = rteRand( 50 ) * 10;
      if ( finished() )
         break;
      msleep( delay );
   }

   close( sendSock );

   sendSock  = UNDEFINED;
   keepAlive = 0;
}   /* sendGifs */


/********************************************************************/

void
sendHLSearch(
   void
)
{
   int
      i, j;

   if ( !loggedIn )
      ll_login();

   rteSleep( 1, 'S' );

   for ( i = 0; i < 2; i++ ) {
      sendSequence( 75, 75 );
      sendSequence( 76, 77 );

      rteSleep( 1, 's' );

      for ( j = 0; j < noNode; j++ ) {
         useNode = j;
         sendSequence( 78, 80 );
      }

      rteSleep( 1, 'a' );

      if ( finished() )
         break;
   }

   rteSleep( 1, 'A' );
}   /* sendHLSearch */


/********************************************************************/

void
sendHLSalesSearch(void)
{
   int
      i, j;

   if ( !loggedIn )
      ll_login();

   rteSleep( 1, 'S' );

   // for ( i = 0; i < 2; i++ ) {
      //sendSequence( 112, 117);
      //sendSequence( 322, 324 );
      sendSequence( 323, 323 );
      sendSequence( 193, 195 );
      sendSequence( 324, 324 );
      sendSequence( 193, 195 );
      sendSequence( 323, 323 );
      sendSequence( 193, 195 );
      sendSequence( 324, 324 );
      sendSequence( 193, 195 );
      sendSequence( 325, 325 );
      sendSequence( 193, 195 );
      sendSequence( 326, 326 );

/*
      if ( finished () )
         break;
   }
*/

   rteSleep( 1, 'A' );
}  /*sendHLSalesSearch */

/********************************************************************/

void
sendHLBrowse(
   void
)
{
   int
      i, j;

   if ( !loggedIn )
      ll_login();

   rteSleep( 1, 'S' );

   if ( newVersion ) {
      for ( i = 0; i < 3; i++ ) {
         sendSequence( 313, 313 );
         sendSequence( 316, 321 );

         if ( finished() )
            break;
      }
   } else {
      for ( i = 81; i <= 90; i++ ) {
         sendSequence( i, i );

         if ( finished() )
            break;
      }
   }

   rteSleep( 1, 'A' );
}   /* sendHLBrowse */


/********************************************************************/

void
sendPspBrowse( void )
{
   int
      i, j;

   if ( !loggedIn )
      ll_login();

   rteSleep( 1, 'S' );

   for ( i = 118; i <= 134; i++ ) {
      sendSequence( i, i );

      if ( finished() )
         break;
   }

   rteSleep( 1, 'A' );
}   /* sendPspBrowse */


/********************************************************************/

void
sendAdvSearch( void )
{
   int
      i, j;

   if ( !loggedIn )
      ll_login();

   for ( i = 135; i <= 139; i++ ) {
      sendSequence( i, i );

      if ( finished() )
         break;
   }


   userLog( "About to run 5 queries" );

   for ( i = 0; i < 5; i++ ) {
      rteSleep( 1, 'S' );
      sendSequence( 140, 141 );

      if ( finished() )
         break;

      rteSleep( 4, 'A' );
   }

   userLog( "Done running 5 queries" );
}   /* sendAdvSearch */


/********************************************************************/

void
sendAddUser( void )
{
   int
      i, j;

   if ( !loggedIn )
      ll_login();

   userLog( "About to add a user" );

   rteSleep( 1, 'S' );
   sendSequence( 142, 142 );

   rteSleep( 4, 'A' );

   userLog( "Added one user" );
}   /* sendAddUser */


/********************************************************************/

void
getDocs(
   void
)
{
   int
      i;

   if ( !loggedIn )
      ll_login();

   if ( newVersion ) {
      sendSequence( 281, 309 );
   } else {
      sendSequence( 163, 172 );
      sendSequence( 173, 178 );
      sendSequence( 179, 179 );
      sendSequence( 180, 181 );
      sendSequence( 182, 184 );
      sendSequence( 185, 185 );
   }

   rteSleep( 1, 'A' );
}   /* getDocs */


/********************************************************************/

void
gather(
   void
)
{
   int
      i   = 0,
      max = 3000;

   if ( !loggedIn )
      ll_login();

   gatherFlg = TRUE;

   while ( i++ < max ) {
      if ( finished() )
         break;

      if ( newVersion ) {
         sendSequence( 276, 276 );
         sendSequence( 193, 195 );
      } else
         sendSequence( 186, 186 );
   }

   rteSleep( 1, 'A' );
}   /* gather */


/********************************************************************/

void
browse(
   void
)
{
   int
      i = 0;

   if ( !loggedIn )
      ll_login();

   gatherFlg = FALSE;

   while ( i++ < 10 ) {
      if ( finished() )
         break;

      if ( newVersion ) {
         sendSequence( 277, 277 );
         sendSequence( 193, 195 );
      } else
         sendSequence( 187, 187 );
   }

   rteSleep( 1, 'A' );
}   /* browse */


/********************************************************************/

void
fetch(
   void
)
{
   int
      i = 0;

   if ( !loggedIn )
      ll_login();

   gatherFlg = FALSE;

   while ( i++ < 5 ) {
      if ( finished() )
         break;

      if ( newVersion )
         sendSequence( 278, 278 );
      else
         sendSequence( 188, 188 );
   }

   rteSleep( 1, 'A' );
}   /* fetch */


/********************************************************************/

void
info(
   void
)
{
   int
      i = 0;

   if ( !loggedIn )
      ll_login();

   gatherFlg = FALSE;

   while ( i++ < 5 ) {
      if ( finished() )
         break;

      if ( newVersion )
         sendSequence( 310, 312 );
      else
         sendSequence( 189, 189 );
   }

   rteSleep( 1, 'A' );
}   /* info */


/********************************************************************/

void
show(
   void
)
{
   int
      i = 0;

   if ( !loggedIn )
      ll_login();

   gatherFlg = FALSE;

   while ( i++ < 1 ) {
      if ( finished() )
         break;

      if ( newVersion ) {
         //sendSequence( 280, 280 );
         sendSequence( 329, 329 );
         sendSequence( 330, 332 );
         sendSequence( 330, 332 );
         sendSequence( 193, 195 );
      } else
         sendSequence( 190, 190 );
   }

   rteSleep( 1, 'A' );
}   /* show */


/********************************************************************/

void
ntlm_authenticate(
   void
)
{
   int
      i = 0,
      t1mlen;

   char
      *pt1m;

   // This just dowloads llheader.jar - to see if it can be done!

   rteSleep( 1, 'A' );

   sendSequence( 193, 195 );

   rteSleep( 1, 'D' );
}   /* ntlm_authenticate */


/********************************************************************/

void
browseFolders(
   void
)
{
   int
      i;

   if ( !loggedIn )
      ll_login();

   for ( i = 0; i < 2; i++ ) {
      sendSequence( 328, 328 );
      sendSequence( 193, 195 );
   }

   close( sendSock );

   sendSock  = UNDEFINED;
   keepAlive = 0;
}   /* browseFolders */


//====================================================================

void LLTest()
{
   userLog( "START - LLTest ..." );

   markThreadStart();

   sendTest();

   markThreadFinish();

   userLog( "END - LLTest ..." );
}   /* LLTest */


/********************************************************************/

void LLGifs()
{
   userLog( "START - LLGifs ..." );

   markThreadStart();

   sendGifs();

   markThreadFinish();

   userLog( "END - LLGifs ..." );
}   /* LLGifs */


/********************************************************************/

void LLHLSearch()
{
   userLog( "START - LLHLSearch ..." );

   markThreadStart();

   // login( NO ); Http is stateless so there's no real log in or log out.

   sendHLSearch();

   // logout( NO );

   markThreadFinish();

   userLog( "END - LLHLSearch ..." );
}   /* LLHLSearch */


/********************************************************************/

void LLHLBrowse()
{
   userLog( "START - LLHLBrowse ..." );

   markThreadStart();

   // login( NO ); Http is stateless so there's no real log in or log out.

   sendHLBrowse();

   // logout( NO );

   markThreadFinish();

   userLog( "END - LLHLBrowse ..." );
}   /* LLHLBrowse */

/********************************************************************/


void LLHLSalesSearch()
{
   userLog( "START - LLHLSalesSearch ..." );
   
   markThreadStart();   

   // login( NO ); Http is stateless so there's no real log in or log out.

   sendHLSalesSearch();

   // logout( NO );

   markThreadFinish();

   userLog( "END - LLHLSalesSearch ..." );
}   /* LLHLSalesSearch */

/********************************************************************/

void LLPspBrowse()
{
   userLog( "START - LLPspBrowse ..." );

   markThreadStart();

   // login( NO ); Http is stateless so there's no real log in or log out.

   sendPspBrowse();

   // logout( NO );

   markThreadFinish();

   userLog( "END - LLPspBrowse ..." );
}   /* LLPspBrowse */


/********************************************************************/

void LLAdvSearch()
{

   userLog( "START - LLAdvSearch ..." );

   markThreadStart();

   // login( NO ); Http is stateless so there's no real log in or log out.

   sendAdvSearch();

   // logout( NO );

   markThreadFinish();

   userLog( "END - LLAdvSearch ..." );
}   /* LLAdvSearch */


/********************************************************************/

void LLAddUser()
{
   userLog( "START - LLAddUser ..." );

   markThreadStart();

   sendAddUser();

   markThreadFinish();

   userLog( "END - LLAddUser ..." );
}   /* LLAddUser */


/********************************************************************/

void LLGetDocs()
{
   userLog( "START - LLGetDocs ..." );

   markThreadStart();

   xfp = fopen( "data.txt", "w" );

   getDocs();

   markThreadFinish();

   userLog( "END - LLGetDocs ..." );
}   /* LLGetDocs */


/********************************************************************/

int
getln(
   FILE    *fp,
   char    *str
)
{
   unsigned int
      ich;

   char
      *sp;

   sp = str;

   while ( ( ( ich = getc( fp ) ) != -1 ) && ( ich != '\n' ) ) {
      *sp++ = ich;   
   }

   *sp = '\0';

   return strlen( str );
}   // getln


/********************************************************************/

void LLGather()
{
   int
      i,
      boid,
      objId;

   char
      lineBuf[ 256 ],
      *title,
      *url,
      *sp;

   userLog( "START - LLGather ..." );

   for ( i = 0; i < MAXOBJID; i++ )
      llb[ i ] = 0;

   if ( ( bfp = fopen( "boid.lst", "r" ) ) == (FILE*)0 ) {
      fprintf( stderr, "Open failed (\"boid.lst\"\n" );
      exit( 1 );
   }

   while ( !feof( bfp ) ) {
      if ( getln( bfp, lineBuf ) ) {
         sp            = strtok( lineBuf, "|" );
         objId         = atoi( sp );
         sp            = strtok( 0, "|" );
         boid          = atoi( sp );
         title         = strtok( 0, "|" );
         url           = strtok( 0, "|" );

         llb_add( objId, title, url, boid );
      }
   }

   fclose( bfp );

   markThreadStart();

   xfp = fopen( "gather.results", "w" );

   gather();

   markThreadFinish();

   llb_save();

   userLog( "END - LLGather ..." );
}   /* LLGather */


/********************************************************************/

void LLBrowse()
{
   int
      i,
      objId;

   char
      lineBuf[ 256 ],
      *sp;

   userLog( "START - LLBrowse ..." );

   markThreadStart();

   xfp = fopen( "data.txt", "w" );

   browse();

   markThreadFinish();

   userLog( "END - LLBrowse ..." );
}   /* LLBrowse */


/********************************************************************/

void LLFetch()
{
   int
      i,
      objId;

   char
      lineBuf[ 256 ],
      *sp;

   userLog( "START - LLFetch ..." );

   markThreadStart();

   xfp = fopen( "data.txt", "w" );

   fetch();

   markThreadFinish();

   userLog( "END - LLFetch ..." );
}   /* LLFetch */


/********************************************************************/

void LLInfo()
{
   int
      i,
      objId;

   char
      lineBuf[ 256 ],
      *sp;

   userLog( "START - LLInfo ..." );

   markThreadStart();

   xfp = fopen( "data.txt", "w" );

   info();

   markThreadFinish();

   userLog( "END - LLInfo ..." );
}   /* LLInfo */


/********************************************************************/

void LLShow()
{
   int
      i,
      objId;

   char
      lineBuf[ 256 ],
      *sp;

   userLog( "START - LLShow ..." );

   markThreadStart();

   xfp = fopen( "data.txt", "w" );

   show();

   markThreadFinish();

   userLog( "END - LLShow ..." );
}   /* LLShow */


/********************************************************************/

void LLNTLMAuth()
{
   int
      i,
      objId;

   char
      lineBuf[ 256 ],
      *sp;

   userLog( "START - LLNTLMAuth ..." );

   markThreadStart();

   ntlm_authenticate();

   markThreadFinish();

   userLog( "END - LLNTLMAuth ..." );
}   /* LLNTLMAuth */


/********************************************************************/

void LLOldLogin()
{
   int
      i,
      objId;

   char
      lineBuf[ 256 ],
      *sp;

   userLog( "START - LLOldLogin ..." );

   markThreadStart();

   newVersion = FALSE;

   ll_login();

   markThreadFinish();

   userLog( "END - LLOldLogin ..." );
}   /* LLOldLogin */


/********************************************************************/

void LLFolder()
{
   int
      i,
      objId;

   char
      lineBuf[ 256 ],
      *sp;

   userLog( "START - LLFolder ..." );

   markThreadStart();

   browseFolders();

   markThreadFinish();

   userLog( "END - LLFolder ..." );
}   /* LLFolder */


/********************************************************************/


